<?php
/*
Plugin Name: Autoptimize CriticalCSS.com
Plugin URI: http://optimizingmatters/autoptimize/criticalcss/
Description: Have Autoptimize use multiple above the fold CSS, part of criticalcss.com subscription.
Author: Optimizing Matters
Version: 0.9.2
Author URI: http://optimizingmatters.com/ 
*/

// CONSTANT with directory to store critical CSS in
if (is_multisite()) {
	$blog_id = get_current_blog_id();
    define("AOCRITCSSDIR",WP_CONTENT_DIR."/aocritcss/".$blog_id."/");
} else {
	define("AOCRITCSSDIR",WP_CONTENT_DIR."/aocritcss/");
}

// get critical CSS settings from WP options (+ fallback to always have placeholder) and json_decode to have a nice array
$critSettingsRaw=get_option("critSettings",'{"inpath":{"dummy":"dummy"},"type":{"dummy":"dummy"}}');
if (empty($critSettingsRaw)) {$critSettingsRaw='{"inpath":{"dummy":"dummy"},"type":{"dummy":"dummy"}}';}
$critSettings=json_decode($critSettingsRaw,true);

// order "inpath" by string length, longest path is most specific and will be treated first
if (!empty($critSettings["inpath"])) {
	$keys = array_map('strlen', array_keys($critSettings["inpath"]));
	array_multisort($keys, SORT_DESC, $critSettings["inpath"]);
}

// the known & supported conditional tags
$ao_acceptedTypes=array("is_page","is_post","is_home","is_archive","is_front_page","is_single","is_sticky","is_category","is_author","is_search","is_404","is_blog_page");

add_action('init','critcss_extend_acceptedTypes');
function critcss_extend_acceptedTypes() {
	global $ao_acceptedTypes;
	
	// conditionally add woocommerce tags
	if ( class_exists('WooCommerce') ) {
		$ao_acceptedTypes=array_merge($ao_acceptedTypes, array("is_woocommerce","is_shop","is_product_category","is_product_tag","is_product","is_cart","is_checkout","is_account_page","is_wc_endpoint_url"));
	}

	// bbpress
	if ( function_exists('is_bbpress') ) {
		$ao_acceptedTypes=array_merge($ao_acceptedTypes, array("bbp_is_forum_archive","bbp_is_topic_archive","bbp_is_topic_tag","bbp_is_topic_tag_edit","bbp_is_single_forum","bbp_is_single_topic","bbp_is_single_reply","bbp_is_topic_edit","bbp_is_topic_merge","bbp_is_topic_split","bbp_is_reply_edit","bbp_is_reply_move","bbp_is_single_view","bbp_is_single_user_edit","bbp_is_single_user","bbp_is_user_home","bbp_is_user_home_edit","bbp_is_topics_created","bbp_is_replies_created","bbp_is_favorites","bbp_is_subscriptions","bbp_is_search","bbp_is_search_results","is_bbpress"));
	}
	
	// buddypress
	if ( function_exists('is_buddypress') ) {
		$ao_acceptedTypes=array_merge($ao_acceptedTypes, array("bp_is_user","bp_is_user_profile","bp_is_activity","bp_is_blogs","bp_is_wire","bp_is_messages","bp_is_friends","bp_is_groups","bp_is_settings_component","bp_is_my_activity","bp_is_friends_activity","bp_is_profile_edit","bp_is_change_avatar","bp_is_group_single","bp_is_group_home","bp_is_group_create","bp_is_group_admin_page","bp_is_group_forum","bp_is_group_forum_topic","bp_is_group_members","bp_is_group_invites","bp_is_group_leave","bp_is_my_blogs","bp_is_create_blog","bp_is_friends_screen","bp_is_friend_requests","bp_is_messages_inbox","bp_is_messages_sentbox","bp_is_messages_conversation","bp_is_notices","bp_is_messages_compose_screen","bp_is_register_page","bp_is_activation_page","is_buddypress"));
	}

	// edd
	if ( function_exists('edd_is_checkout') ) {
		$ao_acceptedTypes=array_merge($ao_acceptedTypes, array("edd_is_checkout","edd_is_success_page","edd_is_failed_transaction_page","edd_is_purchase_history_page"));
	}
	
	// custom post types
	$cpts = get_post_types( array('public' => true, '_builtin' => false), 'names', 'and' );
	foreach ($cpts as $cpt) {
		$ao_acceptedTypes[]="custom_post_".$cpt;
	}
	
	// page templates
	$tmplates = wp_get_theme()->get_page_templates();
	foreach ($tmplates as $tmplfile => $tmplname) {
		$ao_acceptedTypes[]="template_".$tmplfile;
	}
}

// on front-end; inject critical CSS if request URI matches pattern (disabling minification to avoid double minify & caching what is already in a file)
$ao_css_defer_on=get_option('autoptimize_css_defer',false);
if ($ao_css_defer_on) {
	add_filter('autoptimize_filter_css_critcss_minify','__return_false');
	add_filter('autoptimize_filter_css_defer_inline','ao_critcss_function',10,1);
}

function ao_critcss_function($inlined) {
	global $critSettings, $ao_acceptedTypes;
    if (!empty($critSettings["inpath"])) {
        foreach ($critSettings["inpath"] as $pathString => $critCSSfile) {
            if ( ( strpos( $_SERVER["REQUEST_URI"], str_replace(site_url(),'',$pathString) ) !== false  ) && ($pathString!=="dummy") ) {
                if (file_exists(AOCRITCSSDIR.$critCSSfile)) {
                    return apply_filters('ao_critcss_filter_critcss', file_get_contents(AOCRITCSSDIR.$critCSSfile));
                }
            }
        }
    }
    if (!empty($critSettings["type"])) {
        foreach ($critSettings["type"] as $condTag => $critCSSfile) {
            if (in_array($condTag,$ao_acceptedTypes) && file_exists(AOCRITCSSDIR.$critCSSfile)) {
				if (strpos($condTag,"custom_post_")===0) {
					if ( get_post_type( get_the_ID() ) === substr($condTag,12) ) {
						return apply_filters('ao_critcss_filter_critcss',file_get_contents(AOCRITCSSDIR.$critCSSfile));
					}
				} else if (strpos($condTag,"template_")===0) {
					if (is_page_template(substr($condTag,9))) {
						return apply_filters('ao_critcss_filter_critcss',file_get_contents(AOCRITCSSDIR.$critCSSfile));
					}
				} else if (function_exists($condTag) && call_user_func($condTag)) {
                    return apply_filters('ao_critcss_filter_critcss',file_get_contents(AOCRITCSSDIR.$critCSSfile));
                }
            }
        }
    }

    // no match, show default critical CSS
	if (!empty($inlined)) {
		return apply_filters('ao_critcss_filter_critcss',$inlined);
	} else {
		add_filter('autoptimize_filter_css_inline','__return_true');
		return;
	}
}

// hooking up settings-screen
// the tab in autoptimize settings
add_filter('autoptimize_filter_settingsscreen_tabs','add_critcss_tab');
function add_critcss_tab($in) {
	$in=array_merge($in,array('ao_critcss_settings' => 'Critical CSS'));
	return $in;
}

// add submenu page (but invisible in settings menu)
add_action('admin_menu','critcss_settings_init');
function critcss_settings_init() {
	$hook=add_submenu_page(NULL,'AO critcss','AO critcss','manage_options','ao_critcss_settings','ao_critcss_settings');
   	register_setting( 'critcss-settings-group', 'critSettings' );
	register_setting( 'critcss-settings-group', 'critLicense' );
	register_setting( 'critcss-settings-group', 'autoptimize_css_defer_inline' );
}

// enqueue jquery-ui-dialog to add/ edit critcss
if (is_admin()) {
    add_action( 'admin_enqueue_scripts', 'critcss_admin_scripts');
	// add_action( 'admin_shutdown', 'om_check_state');
}
function critcss_admin_scripts() {
    wp_enqueue_script( 'jquery-ui-dialog', array( 'jquery' )  );
    wp_enqueue_style( 'wp-jquery-ui-dialog' );
}

// the actual settings-screen
function ao_critcss_settings() {
    global $ao_css_defer_on;
 	?>
	<div class="wrap">
		<h1><?php _e('Autoptimize Settings','autoptimize'); ?></h1>
		<noscript><div class="notice notice-warning is-dismissible"><p><?php _e("Although you could try to edit below JSON-object manually, Autoptimize Critical CSS works best with JavaScript enabled.","ao_critcss"); ?></p></div></noscript>
		<?php
		// make sure dir to write crit-css-files exists
		if (!is_dir(AOCRITCSSDIR)) {
			$mkdirresp=@mkdir(AOCRITCSSDIR,0775,true);
			$fileresp=file_put_contents(AOCRITCSSDIR."index.html",'<html><head><meta name="robots" content="noindex, nofollow"></head><body>Generated by <a href="http://wordpress.org/extend/plugins/autoptimize/" rel="nofollow">Autoptimize</a></body></html>');
			if ((!$mkdirresp) || (!$fileresp)) {
				?><div class="notice-error notice"><p><?php
				_e("Could not create the \"aocritcss\" directory, make sure the webserver can write to the wp-content directory.","ao_critcss");
				?></p></div><?php            
			}
		}

		// and we obviously need autoptimize and "inline and defer" should be active
		if (!defined('AUTOPTIMIZE_CACHE_NOGZIP')) {
			?><div class="notice-error notice"><p><?php
			_e("Please install and activate Autoptimize first","ao_critcss");
			?></p></div><?php
			exit;
		} else if (!$ao_css_defer_on) {
			?><div class="notice-error notice"><p><?php
			_e("Please <strong>activate the \"Inline & defer CSS\"-option</strong> on AO's main settings page.","ao_critcss");
			?></p></div><?php
		} else if (version_compare(get_option("autoptimize_version"),"2.1.0")===-1) {
			?><div class="notice-error notice"><p><?php
			_e("You will have to upgrade to Autoptimize 2.1.0 to properly use this Power-Up!","ao_critcss");
			?></p></div><?php
		}
		
                // if settings saved, show notice to purge page cache!
                if (array_key_exists("settings-updated",$_GET)) {
                    ?><div class="notice-warning notice is-dismissible"><p><?php
	            _e("Purge your page cache (if any) to ensure the changes are visible to your visitors.","ao_critcss");
	            ?></p></div><?php
                }

		// all OK, echo AO tabs
		echo autoptimizeConfig::ao_admin_tabs();
		$state=om_check_state("ao_critcsscom","0.9");
		if (!$state) {exit();}
		
		global $critSettings, $ao_acceptedTypes;
		?>
		<h2><?php _e("Critical CSS Settings","autoCritCss") ?></h2>
		<div>
                <div id="unSavedWarning" class="hidden updated settings-error notice is-dismissible"><p><?php _e("You have unsaved changes, don't forget to save!","ao_critcss"); ?></p></div>
                <div id="addEditCritCss" class="hidden">
                    <form>
                        <label id="critcss_addedit_type_wrapper"><?php _e("Type of selector:","ao_critcss"); ?>
                            <select id="critcss_addedit_type" style="width:100%;">
                                <option value="inpath"><?php _e("String in URL","ao_critcss"); ?></option>
                                <option value="type"><?php _e("Conditional tag","ao_critcss"); ?></option>
                            </select>
                        </label>
                        <label id="critcss_addedit_path_wrapper"><?php _e("Identifier in URL:","ao_critcss"); ?><input type="text" id="critcss_addedit_path" placeholder="<?php _e("Enter a part of the URL that identifies the page(s) you're targetting.","ao_critcss"); ?>" style="width:100%;"></label>
                        <label id="critcss_addedit_pagetype_wrapper"><?php _e("Conditional tags, custom post type or page templates:","ao_critcss"); ?>
                            <select id="critcss_addedit_pagetype" style="width:100%;">
                                <option value="" disabled selected><?php _e("Select from the list below ...","ao_critcss"); ?></option>
								<option value="" disabled selected>&#8194;<?php _e("Conditional tags","ao_critcss"); ?></option>
                                <?php
                                    foreach ($ao_acceptedTypes as $pageType) {
										if (!empty($prevType) && (substr($prevType,0,3) !== substr($pageType,0,3))) {
											if (substr($pageType,0,12)==="custom_post_") {
												?><option value="" disabled selected>&#8194;<?php _e("Custom Post Types","ao_critcss"); ?></option><?php	
											} else if (substr($pageType,0,9)==="template_") {
												?><option value="" disabled selected>&#8194;<?php _e("Page Templates","ao_critcss"); ?></option><?php
											} else if (substr($pageType,0,4)==="bbp_") {
												?><option value="" disabled selected>&#8194;<?php _e("BBPress","ao_critcss"); ?></option><?php
											} else if (substr($pageType,0,4)==="edd_") {
												?><option value="" disabled selected>&#8194;<?php _e("Easy Digital Downloads","ao_critcss"); ?></option><?php
											} else if (substr($pageType,0,3)==="bp_") {
												?><option value="" disabled selected>&#8194;<?php _e("BuddyPress","ao_critcss"); ?></option><?php
											}
										}
                                        echo "<option value=\"".$pageType."\">"."&#8194;&#8194;".str_replace(array("template_","custom_post_"),"",$pageType)."</option>";
										$prevType=$pageType;
                                    }
                                ?>
                            </select>
                        </label>
                        <br />
                        <label>Critical CSS: <textarea rows="9" cols="10" style="width:100%;" id="critcss_addedit_css"></textarea></label>
                        <input type="hidden" id="critcss_addedit_file">
                        <input type="hidden" id="critcss_addedit_id">
                    </form>
                </div>
                <div id="confirm-rm" title="<?php _e("Remove rule and CSS-file?","ao_critcss") ?>" class="hidden">
                    <p><?php _e("The file with critical CSS will be deleted immediately and cannot be recovered! Are you sure?","ao_critcss"); ?></p>
                </div>
				<div id="default_critcss_wrapper" class="hidden">
					<textarea id="dummyDefault" rows="10" cols="10" style="width:100%;" placeholder="<?php _e("Paste your default above the fold CSS here.","ao_critcss"); ?> <?php _e("Leaving this empty will cause CSS for requests that do not match below rules to be inlined.","ao_critcss");?>"></textarea>
				</div>
				<form method="post" action="options.php">
					<?php settings_fields( 'critcss-settings-group' ); ?>
					<div style="margin-bottom:20px;padding:2px 10px;border-left:solid;border-left-width:5px;border-left-color:#46b450;background-color:white;">
						<p><strong><?php _e("3 steps to optimize your Critical CSS","ao_critcss");?></strong></p>
						<ol>
							<li><?php _e("Add/ edit your <strong>default critical CSS (button below)</strong>. This will be used on all post/ pages by default, but has the lowest priority. You can also leave this empty, in which case all CSS will be inlined if no rules are matched.","ao_critcss");?></li>
							<li><?php _e("Add/ edit <strong>rules based on conditional tags, custom post types or page templates</strong>. These override the default one, but allows to specify the critical CSS for a set of posts/ pages.","ao_critcss");?></li>
							<li><?php _e("Add/ edit <strong>rules based on path (url)</strong>. These have the highest priority. The more precise (longer) the path, the higher priority it takes.","ao_critcss");?></li>
						</ol>
					</div>
					<textarea id="autoptimize_css_defer_inline" name="autoptimize_css_defer_inline" rows="10" cols="10" style="width:100%;" placeholder="<?php _e("Paste your default above the fold CSS here.","ao_critcss"); ?> <?php _e("Leaving this empty will cause CSS for requests that do not match below rules to be inlined.","ao_critcss");?>" ><?php echo get_option('autoptimize_css_defer_inline',''); ?></textarea>
					<table><tbody id="critCssView"></tbody></table>
					<input type="text" id="critCssOrigin" name="critSettings" style="width:100%;" value='<?php echo (json_encode ((object)$critSettings)); ?>'>
					<input type="hidden" id="critLicense" name="critLicense" style="display:none;" value='<?php echo get_option("critLicense",""); ?>'>
					<p class="submit">
						<input type="submit" class="button-primary" value="<?php _e('Save Changes','ao_critcss') ?>" />
                        <span id="addCritCssButton" class="button-secondary"><?php _e('Add new Critical CSS rule','ao_critcss') ?></span>
						<span id="editDefaultButton" class="button-secondary"><?php _e('Edit Default Critical CSS','ao_critcss'); ?></span>
					</p>
				</form>
				<script>
					document.getElementById("critCssOrigin").style.display = 'none';
					document.getElementById("autoptimize_css_defer_inline").style.display = 'none';
					
                    jQuery( document ).ready(function() {
	                    critCssArray=JSON.parse(document.getElementById("critCssOrigin").value);
                        drawTable(critCssArray);
                        
                        jQuery("#addCritCssButton").click(function(){addEditRow();});
						jQuery("#editDefaultButton").click(function(){editDefaultCritCss();});
   					})
                    
					function drawTable(critCssArray) {
						jQuery("#critCssView").empty();
						jQuery.each(critCssArray,function(k,v) {
                            if (k=="inpath") {
                                kstring="<?php _e("Rules based on part of the Path (URL):","ao_critcss") ?>";
                            } else if (k=="type") {
                                kstring="<?php _e("Rules based on conditional tags, custom post types or page templates:","ao_critcss") ?>";
                            }
							jQuery("#critCssView").append("<tr><td colspan='2'><strong>"+kstring+"</strong> </td></tr>");
                            nodeNumber=0;
							jQuery.each(v,function(i,nv){
                                nodeNumber++;
                                nodeId=k+"_"+nodeNumber;
                                if (i!="dummy") {
                                    jQuery("#critCssView").append("<tr><td>"+i+"</td><td>"+nv+"</td><td><span class=\"button-secondary\" style=\"float:right;\" id=\""+nodeId+"_edit\"><?php _e("Edit","ao_critcss"); ?></span></td><td><span class=\"button-secondary\" style=\"float:right;\" id=\""+nodeId+"_remove\"><?php _e("Remove","ao_critcss"); ?></span></td></tr>");							
                                    jQuery("#"+nodeId+"_edit").click(function(){addEditRow(this.id);});
                                    jQuery("#"+nodeId+"_remove").click(function(){confirmRemove(this.id);});
                                }
							})
						});
					}
                    
                    function confirmRemove(idToRemove) {
                        jQuery( "#confirm-rm" ).dialog({
                            resizable: false,
                            height:200,
                            modal: true,
                            buttons: {
                              "<?php _e("Delete","ao_critcss") ?>": function() {
                                removeRow(idToRemove);
								updateAfterChange();
								jQuery( this ).dialog( "close" );
                              },
                              Cancel: function() {
                                jQuery( this ).dialog( "close" );
                              }
                            }
                        });
                    }
                    
                    function removeRow(idToRemove) {
						splits=idToRemove.split(/_/);
						crit_type=splits[0];
						crit_item=splits[1];
						crit_key=Object.keys(critCssArray[crit_type])[crit_item-1];
						crit_file=critCssArray[crit_type][crit_key];
						delete critCssArray[crit_type][crit_key];
						
						var data = {
							'action': 'rm_critcss',
							'critcss_rm_nonce': '<?php echo wp_create_nonce( "rm_critcss_nonce" );?>',
							'cachebustingtimestamp': new Date().getTime(),
							'critcssfile': crit_file
						};

						jQuery.ajaxSetup({
							async: false
						});

						jQuery.post(ajaxurl, data, function(response) {
                            response_array=JSON.parse(response);
                            if (response_array["code"]!=200) {
                                // not displaying notice, as the end result is OK; the file isn't there
                                // displayNotice(response_array["string"]);
                            }
						});
					}
                    
                    function updateAfterChange() {
                        document.getElementById("critCssOrigin").value=JSON.stringify(critCssArray);
                        drawTable(critCssArray);
                        jQuery("#unSavedWarning").show();
                    }
                    
                    function addEditRow(idToEdit) {
                        resetForm();
                        if (idToEdit) {
                            dialogTitle="<?php _e("Edit critical CSS","ao_critcss") ?>";
                            
                            splits=idToEdit.split(/_/);
                            crit_type=splits[0];
                            crit_item=splits[1];
                            crit_key=Object.keys(critCssArray[crit_type])[crit_item-1];
                            crit_file=critCssArray[crit_type][crit_key];
                            
                            jQuery("#critcss_addedit_id").val(idToEdit);
                            jQuery("#critcss_addedit_type").val(crit_type);
                            jQuery("#critcss_addedit_file").val(crit_file);
                            jQuery("#critcss_addedit_css").attr("placeholder", "Loading CSS ...");
                            jQuery("#critcss_addedit_type").attr("disabled",true);
                            
                            if (crit_type==="inpath") {
                                jQuery("#critcss_addedit_path").val(crit_key);
                                jQuery("#critcss_addedit_path_wrapper").show();
                                jQuery("#critcss_addedit_pagetype_wrapper").hide();
                            } else {
                                jQuery("#critcss_addedit_pagetype").val(crit_key);
                                jQuery("#critcss_addedit_pagetype_wrapper").show();
                                jQuery("#critcss_addedit_path_wrapper").hide();
                            }
                            
                            var data = {
                                'action': 'fetch_critcss',
                                'critcss_fetch_nonce': '<?php echo wp_create_nonce( "fetch_critcss_nonce" );?>',
                                'cachebustingtimestamp': new Date().getTime(),
                                'critcssfile': crit_file
                            };

                            jQuery.post(ajaxurl, data, function(response) {
                                response_array=JSON.parse(response);
                                if (response_array["code"]==200) {
                                    jQuery("#critcss_addedit_css").val(response_array["string"]);
                                } else {
									jQuery(".ui-dialog-titlebar").after("<div class='notice notice-warning'><p>"+response_array["string"]+" <?php _e("Paste your CSS to rewrite the file.","ao_critcss"); ?>"+"</p></div>");
									jQuery("#critcss_addedit_css").attr("placeholder","").focus();
                                }
                            });
                        } else {
                            dialogTitle="<?php _e("Add critical CSS","ao_critcss") ?>";
                            
                            // default: inpath, hide content type field
                            jQuery("#critcss_addedit_type").val("inpath");
                            jQuery("#critcss_addedit_pagetype_wrapper").hide();
                            
                            // event handler on type to switch display
                            jQuery("#critcss_addedit_type").on('change', function (e) {
                                if(this.value==="type") {
                                    jQuery("#critcss_addedit_pagetype_wrapper").show();
                                    jQuery("#critcss_addedit_path_wrapper").hide();
                                } else {
                                    jQuery("#critcss_addedit_path_wrapper").show();
                                    jQuery("#critcss_addedit_pagetype_wrapper").hide();
                                }
                            });
                        }
                        
                        jQuery("#addEditCritCss").dialog({
                            autoOpen: true,
                            height: 500,
                            width: 600,
                            title: dialogTitle,
                            modal: true,
                            buttons: {
                                "<?php _e("Submit","ao_critcss") ?>": saveEditCritCss,
                                Cancel: function() {
                                    resetForm();
                                    jQuery("#addEditCritCss").dialog( "close" );
                                }
                            }
                        });
                    }
                    
					function editDefaultCritCss(){
						document.getElementById("dummyDefault").value=document.getElementById("autoptimize_css_defer_inline").value;
						jQuery("#default_critcss_wrapper").dialog({
							autoOpen: true,
							height: 500,
                            width: 600,
                            title: "<?php _e("Your default Critical CSS","ao_critcss"); ?>",
                            modal: true,
                            buttons: {
                                "<?php _e("Submit","ao_critcss") ?>": function(){
									document.getElementById("autoptimize_css_defer_inline").value=document.getElementById("dummyDefault").value;
									jQuery("#unSavedWarning").show();
									jQuery("#default_critcss_wrapper").dialog( "close" );
								},
                                Cancel: function() {
                                    jQuery("#default_critcss_wrapper").dialog( "close" );
                                }
                            }
						});
					}
					
                    function saveEditCritCss(){
                        critcssfile=jQuery("#critcss_addedit_file").val();
                        critcsscontents=jQuery("#critcss_addedit_css").val();
                        critcsstype=jQuery("#critcss_addedit_type").val();
                        critcssid=jQuery("#critcss_addedit_id").val();
                        
                        if (critcssid) {
                            // this was an "edit" action, so remove original
                            // will also remove the file, but that will get rewritten anyway
                            removeRow(critcssid);
                        }
                        
                        if (critcsstype==="type") {
                            critcsssecond=jQuery("#critcss_addedit_pagetype").val();
                        } else {
                            critcsssecond=jQuery("#critcss_addedit_path").val();
                        }
                        
                        if (!critcssfile) {
                            critcssfile="critcss_"+md5(critcsscontents+critcsssecond)+".css";
                        }
                        
                        critCssArray[critcsstype][critcsssecond]=critcssfile;
                        updateAfterChange();
                        
                        var data = {
                            'action': 'save_critcss',
                            'critcss_save_nonce': '<?php echo wp_create_nonce( "save_critcss_nonce" );?>',
                            'critcssfile': critcssfile,
                            'critcsscontents': critcsscontents
                        };

                        jQuery.post(ajaxurl, data, function(response) {
                                response_array=JSON.parse(response);
                                if (response_array["code"]!=200) {
                                    displayNotice(response_array["string"]);
                                }
                        });
                        
                        jQuery("#addEditCritCss").dialog( "close" );
                    }

                    function displayNotice(textIn) {
                        jQuery('<div class="error notice is-dismissable"><p>'+textIn+'</p></div>').insertBefore("#unSavedWarning");
                    }
                    
                    function resetForm() {
                        jQuery("#critcss_addedit_css").attr("placeholder", "Copy/paste minified critical CSS here.");
                        jQuery("#critcss_addedit_type").attr("disabled",false);
                        jQuery("#critcss_addedit_path_wrapper").show();
                        jQuery("#critcss_addedit_id").val("");
                        jQuery("#critcss_addedit_path").val("");
                        jQuery("#critcss_addedit_file").val("");
                        jQuery("#critcss_addedit_pagetype").val("");
                        jQuery("#critcss_addedit_css").val("");
                    }
                    
                    // from https://github.com/blueimp/JavaScript-MD5
                    !function(n){"use strict";function t(n,t){var r=(65535&n)+(65535&t),e=(n>>16)+(t>>16)+(r>>16);return e<<16|65535&r}function r(n,t){return n<<t|n>>>32-t}function e(n,e,o,u,c,f){return t(r(t(t(e,n),t(u,f)),c),o)}function o(n,t,r,o,u,c,f){return e(t&r|~t&o,n,t,u,c,f)}function u(n,t,r,o,u,c,f){return e(t&o|r&~o,n,t,u,c,f)}function c(n,t,r,o,u,c,f){return e(t^r^o,n,t,u,c,f)}function f(n,t,r,o,u,c,f){return e(r^(t|~o),n,t,u,c,f)}function i(n,r){n[r>>5]|=128<<r%32,n[(r+64>>>9<<4)+14]=r;var e,i,a,h,d,l=1732584193,g=-271733879,v=-1732584194,m=271733878;for(e=0;e<n.length;e+=16)i=l,a=g,h=v,d=m,l=o(l,g,v,m,n[e],7,-680876936),m=o(m,l,g,v,n[e+1],12,-389564586),v=o(v,m,l,g,n[e+2],17,606105819),g=o(g,v,m,l,n[e+3],22,-1044525330),l=o(l,g,v,m,n[e+4],7,-176418897),m=o(m,l,g,v,n[e+5],12,1200080426),v=o(v,m,l,g,n[e+6],17,-1473231341),g=o(g,v,m,l,n[e+7],22,-45705983),l=o(l,g,v,m,n[e+8],7,1770035416),m=o(m,l,g,v,n[e+9],12,-1958414417),v=o(v,m,l,g,n[e+10],17,-42063),g=o(g,v,m,l,n[e+11],22,-1990404162),l=o(l,g,v,m,n[e+12],7,1804603682),m=o(m,l,g,v,n[e+13],12,-40341101),v=o(v,m,l,g,n[e+14],17,-1502002290),g=o(g,v,m,l,n[e+15],22,1236535329),l=u(l,g,v,m,n[e+1],5,-165796510),m=u(m,l,g,v,n[e+6],9,-1069501632),v=u(v,m,l,g,n[e+11],14,643717713),g=u(g,v,m,l,n[e],20,-373897302),l=u(l,g,v,m,n[e+5],5,-701558691),m=u(m,l,g,v,n[e+10],9,38016083),v=u(v,m,l,g,n[e+15],14,-660478335),g=u(g,v,m,l,n[e+4],20,-405537848),l=u(l,g,v,m,n[e+9],5,568446438),m=u(m,l,g,v,n[e+14],9,-1019803690),v=u(v,m,l,g,n[e+3],14,-187363961),g=u(g,v,m,l,n[e+8],20,1163531501),l=u(l,g,v,m,n[e+13],5,-1444681467),m=u(m,l,g,v,n[e+2],9,-51403784),v=u(v,m,l,g,n[e+7],14,1735328473),g=u(g,v,m,l,n[e+12],20,-1926607734),l=c(l,g,v,m,n[e+5],4,-378558),m=c(m,l,g,v,n[e+8],11,-2022574463),v=c(v,m,l,g,n[e+11],16,1839030562),g=c(g,v,m,l,n[e+14],23,-35309556),l=c(l,g,v,m,n[e+1],4,-1530992060),m=c(m,l,g,v,n[e+4],11,1272893353),v=c(v,m,l,g,n[e+7],16,-155497632),g=c(g,v,m,l,n[e+10],23,-1094730640),l=c(l,g,v,m,n[e+13],4,681279174),m=c(m,l,g,v,n[e],11,-358537222),v=c(v,m,l,g,n[e+3],16,-722521979),g=c(g,v,m,l,n[e+6],23,76029189),l=c(l,g,v,m,n[e+9],4,-640364487),m=c(m,l,g,v,n[e+12],11,-421815835),v=c(v,m,l,g,n[e+15],16,530742520),g=c(g,v,m,l,n[e+2],23,-995338651),l=f(l,g,v,m,n[e],6,-198630844),m=f(m,l,g,v,n[e+7],10,1126891415),v=f(v,m,l,g,n[e+14],15,-1416354905),g=f(g,v,m,l,n[e+5],21,-57434055),l=f(l,g,v,m,n[e+12],6,1700485571),m=f(m,l,g,v,n[e+3],10,-1894986606),v=f(v,m,l,g,n[e+10],15,-1051523),g=f(g,v,m,l,n[e+1],21,-2054922799),l=f(l,g,v,m,n[e+8],6,1873313359),m=f(m,l,g,v,n[e+15],10,-30611744),v=f(v,m,l,g,n[e+6],15,-1560198380),g=f(g,v,m,l,n[e+13],21,1309151649),l=f(l,g,v,m,n[e+4],6,-145523070),m=f(m,l,g,v,n[e+11],10,-1120210379),v=f(v,m,l,g,n[e+2],15,718787259),g=f(g,v,m,l,n[e+9],21,-343485551),l=t(l,i),g=t(g,a),v=t(v,h),m=t(m,d);return[l,g,v,m]}function a(n){var t,r="";for(t=0;t<32*n.length;t+=8)r+=String.fromCharCode(n[t>>5]>>>t%32&255);return r}function h(n){var t,r=[];for(r[(n.length>>2)-1]=void 0,t=0;t<r.length;t+=1)r[t]=0;for(t=0;t<8*n.length;t+=8)r[t>>5]|=(255&n.charCodeAt(t/8))<<t%32;return r}function d(n){return a(i(h(n),8*n.length))}function l(n,t){var r,e,o=h(n),u=[],c=[];for(u[15]=c[15]=void 0,o.length>16&&(o=i(o,8*n.length)),r=0;16>r;r+=1)u[r]=909522486^o[r],c[r]=1549556828^o[r];return e=i(u.concat(h(t)),512+8*t.length),a(i(c.concat(e),640))}function g(n){var t,r,e="0123456789abcdef",o="";for(r=0;r<n.length;r+=1)t=n.charCodeAt(r),o+=e.charAt(t>>>4&15)+e.charAt(15&t);return o}function v(n){return unescape(encodeURIComponent(n))}function m(n){return d(v(n))}function p(n){return g(m(n))}function s(n,t){return l(v(n),v(t))}function C(n,t){return g(s(n,t))}function A(n,t,r){return t?r?s(t,n):C(t,n):r?m(n):p(n)}"function"==typeof define&&define.amd?define(function(){return A}):"object"==typeof module&&module.exports?module.exports=A:n.md5=A}(this);
				</script>
		</div>
	</div>
<?php 
}

// ajax receiver to GET critical CSS from FS
add_action( 'wp_ajax_fetch_critcss', 'critcss_fetch_callback' );
function critcss_fetch_callback() {
	check_ajax_referer( "fetch_critcss_nonce", 'critcss_fetch_nonce' );
    if ((current_user_can('manage_options')) && (critcss_check_filename($_POST['critcssfile']))) {
        $critcssfile=AOCRITCSSDIR.strip_tags($_POST['critcssfile']);
        if (file_exists($critcssfile)) {
            $content=file_get_contents($critcssfile);
        }
    }
    
    if (!$content) {
        $response["code"]="500";
        $response["string"]="Error reading file ".$critcssfile;
    } else {
        $response["code"]="200";
        $response["string"]=$content;
    }
    
    echo json_encode($response);
    
    wp_die();
}

// ajax receiver to SAVE critical CSS from FS
add_action( 'wp_ajax_save_critcss', 'critcss_save_callback' );
function critcss_save_callback() {
	check_ajax_referer( "save_critcss_nonce", 'critcss_save_nonce' );
	
    if ((current_user_can('manage_options')) && (critcss_check_filename($_POST['critcssfile']))) {
        $critcssfile=AOCRITCSSDIR.strip_tags($_POST['critcssfile']);
        $critcsscontents=stripslashes($_POST['critcsscontents']);
        if (critcss_check_csscontents($critcsscontents)) {
            $status=file_put_contents($critcssfile,$critcsscontents,LOCK_EX);
        } else {
			$error = true;
		}
    } else {
		$error = true;
	}

    if (!$status || $error) {
        $response["code"]="500";
        $response["string"]="Error saving file ".$critcssfile;
    } else {
        $response["code"]="200";
        $response["string"]="file saved";
    }
    
    echo json_encode($response);

    wp_die();
}

// ajax receiver to REMOVE critical CSS from FS
add_action( 'wp_ajax_rm_critcss', 'critcss_rm_callback' );
function critcss_rm_callback() {
	check_ajax_referer( "rm_critcss_nonce", 'critcss_rm_nonce' );
    if ((current_user_can('manage_options')) && (critcss_check_filename($_POST['critcssfile']))) {
        $critcssfile=AOCRITCSSDIR.strip_tags($_POST['critcssfile']);
        if (file_exists($critcssfile)) {
            $status=unlink($critcssfile);
        }
    }
    
    if (!$status) {
        $response["code"]="500";
        $response["string"]="Error removing; file ".$critcssfile." does not exist.";
    } else {
        $response["code"]="200";
        $response["string"]="file removed";
    }
    
    echo json_encode($response);
    
    wp_die();
}

function critcss_check_filename($filename) {
    // try to avoid directory traversal when reading/ writing/ deleting crit-css files
    if (strpos($filename,"critcss_") !== 0) { return false; }
    else if (substr($filename,-4,4)!==".css") { return false; }
    // and use wordpress core's sanitize_file_name to see if anything fishy is going on
    else if (sanitize_file_name($filename) !== $filename) { return false; }
    else { return true; }
}

function critcss_check_csscontents($cssin) {
    // try to avoid code injection when writing crit-css files
    $blacklist=array("#!","function(","<script","<?php");
    foreach ($blacklist as $blacklisted) {
        if (strpos($cssin,$blacklisted)!==false) { return false; }
    }
    // and if there's no curly brackets or colons it's just not css, right?
    $pinklist=array("{","}",":");
    foreach ($pinklist as $needed) {
        if (strpos($cssin,$needed)===false) { return false; }
    }
    return true;
 }

/*
* is_blog_page does not exist in wordpress core
* cfr. https://codex.wordpress.org/Conditional_Tags#The_Blog_Page
* this fixes that
*/
if (!function_exists("is_blog_page")) {
	function is_blog_page() {
		if (!is_front_page() && is_home()) {
			return true;
		} else {
			return false;
		}
	}
}
 
// check state
if (!function_exists("om_check_state")) {
    function om_check_state($plugin="ao_critcss",$version="0.9") {
		$licenseKey=trim(get_option("critLicense",""));
		$licenseStatus=get_transient("om_aocritcss_".md5($licenseKey));
		if ($licenseKey && $licenseStatus && $licenseStatus["state"]==="valid") {
			return true;
		} else if ($licenseKey && !$licenseStatus) {
			$licenseStatus=check_license_status($licenseKey,$plugin,$version);
			if ($licenseStatus && $licenseStatus["state"]==="valid") {
				if (array_key_exists("warning",$licenseStatus)) {
					echo "<div class=\"notice notice-warning\"><p>";
					echo $licenseStatus["warning"];
					echo "</p></div>";
				}
				return true;
			} else {
				if ($licenseStatus) {
					$reason=$licenseStatus["state"];
				} else {
					$reason="couldnotvalidate";
				}
				show_license_input($reason);
			}
		} else if (!$licenseKey) {
			show_license_input("nokey");
		}
	}
}

function check_license_status($licenseKey,$plugin,$version) {
	$omCheckUrl = "http://misc.optimizingmatters.com/api/checkLicense.php?licensekey=".$licenseKey."&plugin=".$plugin."&version=".$version."&host=".urlencode(site_url());
	$checkResp = wp_remote_get($omCheckUrl);

	if (is_wp_error($checkResp)) {
		$checkStatus=false;
	} else {
		if (in_array(wp_remote_retrieve_response_code($checkResp),array(400,403,404))) {
			$checkStatus=false;
		} else {
			$licenseStatus=json_decode(wp_remote_retrieve_body($checkResp),true);
			if ($licenseStatus) {
				$checkStatus=true;
			} else {
				$checkStatus=false;
			}
		}
	}
	
	if ($checkStatus) {
		if ($licenseStatus["state"]==="valid") {
			// store for 1 day
			set_transient("om_aocritcss_".md5($licenseKey),$licenseStatus,DAY_IN_SECONDS);
		} 
		return $licenseStatus;
	} else {
		return false;
	}
}

function show_license_input($reason) {
	global $critSettings;
	?>
	<h2>License key</h2>
	<div class="notice notice-warning"><p>
		<?php
		switch ($reason) {
            		case "overuse":
                		update_option("critLicense","");
            		case "nokey":
				_e("Please enter your criticalcss.com license key.","ao_critcss");
				break;
			case "invalid":
				_e("This is not a valid criticalcss.com license key.","ao_critcss");
				break;
			case "expired":
				_e("This criticalcss.com license key is valid but seems to have expired.","ao_critcss");
				break;
			default:
				_e("Something went wrong while validating this key.","ao_critcss");
		}
		_e(" Go to <a href=\"https://criticalcss.com/\" target=\"_blank\">https://criticalcss.com/</a> and click on <strong>account</strong> to verify your license key or to edit your payment details.","ao_critcss");
		?>
	</p></div>
	<form method="post" action="options.php">
		<?php settings_fields( 'critcss-settings-group' ); ?>
		<input type="text" id="critLicense" name="critLicense" style="width:100%;" placeholder="<?php _e("Please enter your license key.","ao_critcss"); ?>" value='<?php echo get_option("critLicense",""); ?>'>
		<input type="hidden" id="critCssOrigin" name="critSettings" style="display:none;" value='<?php echo (json_encode ((object)$critSettings)); ?>'>

		<p class="submit">
			<input type="submit" class="button-primary" value="<?php _e('Save Changes','ao_critcss') ?>" />
		</p>
	</form>
	<?php
}
