<?php 

/*
Plugin Name: SEO Optimized Images Business
Plugin URI: http://webriti.com
Description: The **SEO Optimized Images** plugin Seo Optmized Images Plugin lets you dynamically insert Seo Friendly alt attributes and title attributes to your Images .  Simply activate the plugin, provide the pattern and you are ready to go. 
Version: 1.5.2
Author: priyanshu.mittal
Author URI: http://webriti.com
Text Domain: seo-optimized-images-business
Domain Path: /lang
*/


// Plugin Root File.
if ( ! defined( 'SEO_IMAGES_PLUGIN_FILE' ) ) {
	define( 'SEO_IMAGES_PLUGIN_FILE', __FILE__ );
}

/*
 * adding plugin menu name in dashboard
 *
 */
add_action('admin_menu', 'soi_add_menu_page');
function soi_add_menu_page()
{
	$seo_lang_dir  = dirname( plugin_basename( SEO_IMAGES_PLUGIN_FILE ) ) . '/lang/';
	load_plugin_textdomain( 'seo-optimized-images-business', false, $seo_lang_dir );
	
	add_menu_page( 'soi_settings_page', __('SEO Optimized Images','seo-optimized-images-business'), 'administrator', 'soi_setting','soi_create_setting_page',''); 
}
 
	function soi_create_setting_page()
	{
		require_once('seo-optimized-images-settings.php');
	}

	
	
/*
 * adding all stylesheet files here
 *
 */
add_action( 'admin_enqueue_scripts', 'soi_load_custom_wp_admin_style' ); 
function soi_load_custom_wp_admin_style($hook) {
	if ($hook != 'toplevel_page_soi_setting'){return;} 
    wp_register_style ('soi_custom_wp_admin_css', plugins_url('css/plugin-admin-panel.css', __FILE__));
    wp_enqueue_style( 'soi_custom_wp_admin_css' );
    wp_enqueue_style( 'wp-color-picker' ); 
}



/*
 * adding all admin script files here
 *
 */
function soi_load_custom_wp_admin_scripts($hook) {
	if ($hook != 'toplevel_page_soi_setting'){ return; } 
	wp_register_script( 'soi_custom_wp_admin_js', plugin_dir_url( __FILE__ ) . 'js/plugin-admin-panel.js',array('jquery','jquery-ui-core','jquery-ui-tabs','wp-color-picker'), false, '1.0.0' );
	wp_enqueue_script ('soi_custom_wp_admin_js');
}
add_action( 'admin_enqueue_scripts', 'soi_load_custom_wp_admin_scripts' );



$soi_options_array = get_soi_option();
/*
 * conditional checks for thumbnail and woocommerce images
 *
 */
if($soi_options_array['soi_override_thumbnail_images'] == 1) require('seo-optimized-thumbnail-images.php');

/*
 * seo optimize all images added by editor
 *
 */	
add_filter('the_content', 'soi_replace_tags', 100); 
function soi_replace_tags( $content )
{   
	global $post; 
	
	$soi_options_array = get_soi_option();
	
	
	// get the post title for later use
	$post_title = esc_attr($post->post_title);
	
	$taxonomy = '';
	$taxonomy_objects = get_object_taxonomies( $post->post_type, 'objects' );
	if(!empty($taxonomy_objects)){
		foreach($taxonomy_objects as $key=>$val){
			$taxonomy = $key;
		}
	}
	
	$post_category='';
	$post_tags='';
	$cat_arr = array();
	$post_tags_arr = array();
	
		// Get post categories
		if($post->post_type=='post')
		{
			
			$postcategories = get_the_category();
			
			if ($postcategories) {
				foreach($postcategories as $category) {
					$post_category .= $category->name .' ';
					$cat_arr[] = $category->term_id;
				}
			}
			
			if( $soi_options_array['soi_override_yost_primary_cat'] == true ){
				if( class_exists('WPSEO_Primary_Term') ){
					$cat = new WPSEO_Primary_Term('category', get_the_ID());
					$cat = $cat->get_primary_term();
					$post_category = get_cat_name($cat);
				}
			}
			
		}
		else{
			
			$postcategories = get_the_terms( $post->ID, $taxonomy );
			
			if ($postcategories) {
				foreach($postcategories as $category) {
					$post_category .= $category->name .' ';
					$cat_arr[] = $category->term_id;
				}
			}
			
			if( $soi_options_array['soi_override_yost_primary_cat'] == true ){
				if( class_exists('WPSEO_Primary_Term') ){
					$cat = new WPSEO_Primary_Term('product_cat', get_the_ID());
					$cat = $cat->get_primary_term();
					$post_category = get_cat_name($cat);
				}
			}
		}
		
		if($post->post_type=='post'){
			// Get all tags of post
			$posttags = get_the_terms( $post->ID, $post->post_type.'_tag' );
			if ($posttags) {
				foreach($posttags as $tag) {
					$post_tags .= $tag->name .' ';
					$post_tags_arr[] = $tag->term_id;
				}
			}
		}
	
	$post_types = array();
	$post_types = ( !empty($soi_options_array['soi_exclude_post_type']) ? $soi_options_array['soi_exclude_post_type'] : array() );
	
	$post_ids = array();
	$post_ids = ( !empty($soi_options_array['soi_exclude_post_ids']) ? explode(',',$soi_options_array['soi_exclude_post_ids']) : array() );
	
	$post_cats = array();
	$post_cats = ( !empty($soi_options_array['soi_exclude_post_cat']) ? explode(',',$soi_options_array['soi_exclude_post_cat']) : array() );
	
	$post_tagsarr = array();
	$post_tagsarr = ( !empty($soi_options_array['soi_exclude_post_tags']) ? explode(',',$soi_options_array['soi_exclude_post_tags']) : array() );
	
	$page_ids = array();
	$page_ids = ( !empty($soi_options_array['soi_exclude_page_ids']) ? explode(',',$soi_options_array['soi_exclude_page_ids']) : array() );
	
	
	if(!in_array($post->post_type, $post_types)){
		
		if($post->post_type=='page'){
			if (!in_array($post->ID, $page_ids)) {
				// replace image title and alt attributes function
				$content = optimize_all_images_in_contents($content,$post_title,$post_category,$post_tags);
			}
		}
		elseif($post->post_type=='post'){

			if (!in_array($post->ID, $post_ids)) {
						
				if(check_array_exist_value($cat_arr,$post_cats)==false){
								
						if(check_array_exist_value($post_tags_arr,$post_tagsarr)==false){
								// replace image title and alt attributes function
								$content = optimize_all_images_in_contents($content,$post_title,$post_category,$post_tags);
						}	
				}
			}
		}
		else
		{
			if ( class_exists( 'WooCommerce' ) ){
				if( is_woocommerce() && $soi_options_array['soi_override_woo_thumbnail_images'] == 1  ){
					if (!in_array($post->ID, $post_ids)) {
						if(check_array_exist_value($cat_arr,$post_cats)==false){		
								if(check_array_exist_value($post_tags_arr,$post_tagsarr)==false){
										// replace image title and alt attributes function
										$content = optimize_all_images_in_contents($content,$post_title,$post_category,$post_tags);
								}	
						}
					}
				}
				else
				{
					if (!in_array($post->ID, $post_ids)) {
						if(check_array_exist_value($cat_arr,$post_cats)==false){		
								if(check_array_exist_value($post_tags_arr,$post_tagsarr)==false){
										// replace image title and alt attributes function
										$content = optimize_all_images_in_contents($content,$post_title,$post_category,$post_tags);
								}	
						}
					}
				}
			}
			else
			{
				if (!in_array($post->ID, $post_ids)) {
						if(check_array_exist_value($cat_arr,$post_cats)==false){		
								if(check_array_exist_value($post_tags_arr,$post_tagsarr)==false){
										// replace image title and alt attributes function
										$content = optimize_all_images_in_contents($content,$post_title,$post_category,$post_tags);
								}	
						}
					}
			}
			
		}
	}
	
	return $content;
}




/*
 * optimize images in text widget
 *
 */
add_filter('widget_text', 'soi_load_custom_widget_output',999, 3);
function soi_load_custom_widget_output($content, $instance, $id_base){

	$post_title = (empty($instance['title'])?'':$instance['title']);
	
	// replace image title and alt attributes function 
	$content = optimize_all_images_in_contents( $content, $post_title, $post_category = '', $post_tags = '' );
	
	return $content;
}



// getting all settings
function get_soi_option(){
	return get_option('soi_options_values');
}

// check category exist in array 
function check_array_exist_value($cat_arr,$post_cats){
	
	return array_intersect($cat_arr, $post_cats);
}


// optimize all images alt and title in content 
function optimize_all_images_in_contents($content, $post_title, $post_category, $post_tags){
	
	$alt_text='';
	$title='';

    $soi_options_array = get_soi_option();
	
	// alt value settings
	$alt_text              = $soi_options_array['soi_alt_value'];
	// get custom title 
	$title_text            = $soi_options_array['soi_title_value'];
   
	//check setting for overinding alt tag
	$alt_flag              = $soi_options_array['soi_override_alt_value']; 
	//check setting for overinding title tag
	$title_flag            = $soi_options_array['soi_override_title_value']; 
	
    // count number of images found in content
    $count = preg_match_all('/<img[^>]+>/i', $content, $images);


    if($count>0)
    {   
        // we want to output like alt = "text"
        $t = 'alt = "'.$alt_text.'"';
        
        // we want to output like title = "text"
        $t_title = 'title = "'.$title_text.'"';
        
        foreach($images[0] as $img)
        {  
        
			// Get the Name of Image Files. 
			$output = preg_match_all( '/<img[^>]+src=[\'"]([^\'"]+)[\'"].*>/i', $img, $matches);
        
			$get_file_name = pathinfo($matches[1][0]);
			$image_file_name = $get_file_name['filename'];

			// Replace the Values for alt tag
			$alt_text = str_replace('%title',$post_title,$alt_text ); 
			$alt_text = str_replace('%name',$image_file_name,$alt_text );
			$alt_text = str_replace('%tags',$post_tags,$alt_text );
			$alt_text = str_replace('%category',$post_category,$alt_text );
        
			// replace the values for title tag.
			$title_text = str_replace('%title',$post_title,$title_text ); 
			$title_text = str_replace('%name',$image_file_name,$title_text );
			$title_text = str_replace('%tags',$post_tags,$title_text );
			$title_text = str_replace('%category',$post_category,$title_text );
        
			//configure tags with specified values from option panel.
			$t = ' alt = "'.$alt_text.'" ';
			$t_title =  ' title = "'.$title_text.'" ';
         
			//take the alt tag out from the image html markup
			$is_alt = preg_match_all('/ alt="([^"]*)"/i', $img, $alt);

			/* ---------------------- check for alt tag --------------------- */
			if ($alt_flag == "1")
            {
				// if alt tag is not present than insert the tag.
				if($is_alt == 0)
				{   
					$new_img = str_replace('<img ', '<img '.$t , $img);
					$content = str_replace($img, $new_img, $content);
				}
				elseif($is_alt==1)
				{ 
				  
					$text = trim($alt[1][0]);
				  
					// Check if the alt text is empty. 
					if(empty($text))
					{   
						$new_img = str_replace($alt[0][0], $t, $img);
						$content = str_replace($img, $new_img, $content);
					}
					 
					// Should we override the existing alt tag
					if ($alt_flag == "1")
					{
					   $new_img = str_replace($alt[0][0], $t, $img);
					   $content = str_replace($img, $new_img, $content);
					}
				}
            }
           
		    /* ---------------------- first check weither title tag needs to be overide --------------------- */    
		    if($title_flag == "1")
			{
			
				if(!isset($new_img)) $new_img=$img; 
			
				$is_title = preg_match_all('/ title="([^"]*)"/i', $new_img, $title);
			 
				// check if title tag is not present in the img tag
				if($is_title == 0)
				{
					// create the title tag and insert the tag
					$final_img = str_replace('<img ', '<img '.$t_title , $new_img);
					$content = str_replace($new_img, $final_img, $content);
				  
				} else 
				{ 
				
					// you are here bcs title tags exsis and needs to be override
					$final_img = str_replace($title[0][0], $t_title, $new_img);
					$content = str_replace($new_img, $final_img, $content);
				}
			} 
            
        }
    }
    
    return $content;
}