<?php 
add_filter('post_thumbnail_html','soi_update_thumbnails',99);
function soi_update_thumbnails($html)
{   
	global $post; 
	
	$soi_options_array = get_soi_option();
   
	// get the post title for later use
	$post_title = $post->post_title;
   
	// Get all tags of post 
	$posttags = get_the_tags();
	$post_tags='';
	if ($posttags) {
		foreach($posttags as $tag) {
			$post_tags .= $tag->name .' ';
		}
	}

	// Get post categories
	$postcategories = get_the_category();
	$post_category='';
	if ($postcategories) {
		foreach($postcategories as $category) {
			$post_category .= $category->name .' ';
		}
	}
	
	if( $soi_options_array['soi_override_yost_primary_cat'] == true ){
		if( class_exists('WPSEO_Primary_Term') ){
			$cat = new WPSEO_Primary_Term('category', get_the_ID());
			$cat = $cat->get_primary_term();
			$post_category = get_cat_name($cat);
		}
	}
	
    // replace image title and alt attributes function 
	$html = optimize_all_images_in_contents( $html, $post_title, $post_category, $post_tags );
	
    return $html;
}