<?php
// Custom Admin Stylesheet
function custom_admin_style() {
    if(get_field('branding_type', 'option') == Visibility) {
    wp_enqueue_style('admin-styles', get_template_directory_uri() . '/css/hv-admin.min.css');
    } else if(get_field('branding_type', 'option') == Rankology) {
    wp_enqueue_style('admin-styles', get_template_directory_uri() . '/css/fp-admin.min.css');
    } else if(get_field('branding_type', 'option') == White_Label) {
    wp_enqueue_style('admin-styles', get_template_directory_uri() . '/css/wl-admin.min.css');
    }
}
add_action('admin_enqueue_scripts', 'custom_admin_style' );

// Custom Login Stylesheet
function custom_login_style() {
    if(get_field('branding_type', 'option') == Visibility) {
    wp_enqueue_style('login-styles', get_template_directory_uri() . '/css/hv-logins.min.css');
    } else if(get_field('branding_type', 'option') == Rankology) {
    wp_enqueue_style('login-styles', get_template_directory_uri() . '/css/fp-logins.min.css');
    } else if(get_field('branding_type', 'option') == White_Label) {
    }
}
add_action('login_enqueue_scripts', 'custom_login_style');

// Custom Dashboard Widget Functions
add_action('wp_dashboard_setup', 'template_dashboard_widgets');
function visibility_seo_widget_function() {
    echo '<iframe src="https://s3.amazonaws.com/templateadmin/hv-seo.html" width="100%" height="455" frameBorder="0"></iframe>';
}
function visibility_ppc_widget_function() {
    echo '<iframe src="https://s3.amazonaws.com/templateadmin/hv-ppc.html" width="100%" height="455" frameBorder="0"></iframe>';
}
function rankology_seo_widget_function() {
    echo '<iframe src="https://s3.amazonaws.com/templateadmin/ry-seo.html" width="100%" height="455" frameBorder="0"></iframe>';
}
function rankology_ppc_widget_function() {
    echo '<iframe src="https://s3.amazonaws.com/templateadmin/ry-ppc.html" width="100%" height="455" frameBorder="0"></iframe>';
}

function request_widget_function($a, $args) {
    echo "<iframe src='https://form.ourdemosites.com/?domain=".$args['args']['domain'] . "&type=" . $args['args']['type'] . "&support_email=" . $args['args']['support_email'] . "' width='100%' height='305' frameBorder='0'></iframe>";
    if(get_field('branding_type', 'option') == 'Visibility') {
    echo "<a href='http://www.highervisibility.com/website-maintenance-request' class='button button-primary request' target='_blank'>Allowed Maintenance Requests</a>";
    } else if(get_field('branding_type', 'option') == 'Rankology') {
    echo "<a href='http://www.rankology.com/website-maintenance-request' class='button button-primary request' target='_blank'>Allowed Maintenance Requests</a>";
    } else if(get_field('branding_type', 'option') == 'White_Label') {
    }
} 

function recent_forms_entry_widget_function() {
    global $wpdb;
    $db_entries = $wpdb->get_results( 
      "
      select 
      wp_frm_items.id as form_id,
      wp_frm_fields.name as field_name,
      meta_value as value,
      wp_frm_items.created_at as created_at
      from
      wp_frm_items join wp_frm_item_metas
      on wp_frm_items.id = wp_frm_item_metas.item_id
      join wp_frm_fields
      on wp_frm_fields.id = wp_frm_item_metas.field_id
      where wp_frm_fields.name in ('Name')
      order by created_at DESC
      limit 10
      "
    );
    $recent_entries = [];
    foreach ( $db_entries as $db_entry ) {
      $recent_entries[$db_entry->form_id][$db_entry->field_name] = $db_entry->value;
      $recent_entries[$db_entry->form_id]['created_at'] = date('M d, Y', strtotime($db_entry->created_at));
    }
    foreach ( $recent_entries as $form_id => $entry ) {
      echo '<div style="height: 31px;"><li class="entry-name entry-list" style="list-style: none; width: 50%; float: left;">'. $entry['Name'] .'</li>';
      echo '<li class="entry-date entry-list" style="list-style: none; width: 30%; float: left;">'. $entry['created_at'] .'</li>';
      echo '<li class="entry-view entry-list" style="list-style: none; width: 10%; float: left; text-align: right;"><a href="/wp-admin/admin.php?page=formidable-entries&frm_action=show&id='. $form_id .'">View</a></li></div>';
    }
}

// Custom Dashboard Widgets
function template_dashboard_widgets() {
    if (get_field('branding_type', 'option') == 'Visibility') {
        add_meta_box('visibility_seo_widget', 'Search Engine Optimization', 'visibility_seo_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('visibility_ppc_widget', 'Paid Search Management', 'visibility_ppc_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('recent_forms_entry_widget', 'Recent Leads', 'recent_forms_entry_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('request_widget', 'Request Form', 'request_widget_function', 'dashboard', 'side', 'high', array('domain' => $_SERVER['HTTP_HOST'], 'type' => 'highervisibility', 'support_email' => get_field('support_email', 'option')));
    } else if(get_field('branding_type', 'option') == 'Rankology') {
        add_meta_box('rankology_seo_widget', 'Search Engine Optimization', 'rankology_seo_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('rankology_ppc_widget', 'Paid Search Management', 'rankology_ppc_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('recent_forms_entry_widget', 'Recent Leads', 'recent_forms_entry_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('request_widget', 'Request Form', 'request_widget_function', 'dashboard', 'side', 'high', array('domain' => $_SERVER['HTTP_HOST'], 'type' => 'rankology', 'support_email' => get_field('support_email', 'option')));
    } else if(get_field('branding_type', 'option') == 'White_Label') {
        add_meta_box('recent_forms_entry_widget', 'Recent Leads', 'recent_forms_entry_widget_function', 'dashboard', 'side', 'high');
        add_meta_box('request_widget', 'Request Form', 'request_widget_function', 'dashboard', 'side', 'high', array('domain' => $_SERVER['HTTP_HOST'], 'type' => 'rankology', 'support_email' => get_field('support_email', 'option')));
    }
}
// Custom Dashboard Brands
function custom_admin_logo() {
    global $current_screen;    
    if(get_field('branding_type', 'option') == 'Visibility') {
    $img_src = '../wp-content/images/H.Visibility.png';
    if( isset($current_screen) && ($current_screen->id == 'dashboard' ) ):
        echo '<script type="text/javascript">jQuery(document).ready(function($) { $("#wpbody-content .wrap h1:eq(0)").html(""); });</script>';
        echo '<style> #icon-index { background:transparent; height:auto; width:auto; visibility:hidden; } #dashboard-widgets-wrap { clear:both } </style>';        
        echo '<script type="text/javascript">jQuery(document).ready(function($) {';
        echo '$(".index-php #wpbody-content .wrap h1:eq(0)").prepend("<span id=\"wlcms_dashboard_logo\"><img src=\"'.$img_src.'\" alt=\"\" /></span>");';
        echo '$("#wlcms_dashboard_logo").css({"visibility":"visible", "display": "block", "float" : "left", "margin": "0px 5px 0px 0px"});';
        echo '}); </script>';
    endif;
    } else if(get_field('branding_type', 'option') == 'Rankology') {
    $img_src = '../wp-content/images/Fully-Promoted.png';
    if( isset($current_screen) && ($current_screen->id == 'dashboard' ) ):
        echo '<script type="text/javascript">jQuery(document).ready(function($) { $("#wpbody-content .wrap h1:eq(0)").html(""); });</script>';
        echo '<style> #icon-index { background:transparent; height:auto; width:auto; visibility:hidden; } #dashboard-widgets-wrap { clear:both } </style>';        
        echo '<script type="text/javascript">jQuery(document).ready(function($) {';
        echo '$(".index-php #wpbody-content .wrap h1:eq(0)").prepend("<span id=\"wlcms_dashboard_logo\"><img src=\"'.$img_src.'\" alt=\"\" /></span>");';
        echo '$("#wlcms_dashboard_logo").css({"visibility":"visible", "display": "block", "float" : "left", "margin": "0px 5px 0px 0px"});';
        echo '}); </script>';
    endif;
    } else if(get_field('branding_type', 'option') == 'White_Label') {
    }
}

add_action('admin_head', 'custom_admin_logo');

// Custom Login Logo / Alts
function custom_login_url() {
    if (get_field('branding_type', 'option') == 'Visibility') {
        return 'https://www.highervisibility.com';
    } else if (get_field('branding_type', 'option') == 'Rankology') { 
        return 'https://www.rankology.com';
    } else if (get_field('branding_type', 'option') == 'White_Label') { 
        return 'https://wordpress.org';
    }
}
add_filter('login_headerurl', 'custom_login_url');

// Custom Login Logo / Alts
function custom_login_alt() {
    if (get_field('branding_type', 'option') == 'Visibility') {
        return 'Higher Visibility';
    } else if (get_field('branding_type', 'option') == 'Rankology') { 
        return 'Rankology';
    } else if (get_field('branding_type', 'option') == 'White_Label') { 
    }
}
add_filter('login_headertitle', 'custom_login_alt');

// Custom Dashboard Favicon
function add_favicon() {
    $favicon_url = get_field('favicon', 'option');
    echo '<link rel="shortcut icon" href="' . $favicon_url . '" />';
}
add_action('login_head', 'add_favicon');
add_action('admin_head', 'add_favicon');

// Custom Dashboard Footers
function custom_footer_logo () {
    if (get_field('branding_type', 'option') == 'Visibility') {
        echo '<span id="footer-thankyou"><a href="http://www.highervisibility.com" target="_blank"><img style="width:120px;" src="../wp-content/images/H.Visibility.png" /></a></span>';
    } else if (get_field('branding_type', 'option') == 'Rankology') { 
        echo '<span id="footer-thankyou"><a href="http://www.rankology.com" target="_blank"><img style="width:120px;" src="../wp-content/images/Rankology.png" /></a></span>';
    } else if (get_field('branding_type', 'option') == 'White_Label') { 
    }
}
add_filter('admin_footer_text', 'custom_footer_logo')
?>
