<?php
// Custom Type - Reviews
add_action( 'init', 'type_testimonial' );
function type_testimonial() {
	$labels = array(
		"name" => __( 'Testimonial', '' ),
		"singular_name" => __( 'Testimonial', '' ), );
	$args = array(
		"label" => __( 'Testimonial', '' ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => false,
		"rest_base" => "",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "testimonial", "with_front" => true ),
		"query_var" => true,
		"supports" => array( "title", "editor", "thumbnail" ), );
	register_post_type( "testimonial", $args ); }
	
// Custom Type - Gallery
add_action( 'init', 'type_gallery' );
function type_gallery() {
	$labels = array(
		"name" => __( 'Galleries', '' ),
		"singular_name" => __( 'Gallery', '' ),
	);
	$args = array(
		"label" => __( 'Galleries', '' ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => false,
		"rest_base" => "",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "gallery", "with_front" => true ),
		"query_var" => true,
		"supports" => array( "title", "editor", "thumbnail" ),          );
	register_post_type( "gallery", $args ); }

// Custom Type - Members
add_action( 'init', 'type_members' );
function type_members() {
	$labels = array(
		"name" => __( 'Team', '' ),
		"singular_name" => __( 'Member', '' ), );
	$args = array(
		"label" => __( 'Members', '' ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => false,
		"rest_base" => "",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "team", "with_front" => true ),
		"query_var" => true,
		"supports" => array( "title", "editor", "thumbnail" ), );
	register_post_type( "team", $args ); }

// Custom Type - Service
add_action( 'init', 'type_service' );
function type_service() {
	$labels = array(
		"name" => __( 'Services', '' ),
		"singular_name" => __( 'Service', '' ), );
	$args = array(
		"label" => __( 'Services', '' ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => false,
		"rest_base" => "",
		"has_archive" => false,
		"show_in_menu" => true,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => array( "slug" => "service", "with_front" => true ),
		"query_var" => true,
		"supports" => array( "title", "editor", "thumbnail" ), );
	register_post_type( "service", $args ); }

// Custom Taxe - Gallery
add_action( 'init', 'gallery_type' );
function gallery_type() {
	$labels = array(
		"name" => __( 'Categories', '' ),
		"singular_name" => __( 'Category', '' ),
	);
	$args = array(
		"label" => __( 'Categories', '' ),
		"labels" => $labels,
		"public" => true,
		"hierarchical" => true,
		"label" => "Categories",
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => array( 'slug' => 'type', 'with_front' => true,  'hierarchical' => true, ),
		"show_admin_column" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"show_in_quick_edit" => true,
	);
	register_taxonomy( "gallery_type", array( "gallery" ), $args ); }

// Custom Taxe - Gallery
add_action( 'init', 'service_type' );
function service_type() {
	$labels = array(
		"name" => __( 'Categories', '' ),
		"singular_name" => __( 'Category', '' ),
	);
	$args = array(
		"label" => __( 'Categories', '' ),
		"labels" => $labels,
		"public" => true,
		"hierarchical" => true,
		"label" => "Categories",
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => array( 'slug' => 'type', 'with_front' => true,  'hierarchical' => true, ),
		"show_admin_column" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"show_in_quick_edit" => true,
	);
	register_taxonomy( "service_type", array( "service" ), $args ); }
?>