<?php

/* Test */

/**
 * Returns address as an array (commas are used as delimiters)
 *
 */
function formatAddress($address) {
  $address = explode( "," , $address['address']);
  return $address;
}

/**
 * Prints company hours in preferred format
 *
 */
function printHours() {
  if ( have_rows('company_hours', 'option') ) :
    $counter = 0;

    while ( have_rows('company_hours', 'option') ) : the_row();
      $day          =   substr( get_sub_field('company_days'), 0, 2 );
      $start_time   =   date("H:i", strtotime( get_sub_field('company_time_opens') ));
      $end_time     =   date("H:i", strtotime( get_sub_field('company_time_close') ));

      if ( $counter == 0 ) :
        echo '"' . $day . ' ' . $start_time . '-' . $end_time . '"';
      else :
        echo ',"' . $day . ' ' . $start_time . '-' . $end_time . '"';
      endif;

      $counter++;
    endwhile;
  endif;
}

/**
 * Returns number of reviews and average rating value
 *
 */
function getRatingInfo($reviews) {
  $num_reviews  =   0;
  $rating_sum   =   0;

  foreach ($reviews as &$review) {
    $rating_sum += $review['reviewRating']['ratingValue'];
    $num_reviews++;
  }

  $rating_avg = $rating_sum / $num_reviews;

  $rating_details = [
    "count"    =>  $num_reviews,
    "average"  =>  $rating_avg
  ];

  return $rating_details;
}

/**
 * Returns all reviews as a group of associative arrays
 *
 */
function buildReviews($business_details) {

    $args = array(
      'post_type'       =>   'testimonial',
      'post_status'     =>   'publish',
      'posts_per_page'  =>   -1
    );

    $custom_query           =    new WP_Query($args);
    $company_type           =    $business_details['company_type'];
    $company_image          =    $business_details['company_image'];
    $company_name           =    $business_details['company_name'];
    $company_description    =    $business_details['company_description'];
    $company_phone          =    $business_details['company_phone'];
    $company_email          =    $business_details['company_email'];
    $company_address        =    $business_details['company_address'];
    $company_street         =    $business_details['company_street'];
    $company_city           =    $business_details['company_city'];
    $company_state          =    $business_details['company_state'];
    $company_zip            =    $business_details['company_zip'];
    $company_price_range    =    $business_details['company_price_range'];
    $max_rating             =    5;
    $min_rating             =    1;
    $reviews                =    [];

    if ($company_type == "Local") :
      $company_type = "LocalBusiness";

      if ( $custom_query -> have_posts() ) :
        while ( $custom_query -> have_posts() ) : $custom_query -> the_post();
          $author_name   =  get_the_title();
          $review_body   =  get_the_content();

          $review = [
            "@context" => 'http://schema.org',
            "@type"	=>	"Review",
            "reviewBody" => wp_strip_all_tags($review_body),
            "author" => [
              "@type" => "Person",
              "name" => $author_name
            ],
            "publisher" => [
              "@type" => $company_type,
              "name" => $company_name,
              "address" => [
                "@type"             => "PostalAddress",
                "streetAddress"     => $company_street,
                "addressLocality"   => $company_city,
                "addressRegion"     => $company_state,
                "postalCode"        => $company_zip
              ],
              "priceRange" => $company_price_range,
              "telephone" => $company_phone,
              "image" => $company_image
            ],
            "itemReviewed" => [
              "@type" => $company_type,
              "priceRange" => $company_price_range,
              "name"  => $company_name,
              "telephone" => $company_phone,
              "address" => [
                "@type" => "PostalAddress",
                "streetAddress" => $company_street,
                "addressLocality" => $company_city,
                "addressRegion" => $company_state,
                "postalCode" => $company_zip
              ],
              "image" => $company_image
            ]
          ];

          array_push($reviews, $review);

        endwhile;
        return $reviews;
      endif;
      
      elseif ($company_type == "Generic") :
      $company_type = "LocalBusiness";

      if ( $custom_query -> have_posts() ) :
        while ( $custom_query -> have_posts() ) : $custom_query -> the_post();
          $author_name   =  get_the_title();
          $review_body   =  get_the_content();

          $review = [
            "@context" => 'http://schema.org',
            "@type"	=>	"Review",
            "reviewBody" => wp_strip_all_tags($review_body),
            "author" => [
              "@type" => "Person",
              "name" => $author_name
            ],
            "publisher" => [
              "@type" => $company_type,
              "name" => $company_name,
              "address" => [
                "@type"             => "PostalAddress",
                "addressLocality"   => $company_street,
                "addressRegion"     => $company_city,
                "postalCode"        => $company_state
              ],
              "priceRange" => $company_price_range,
              "telephone" => $company_phone,
              "image" => $company_image
            ],
            "itemReviewed" => [
              "@type" => $company_type,
              "priceRange" => $company_price_range,
              "name"  => $company_name,
              "telephone" => $company_phone,
              "address" => [
                "@type" => "PostalAddress",
                "addressLocality"   => $company_street,
                "addressRegion"     => $company_city,
                "postalCode"        => $company_state
              ],
              "image" => $company_image
            ]
          ];

          array_push($reviews, $review);

        endwhile;
        return $reviews;
      endif;
    elseif ($company_type == "National") :
      $company_type = "Organization";

      if ( $custom_query -> have_posts() ) :
        while ( $custom_query -> have_posts() ) : $custom_query -> the_post();
          $author_name   =  get_the_title();
          $review_body   =  get_the_content();
          $review_rating =  5;

          $review = [
            "@context" => 'http://schema.org',
            "@type"	=>	"Review",
            "reviewBody" => wp_strip_all_tags($review_body),
            "author" => [
              "@type" => "Person",
              "name" => $author_name
            ],
            "publisher" => [
              "@type" => $company_type,
              "name" => $company_name,
              "address" => [
                "@type" => "PostalAddress",
                "streetAddress" => $company_street,
                "addressLocality" => $company_city,
                "addressRegion" => $company_state,
                "postalCode" => $company_zip
              ],
              "telephone" => $company_phone,
              "image" => $company_image
            ],
            "itemReviewed" => [
              "@type" => $company_type,
              "name"  => $company_name,
              "telephone" => $company_phone,
              "address" => [
                "@type" => "PostalAddress",
                "streetAddress" => $company_street,
                "addressLocality" => $company_city,
                "addressRegion" => $company_state,
                "postalCode" => $company_zip
              ],
              "image" => $company_image
            ]
          ];

          array_push($reviews, $review);

        endwhile;
        return $reviews;
      endif;
    endif;

  }

$company_details    =   [
    "company_type"           =>    get_field('business_type', 'option'),
    "company_image"          =>    get_field('company_image', 'option'),
    "company_name"           =>    get_field('company_name', 'option'),
    "company_description"    =>    get_bloginfo('description'),
    "company_phone"          =>    get_field('company_phone', 'option'),
    "company_email"          =>    get_field('company_email', 'option'),
    "company_address"        =>    formatAddress( get_field('company_address', 'option') ),
    "company_price_range"    =>    get_field('prices', 'option'),
    "company_hours"          =>    get_field('company_hours', 'option'),
];

$company_details    +=   [
  "company_street"         =>    $company_details['company_address'][0],
  "company_city"           =>    $company_details['company_address'][1],
  "company_state"          =>    $company_details['company_address'][2],
  "company_zip"            =>    $company_details['company_address'][3],
];

?>

<?php if (get_field('business_type', 'option') == 'Local') :
  $reviews  =   buildReviews($company_details);
?>

  <script type="application/ld+json">
  {
    "@context": "http://schema.org",
    "@type": "localBusiness",
    "name": "<?php echo $company_details['company_name']; ?>",
    "description": "<?php echo $company_details['company_description']; ?>",
    "telephone": "<?php echo $company_details['company_phone']; ?>",
    "email": "<?php echo $company_details['company_email']; ?>",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo $company_details['company_street']; ?>",
      "addressLocality": "<?php echo $company_details['company_city']; ?>",
      "addressRegion": "<?php echo $company_details['company_state']; ?>",
      "postalCode": "<?php echo $company_details['company_zip']; ?>"
    },
    "openingHours": [
      <?php printHours(); ?>
    ],
    "priceRange": "<?php echo $company_details['company_price_range']; ?>",
    "image": "<?php echo $company_details['company_image']; ?>"
  }
  </script>

  <?php foreach($reviews as $review) {
    echo '<script type="application/ld+json">';
    echo json_encode($review, JSON_UNESCAPED_SLASHES);
    echo '</script>';
  }
  ?>
  
<?php elseif (get_field('business_type', 'option') == 'Generic') :
  $reviews  =   buildReviews($company_details);
?>

  <script type="application/ld+json">
  {
    "@context": "http://schema.org",
    "@type": "localBusiness",
    "name": "<?php echo $company_details['company_name']; ?>",
    "description": "<?php echo $company_details['company_description']; ?>",
    "telephone": "<?php echo $company_details['company_phone']; ?>",
    "email": "<?php echo $company_details['company_email']; ?>",
    "address": {
      "@type": "PostalAddress",
      "addressLocality": "<?php echo $company_details['company_street']; ?>",
      "addressRegion": "<?php echo $company_details['company_city']; ?>",
      "postalCode": "<?php echo $company_details['company_state']; ?>"
    },
    "openingHours": [
      <?php printHours(); ?>
    ],
    "priceRange": "<?php echo $company_details['company_price_range']; ?>",
    "image": "<?php echo $company_details['company_image']; ?>"
  }
  </script>

  <?php foreach($reviews as $review) {
    echo '<script type="application/ld+json">';
    echo json_encode($review, JSON_UNESCAPED_SLASHES);
    echo '</script>';
  }
  ?>

<?php elseif (get_field('business_type', 'option') == 'National') :
  $reviews  =   buildReviews($company_details);
?>

  <script type="application/ld+json">
  {
    "@context": "http://schema.org",
    "@type": "Organization",
    "name": "<?php echo $company_details['company_name']; ?>",
    "description": "<?php echo $company_details['company_description']; ?>",
    "image": "<?php echo $company_details['company_image']; ?>",
    "telephone": "<?php echo $company_details['company_phone']; ?>",
    "email": "<?php echo $company_details['company_email']; ?>",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo $company_details['company_street']; ?>",
      "addressLocality": "<?php echo $company_details['company_city']; ?>",
      "addressRegion": "<?php echo $company_details['company_state']; ?>",
      "postalCode": "<?php echo $company_details['company_zip']; ?>"
    }
  }
  </script>

  <?php foreach($reviews as $review) :
    echo '<script type="application/ld+json">' . json_encode($review, JSON_UNESCAPED_SLASHES) . '</script>';
  endforeach;
  ?>

<?php endif; ?>