<?php

// Load Google Maps script
function google_scripts() {
	if ( is_page( 'contact' ) ) {
		wp_enqueue_script( 'maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyBgyMW4-sbBpgRZFL9Uyd1OL6iKeDu_lEE', true );
  	}
}
add_action( 'wp_enqueue_scripts', 'google_scripts' );

// Set Google Maps API key
function my_acf_init() {
	acf_update_setting( 'google_api_key', 'AIzaSyBgyMW4-sbBpgRZFL9Uyd1OL6iKeDu_lEE' );
}
add_action( 'acf/init', 'my_acf_init' );

// Load custom scripts and styles
function template_scripts() {
	wp_enqueue_script( 'custom', get_stylesheet_directory_uri() . '/assets/js/custom.min.js', array('jquery'), true );
	wp_enqueue_style( 'resource', get_stylesheet_directory_uri() . '/assets/css/resource.css' );
	wp_enqueue_style( 'style', get_stylesheet_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'template_scripts' );

// Load custom navigation effect
function template_walker( $item_output, $item, $depth, $args ) {
    $classes = 'hvr-underline-from-center';
	$item_output = preg_replace( '/<a /', '<a class="'.$classes.'" ', $item_output, 1 );
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'template_walker', 10, 4 );

// Modify excerpt length
function custom_excerpt_length( $length ) {
	return 100;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

// Modify excerpt text
function new_excerpt_more( $more ) {
	return '...';
}
add_filter( 'excerpt_more', 'new_excerpt_more' );

// Replace attachment links with data-action=zoom
function rc_add_rel_attribute($link) {
	global $post;
	return str_replace('<a href', '<a data-action="zoom" href', $link);
}
add_filter('wp_get_attachment_link', 'rc_add_rel_attribute');

// Hide blog links if there are no posts
function hide_blog_links( $items, $menu, $args ) {
	if ( !is_admin() ) {
		$query = new WP_Query(array('post_type' => 'post'));
		
		if ( !$query->have_posts() ) {
		    $i = 0;
			
			foreach ( $items as $item ) {
				if ( $item->title === 'Blog' ) {
					unset( $items[ $i ] );
				    return $items;
				}
			
				$i++;
			}
		}
	}
	
	return $items;
}
add_filter( 'wp_get_nav_menu_items', 'hide_blog_links', 99, 3 );