<?php
get_header();
get_template_part('templates/search-header');
?>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 content-right main-content">
                <div class="news-list">
                    <?php
                    $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                    $custom_args = array(
                        'post_type' => 'post',
                        'posts_per_page' => 6,
                        'paged' => $paged
                    );

                    $custom_query = new WP_Query( $custom_args );
                    ?>
            
                    <?php if ( $custom_query->have_posts() ) : while ( $custom_query->have_posts() ) : $custom_query->the_post(); ?>
                        <div class="block">
                            <div class="text">
                                <h2>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title();?>
                                    </a>
                                </h2>

                                <div class="time">
                                    <?php the_time('M d Y')?>
                                </div>

                                <?php echo the_excerpt(); ?>

                                <div class="clear"></div>

                                <a href="<?php the_permalink(); ?>" class="continue">Continue Reading</a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                        <?php
                            if ( function_exists(custom_pagination) ) { custom_pagination( $custom_query->max_num_pages, "", $paged ); }
                            wp_reset_postdata();
                        ?>
                    <?php else :  ?>
                        <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>