<?php
/** Template part for page header */
?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    <section class="inner-banner">  
        <figure class="image-fill" style="background:url(<?php if ( has_post_thumbnail() ) { the_post_thumbnail_url(); } else { the_field('page_banner', 'option'); } ?>) no-repeat center center; background-size: cover; width: 100%;">
            <span class="overlay"></span>
        </figure>

        <div class="container">    
            <h1><?php the_title(); ?></h1>

            <div class="page-nav">
                <ul>
                    <li><a href="<?php bloginfo('url'); ?>">Home</a></li>
                  
                    <?php if (is_singular('service')) : ?>
                        <li><a href="/services">Services</a></li>
                    <?php endif; ?>
                  
                    <?php if (is_singular('post')) : ?>
                        <li><a href="/blog">Blog</a></li>
                    <?php endif; ?>

                    <li><?php the_title(); ?></li>
                </ul>
            </div>
        </div>
    </section>
<?php endwhile; endif; wp_reset_query(); ?>