<?php
/* Template Name: Testimonials Page */

get_header();
get_template_part('templates/page-header');
?>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="col-md-9 col-sm-8 content-right main-content">
                <?php
                $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                $custom_args = array(
                'post_type' => 'testimonial',
                'posts_per_page' => 6,
                'paged' => $paged
                );

                $custom_query = new WP_Query( $custom_args );
                ?>

                <?php if ( $custom_query->have_posts() ) : ?>
                    <?php while ( $custom_query->have_posts() ) : $custom_query->the_post(); ?>
                        <div class="testimonial">
                            <?php echo the_content(); ?>

                            <div class="testimonial-author">
                                <i class="testimonial-icon icon ion-quote"></i>
                                <?php the_title(); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                
                    <?php
                    if ( function_exists(custom_pagination) ) {
                        custom_pagination( $custom_query->max_num_pages, "", $paged );
                    }
                    ?>

                    <?php wp_reset_postdata(); ?>
                <?php else :  ?>
                    <p>
                        <?php _e( 'Sorry, no posts matched your criteria.' ); ?>
                    </p>
                <?php endif; ?>
            </div>

            <div class="col-md-3 col-sm-4 content-left sidebar">
                <?php get_template_part( 'sections/sidebar-forms' ); ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>