/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-02-17 17:40:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ewwwio_images` (
  `id` int(14) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1970-12-31 17:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `level` int(5) unsigned DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `backup` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`),
  KEY `path` (`path`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1845 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ewwwio_queue` (
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) DEFAULT NULL,
  `scanned` tinyint(1) NOT NULL DEFAULT '0',
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_frm_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `field_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` text COLLATE utf8mb4_unicode_ci,
  `default_value` longtext COLLATE utf8mb4_unicode_ci,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `field_order` int(11) DEFAULT '0',
  `required` int(1) DEFAULT NULL,
  `field_options` longtext COLLATE utf8mb4_unicode_ci,
  `form_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_key` (`field_key`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_frm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `parent_form_id` int(11) DEFAULT '0',
  `logged_in` tinyint(1) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT '0',
  `default_template` tinyint(1) DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_key` (`form_key`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_frm_item_metas` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `field_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_frm_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ip` text COLLATE utf8mb4_unicode_ci,
  `form_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `parent_item_id` bigint(20) DEFAULT '0',
  `is_draft` tinyint(1) DEFAULT '0',
  `updated_by` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_key` (`item_key`),
  KEY `form_id` (`form_id`),
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_item_id` (`parent_item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=191683 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9288 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=370 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL,
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=2501 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfCrawlers` (
  `IP` binary(16) NOT NULL,
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfFileChanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=188281 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=5821 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6061 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLocs` (
  `IP` binary(16) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=7503 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfReverseCache` (
  `IP` binary(16) NOT NULL,
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2602 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=159295 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfTrafficRates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wppusher_packages` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `package` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repository` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'master',
  `type` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `ptd` int(11) NOT NULL,
  `host` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `private` int(11) NOT NULL,
  `subdirectory` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("7", "20190904_template01", "ea35ed8436b865c99790_20210217173924", "20", "2021-02-17 17:40:18", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-17 17:39:24\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:6:\"4.9.16\";s:9:\"VersionDB\";s:7:\"10.1.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:19:\"20190904_template01\";s:4:\"Hash\";s:35:\"ea35ed8436b865c99790_20210217173924\";s:8:\"NameHash\";s:55:\"20190904_template01_ea35ed8436b865c99790_20210217173924\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:65:\"20190904_template01_ea35ed8436b865c99790_20210217173924_scan.json\";s:10:\"TimerStart\";d:1613583618.0104160308837890625;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.4\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:67:\"20190904_template01_ea35ed8436b865c99790_20210217173924_archive.daf\";s:6:\"Format\";s:3:\"DAF\";s:7:\"PackDir\";s:41:\"/home/ourdemosites/public_html/template01\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-17 17:39:24\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:6:\"4.9.16\";s:9:\"VersionDB\";s:7:\"10.1.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"20190904_template01\";s:4:\"Hash\";s:35:\"ea35ed8436b865c99790_20210217173924\";s:8:\"NameHash\";s:55:\"20190904_template01_ea35ed8436b865c99790_20210217173924\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:69:\"20190904_template01_ea35ed8436b865c99790_20210217173924_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"20190904_template01_ea35ed8436b865c99790_20210217173924_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:14:\"wp_commentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:127:\"/home/ourdemosites/public_html/template01/wp-snapshots/tmp/20190904_template01_ea35ed8436b865c99790_20210217173924_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";i:1613583618;s:11:\"initialized\";b:1;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:50:\"/home/ourdemosites/public_html/template01/wp-admin\";i:1;s:60:\"/home/ourdemosites/public_html/template01/wp-content/uploads\";i:2;s:62:\"/home/ourdemosites/public_html/template01/wp-content/languages\";i:3;s:59:\"/home/ourdemosites/public_html/template01/wp-content/themes\";i:4;s:53:\"/home/ourdemosites/public_html/template01/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:41:\"/home/ourdemosites/public_html/template01\";i:1;s:52:\"/home/ourdemosites/public_html/template01/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:94;s:13:\"BuildProgress\";r:126;}");

/* INSERT TABLE DATA: wp_ewwwio_images */
INSERT INTO `wp_ewwwio_images` VALUES("1634", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/project01.jpg", "", "Reduced by 3.9% (9.1&nbsp;KB)", "233032", "242393", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1635", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/project02.jpg", "", "Reduced by 4.5% (26.3&nbsp;KB)", "573783", "600714", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1636", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/project03.jpg", "", "Reduced by 4.3% (33.0&nbsp;KB)", "747907", "781679", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1637", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/news01.jpg", "", "Reduced by 4.3% (22.3&nbsp;KB)", "506115", "528925", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1639", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/slider01.jpg", "", "Reduced by 4.2% (30.5&nbsp;KB)", "717627", "748814", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1642", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/testimonial_pic01.jpg", "", "Reduced by 5.2% (3.1&nbsp;KB)", "58914", "62121", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1644", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/inner-banner.jpg", "", "Reduced by 5.7% (15.0&nbsp;KB)", "253580", "268985", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1645", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/service03.jpg", "", "Reduced by 4.4% (28.1&nbsp;KB)", "629221", "658043", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1646", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/service01.jpg", "", "Reduced by 4.4% (23.1&nbsp;KB)", "511605", "535266", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1648", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/about-pic01.jpg", "", "Reduced by 4.3% (16.0&nbsp;KB)", "365920", "382320", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1651", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/testimonial_pic03.jpg", "", "Reduced by 5.3% (5.4&nbsp;KB)", "98473", "103957", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1654", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/testimonial_pic02.jpg", "", "Reduced by 4.5% (3.8&nbsp;KB)", "82923", "86789", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1655", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/news02.jpg", "", "Reduced by 3.6% (8.6&nbsp;KB)", "234571", "243333", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1656", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/service02.jpg", "", "Reduced by 4.5% (23.5&nbsp;KB)", "505597", "529686", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1658", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/about-pic02.jpg", "", "Reduced by 4.3% (27.5&nbsp;KB)", "630106", "658281", "1", "2017-05-09 14:40:59", "", NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1746", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/prev02.png", "", "Reduced by 79.0% (1.2&nbsp;KB)", "334", "1588", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1745", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/arrow-select-drop.png", "", "Reduced by 88.8% (875.0&nbsp;B)", "110", "985", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1744", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/prev01.png", "", "Reduced by 90.4% (1.4&nbsp;KB)", "148", "1534", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1740", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/fav.png", "", "Reduced by 46.7% (1.2&nbsp;KB)", "1401", "2630", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1741", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/next01.png", "", "Reduced by 90.3% (1.3&nbsp;KB)", "148", "1523", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1742", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/next02.png", "", "Reduced by 80.3% (1.3&nbsp;KB)", "318", "1611", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1743", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/logo02.png", "", "Reduced by 53.7% (1.7&nbsp;KB)", "1471", "3175", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1738", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/arrow-down.png", "", "Reduced by 83.8% (970.0&nbsp;B)", "187", "1157", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1739", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/menu_icon.png", "", "Reduced by 81.5% (888.0&nbsp;B)", "201", "1089", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1737", NULL, NULL, "ABSPATHwp-content/themes/consultant/images/logo01.png", "", "Reduced by 56.2% (1.8&nbsp;KB)", "1476", "3368", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1736", NULL, NULL, "ABSPATHwp-content/themes/consultant/screenshot.png", "", "Reduced by 27.5% (972.8&nbsp;KB)", "2632665", "3628816", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1747", NULL, NULL, "ABSPATHwp-content/themes/template/screenshot.png", "", "No savings", "2632665", "2632665", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1748", NULL, NULL, "ABSPATHwp-content/themes/template/images/project01.jpg", "", "Reduced by 0.2% (554.0&nbsp;B)", "232478", "233032", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1749", NULL, NULL, "ABSPATHwp-content/themes/template/images/project02.jpg", "", "Reduced by 1.1% (5.9&nbsp;KB)", "567730", "573783", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1750", NULL, NULL, "ABSPATHwp-content/themes/template/images/project03.jpg", "", "Reduced by 1.3% (9.4&nbsp;KB)", "738274", "747907", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1751", NULL, NULL, "ABSPATHwp-content/themes/template/images/news01.jpg", "", "Reduced by 0.7% (3.7&nbsp;KB)", "502332", "506115", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1752", NULL, NULL, "ABSPATHwp-content/themes/template/images/logo01.png", "", "No savings", "1476", "1476", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1753", NULL, NULL, "ABSPATHwp-content/themes/template/images/slider01.jpg", "", "Reduced by 1.1% (7.6&nbsp;KB)", "709803", "717627", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1754", NULL, NULL, "ABSPATHwp-content/themes/template/images/arrow-down.png", "", "No savings", "187", "187", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1755", NULL, NULL, "ABSPATHwp-content/themes/template/images/menu_icon.png", "", "No savings", "201", "201", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1756", NULL, NULL, "ABSPATHwp-content/themes/template/images/testimonial_pic01.jpg", "", "Reduced by 0.3% (191.0&nbsp;B)", "58723", "58914", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1757", NULL, NULL, "ABSPATHwp-content/themes/template/images/fav.png", "", "No savings", "1401", "1401", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1758", NULL, NULL, "ABSPATHwp-content/themes/template/images/inner-banner.jpg", "", "Reduced by 0.6% (1.6&nbsp;KB)", "251948", "253580", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1759", NULL, NULL, "ABSPATHwp-content/themes/template/images/service03.jpg", "", "Reduced by 1.9% (11.8&nbsp;KB)", "617089", "629221", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1760", NULL, NULL, "ABSPATHwp-content/themes/template/images/service01.jpg", "", "Reduced by 1.1% (5.6&nbsp;KB)", "505858", "511605", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1761", NULL, NULL, "ABSPATHwp-content/themes/template/images/next01.png", "", "No savings", "148", "148", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1762", NULL, NULL, "ABSPATHwp-content/themes/template/images/about-pic01.jpg", "", "Reduced by 0.8% (2.9&nbsp;KB)", "362905", "365920", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1763", NULL, NULL, "ABSPATHwp-content/themes/template/images/next02.png", "", "No savings", "318", "318", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1764", NULL, NULL, "ABSPATHwp-content/themes/template/images/logo02.png", "", "No savings", "1471", "1471", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1765", NULL, NULL, "ABSPATHwp-content/themes/template/images/testimonial_pic03.jpg", "", "Reduced by 0.8% (773.0&nbsp;B)", "97700", "98473", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1766", NULL, NULL, "ABSPATHwp-content/themes/template/images/prev01.png", "", "No savings", "148", "148", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1767", NULL, NULL, "ABSPATHwp-content/themes/template/images/arrow-select-drop.png", "", "No savings", "110", "110", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1768", NULL, NULL, "ABSPATHwp-content/themes/template/images/testimonial_pic02.jpg", "", "Reduced by 0.1% (78.0&nbsp;B)", "82845", "82923", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1769", NULL, NULL, "ABSPATHwp-content/themes/template/images/news02.jpg", "", "Reduced by 0.2% (493.0&nbsp;B)", "234078", "234571", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1770", NULL, NULL, "ABSPATHwp-content/themes/template/images/service02.jpg", "", "Reduced by 1.2% (6.1&nbsp;KB)", "499331", "505597", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1771", NULL, NULL, "ABSPATHwp-content/themes/template/images/prev02.png", "", "No savings", "334", "334", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1772", NULL, NULL, "ABSPATHwp-content/themes/template/images/about-pic02.jpg", "", "Reduced by 1.3% (8.1&nbsp;KB)", "621761", "630106", "1", "2017-05-09 14:40:59", NULL, NULL, NULL, "0", NULL);
INSERT INTO `wp_ewwwio_images` VALUES("1777", "38", "full", "ABSPATHwp-content/uploads/2016/11/logo01.png", "", "No savings", "1213", "1213", "1", "2017-06-01 16:30:49", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1774", "281", "full", "ABSPATHwp-content/uploads/2016/11/partners-placeholder.png", "", "No savings", "817", "817", "1", "2017-05-09 14:40:59", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1775", "281", "thumbnail", "ABSPATHwp-content/uploads/2016/11/partners-placeholder-150x50.png", "", "Reduced by 49.6% (669 B) - Previously Optimized", "680", "1349", "1", "2017-06-01 12:30:51", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1776", "289", "full", "ABSPATHwp-content/uploads/2017/05/template-favicon-1.png", "", "Reduced by 13.4% (65 B) - Previously Optimized", "421", "486", "1", "2017-06-01 12:30:51", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1778", "40", "full", "ABSPATHwp-content/uploads/2016/11/logo02.png", "", "No savings", "1203", "1203", "1", "2017-06-01 16:30:49", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1779", "38", "thumbnail", "ABSPATHwp-content/uploads/2016/11/logo01-150x50.png", "", "No savings", "802", "802", "1", "2017-06-01 16:30:50", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1780", "40", "thumbnail", "ABSPATHwp-content/uploads/2016/11/logo02-150x50.png", "", "No savings", "801", "801", "1", "2017-06-01 16:30:50", NULL, "media", NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1781", NULL, NULL, "ABSPATHwp-content/themes/template01/screenshot.png", "", "No savings", "2632665", "2632665", "1", "2017-06-12 10:47:58", NULL, NULL, NULL, "0", "");
INSERT INTO `wp_ewwwio_images` VALUES("1835", "368", "thumbnail", "ABSPATHwp-content/uploads/2020/05/responsive-lightbox-thumbnail-150x150.png", "", "No savings", "111", "111", "1", "2020-05-06 13:10:18", NULL, "media", "50", "0", "5eb319a8a0bab1655c6fee6baddc1ecf16ae9694feb52948e9b3877fd507bea305948c68b026b");
INSERT INTO `wp_ewwwio_images` VALUES("1836", "368", "medium_large", "ABSPATHwp-content/uploads/2020/05/responsive-lightbox-thumbnail-768x432.png", "", "No savings", "148", "148", "1", "2020-05-06 13:10:20", NULL, "media", "50", "0", "5eb319aaa4fa784ac6a4aaf9bf28d13d038cd55f52dbd639b7b3b4c535740e8f3220102b482da");
INSERT INTO `wp_ewwwio_images` VALUES("1837", "368", "full", "ABSPATHwp-content/uploads/2020/05/responsive-lightbox-thumbnail.png", "", "No savings", "1896", "1896", "1", "2020-05-06 13:10:22", NULL, "media", "50", "0", "5eb319a799fcd5eb919b2aa26644bc2ee48d2eb3fa921838c4f4d886cc058c18c9c88ff9eee92");
INSERT INTO `wp_ewwwio_images` VALUES("1838", "368", "large", "ABSPATHwp-content/uploads/2020/05/responsive-lightbox-thumbnail-1024x576.png", "", "No savings", "179", "179", "1", "2020-05-06 13:10:22", NULL, "media", "50", "0", "5eb319ab9d4c9ff62f30902d8445d620ffe13386aa003066e981eaf37fdd84a5c4f0d3d8f77c2");
INSERT INTO `wp_ewwwio_images` VALUES("1839", "368", "medium", "ABSPATHwp-content/uploads/2020/05/responsive-lightbox-thumbnail-300x169.png", "", "No savings", "114", "114", "1", "2020-05-06 13:10:29", NULL, "media", "50", "0", "5eb319a9ad557f0fd28082388a243875cde68d6980ffe4838238a9b354108c3680e108397de9d");

/* INSERT TABLE DATA: wp_frm_fields */
INSERT INTO `wp_frm_fields` VALUES("64", "qh4icy2", "Name", "", "text", "", NULL, "0", "1", "a:71:{s:5:\"blank\";s:27:\"This field cannot be blank.\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:18:\"required_indicator\";s:0:\"\";s:7:\"invalid\";s:15:\"Name is invalid\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"custom_html\";s:413:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\r\n    <label for=\"field_[key]\" class=\"frm_primary_label\">[field_name]\r\n        <span class=\"frm_required\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\"frm_description\">[description]</div>[/if description]\r\n    [if error]<div class=\"frm_error\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:4:\"Name\";s:11:\"is_currency\";i:0;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:14:\"clear_on_focus\";i:0;}", "6", "2016-11-22 13:32:42");
INSERT INTO `wp_frm_fields` VALUES("68", "e6lis62", "Subject", "", "text", "", NULL, "4", "1", "a:71:{s:5:\"blank\";s:27:\"This field cannot be blank.\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:18:\"Subject is invalid\";s:14:\"separate_value\";i:0;s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"custom_html\";s:413:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\r\n    <label for=\"field_[key]\" class=\"frm_primary_label\">[field_name]\r\n        <span class=\"frm_required\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\"frm_description\">[description]</div>[/if description]\r\n    [if error]<div class=\"frm_error\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:7:\"Subject\";s:11:\"is_currency\";i:0;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:14:\"clear_on_focus\";i:0;}", "6", "2016-11-22 13:32:42");
INSERT INTO `wp_frm_fields` VALUES("69", "9jv0r12", "Message", "", "textarea", "", NULL, "5", "1", "a:71:{s:3:\"max\";s:1:\"5\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:7:\"classes\";s:5:\"frm12\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:11:\"custom_html\";s:413:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\r\n    <label for=\"field_[key]\" class=\"frm_primary_label\">[field_name]\r\n        <span class=\"frm_required\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\"frm_description\">[description]</div>[/if description]\r\n    [if error]<div class=\"frm_error\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"placeholder\";s:7:\"Message\";s:11:\"is_currency\";i:0;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:14:\"clear_on_focus\";i:0;}", "6", "2016-11-22 13:32:42");
INSERT INTO `wp_frm_fields` VALUES("72", "dlpkw", "Phone", "", "phone", "", "", "3", "0", "a:71:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:29:\"Your phone number* is invalid\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_half\";s:11:\"custom_html\";s:413:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\r\n    <label for=\"field_[key]\" class=\"frm_primary_label\">[field_name]\r\n        <span class=\"frm_required\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\"frm_description\">[description]</div>[/if description]\r\n    [if error]<div class=\"frm_error\">[error]</div>[/if error]\r\n</div>\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:10:\"in_section\";s:1:\"0\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:5:\"Phone\";s:11:\"is_currency\";i:0;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:14:\"clear_on_focus\";i:0;}", "6", "2016-11-22 13:52:22");
INSERT INTO `wp_frm_fields` VALUES("71", "p5p7c", "Email", "", "email", "", "", "2", "1", "a:71:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:0:\"\";s:7:\"invalid\";s:17:\"Email* is invalid\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_half\";s:11:\"custom_html\";s:413:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\r\n    <label for=\"field_[key]\" class=\"frm_primary_label\">[field_name]\r\n        <span class=\"frm_required\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\"frm_description\">[description]</div>[/if description]\r\n    [if error]<div class=\"frm_error\">[error]</div>[/if error]\r\n</div>\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:10:\"in_section\";s:1:\"0\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:5:\"Email\";s:11:\"is_currency\";i:0;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:14:\"clear_on_focus\";i:0;}", "6", "2016-11-22 13:35:28");
INSERT INTO `wp_frm_fields` VALUES("73", "qh4icy3", "Name", "", "text", "", NULL, "0", "1", "a:67:{s:5:\"blank\";s:27:\"This field cannot be blank.\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:4:\"none\";s:18:\"required_indicator\";s:0:\"\";s:7:\"invalid\";s:0:\"\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"custom_html\";s:427:\"<div id=\\\"frm_field_[id]_container\\\" class=\\\"frm_form_field form-field [required_class][error_class]\\\">\r\n    <label for=\\\"field_[key]\\\" class=\\\"frm_primary_label\\\">[field_name]\r\n        <span class=\\\"frm_required\\\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\\\"frm_description\\\">[description]</div>[/if description]\r\n    [if error]<div class=\\\"frm_error\\\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:4:\"Name\";}", "8", "2017-04-19 21:30:46");
INSERT INTO `wp_frm_fields` VALUES("74", "p5p7c2", "Email", "", "email", "", "", "1", "1", "a:67:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:4:\"none\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:0:\"\";s:7:\"invalid\";s:17:\"Email* is invalid\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:11:\"custom_html\";s:427:\"<div id=\\\"frm_field_[id]_container\\\" class=\\\"frm_form_field form-field [required_class][error_class]\\\">\r\n    <label for=\\\"field_[key]\\\" class=\\\"frm_primary_label\\\">[field_name]\r\n        <span class=\\\"frm_required\\\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\\\"frm_description\\\">[description]</div>[/if description]\r\n    [if error]<div class=\\\"frm_error\\\">[error]</div>[/if error]\r\n</div>\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:10:\"in_section\";s:1:\"0\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:5:\"Email\";}", "8", "2017-04-19 21:30:46");
INSERT INTO `wp_frm_fields` VALUES("75", "dlpkw2", "Phone", "", "phone", "", "", "2", "0", "a:67:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:4:\"none\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:29:\"Your phone number* is invalid\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:11:\"custom_html\";s:427:\"<div id=\\\"frm_field_[id]_container\\\" class=\\\"frm_form_field form-field [required_class][error_class]\\\">\r\n    <label for=\\\"field_[key]\\\" class=\\\"frm_primary_label\\\">[field_name]\r\n        <span class=\\\"frm_required\\\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\\\"frm_description\\\">[description]</div>[/if description]\r\n    [if error]<div class=\\\"frm_error\\\">[error]</div>[/if error]\r\n</div>\";s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:10:\"in_section\";s:1:\"0\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:5:\"Phone\";}", "8", "2017-04-19 21:30:46");
INSERT INTO `wp_frm_fields` VALUES("76", "e6lis63", "Subject", "", "text", "", NULL, "3", "1", "a:67:{s:5:\"blank\";s:27:\"This field cannot be blank.\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:4:\"none\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"custom_html\";s:427:\"<div id=\\\"frm_field_[id]_container\\\" class=\\\"frm_form_field form-field [required_class][error_class]\\\">\r\n    <label for=\\\"field_[key]\\\" class=\\\"frm_primary_label\\\">[field_name]\r\n        <span class=\\\"frm_required\\\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\\\"frm_description\\\">[description]</div>[/if description]\r\n    [if error]<div class=\\\"frm_error\\\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:11:\"placeholder\";s:7:\"Subject\";}", "8", "2017-04-19 21:30:46");
INSERT INTO `wp_frm_fields` VALUES("77", "9jv0r13", "Message", "", "textarea", "", NULL, "4", "1", "a:67:{s:3:\"max\";s:1:\"5\";s:5:\"blank\";s:27:\"This field cannot be blank.\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:5:\"label\";s:4:\"none\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:14:\"separate_value\";i:0;s:12:\"captcha_size\";s:6:\"normal\";s:13:\"captcha_theme\";s:5:\"light\";s:5:\"slide\";i:0;s:11:\"form_select\";s:0:\"\";s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"any\";s:5:\"align\";s:5:\"block\";s:10:\"hide_field\";a:0:{}s:15:\"hide_field_cond\";a:1:{i:0;s:2:\"==\";}s:8:\"hide_opt\";a:0:{}s:4:\"star\";i:0;s:6:\"ftypes\";a:0:{}s:9:\"data_type\";s:6:\"select\";s:8:\"restrict\";i:0;s:10:\"start_year\";i:2000;s:8:\"end_year\";i:2020;s:9:\"read_only\";i:0;s:10:\"admin_only\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:6:\"attach\";b:0;s:6:\"minnum\";i:0;s:6:\"maxnum\";i:9999;s:6:\"delete\";b:0;s:4:\"step\";i:1;s:5:\"clock\";i:12;s:10:\"start_time\";s:5:\"00:00\";s:8:\"end_time\";s:5:\"23:59\";s:6:\"unique\";i:0;s:8:\"use_calc\";i:0;s:4:\"calc\";s:0:\"\";s:8:\"calc_dec\";s:0:\"\";s:9:\"calc_type\";s:0:\"\";s:17:\"dyn_default_value\";s:0:\"\";s:8:\"multiple\";i:0;s:10:\"unique_msg\";s:0:\"\";s:7:\"autocom\";i:0;s:6:\"format\";s:0:\"\";s:6:\"repeat\";i:0;s:9:\"add_label\";s:3:\"Add\";s:12:\"remove_label\";s:6:\"Remove\";s:10:\"conf_field\";s:0:\"\";s:10:\"conf_input\";s:0:\"\";s:9:\"conf_desc\";s:0:\"\";s:8:\"conf_msg\";s:31:\"The entered values do not match\";s:5:\"other\";i:0;s:11:\"custom_html\";s:427:\"<div id=\\\"frm_field_[id]_container\\\" class=\\\"frm_form_field form-field [required_class][error_class]\\\">\r\n    <label for=\\\"field_[key]\\\" class=\\\"frm_primary_label\\\">[field_name]\r\n        <span class=\\\"frm_required\\\">[required_label]</span>\r\n    </label>\r\n    [input]\r\n    [if description]<div class=\\\"frm_description\\\">[description]</div>[/if description]\r\n    [if error]<div class=\\\"frm_error\\\">[error]</div>[/if error]\r\n</div>\";s:12:\"custom_field\";s:0:\"\";s:10:\"post_field\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:11:\"exclude_cat\";i:0;s:11:\"single_time\";i:0;s:18:\"autopopulate_value\";b:0;s:15:\"get_values_form\";s:0:\"\";s:16:\"get_values_field\";s:0:\"\";s:12:\"watch_lookup\";a:1:{i:0;s:0:\"\";}s:21:\"get_most_recent_value\";s:0:\"\";s:26:\"lookup_filter_current_user\";b:0;s:11:\"placeholder\";s:7:\"Message\";}", "8", "2017-04-19 21:30:46");

/* INSERT TABLE DATA: wp_frm_forms */
INSERT INTO `wp_frm_forms` VALUES("6", "contact2", "Contact Us", "<p>We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.</p>\r\n", "0", "0", "0", "0", "0", "published", "a:44:{s:14:\"success_action\";s:8:\"redirect\";s:11:\"success_url\";s:11:\"/thank-you/\";s:15:\"success_page_id\";s:0:\"\";s:7:\"akismet\";s:1:\"1\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:14:\"logged_in_role\";s:0:\"\";s:17:\"single_entry_type\";s:4:\"user\";s:17:\"cookie_expiration\";s:4:\"8000\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";s:0:\"\";s:13:\"protect_files\";s:1:\"0\";s:11:\"open_status\";s:0:\"\";s:9:\"open_date\";s:16:\"2019-01-29 20:43\";s:10:\"close_date\";s:0:\"\";s:11:\"max_entries\";s:0:\"\";s:10:\"closed_msg\";s:53:\"<p>This form is currently closed for submissions.</p>\";s:12:\"custom_style\";s:1:\"1\";s:12:\"submit_value\";s:6:\"Submit\";s:10:\"edit_value\";s:6:\"Update\";s:12:\"submit_align\";s:0:\"\";s:17:\"submit_conditions\";a:2:{s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"all\";}s:10:\"form_class\";s:0:\"\";s:11:\"before_html\";s:225:\"<legend class=\\\"frm_hidden\\\">[form_name]</legend>\r\n[if form_name]<h3 class=\\\"frm_form_title\\\">[form_name]</h3>[/if form_name]\r\n[if form_description]<div class=\\\"frm_description\\\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:471:\"<div class=\\\"frm_submit\\\">\r\n[if back_button]<input type=\\\"button\\\" value=\\\"[back_label]\\\" name=\\\"frm_prev_page\\\" formnovalidate=\\\"formnovalidate\\\" class=\\\"frm_prev_page\\\" [back_hook] />[/if back_button]\r\n<input type=\\\"submit\\\" value=\\\"[button_label]\\\" [button_action] />\r\n<img class=\\\"frm_ajax_loading\\\" src=\\\"[frmurl]/images/ajax_loader.gif\\\" alt=\\\"Sending\\\"/>\r\n[if save_draft]<a href=\\\"#\\\" class=\\\"frm_save_draft\\\" [draft_hook]>[draft_label]</a>[/if save_draft]\r\n</div>\";s:9:\"show_form\";i:0;s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:11:\"js_validate\";i:0;s:10:\"save_draft\";i:0;s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:11:\"ajax_submit\";i:0;s:10:\"prev_value\";s:8:\"Previous\";s:8:\"rootline\";s:0:\"\";s:18:\"rootline_titles_on\";i:0;s:15:\"rootline_titles\";a:0:{}s:18:\"rootline_lines_off\";i:0;s:20:\"rootline_numbers_off\";i:0;}", "2016-11-22 13:32:42");
INSERT INTO `wp_frm_forms` VALUES("8", "contact22", "Contact Us", "<p>We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.</p>\r\n", "0", "0", "0", "0", "0", "published", "a:44:{s:14:\"success_action\";s:8:\"redirect\";s:11:\"success_url\";s:16:\"/thank-you-page/\";s:15:\"success_page_id\";s:0:\"\";s:7:\"akismet\";s:1:\"1\";s:14:\"logged_in_role\";s:0:\"\";s:17:\"single_entry_type\";s:4:\"user\";s:17:\"cookie_expiration\";s:4:\"8000\";s:13:\"editable_role\";s:0:\"\";s:18:\"open_editable_role\";s:2:\"-1\";s:11:\"edit_action\";s:7:\"message\";s:8:\"edit_url\";s:0:\"\";s:12:\"edit_page_id\";s:0:\"\";s:13:\"protect_files\";s:1:\"0\";s:11:\"open_status\";s:0:\"\";s:9:\"open_date\";s:16:\"2019-01-29 20:43\";s:10:\"close_date\";s:0:\"\";s:11:\"max_entries\";s:0:\"\";s:10:\"closed_msg\";s:53:\"<p>This form is currently closed for submissions.</p>\";s:12:\"custom_style\";s:1:\"1\";s:12:\"submit_value\";s:6:\"Submit\";s:10:\"edit_value\";s:6:\"Update\";s:12:\"submit_align\";s:0:\"\";s:17:\"submit_conditions\";a:2:{s:9:\"show_hide\";s:4:\"show\";s:7:\"any_all\";s:3:\"all\";}s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:8:\"edit_msg\";s:39:\"Your submission was successfully saved.\";s:9:\"draft_msg\";s:26:\"Your draft has been saved.\";s:10:\"form_class\";s:0:\"\";s:11:\"before_html\";s:200:\"<legend class=\\\"frm_hidden\\\">[form_name]</legend>\r\n[if form_name]<h4>[form_name]</h4>[/if form_name]\r\n[if form_description]<div class=\\\"frm_description\\\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:471:\"<div class=\\\"frm_submit\\\">\r\n[if back_button]<input type=\\\"button\\\" value=\\\"[back_label]\\\" name=\\\"frm_prev_page\\\" formnovalidate=\\\"formnovalidate\\\" class=\\\"frm_prev_page\\\" [back_hook] />[/if back_button]\r\n<input type=\\\"submit\\\" value=\\\"[button_label]\\\" [button_action] />\r\n<img class=\\\"frm_ajax_loading\\\" src=\\\"[frmurl]/images/ajax_loader.gif\\\" alt=\\\"Sending\\\"/>\r\n[if save_draft]<a href=\\\"#\\\" class=\\\"frm_save_draft\\\" [draft_hook]>[draft_label]</a>[/if save_draft]\r\n</div>\";s:9:\"show_form\";i:0;s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:11:\"js_validate\";i:0;s:10:\"save_draft\";i:0;s:4:\"copy\";i:0;s:12:\"single_entry\";i:0;s:11:\"ajax_submit\";i:0;s:10:\"prev_value\";s:8:\"Previous\";s:8:\"rootline\";s:0:\"\";s:18:\"rootline_titles_on\";i:0;s:15:\"rootline_titles\";a:0:{}s:18:\"rootline_lines_off\";i:0;s:20:\"rootline_numbers_off\";i:0;}", "2017-04-19 21:30:46");

/* INSERT TABLE DATA: wp_frm_item_metas */
INSERT INTO `wp_frm_item_metas` VALUES("6", "New Customer", "64", "2", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_item_metas` VALUES("7", "customer@email.com", "71", "2", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_item_metas` VALUES("8", "555-555-5555", "72", "2", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_item_metas` VALUES("9", "Subject", "68", "2", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_item_metas` VALUES("10", "This is a test submission. No further action is required!", "69", "2", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_item_metas` VALUES("11", "New Customer", "64", "3", "2017-04-17 20:33:23");
INSERT INTO `wp_frm_item_metas` VALUES("12", "customer@email.com", "71", "3", "2017-04-17 20:33:23");
INSERT INTO `wp_frm_item_metas` VALUES("13", "555-555-5555", "72", "3", "2017-04-17 20:33:23");
INSERT INTO `wp_frm_item_metas` VALUES("14", "Subject", "68", "3", "2017-04-17 20:33:23");
INSERT INTO `wp_frm_item_metas` VALUES("15", "This is a test submission. No further action is required.", "69", "3", "2017-04-17 20:33:23");

/* INSERT TABLE DATA: wp_frm_items */
INSERT INTO `wp_frm_items` VALUES("2", "9uufp", "New Customer", "a:2:{s:7:\"browser\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36\";s:8:\"referrer\";s:97:\"http://template01.ourdemosites.com/wp-admin/admin-ajax.php?action=frm_forms_preview&form=contact2\";}", "209.118.12.114", "6", "0", "1", "0", "0", "1", "2017-04-17 20:33:19", "2017-04-17 20:33:19");
INSERT INTO `wp_frm_items` VALUES("3", "prs4k", "New Customer", "a:2:{s:7:\"browser\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36\";s:8:\"referrer\";s:97:\"http://template01.ourdemosites.com/wp-admin/admin-ajax.php?action=frm_forms_preview&form=contact2\";}", "209.118.12.114", "6", "0", "1", "0", "0", "1", "2017-04-17 20:33:23", "2017-04-17 20:33:23");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://template01.ourdemosites.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://template01.ourdemosites.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Template 01", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "william@highervisibility.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:25:{i:0;s:15:\"worker/init.php\";i:1;s:37:\"admin-menu-editor-pro/menu-editor.php\";i:2;s:34:\"advanced-custom-fields-pro/acf.php\";i:3;s:19:\"akismet/akismet.php\";i:4;s:31:\"ao_critcsscom/ao_critcsscom.php\";i:5;s:27:\"autoptimize/autoptimize.php\";i:6;s:47:\"better-search-replace/better-search-replace.php\";i:7;s:31:\"cache-enabler/cache-enabler.php\";i:8;s:33:\"classic-editor/classic-editor.php\";i:9;s:25:\"duplicator/duplicator.php\";i:10;s:57:\"ewww-image-optimizer-cloud/ewww-image-optimizer-cloud.php\";i:11;s:53:\"formidable-autoresponder/formidable-autoresponder.php\";i:12;s:33:\"formidable-pro/formidable-pro.php\";i:13;s:25:\"formidable/formidable.php\";i:14;s:19:\"mailgun/mailgun.php\";i:15;s:19:\"optimus/optimus.php\";i:16;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:17;s:27:\"redirection/redirection.php\";i:18;s:43:\"responsive-lightbox/responsive-lightbox.php\";i:19;s:54:\"seo-optimized-images-business/seo-optimized-images.php\";i:20;s:29:\"video-user-manuals/plugin.php\";i:21;s:23:\"wordfence/wordfence.php\";i:22;s:24:\"wordpress-seo/wp-seo.php\";i:23;s:26:\"wp-toolbar-editor/load.php\";i:24;s:21:\"wppusher/wppusher.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:84:\"/home/ourdemosites/public_html/template01/wp-content/themes/template01/functions.php\";i:1;s:80:\"/home/ourdemosites/public_html/template01/wp-content/themes/template01/style.css\";i:2;s:89:\"/home/ourdemosites/public_html/template01/wp-content/themes/template01/single-service.php\";i:3;s:83:\"/home/ourdemosites/public_html/template01/wp-content/themes/framework/functions.php\";i:4;s:79:\"/home/ourdemosites/public_html/template01/wp-content/themes/framework/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "framework", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "template01", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "administrator", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:10:{s:35:\"wp-fastest-cache/wpFastestCache.php\";a:2:{i:0;s:14:\"WpFastestCache\";i:1;s:9:\"uninstall\";}s:57:\"ewww-image-optimizer-cloud/ewww-image-optimizer-cloud.php\";s:30:\"ewww_image_optimizer_uninstall\";s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:43:\"google-analytics-dashboard-for-wp/gadwp.php\";a:2:{i:0;s:15:\"GADWP_Uninstall\";i:1;s:9:\"uninstall\";}s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:31:\"cache-enabler/cache-enabler.php\";a:2:{i:0;s:13:\"Cache_Enabler\";i:1;s:12:\"on_uninstall\";}s:19:\"optimus/optimus.php\";a:2:{i:0;s:7:\"Optimus\";i:1;s:21:\"handle_uninstall_hook\";}s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "5", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "37965", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:4:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:82:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"frm_view_forms\";b:1;s:14:\"frm_edit_forms\";b:1;s:16:\"frm_delete_forms\";b:1;s:19:\"frm_change_settings\";b:1;s:16:\"frm_view_entries\";b:1;s:18:\"frm_delete_entries\";b:1;s:18:\"frm_create_entries\";b:1;s:16:\"frm_edit_entries\";b:1;s:16:\"frm_view_reports\";b:1;s:17:\"frm_edit_displays\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"client\";a:2:{s:4:\"name\";s:6:\"Client\";s:12:\"capabilities\";a:68:{s:16:\"activate_plugins\";b:0;s:12:\"create_pages\";b:0;s:12:\"create_posts\";b:1;s:12:\"create_users\";b:1;s:19:\"delete_others_pages\";b:0;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:14:\"delete_plugins\";b:0;s:12:\"delete_posts\";b:1;s:20:\"delete_private_pages\";b:0;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:0;s:22:\"delete_published_posts\";b:1;s:13:\"delete_themes\";b:0;s:12:\"delete_users\";b:0;s:14:\"edit_dashboard\";b:0;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:12:\"edit_plugins\";b:0;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:18:\"edit_theme_options\";b:0;s:11:\"edit_themes\";b:0;s:10:\"edit_users\";b:0;s:6:\"export\";b:0;s:19:\"frm_change_settings\";b:0;s:18:\"frm_create_entries\";b:1;s:18:\"frm_delete_entries\";b:1;s:16:\"frm_delete_forms\";b:0;s:17:\"frm_edit_displays\";b:0;s:16:\"frm_edit_entries\";b:0;s:14:\"frm_edit_forms\";b:0;s:16:\"frm_view_entries\";b:1;s:14:\"frm_view_forms\";b:1;s:16:\"frm_view_reports\";b:1;s:6:\"import\";b:0;s:15:\"install_plugins\";b:0;s:14:\"install_themes\";b:0;s:10:\"list_users\";b:0;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:14:\"manage_options\";b:0;s:17:\"moderate_comments\";b:1;s:13:\"promote_users\";b:0;s:13:\"publish_pages\";b:0;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:12:\"remove_users\";b:0;s:13:\"switch_themes\";b:0;s:15:\"unfiltered_html\";b:0;s:17:\"unfiltered_upload\";b:0;s:11:\"update_core\";b:0;s:14:\"update_plugins\";b:0;s:13:\"update_themes\";b:0;s:12:\"upload_files\";b:1;s:23:\"ure_create_capabilities\";b:0;s:16:\"ure_create_roles\";b:0;s:23:\"ure_delete_capabilities\";b:0;s:16:\"ure_delete_roles\";b:0;s:14:\"ure_edit_roles\";b:0;s:18:\"ure_manage_options\";b:0;s:15:\"ure_reset_roles\";b:0;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:3:{s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:2:{s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "cron", "a:28:{i:1613583726;a:1:{s:13:\"ao_ccss_queue\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"ao_ccss\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1613583803;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1613586273;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1613586783;a:1:{s:25:\"ewww_image_optimizer_auto\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1613586922;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1613590634;a:1:{s:18:\"ai1wm_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613594083;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613596278;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613598788;a:1:{s:38:\"check_plugin_updates-wp-toolbar-editor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613600911;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613602797;a:1:{s:40:\"puc_cron_check_updates-wp-toolbar-editor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613604215;a:1:{s:44:\"puc_cron_check_updates-admin-menu-editor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613620405;a:1:{s:39:\"check_plugin_updates-video-user-manuals\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every12hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613622223;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613625126;a:1:{s:19:\"ao_ccss_maintenance\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613625491;a:1:{s:21:\"wpo_plugin_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1613637337;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613640079;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613647076;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613657548;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613662988;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613663003;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613664725;a:1:{s:22:\"redirection_log_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613841000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"3ae3e929eb981031f7b553df8f0ccd13\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1613841000;}}}}i:1614009600;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1614100200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"867c665c9231db57b38ec9ca4a068ce6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1614100200;}}}}i:1614131680;a:1:{s:21:\"formidable_send_usage\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("124", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1479374453;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("125", "current_theme", "Template - 01", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_mods_consultant", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"mainnav\";i:2;s:8:\"aboutnav\";i:3;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1485794776;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("127", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("131", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("132", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("141", "acf_version", "5.9.3", "yes");
INSERT INTO `wp_options` VALUES("142", "options_theme_general_settings_0_logo", "38", "no");
INSERT INTO `wp_options` VALUES("143", "_options_theme_general_settings_0_logo", "field_582d8395115e4", "no");
INSERT INTO `wp_options` VALUES("144", "options_theme_general_settings_0_phone", "020 8567 0707", "no");
INSERT INTO `wp_options` VALUES("145", "_options_theme_general_settings_0_phone", "field_582d83a9115e5", "no");
INSERT INTO `wp_options` VALUES("146", "options_theme_general_settings_0_email", "support24.7@domain.com", "no");
INSERT INTO `wp_options` VALUES("147", "_options_theme_general_settings_0_email", "field_582d83b2115e6", "no");
INSERT INTO `wp_options` VALUES("148", "options_theme_general_settings_0_address", "51 Uxbridge Road, San Francisco W7 3PX", "no");
INSERT INTO `wp_options` VALUES("149", "_options_theme_general_settings_0_address", "field_582d83ba115e7", "no");
INSERT INTO `wp_options` VALUES("150", "options_theme_general_settings_0_google_map", "", "no");
INSERT INTO `wp_options` VALUES("151", "_options_theme_general_settings_0_google_map", "field_582d83c0115e8", "no");
INSERT INTO `wp_options` VALUES("152", "options_theme_general_settings_0_footer_content", "<p>Lorem ipsum dolor sit consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna veniam aliqua.</p>", "no");
INSERT INTO `wp_options` VALUES("153", "_options_theme_general_settings_0_footer_content", "field_582d83c7115e9", "no");
INSERT INTO `wp_options` VALUES("154", "options_theme_general_settings_0_business_hours", " <p>Our suppoer available to help you 24 hours a day, seven days week</p><ul><li>Monday-Saturday: ............ 8.00-18.00</li><li>Sunday: .......................................... Closed</li><li>Calendar Events: ....................... Closed</li></ul>", "no");
INSERT INTO `wp_options` VALUES("155", "_options_theme_general_settings_0_business_hours", "field_582d83dc115ea", "no");
INSERT INTO `wp_options` VALUES("156", "options_theme_general_settings_0_copy_rights", "© 2016 Designed by NthPsd. All rights reserved", "no");
INSERT INTO `wp_options` VALUES("157", "_options_theme_general_settings_0_copy_rights", "field_582d8400115eb", "no");
INSERT INTO `wp_options` VALUES("158", "options_theme_general_settings", "a:1:{i:0;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("159", "_options_theme_general_settings", "field_582d836a115e3", "no");
INSERT INTO `wp_options` VALUES("160", "options_theme_general_settings_0_footer_logo", "40", "no");
INSERT INTO `wp_options` VALUES("161", "_options_theme_general_settings_0_footer_logo", "field_582d88335198c", "no");
INSERT INTO `wp_options` VALUES("162", "options_theme_general_settings_0_social_networks_0_title", "ion-social-twitter", "no");
INSERT INTO `wp_options` VALUES("163", "_options_theme_general_settings_0_social_networks_0_title", "field_582d8886385a9", "no");
INSERT INTO `wp_options` VALUES("164", "options_theme_general_settings_0_social_networks_0_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("165", "_options_theme_general_settings_0_social_networks_0_url", "field_582d8891385aa", "no");
INSERT INTO `wp_options` VALUES("166", "options_theme_general_settings_0_social_networks_1_title", "ion-social-facebook", "no");
INSERT INTO `wp_options` VALUES("167", "_options_theme_general_settings_0_social_networks_1_title", "field_582d8886385a9", "no");
INSERT INTO `wp_options` VALUES("168", "options_theme_general_settings_0_social_networks_1_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("169", "_options_theme_general_settings_0_social_networks_1_url", "field_582d8891385aa", "no");
INSERT INTO `wp_options` VALUES("170", "options_theme_general_settings_0_social_networks_2_title", "ion-social-pinterest", "no");
INSERT INTO `wp_options` VALUES("171", "_options_theme_general_settings_0_social_networks_2_title", "field_582d8886385a9", "no");
INSERT INTO `wp_options` VALUES("172", "options_theme_general_settings_0_social_networks_2_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("173", "_options_theme_general_settings_0_social_networks_2_url", "field_582d8891385aa", "no");
INSERT INTO `wp_options` VALUES("174", "options_theme_general_settings_0_social_networks_3_title", "ion-social-instagram-outline", "no");
INSERT INTO `wp_options` VALUES("175", "_options_theme_general_settings_0_social_networks_3_title", "field_582d8886385a9", "no");
INSERT INTO `wp_options` VALUES("176", "options_theme_general_settings_0_social_networks_3_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("177", "_options_theme_general_settings_0_social_networks_3_url", "field_582d8891385aa", "no");
INSERT INTO `wp_options` VALUES("178", "options_theme_general_settings_0_social_networks_4_title", "ion-social-linkedin", "no");
INSERT INTO `wp_options` VALUES("179", "_options_theme_general_settings_0_social_networks_4_title", "field_582d8886385a9", "no");
INSERT INTO `wp_options` VALUES("180", "options_theme_general_settings_0_social_networks_4_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("181", "_options_theme_general_settings_0_social_networks_4_url", "field_582d8891385aa", "no");
INSERT INTO `wp_options` VALUES("182", "options_theme_general_settings_0_social_networks", "5", "no");
INSERT INTO `wp_options` VALUES("183", "_options_theme_general_settings_0_social_networks", "field_582d8877385a8", "no");
INSERT INTO `wp_options` VALUES("195", "cptui_post_types", "a:3:{s:7:\"service\";a:28:{s:4:\"name\";s:7:\"service\";s:5:\"label\";s:8:\"Services\";s:14:\"singular_label\";s:7:\"Service\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:7:\"gallery\";a:28:{s:4:\"name\";s:7:\"gallery\";s:5:\"label\";s:9:\"Galleries\";s:14:\"singular_label\";s:7:\"Gallery\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:11:\"testimonial\";a:28:{s:4:\"name\";s:11:\"testimonial\";s:5:\"label\";s:12:\"Testimonials\";s:14:\"singular_label\";s:11:\"Testimonial\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("225", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("228", "cptui_taxonomies", "a:1:{s:4:\"type\";a:21:{s:4:\"name\";s:4:\"type\";s:5:\"label\";s:10:\"Categories\";s:14:\"singular_label\";s:8:\"Category\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:12:\"hierarchical\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:12:\"show_in_menu\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";s:17:\"show_admin_column\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:18:\"show_in_quick_edit\";s:0:\"\";s:9:\"rest_base\";s:0:\"\";s:6:\"labels\";a:18:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:11:\"update_item\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:13:\"new_item_name\";s:0:\"\";s:11:\"parent_item\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:13:\"popular_items\";s:0:\"\";s:26:\"separate_items_with_commas\";s:0:\"\";s:19:\"add_or_remove_items\";s:0:\"\";s:21:\"choose_from_most_used\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:8:\"no_terms\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";}s:12:\"object_types\";a:1:{i:0;s:7:\"gallery\";}}}", "yes");
INSERT INTO `wp_options` VALUES("261", "options_email", "info@consultant.com", "no");
INSERT INTO `wp_options` VALUES("262", "_options_email", "field_5832c7cd41d5f", "no");
INSERT INTO `wp_options` VALUES("263", "options_phone", "123-456-7890", "no");
INSERT INTO `wp_options` VALUES("264", "_options_phone", "field_5832c7e8768a7", "no");
INSERT INTO `wp_options` VALUES("265", "options_address", "51 Uxbridge Road, San Francisco W7 3PX", "no");
INSERT INTO `wp_options` VALUES("266", "_options_address", "field_5832c89b063f6", "no");
INSERT INTO `wp_options` VALUES("267", "options_google_map", "<iframe class=\"map-hover\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d31379.833421146785!2d-74.023112896384!3d40.703817114610544!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24fa5d33f083b%3A0xc80b8f06e177fe62!2sNew+York%2C+NY%2C+USA!5e0!3m2!1sen!2sin!4v1478089967584\" width=\"600\" height=\"450\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe>", "no");
INSERT INTO `wp_options` VALUES("268", "_options_google_map", "field_5832c8a6063f7", "no");
INSERT INTO `wp_options` VALUES("269", "options_logo", "38", "no");
INSERT INTO `wp_options` VALUES("270", "_options_logo", "field_583433bd781dd", "no");
INSERT INTO `wp_options` VALUES("271", "options_header_phone", "020 8567 0707", "no");
INSERT INTO `wp_options` VALUES("272", "_options_header_phone", "field_583433c9781de", "no");
INSERT INTO `wp_options` VALUES("273", "options_footer_logo", "40", "no");
INSERT INTO `wp_options` VALUES("274", "_options_footer_logo", "field_583433e4781e0", "no");
INSERT INTO `wp_options` VALUES("275", "options_footer_content", "Lorem ipsum dolor sit consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna veniam aliqua.", "no");
INSERT INTO `wp_options` VALUES("276", "_options_footer_content", "field_583433fd781e1", "no");
INSERT INTO `wp_options` VALUES("277", "options_copy_rights", "Designed by NthPsd. All rights reserved", "no");
INSERT INTO `wp_options` VALUES("278", "_options_copy_rights", "field_583434b8781e8", "no");
INSERT INTO `wp_options` VALUES("279", "options_business_hours_content", "Our support is available to help you 24 hours a day, 7 days a week", "no");
INSERT INTO `wp_options` VALUES("280", "_options_business_hours_content", "field_583434f7781ed", "no");
INSERT INTO `wp_options` VALUES("281", "options_business_hours_timings_0_title", "Monday-Saturday", "no");
INSERT INTO `wp_options` VALUES("282", "_options_business_hours_timings_0_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("283", "options_business_hours_timings_0_timings", "8.00-18.00", "no");
INSERT INTO `wp_options` VALUES("284", "_options_business_hours_timings_0_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("285", "options_business_hours_timings_1_title", "Sunday", "no");
INSERT INTO `wp_options` VALUES("286", "_options_business_hours_timings_1_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("287", "options_business_hours_timings_1_timings", "Closed", "no");
INSERT INTO `wp_options` VALUES("288", "_options_business_hours_timings_1_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("289", "options_business_hours_timings_2_title", "Calendar Events", "no");
INSERT INTO `wp_options` VALUES("290", "_options_business_hours_timings_2_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("291", "options_business_hours_timings_2_timings", "Closed", "no");
INSERT INTO `wp_options` VALUES("292", "_options_business_hours_timings_2_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("293", "options_business_hours_timings", "3", "no");
INSERT INTO `wp_options` VALUES("294", "_options_business_hours_timings", "field_58343514781ee", "no");
INSERT INTO `wp_options` VALUES("295", "options_social_networks_0_title", "twitter", "no");
INSERT INTO `wp_options` VALUES("296", "_options_social_networks_0_title", "field_5834354a781f3", "no");
INSERT INTO `wp_options` VALUES("297", "options_social_networks_0_url", "https://www.twitter.com/", "no");
INSERT INTO `wp_options` VALUES("298", "_options_social_networks_0_url", "field_5834354f781f4", "no");
INSERT INTO `wp_options` VALUES("299", "options_social_networks_1_title", "facebook", "no");
INSERT INTO `wp_options` VALUES("300", "_options_social_networks_1_title", "field_5834354a781f3", "no");
INSERT INTO `wp_options` VALUES("301", "options_social_networks_1_url", "https://www.facebook.com/", "no");
INSERT INTO `wp_options` VALUES("302", "_options_social_networks_1_url", "field_5834354f781f4", "no");
INSERT INTO `wp_options` VALUES("303", "options_social_networks_2_title", "pinterest", "no");
INSERT INTO `wp_options` VALUES("304", "_options_social_networks_2_title", "field_5834354a781f3", "no");
INSERT INTO `wp_options` VALUES("305", "options_social_networks_2_url", "https://www.pinterest.com/", "no");
INSERT INTO `wp_options` VALUES("306", "_options_social_networks_2_url", "field_5834354f781f4", "no");
INSERT INTO `wp_options` VALUES("307", "options_social_networks_3_title", "instagram-outline", "no");
INSERT INTO `wp_options` VALUES("308", "_options_social_networks_3_title", "field_5834354a781f3", "no");
INSERT INTO `wp_options` VALUES("309", "options_social_networks_3_url", "https://www.instagram.com/", "no");
INSERT INTO `wp_options` VALUES("310", "_options_social_networks_3_url", "field_5834354f781f4", "no");
INSERT INTO `wp_options` VALUES("311", "options_social_networks_4_title", "linkedin", "no");
INSERT INTO `wp_options` VALUES("312", "_options_social_networks_4_title", "field_5834354a781f3", "no");
INSERT INTO `wp_options` VALUES("313", "options_social_networks_4_url", "https://www.linkedin.com/", "no");
INSERT INTO `wp_options` VALUES("314", "_options_social_networks_4_url", "field_5834354f781f4", "no");
INSERT INTO `wp_options` VALUES("315", "options_social_networks", "5", "no");
INSERT INTO `wp_options` VALUES("316", "_options_social_networks", "field_58343539781f2", "no");
INSERT INTO `wp_options` VALUES("357", "frm_last_style_update", "1112000", "yes");
INSERT INTO `wp_options` VALUES("358", "frmpro_css", "/* WARNING: Any changes made to this file will be lost when your Formidable settings are updated */\n.with_frm_style{--form-width:100%;--form-align:left;--direction:ltr;--fieldset:0px;--fieldset-color:#000000;--fieldset-padding:0 0 15px 0;--fieldset-bg-color:transparent;--title-size:40px;--title-color:#444444;--title-margin-top:10px;--title-margin-bottom:60px;--form-desc-size:14px;--form-desc-color:#666666;--form-desc-margin-top:10px;--form-desc-margin-bottom:25px;--font:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;--font-size:15px;--label-color:#3f4b5b;--weight:normal;--position:none;--align:left;--width:150px;--required-color:#B94A48;--required-weight:bold;--label-padding:0 0 3px 0;--description-font-size:12px;--description-color:#666666;--description-weight:normal;--description-style:normal;--description-align:left;--description-margin:0;--field-font-size:14px;--field-height:32px;--line-height:normal;--field-width:100%;--auto-width:100%;--field-pad:6px 10px;--field-margin:20px;--field-weight:normal;--text-color:#555555;--border-color:#BFC3C8;--field-border-width:1px;--field-border-style:solid;--bg-color:#ffffff;--bg-color-active:#ffffff;--border-color-active:#66afe9;--text-color-error:#444444;--bg-color-error:#ffffff;--border-color-error:#B94A48;--border-width-error:1px;--border-style-error:solid;--bg-color-disabled:#ffffff;--border-color-disabled:#E5E5E5;--text-color-disabled:#A1A1A1;--radio-align:block;--check-align:block;--check-font-size:13px;--check-label-color:#444444;--check-weight:normal;--section-font-size:18px;--section-color:#444444;--section-weight:bold;--section-pad:15px 0 3px 0;--section-mar-top:15px;--section-mar-bottom:30px;--section-bg-color:transparent;--section-border-color:#e8e8e8;--section-border-width:2px;--section-border-style:solid;--section-border-loc:-top;--collapse-pos:after;--submit-font-size:15px;--submit-width:auto;--submit-height:auto;--submit-bg-color:#579AF6;--submit-border-color:#579AF6;--submit-border-width:1px;--submit-text-color:#ffffff;--submit-weight:normal;--submit-border-radius:4px;--submit-margin:10px;--submit-padding:10px 20px;--submit-shadow-color:#eeeeee;--submit-hover-bg-color:#efefef;--submit-hover-color:#444444;--submit-hover-border-color:#cccccc;--submit-active-bg-color:#efefef;--submit-active-color:#444444;--submit-active-border-color:#cccccc;--border-radius:4px;--error-bg:#F2DEDE;--error-border:#EBCCD1;--error-text:#B94A48;--error-font-size:14px;--success-bg-color:#DFF0D8;--success-border-color:#D6E9C6;--success-text-color:#468847;--success-font-size:14px;--progress-bg-color:#eaeaea;--progress-active-color:#ffffff;--progress-active-bg-color:#579AF6;--progress-color:#3f4b5b;--progress-border-color:#E5E5E5;--progress-border-size:2px;--progress-size:30px;--toggle-font-size:15px;--toggle-on-color:#579AF6;--toggle-off-color:#eaeaea;--slider-font-size:24px;--slider-color:#579AF6;--slider-bar-color:#579AF6;--date-head-bg-color:#579AF6;--date-head-color:#ffffff;--date-band-color:#2568c4;--box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_hidden,.frm_add_form_row.frm_hidden,.frm_remove_form_row.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style,.with_frm_style form,.with_frm_style .frm-show-form div.frm_description p{text-align:left;text-align:var(--form-align);}.with_frm_style .frm-show-form div.frm_description p{font-size:14px;font-size:var(--form-desc-size);color:#666666;color:var(--form-desc-color);margin-top:10px;margin-top:var(--form-desc-margin-top);margin-bottom:25px;margin-bottom:var(--form-desc-margin-bottom);}form input.frm_verify{position:absolute;left:-3000px;}.with_frm_style fieldset{min-width:0;}.with_frm_style fieldset fieldset{border:none;margin:0;padding:0;background-color:transparent;}.with_frm_style .frm_form_fields > fieldset{border-width:0px;border-width:var(--fieldset);border-style:solid;border-color:#000000;border-color:var(--fieldset-color);margin:0;padding:0 0 15px 0;padding:var(--fieldset-padding);background-color:transparent;background-color:var(--fieldset-bg-color);font-family:var(--font);}legend.frm_hidden{display:none !important;}.with_frm_style .frm_form_fields{opacity:1;transition: opacity 0.1s linear;}.with_frm_style .frm_doing_ajax{opacity:.5;}.frm_transparent{color:transparent;}.with_frm_style legend + h3,.with_frm_style h3.frm_form_title{font-size:40px;font-size:var(--title-size);color:#444444;color:var(--title-color);font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);margin-top:10px;margin-top:var(--title-margin-top);margin-bottom:60px;margin-bottom:var(--title-margin-bottom);}.with_frm_style .frm_form_field.frm_html_container,.with_frm_style .frm_form_field .frm_show_it{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);color:#666666;color:var(--form-desc-color);}.with_frm_style .frm_form_field.frm_html_container{font-size:14px;font-size:var(--form-desc-size);}.with_frm_style .frm_form_field .frm_show_it{font-size:14px;font-size:var(--field-font-size);font-weight:normal;font-weight:var(--field-weight);}.with_frm_style .frm_required{color:#B94A48;color:var(--required-color);font-weight:bold;font-weight:var(--required-weight);}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container{font-family:var(--font);font-size:14px;font-size:var(--field-font-size);margin-bottom:0;}.with_frm_style textarea{vertical-align:top;height:auto;}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=phone],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.frm_form_fields_style,.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .chosen-container-multi .chosen-choices,.with_frm_style .chosen-container-single .chosen-single{color:#555555;color:var(--text-color);background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;font-weight:var(--field-weight);box-shadow:var(--box-shadow);}.with_frm_style input[type=radio],.with_frm_style input[type=checkbox]{border-color:#BFC3C8;border-color:var(--border-color);box-shadow:var(--box-shadow);}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=file],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style .frm-card-element.StripeElement{height:32px;height:var(--field-height);line-height:1.3;}.with_frm_style select[multiple=multiple]{height:auto;}.input[type=file].frm_transparent:focus,.with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{color:#555555;color:var(--text-color);padding:0px;font-family:var(--font);font-size:14px;font-size:var(--field-font-size);display:initial;}.with_frm_style input[type=file].frm_transparent{color:transparent;}.with_frm_style .wp-editor-wrap{width:100%;width:var(--field-width);max-width:100%;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .mceIframeContainer{background-color:#ffffff;background-color:var(--bg-color);}.with_frm_style select{width:100%;width:var(--auto-width);max-width:100%;}.with_frm_style input[disabled],.with_frm_style select[disabled],.with_frm_style textarea[disabled],.with_frm_style input[readonly],.with_frm_style select[readonly],.with_frm_style textarea[readonly]{background-color:#ffffff;background-color:var(--bg-color-disabled);color:#A1A1A1;color:var(--text-color-disabled);border-color:#E5E5E5;border-color:var(--border-color-disabled);}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .frm_primary_label{max-width:100%;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);font-size:15px;font-size:var(--font-size);color:#3f4b5b;color:var(--label-color);font-weight:normal;font-weight:var(--weight);text-align:left;text-align:var(--align);padding:0 0 3px 0;padding:var(--label-padding);margin:0;width:auto;display:block;}.with_frm_style .frm_top_container .frm_primary_label,.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container .frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container .frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_pos_center {text-align: center;}.with_frm_style .frm_none_container .frm_primary_label,.with_frm_style .frm_pos_none,.frm_pos_none,.frm_none_container .frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container .frm_primary_label{visibility:hidden;white-space:nowrap;}.with_frm_style .frm_inside_container .frm_primary_label{opacity:0;transition: opacity 0.1s linear;}.with_frm_style .frm_inside_container label.frm_visible,.frm_visible{opacity:1;}.with_frm_style .frm_description{clear:both;}.with_frm_style input[type=number][readonly]{-moz-appearance: textfield;}.with_frm_style select[multiple=\"multiple\"]{height:auto;line-height:normal;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none !important;;border:1px solid #eee;display:inline-block;padding:10px 20px;padding:var(--submit-padding);-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;border-radius:var(--border-radius);font-size:15px;font-size:var(--submit-font-size);font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);font-weight:normal;font-weight:var(--submit-weight);color:#ffffff;color:var(--submit-text-color);background:#579AF6;background:var(--submit-bg-color);border-width:1px;border-width:var(--submit-border-width);border-color:#579AF6;border-color:var(--submit-border-color);height:auto;height:var(--submit-height);}.with_frm_style .frm_button.frm_inverse{color:var(--submit-bg-color);background:var(--submit-text-color);}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field,.frm_inline_form .frm_submit{grid-column: span 1 / span 1;}.frm_inline_form .frm_submit{margin:0;}.frm_submit.frm_inline_submit input[type=submit],.frm_submit.frm_inline_submit button,.frm_inline_form .frm_submit input[type=submit],.frm_inline_form .frm_submit button{margin-top:0;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style .frm_inline_success .frm_submit{display: flex;flex-direction: row;align-items: center;margin: 0;}.with_frm_style .frm_inline_success .frm_submit .frm_message{flex: 1;margin: 0;padding-left: 10px;}.with_frm_style .frm_inline_success.frm_alignright_success .frm_submit .frm_message{text-align: right;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button],.with_frm_style.frm_center_submit .frm_submit button{margin-bottom:8px !important;}.with_frm_style .frm-edit-page-btn,.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button],.with_frm_style .frm_submit button{-webkit-appearance: none;cursor: pointer;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.with_frm_style .frm_loading_prev .frm_ajax_loading,.with_frm_style .frm_loading_form .frm_ajax_loading{visibility:visible !important;}.with_frm_style .frm_loading_prev .frm_prev_page,.with_frm_style .frm_loading_form .frm_button_submit {position: relative;opacity: .8;color: transparent !important;text-shadow: none !important;}.with_frm_style .frm_loading_prev .frm_prev_page:hover,.with_frm_style .frm_loading_prev .frm_prev_page:active,.with_frm_style .frm_loading_prev .frm_prev_page:focus,.with_frm_style .frm_loading_form .frm_button_submit:hover,.with_frm_style .frm_loading_form .frm_button_submit:active,.with_frm_style .frm_loading_form .frm_button_submit:focus {cursor: not-allowed;color: transparent;outline: none !important;box-shadow: none;}.with_frm_style .frm_loading_prev .frm_prev_page::before,.with_frm_style .frm_loading_form .frm_button_submit:before {content: \'\';display: inline-block;position: absolute;background: transparent;border: 1px solid #fff;border-top-color: transparent;border-left-color: transparent;border-radius: 50%;box-sizing: border-box;top: 50%;left: 50%;margin-top: -10px;margin-left: -10px;width: 20px;height: 20px;-webkit-animation: spin 2s linear infinite;-moz-animation:spin 2s linear infinite;-o-animation:  spin 2s linear infinite;animation: spin 2s linear infinite;}.frm_style_formidable-style.with_frm_style{}.frm_forms.frm_style_formidable-style.with_frm_style{max-width:100%;direction:ltr;}.frm_style_formidable-style.with_frm_style .frm_icon_font{color:#3f4b5b;}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before{content:\"\\e600\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{content:\"\\e602\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before,.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{color:#ffffff;vertical-align:middle;}.frm_style_formidable-style.with_frm_style .frm_trigger.active .frm_icon_font.frm_arrow_icon:before{content:\"\\e62d\";color:#444444;}.frm_style_formidable-style.with_frm_style .frm_trigger .frm_icon_font.frm_arrow_icon:before{content:\"\\e62a\";color:#444444;}.frm_style_formidable-style.with_frm_style .form-field{margin-bottom:20px;}.frm_style_formidable-style.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_formidable-style.with_frm_style p.description,.frm_style_formidable-style.with_frm_style div.description,.frm_style_formidable-style.with_frm_style div.frm_description,.frm_style_formidable-style.with_frm_style .frm-show-form > div.frm_description,.frm_style_formidable-style.with_frm_style .frm_error{padding:0;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:12px;color:#666666;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container{grid-template-columns: 150px auto;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container{grid-template-columns: auto 150px;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_style_formidable-style.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_data_container,.frm_style_formidable-style.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_formidable-style.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_formidable-style.with_frm_style .frm_none_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_pos_none{display:none;}.frm_style_formidable-style.with_frm_style .frm_scale label{font-weight:normal;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:13px;color:#444444;}.frm_style_formidable-style.with_frm_style input::placeholder,.frm_style_formidable-style.with_frm_style textarea::placeholder{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style input::-webkit-input-placeholder,.frm_style_formidable-style.with_frm_style textarea::-webkit-input-placeholder{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style input::-moz-placeholder,.frm_style_formidable-style.with_frm_style textarea::-moz-placeholder{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style input:-ms-input-placeholder,frm_style_formidable-style.with_frm_style textarea:-ms-input-placeholder{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style input:-moz-placeholder,.frm_style_formidable-style.with_frm_style textarea:-moz-placeholder{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style .frm_default,.frm_style_formidable-style.with_frm_style input.frm_default,.frm_style_formidable-style.with_frm_style textarea.frm_default,.frm_style_formidable-style.with_frm_style select.frm_default,.frm_style_formidable-style.with_frm_style .placeholder,.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices li.search-field .default,.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-default{color: #A1A1A1;}.frm_style_formidable-style.with_frm_style .form-field input:not([type=file]):focus,.frm_style_formidable-style.with_frm_style select:focus,.frm_style_formidable-style.with_frm_style textarea:focus,.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_formidable-style.with_frm_style .frm_focus_field .frm-card-element.StripeElement,.frm_style_formidable-style.with_frm_style .chosen-container-single.chosen-container-active .chosen-single,.frm_style_formidable-style.with_frm_style .chosen-container-active .chosen-choices{background-color:#ffffff;border-color:#66afe9;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(102,175,233, 0.6);}.frm_style_formidable-style.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_formidable-style.with_frm_style input[type=submit],.frm_style_formidable-style.with_frm_style .frm_submit input[type=button],.frm_style_formidable-style.with_frm_style .frm_submit button,.frm_form_submit_style,.frm_style_formidable-style.with_frm_style .frm-edit-page-btn {width:auto;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:15px;height:auto;line-height:normal;text-align:center;background:#579AF6;border-width:1px;border-color: #579AF6;border-style:solid;color:#ffffff;cursor:pointer;font-weight:normal;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;text-shadow:none;padding:10px 20px;-moz-box-sizing:border-box;box-sizing:border-box;-ms-box-sizing:border-box;-moz-box-shadow:0 1px 1px #eeeeee;-webkit-box-shadow:0 1px 1px #eeeeee;box-shadow:0 1px 1px #eeeeee;margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_formidable-style.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message{margin:0;}.frm_style_formidable-style.with_frm_style .frm-edit-page-btn:hover,.frm_style_formidable-style.with_frm_style input[type=submit]:hover,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:hover,.frm_style_formidable-style.with_frm_style .frm_submit button:hover{background: #efefef;border-color: #cccccc;color: #444444;}.frm_style_formidable-style.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_formidable-style.with_frm_style .frm-edit-page-btn:focus,.frm_style_formidable-style.with_frm_style input[type=submit]:focus,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:focus,.frm_style_formidable-style.with_frm_style .frm_submit button:focus,.frm_style_formidable-style.with_frm_style input[type=submit]:active,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:active,.frm_style_formidable-style.with_frm_style .frm_submit button:active{background: #efefef;border-color: #cccccc;color: #444444;}.frm_style_formidable-style.with_frm_style .frm_loading_prev .frm_prev_page,.frm_style_formidable-style.with_frm_style .frm_loading_prev .frm_prev_page:hover,.frm_style_formidable-style.with_frm_style .frm_loading_prev .frm_prev_page:active,.frm_style_formidable-style.with_frm_style .frm_loading_prev .frm_prev_page:focus,.frm_style_formidable-style.with_frm_style .frm_loading_form .frm_button_submit,.frm_style_formidable-style.with_frm_style .frm_loading_form .frm_button_submit:hover,.frm_style_formidable-style.with_frm_style .frm_loading_form .frm_button_submit:active,.frm_style_formidable-style.with_frm_style .frm_loading_form .frm_button_submit:focus{color: transparent ;background: #579AF6;}.frm_style_formidable-style.with_frm_style .frm_loading_prev .frm_prev_page:before,.frm_style_formidable-style.with_frm_style .frm_loading_form .frm_button_submit:before {border-bottom-color: #ffffff;border-right-color: #ffffff;}.frm_style_formidable-style.with_frm_style.frm_inline_top .frm_submit::before,.frm_style_formidable-style.with_frm_style .frm_submit.frm_inline_submit::before {content:\"before\";font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:15px;color:#3f4b5b;font-weight:normal;margin:0;padding:0 0 3px 0;width:auto;display:block;visibility:hidden;}.frm_style_formidable-style.with_frm_style.frm_inline_form .frm_submit input,.frm_style_formidable-style.with_frm_style.frm_inline_form .frm_submit button,.frm_style_formidable-style.with_frm_style .frm_submit.frm_inline_submit input,.frm_style_formidable-style.with_frm_style .frm_submit.frm_inline_submit button {margin: 0 !important;}.frm_style_formidable-style.with_frm_style #frm_field_cptch_number_container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:15px;color:#3f4b5b;font-weight:normal;clear:both;}.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_blank_field textarea,.frm_style_formidable-style.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field select,.frm_form_fields_error_style,.frm_style_formidable-style.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .frm-card-element.StripeElement,.frm_style_formidable-style.with_frm_style .frm_blank_field .chosen-container-multi .chosen-choices,.frm_style_formidable-style.with_frm_style .frm_blank_field .chosen-container-single .chosen-single,.frm_style_formidable-style.with_frm_style .frm_form_field :invalid{color:#444444;background-color:#ffffff;border-color:#B94A48;border-width:1px;border-style:solid;}.frm_style_formidable-style.with_frm_style .frm_blank_field .sigWrapper{border-color:#B94A48 !important;}.frm_style_formidable-style.with_frm_style .frm_error{font-weight:normal;}.frm_style_formidable-style.with_frm_style .frm_blank_field label,.frm_style_formidable-style.with_frm_style .frm_error{color:#B94A48;}.frm_style_formidable-style.with_frm_style .frm_error_style{background-color:#F2DEDE;border:1px solid #EBCCD1;border-radius:4px;color: #B94A48;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_formidable-style.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_formidable-style.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total_big input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total_big textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total textarea{color: #555555;background-color:transparent;border:none;display:inline;width:auto;padding:0;}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.with_frm_style a.frm_save_draft{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);font-size:15px;font-size:var(--submit-font-size);font-weight:normal;font-weight:var(--submit-weight);}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:5px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;padding-left: 0;}.with_frm_style .frm_radio{display:block;display:var(--radio-align);}.with_frm_style .frm_checkbox{display:block;display:var(--check-align);}.with_frm_style .vertical_radio .frm_checkbox,.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.with_frm_style .horizontal_radio .frm_checkbox,.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.with_frm_style .frm_checkbox label,.with_frm_style .frm_radio label{display: inline;white-space:normal;}.with_frm_style .vertical_radio .frm_checkbox label,.with_frm_style .vertical_radio .frm_radio label{display: block;padding-left: 20px;text-indent: -20px;}.with_frm_style .frm_radio label,.with_frm_style .frm_checkbox label{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);font-size:13px;font-size:var(--check-font-size);color:#444444;color:var(--check-label-color);font-weight:normal;font-weight:var(--check-weight);}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox] {font-size:13px;font-size:var(--check-font-size);position:static;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{-webkit-appearance:radio;border-radius:50%;}.with_frm_style .frm_checkbox input[type=checkbox]{-webkit-appearance:checkbox;border-radius:0;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{flex: none;display:inline-block;margin:4px 5px 0 0;width:auto;border:none;vertical-align:baseline;position: initial; }.with_frm_style :invalid,.with_frm_style :-moz-submit-invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;padding:15px;}.with_frm_style .frm_message p{margin-bottom:5px;color:#468847;color:var(--success-text-color);}.with_frm_style .frm_message,.frm_success_style{margin:5px 0 15px;border:1px solid #D6E9C6;border-color:var(--success-border-color);background-color:#DFF0D8;background-color:var(--success-bg-color);color:#468847;color:var(--success-text-color);border-radius:4px;border-radius:var(--border-radius);font-size:14px;font-size:var(--success-font-size);}.with_frm_style .frm_plain_success .frm_message {background-color: transparent;padding:0;border:none;font-size:inherit;color:inherit;}.with_frm_style .frm_plain_success .frm_message p {color:inherit;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-top:none;border-left:none;border-right:none;}.frm-alt-table {width:100%;border-collapse:separate;margin-top:0.5em;font-size:15px;border-width:1px;}.with_frm_style .frm-alt-table{border-color:#BFC3C8;border-color:var(--border-color);}.frm-alt-table th {width:200px;}.frm-alt-table tr {background-color:transparent;}.frm-alt-table th,.frm-alt-table td {background-color:transparent;vertical-align:top;text-align:left;padding:20px;border-color:transparent;}.frm-alt-table tr:nth-child(even) {background-color:#ecf0f5;}table.form_results.with_frm_style{border:1px solid #BFC3C8;border-width:var(--field-border-width);border-color:var(--border-color);}table.form_results.with_frm_style tr td{text-align:left;padding:7px 9px;color:#555555;color:var(--text-color);border-top:1px solid #BFC3C8;border-top-width:var(--field-border-width);border-top-color:var(--border-color);}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;background-color:var(--bg-color);}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_color_block {background-color:#ecf0f5;padding: 40px;}.with_frm_style .frm-show-form .frm_color_block.frm_section_heading h3,.frm_color_block.frm_section_heading h3 {border-width: 0 !important;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #BFC3C8 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #BFC3C8 50%, #BFC3C8 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar{background-color:#ffffff;background-color:var(--bg-color);box-shadow:0 -1px 0 rgba(0, 0, 0, 0.15) inset;float:left;height:100%;line-height:20px;text-align:center;transition:width 0.6s ease 0s;width:100%;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(../images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}select.frm_loading_lookup{background-image: url(../images/ajax_loader.gif) !important;background-position: 10px;background-repeat: no-repeat;color: transparent !important;}.frm_screen_reader {border: 0;clip: rect(1px, 1px, 1px, 1px);-webkit-clip-path: inset(50%);clip-path: inset(50%);height: 1px;margin: -1px;overflow: hidden;padding: 0;position: absolute;width: 1px;word-wrap: normal !important; }.frm_screen_reader.frm_hidden{display:initial;}.frm_verify{position:absolute;left:-3000px;}.frm_clear_none{clear:none;}.frm_clear{clear:both;}.frm_form_field.frm_alignright{float:right !important;}.with_frm_style .frm_form_field{clear:both;}.frm_combo_inputs_container,.frm_grid_container,.frm_form_fields .frm_section_heading,.frm_form_fields .frm_fields_container{display:grid;grid-template-columns: repeat(12, 6.5%);grid-auto-rows: max-content;grid-gap: 0 2%;}.frm_combo_inputs_container > *,.frm_grid_container > *,.frm_section_heading > *,.frm_fields_container .frm_form_field,.frm_fields_container > *{grid-column: span 12 / span 12;}.frm_inline,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;grid-column: span 2 / span 2;}.frm6,.frm_half,.frm_form_field.frm_three_fifths, .frm_form_field.frm6,.frm_submit.frm6,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{grid-column:span 6 / span 6;}.frm4,.frm_third,.frm_form_field.frm_two_fifths, .frm_form_field.frm4,.frm_submit.frm4,.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{grid-column:span 4 / span 4;}.frm8,.frm_two_thirds,.frm_form_field.frm8,.frm_submit.frm8,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{grid-column: span 8/span 8;}.frm3,.frm_fourth,.frm_form_field.frm3,.frm_submit.frm3,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{grid-column: span 3/span 3;}.frm9,.frm_three_fourths,.frm_form_field.frm_four_fifths, .frm_form_field.frm9,.frm_submit.frm9,.frm_form_field.frm_three_fourths{grid-column: span 9/span 9;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{grid-column: span 2/span 2;}.frm2,.frm_sixth,.frm_form_field.frm2,.frm_submit.frm2,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{grid-column: span 2/span 2;}.frm10,.frm_form_field.frm10,.frm_submit.frm10{grid-column: span 10/span 10;}.frm1,.frm_form_field.frm1,.frm_submit.frm1,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{grid-column: span 1/span 1;}.frm5,.frm_form_field.frm5,.frm_submit.frm5{grid-column: span 5/span 5;}.frm7,.frm_form_field.frm7,.frm_submit.frm7{grid-column: span 7/span 7;}.frm11,.frm_form_field.frm11,.frm_submit.frm11{grid-column: span 11/span 11;}.frm12,.frm_full,.frm_full .wp-editor-wrap,.frm_full > input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;grid-column: span 12/span 12;box-sizing: border-box;}.frm_full .wp-editor-wrap input{width:auto !important;}.frm_first,.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{grid-column-start:1;}.frm_last,.frm_form_field.frm_last,.frm_form_field.frm_alignright{grid-column-end:-1;grid-row-start: span 100;justify-content: end;}.with_frm_style.frm_rtl .frm_form_fields .star-rating{float:right;}.with_frm_style.frm_rtl .frm_grid .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_first .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_odd .frm_primary_label,.with_frm_style.frm_rtl .frm_grid .frm_radio,.with_frm_style.frm_rtl .frm_grid_first .frm_radio,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio,.with_frm_style.frm_rtl .frm_grid .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox{float:right !important;margin-right:0 !important;}.with_frm_style.frm_rtl .frm_grid_first .frm_radio label input,.with_frm_style.frm_rtl .frm_grid .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox label input{float:left;}.with_frm_style.frm_rtl .frm_catlevel_2,.with_frm_style.frm_rtl .frm_catlevel_3,.with_frm_style.frm_rtl .frm_catlevel_4,.with_frm_style.frm_rtl .frm_catlevel_5{margin-right:18px;}.with_frm_style.frm_rtl div > .frm_time_select{margin-right:5px;}.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display: grid;grid-template-columns: 25% auto;width:100%;grid-auto-rows: min-content;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_form_field.frm_inline_container{grid-template-columns: repeat(2, minmax(auto, max-content) );}.frm_form_field.frm_inline_container .frm_primary_label,.frm_form_field.frm_right_container .frm_primary_label,.frm_form_field.frm_left_container .frm_primary_label{margin-right:10px;grid-row:span 2/span 2;padding-top:4px;}.frm_form_field.frm_left_container .frm_primary_label{grid-column:1;grid-row:span 2/span 2; }.frm_form_field.frm_right_container .frm_primary_label{grid-column:2;grid-row:1;margin-right:0;margin-left:10px;}.frm_form_field.frm_inline_container .frm_description,.frm_form_field.frm_left_container .frm_description{grid-column:2;}.frm_form_field.frm_right_container .frm_description{grid-column:1;}.frm_conf_field.frm_left_container{grid-template-columns: 67%;}.frm_conf_field.frm_left_container .frm_description{grid-column:1;}.frm-fade-in {-webkit-animation-name: fadeIn;animation-name: fadeIn;-webkit-animation-duration: 1s;animation-duration: 1s;-webkit-animation-fill-mode: both;animation-fill-mode: both;}@keyframes spin {0% { transform: rotate(0deg); }100% { transform: rotate(360deg); }}@keyframes fadeIn {   0% {opacity: 0;}   100% {opacity: 1;}}@media only screen and (max-width: 750px) {.frm_grid_container.frm_no_grid_750{display:block;}}@media only screen and (max-width: 600px) {.frm_section_heading > .frm_form_field,.frm_fields_container > .frm_submit,.frm_grid_container > .frm_form_field,.frm_fields_container > .frm_form_field{grid-column: 1 / span 12 !important;}.frm_grid_container.frm_no_grid_600,.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display:block;}}.frm_conf_field.frm_left_container .frm_primary_label{display:none;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color:#BFC3C8;border-color:var(--border-color);border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:\" \";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd{background-color:#ffffff;background-color:var(--bg-color);}.frm_grid{background-color:#ffffff;background-color:var(--bg-color-active);}.with_frm_style .frm_grid.frm_blank_field,.with_frm_style .frm_grid_first.frm_blank_field,.with_frm_style .frm_grid_odd.frm_blank_field{background-color:#F2DEDE;background-color:var(--error-bg);border-color:#EBCCD1;border-color:var(--error-bg);}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{visibility:hidden;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 .frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 .frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 .frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 .frm_primary_label,.frm_grid_7 .frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 .frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 .frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 .frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 .frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 .frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_left_container .frm_opt_container{padding-top:4px;}.with_frm_style .frm_inline_container.frm_grid_first .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.frm_form_field.frm_two_col .frm_opt_container,.frm_form_field.frm_three_col .frm_opt_container,.frm_form_field.frm_four_col .frm_opt_container{display: grid;grid-template-columns: repeat(2, 1fr);grid-auto-rows: max-content;grid-gap: 0 2.5%;}.frm_form_field.frm_three_col .frm_opt_container{grid-template-columns: repeat(3, 1fr);}.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(4, 1fr);}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{grid-column-end: span 1;}.frm_form_field .frm_checkbox,.frm_form_field .frm_checkbox + .frm_checkbox,.frm_form_field .frm_radio,.frm_form_field .frm_radio + .frm_radio{margin-top: 0;margin-bottom: 0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_html_container.frm_scroll_box,.frm_form_field.frm_html_scroll_box{height:100px;overflow:auto;background-color:#ffffff;background-color:var(--bg-color);border-color:#BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;border-radius:var(--border-radius);width:100%;width:var(--field-width);max-width:100%;font-size:14px;font-size:var(--field-font-size);padding:6px 10px;padding:var(--field-pad);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;box-shadow:var(--box-shadow);}.frm_form_field.frm_total_big input,.frm_form_field.frm_total_big textarea,.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;-moz-box-shadow:none;-webkit-box-shadow:none;width:auto !important;height:auto !important;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total_big input::-webkit-outer-spin-button,.frm_form_field.frm_total_big input::-webkit-inner-spin-button,.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total_big input:focus,.frm_form_field.frm_total_big textarea:focus,.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;}.frm_form_field.frm_label_justify .frm_primary_label{text-align:justify !important;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:block;}@font-face {font-family: \'s11-fp\';src: url(\'../fonts/s11-fp.ttf?v=7\') format(\'truetype\'),url(\'../fonts/s11-fp.woff?v=7\') format(\'woff\'),url(\'../fonts/s11-fp.svg?v=7#s11-fp\') format(\'svg\');font-weight: normal;font-style: normal;}.frmfont,.frm_icon_font,.frm_dashicon_font{text-decoration:none;text-shadow: none;font-weight:normal;display:inline-block;-webkit-font-smoothing: antialiased;-moz-osx-font-smoothing: grayscale;text-rendering: auto;line-height: 1;-moz-transition: color .1s ease-in-out, opacity .1s ease-in-out;-webkit-transition: color .1s ease-in-out, opacity .1s ease-in-out;transition: color .1s ease-in-out, opacity .1s ease-in-out;font-size: 18px;}i.frmfont,i.frm_icon_font{font-style:normal;font-variant: normal;speak: none;}.frmfont:before,select.frmfont,.frm_icon_font:before,select.frm_icon_font{font-family: \'s11-fp\' !important;text-align:center;}.frmfont,a.frmfont,.frmfont:hover,a.frmfont:hover.frm_icon_font,a.frm_icon_font,.frm_icon_font:hover,a.frm_icon_font:hover{text-decoration:none !important;box-shadow:none;}.frmfont:focus,.frm_icon_font:focus,.frm_dashicon_font:focus{box-shadow:none;-webkit-box-shadow:none;}.frmfont:active,.frm_icon_font:active{outline:none;}.frm_trigger .frm_icon_font{padding:0 5px;}.frm_logo_icon:before {content: \"\\e601\";}.frm_required_icon:before {content: \"\\e612\";}.frm_delete_icon:before {content: \"\\e610\" !important;}.frm_delete_solid_icon:before {content: \"\\e900\";}.frm_move_icon:before {content: \"\\e61a\";}.frm_drag_icon:before {content: \"\\e93b\";}.frm_clear_icon:before {content: \"\\e60a\";}.frm_noclear_icon:before {content: \"\\e60b\";}.frm_duplicate_icon:before {content: \"\\e61b\";}.frm_copy_icon:before {content: \"\\f0c5\";}.frm_clone_solid_icon:before {content: \"\\f24e\";}.frm_clone_icon:before {content: \"\\f24d\";}.frm_tooltip_icon:before {content: \"\\e611\";}.frm_tooltip_solid_icon:before {content: \"\\e907\";}.frm_forbid_icon:before {content: \"\\e636\";}.frm_checkmark_icon:before {content: \"\\e90a\";}.frm_check_icon:before {content: \"\\e605\";}.frm_check1_icon:before {content: \"\\e606\";}.frm_plus_icon:before {content: \"\\e62f\";}.frm_plus1_icon:before {content: \"\\e602\";}.frm_plus2_icon:before {content: \"\\e603\";}.frm_plus3_icon:before {content: \"\\e632\";}.frm_plus4_icon:before {content: \"\\e60f\";}.frm_minus_icon:before {content: \"\\e62e\";}.frm_minus1_icon:before {content: \"\\e600\";}.frm_minus2_icon:before {content: \"\\e604\";}.frm_minus3_icon:before {content: \"\\e633\";}.frm_minus4_icon:before {content: \"\\e613\";}.frm_cancel_icon:before {content: \"\\e607\";}.frm_cancel1_icon:before {content: \"\\e608\";}.frm_close_icon:before {content: \"\\e928\";}.frm_report_problem_solid_icon:before {content: \"\\e914\";}.frm_report_problem_icon:before {content: \"\\e915\";}.frm_arrowup_icon:before {content: \"\\e60d\";}.frm_arrowup1_icon:before {content: \"\\e60e\";}.frm_arrowup2_icon:before {content: \"\\e630\";}.frm_arrowup3_icon:before {content: \"\\e62b\";}.frm_arrowup4_icon:before {content: \"\\e62c\";}.frm_arrowup5_icon:before {content: \"\\e635\";}.frm_arrowup5_solid_icon:before {content: \"\\e9d\";}.frm_arrowup7_icon:before {content: \"\\e908\";}.frm_arrowup6_icon:before {content: \"\\e62d\";}.frm_arrowdown_icon:before {content: \"\\e609\";}.frm_arrowdown1_icon:before {content: \"\\e60c\";}.frm_arrowdown2_icon:before {content: \"\\e631\";}.frm_arrowdown3_icon:before {content: \"\\e628\";}.frm_arrowdown4_icon:before {content: \"\\e629\";}.frm_arrowdown5_icon:before {content: \"\\e634\";}.frm_arrowdown5_solid_icon:before {content: \"\\e905\";}.frm_arrowdown7_icon:before {content: \"\\e90b\";}.frm_arrowdown6_icon:before {content: \"\\e62a\";}.frm_arrow_left_icon:before {content: \"\\e912\";}.frm_arrow_right_icon:before {content: \"\\e913\";}.frm_filter_icon:before {content: \"\\e90c\";}.frm_download_icon:before {content: \"\\e615\";}.frm_upload2_icon:before {content: \"\\f093\";}.frm_upload_icon:before {content: \"\\e616\";}.frm_download2_icon:before {content: \"\\f019\";}.frm_hard_drive_icon:before {content: \"\\e916\";}.frm_pencil_solid_icon:before {content: \"\\e901\";}.frm_pencil_icon:before {content: \"\\e61d\";}.frm_signature_icon:before {content: \"\\e919\";}.frm_user_icon:before {content: \"\\e7ff\";}.frm_register_icon:before {content: \"\\e637\";}.frm_account_circle_solid_icon:before {content: \"\\e853\";}.frm_account_circle_icon:before {content: \"\\e921\";}.frm_address_card_icon:before {content: \"\\e996\";}.frm_paragraph_icon:before {content: \"\\f1dd\";}.frm_checkbox_unchecked_icon:before {content: \"\\e91e\";}.frm_checkbox_icon:before {content: \"\\e922\";}.frm_checkbox_solid_icon:before {content: \"\\e91f\";}.frm_dropdown_icon:before {content: \"\\e909\";}.frm_caret_square_down_icon:before {content: \"\\f150\";}.frm_check_square_icon:before {content: \"\\f14a\";}.frm_radio_unchecked_icon:before {content: \"\\e971\";}.frm_radio_checked_icon:before {content: \"\\ea54\";}.frm_scrubber_icon:before {content: \"\\f2f8\";}.frm_location_solid_icon:before {content: \"\\e955\";}.frm_location_icon:before {content: \"\\e947\";}.frm_toggle_on_icon:before {content: \"\\f205\";}.frm_toggle_off_icon:before {content: \"\\f204\";}.frm_shield_check_icon:before {content: \"\\f2f7\";}.frm_shield_check_solid_icon:before {content: \"\\e97d\";}.frm_clock_icon:before {content: \"\\e929\";}.frm_clock_solid_icon:before {content: \"\\e985\";}.frm_link_icon:before {content: \"\\f0c1\";}.frm_email_icon:before {content: \"\\e626\";}.frm_email_solid_icon:before {content: \"\\f0e0\";}.frm_mail_bulk_icon:before {content: \"\\e95c\";}.frm_phone_icon:before {content: \"\\e942\";}.frm_calendar_icon:before {content: \"\\f073\";}.frm_code_icon:before {content: \"\\e90d\";}.frm_tag_icon:before {content: \"\\e98b\";}.frm_tag_solid_icon:before {content: \"\\e989\";}.frm_price_tags_icon:before {content: \"\\e936\";}.frm_search_icon:before {content: \"\\e978\";}.frm_sitemap_icon:before {content: \"\\f0e8\";}.frm_file_icon:before {content: \"\\f15b\";}.frm_file_text_solid_icon:before {content: \"\\f15c\";}.frm_file_text_icon:before {content: \"\\e923\";}.frm-option-icon:before, .frm_option_icon:before {content: \"\\e904\";}.frm_option_solid_icon:before {content: \"\\e906\";}.frm_more_horiz_icon:before {content: \"\\e5d3\";}.frm_more_vert_icon:before {content: \"\\e5d4\";}.frm_more_horiz_solid_icon {font-size: 28px !important;font-weight: bold;line-height: 18px;}.frm_more_horiz_solid_icon:before {content: \"\\00B7\\00B7\\00B7\";}.frm_more_vert_solid_icon:before {content: \"\\f142\";}.frm_calculator_icon:before {content: \"\\f1ec\";}.frm_key_icon:before {content: \"\\f084\";}.frm_keyalt_solid_icon:before {content: \"\\e986\";}.frm_keyalt_icon:before {content: \"\\e987\";}.frm_keyboard_icon:before {content: \"\\e924\";}.frm_eye_icon:before {content: \"\\f06e\";}.frm_eye_solid_icon:before {content: \"\\e945\";}.frm_eye_slash_icon:before {content: \"\\f070\";}.frm_eye_slash_solid_icon:before {content: \"\\e949\";}.frm_page_break_icon:before {content: \"\\e8e9\";}.frm_view_day_icon:before {content: \"\\e8ed\";}.frm_attach_file_icon:before {content: \"\\e226\";}.frm_printer_icon:before {content: \"\\e926\";}.frm_header_icon:before {content: \"\\f1dc\";}.frm_h1_icon:before {content: \"\\e94c\";}.frm_repeat_icon:before {content: \"\\f363\";}.frm_repeater_icon:before {content: \"\\e974\";}.frm_hashtag_icon:before {content: \"\\e292\";}.frm_save_icon:before {content: \"\\e927\";}.frm_sliders_icon:before {content: \"\\f1de\";}.frm_code_commit_icon:before {content: \"\\f386\";}.frm_star_icon:before {content: \"\\e9d7\";}.frm_star_full_icon:before {content: \"\\e9d9\";}.frm_star_half_icon:before {content: \"\\e9d8\";}.frm_linear_scale_icon:before {content: \"\\e260\";}.frm_pie_chart_icon:before {content: \"\\e99a\";}.frm_stats_bars_icon:before {content: \"\\e99c\";}.frm_sms_icon:before {content: \"\\e61c\";}.frm_highrise_icon:before {content: \"\\e617\";}.frm_mailchimp_icon:before {content: \"\\e622\";}.frm_feed_icon:before {content: \"\\e624\";}.frm_align_right_icon:before {content: \"\\e90f\";}.frm_align_left_icon:before {content: \"\\e910\";}.frm_button_icon:before {content: \"\\e911\";}.frm_browser_icon:before {content: \"\\e925\";}.frm_cloud_download_solid_icon:before {content: \"\\e92a\";}.frm_cloud_download_icon:before {content: \"\\e92b\";}.frm_cloud_upload_solid_icon:before {content: \"\\e92c\";}.frm_cloud_upload_icon:before {content: \"\\e92d\";}.frm_cloud_solid_icon:before {content: \"\\e92e\";}.frm_cloud_icon:before {content: \"\\e92f\";}.frm_shuffle_icon:before {content: \"\\e917\";}.frm_swap_icon:before {content: \"\\e918\";}.frm_dropper_solid_icon:before {content: \"\\e93c\";}.frm_tint_icon:before {content: \"\\e93e\";}.frm_pallet_solid_icon:before {content: \"\\e96c\";}.frm_pallet_icon:before {content: \"\\e96d\";}.frm_fingerprint_icon:before {content: \"\\e94a\";}.frm_ghost_icon:before {content: \"\\e94b\";}.frm_heart_solid_icon:before {content: \"\\e94d\";}.frm_heart_icon:before {content: \"\\e94e\";}.frm_history_icon:before {content: \"\\e94f\";}.frm_import_icon:before {content: \"\\e91a\";}.frm_export_icon:before {content: \"\\e91b\";}.frm_label_solid_icon:before {content: \"\\e952\";}.frm_label_icon:before {content: \"\\e953\";}.frm_lock_open_icon:before {content: \"\\e957\";}.frm_lock_solid_icon:before {content: \"\\e958\";}.frm_lock_icon:before {content: \"\\e959\";}.frm_magic_wand_icon:before {content: \"\\e997\";}.frm_dollar_sign_icon:before {content: \"\\e91c\";}.frm_percent_icon:before {content: \"\\e939\";}.frm_notification_solid_icon:before {content: \"\\e964\";}.frm_notification_icon:before {content: \"\\e965\";}.frm_external_link_icon:before {content: \"\\e966\";}.frm_pageview_solid_icon:before {content: \"\\e96a\";}.frm_pageview_icon:before {content: \"\\e96b\";}.frm_settings_solid_icon:before {content: \"\\e979\";}.frm_settings_icon:before {content: \"\\e97a\";}.frm_stamp_icon:before {content: \"\\e980\";}.frm_support_icon:before {content: \"\\f1cd\";}.frm_text_solid_icon:before {content: \"\\e98c\";}.frm_text_icon:before {content: \"\\e98d\";}.frm_text2_icon:before {content: \"\\f031\";}.frm_text3_icon:before {content: \"\\e98e\";}.frm_unfold_less_icon:before {content: \"\\e993\";}.frm_unfold_more_icon:before {content: \"\\e994\";}.frm_work_solid_icon:before {content: \"\\e999\";}.frm_work_icon:before {content: \"\\e99e\";}.frm_white_label_icon:before {content: \"\\e91d\" !important;}.frm_zoom_out_icon:before {content: \"\\e99f\";}.frm_maximize_icon:before {content: \"\\e920\";}.frm_minimize_icon:before {content: \"\\e93a\";}.frm_authorize_icon:before {content: \"\\e903\";}.frm_icon_font.frm_activecampaign_icon {background-image: none;}.frm_activecampaign_icon:before {content: \"\\e930\";}.frm_aweber_icon:before {content: \"\\e627\";}.frm_campaignmonitor_icon:before {content: \"\\e946\";}.frm_constant_contact_icon:before {content: \"\\e931\";}.frm_getresponse_icon:before {content: \"\\e932\";}.frm_googlesheets_icon:before {content: \"\\e944\";}.frm_building_icon:before {content: \"\\e93f\";}.frm_hubspot_icon:before {content: \"\\e933\";}.frm_icontact_icon:before {content: \"\\e940\";}.frm_icon_font.frm_mailpoet_icon:before {content: \"\\e934\";}.frm_paypal_icon:before {content: \"\\e61f\";}.frm_sendinblue_icon:before {content: \"\\e943\";}.frm_sendy_icon:before {content: \"\\e941\";}.frm_salesforce_icon:before {content: \"\\e935\";}.frm_salesforcealt_icon:before {content: \"\\e937\";}.frm_stripe_icon:before {content: \"\\e902\";}.frm_stripealt_icon:before {content: \"\\e93d\";}.frm_twilio_icon:before {content: \"\\e620\";}.frm_woocommerce_icon:before {content: \"\\e90e\";}.frm_wordpress_icon:before {content: \"\\f19a\";}.frm_credit_card_icon:before {content: \"\\e938\";}.frm_credit-card-alt_icon:before, .frm_credit_card_alt_icon:before {content: \"\\f283\";}.frm_cc_amex_icon:before {content: \"\\f1f3\";}.frm_cc_discover_icon:before {content: \"\\f1f2\";}.frm_cc_mastercard_icon:before {content: \"\\f1f1\";}.frm_cc_visa_icon:before {content: \"\\f1f0\";}.frm_cc_paypal_icon:before {content: \"\\f1f4\";}.frm_cc_stripe_icon:before {content: \"\\f1f5\";}.with_frm_style, .frm_forms {--progress-border-color-b: #dbdbdb;--image-size:150px;}.js .frm_logic_form:not(.frm_no_hide) {display:none;}.with_frm_style .frm_conf_field.frm_half label.frm_conf_label {overflow: hidden;white-space: nowrap;}.with_frm_style .frm_time_wrap{white-space:nowrap;}.with_frm_style select.frm_time_select{white-space:pre;display:inline;}.with_frm_style .frm-show-form  .frm_section_heading h3{padding:15px 0 3px 0;margin:0;font-size:18px;font-size:var(--section-font-size);font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-family:var(--font);font-weight:bold;font-weight:var(--section-weight);color:#444444;color:var(--section-color);border:none;background-color:transparent;background-color:var(--section-bg-color);}.with_frm_style .frm_repeat_sec{margin-bottom:20px;margin-bottom:var(--field-margin);margin-top:20px;margin-top:var(--field-margin);padding-bottom:15px;border-bottom:2px solid #e8e8e8;border-bottom-width:var(--section-border-width);border-bottom-style:var(--section-border-style);border-color:var(--section-border-color);}.with_frm_style .frm_repeat_sec:last-child{border-bottom:none;padding-bottom:0;}.with_frm_style .frm_repeat_inline{clear:both;}.frm_invisible_section .frm_form_field,.frm_invisible_section{display:none !important;visibility:hidden !important;height:0;margin:0;}.frm_form_field .frm_repeat_sec .frm_add_form_row,.frm_section_heading div.frm_repeat_sec:last-child .frm_add_form_row.frm_hide_add_button,.frm_form_field div.frm_repeat_grid .frm_add_form_row.frm_hide_add_button,.frm_form_field div.frm_repeat_inline .frm_add_form_row.frm_hide_add_button {-moz-transition: opacity .15s ease-in-out;-webkit-transition: opacity .15s ease-in-out;transition: opacity .15s ease-in-out;pointer-events: none;}.frm_form_field .frm_repeat_sec .frm_add_form_row,.frm_section_heading div.frm_repeat_sec:last-child .frm_add_form_row.frm_hide_add_button {display: none;}.frm_form_field div.frm_repeat_grid .frm_add_form_row.frm_hide_add_button,.frm_form_field div.frm_repeat_inline .frm_add_form_row.frm_hide_add_button {visibility: hidden;}.frm_form_field div.frm_repeat_grid .frm_add_form_row,.frm_form_field div.frm_repeat_inline .frm_add_form_row,.frm_section_heading div.frm_repeat_sec:last-child .frm_add_form_row {display: inline-block;visibility: visible;pointer-events: auto;}.frm_add_form_row.frm_button.frm_hidden:last-child, .frm_add_form_row.frm_icon_font.frm_hidden:last-child {display: inline-block;}.frm_form_fields .frm_section_heading.frm_hidden {display: none;}.frm_repeat_inline .frm_repeat_buttons a.frm_icon_font{vertical-align: sub;}.frm_repeat_inline .frm_repeat_buttons a.frm_icon_font:before{vertical-align: text-top;}.frm_repeat_grid .frm_button,.frm_repeat_inline .frm_button,.frm_repeat_sec .frm_button{display: inline-block;line-height:1;}.with_frm_style .frm_button .frm_icon_font:before{font-size:15px;font-size:var(--submit-font-size);}.frm_repeat_sec .frm_button .frm_icon_font:before,.frm_repeat_grid .frm_button .frm_icon_font:before,.frm_repeat_inline .frm_button .frm_icon_font:before{line-height:1;}.frm_form_field .frm_repeat_grid ~ .frm_repeat_grid .frm_form_field .frm_primary_label{display:none !important;}.with_frm_style .frm_input_group {position: relative;display: -ms-flexbox;display: flex;-ms-flex-wrap: wrap;flex-wrap: wrap;-ms-flex-align: stretch;align-items: stretch;width: 100%;}.with_frm_style .frm_input_group.frm_hidden {display: none;}.with_frm_style .frm_inline_box {display: -ms-flexbox;display: flex;text-align: center;align-items: center;font-size: 90%;padding: 0 10px;color:#3f4b5b;color:var(--progress-color);border:1px solid #BFC3C8;border-color:var(--border-color);border-width:var(--field-border-width);border-style:var(--field-border-style);background-color: #eaeaea;background-color:var(--progress-bg-color);-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;border-radius:var(--border-radius);width: auto;}.with_frm_style .frm_input_group .frm_inline_box:first-child {margin-right: -1px;border-top-right-radius: 0 !important;border-bottom-right-radius: 0 !important;}.with_frm_style .frm_input_group .chosen-container + .frm_inline_box,.with_frm_style .frm_input_group select + .frm_inline_box,.with_frm_style .frm_input_group input + .frm_inline_box {margin-left: -1px;border-top-left-radius: 0 !important;border-bottom-left-radius: 0 !important;}.with_frm_style .frm_input_group .chosen-container,.with_frm_style .frm_input_group > select,.with_frm_style .frm_input_group > input {position: relative;-ms-flex: 1 1 auto;flex: 1 1 auto;width: 1% !important;min-width: 0;margin-bottom: 0;display: block;}.with_frm_style .frm_input_group.frm_with_pre .chosen-container-multi .chosen-choices,.with_frm_style .frm_input_group.frm_with_pre .chosen-single,.with_frm_style .frm_input_group.frm_with_pre > select,.with_frm_style .frm_input_group.frm_with_pre > input {border-top-left-radius: 0 !important;border-bottom-left-radius: 0 !important;}.with_frm_style .frm_input_group.frm_with_post .chosen-container-multi .chosen-choices,.with_frm_style .frm_input_group.frm_with_post .chosen-single,.with_frm_style .frm_input_group.frm_with_post > select,.with_frm_style .frm_input_group.frm_with_post > input {border-top-right-radius: 0 !important;border-bottom-right-radius: 0 !important;}.with_frm_style .frm_total input,.with_frm_style .frm_total_big input {background-color:transparent;border:none;width:auto;box-shadow: none !important;}.with_frm_style .frm_total .frm_inline_box,.with_frm_style .frm_total_big .frm_inline_box {background-color:transparent !important;border-width: 0 !important;box-shadow:none !important;color:var(--text-color);padding:0 3px 0 1px !important;}.with_frm_style .frm_inline_total {padding:0 3px;}#ui-datepicker-div{display:none;z-index:999999 !important;}.ui-datepicker .ui-datepicker-title select.ui-datepicker-month,.ui-datepicker .ui-datepicker-title select.ui-datepicker-year {width: 33% ;background-color:#fff;float:none;}.ui-datepicker select.ui-datepicker-month{margin-right: 3px;}.ui-datepicker-month, .ui-datepicker-year{max-width:100%;max-height:2em;padding:6px 10px;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;}.ui-datepicker .ui-widget-header,.ui-datepicker .ui-datepicker-header {background: #579AF6 !important;color: #ffffff !important;}.ui-datepicker td.ui-datepicker-today{background: rgba(37,104,196,0.15) !important;}.ui-datepicker td.ui-datepicker-current-day,.ui-datepicker td .ui-state-hover,.ui-datepicker thead {background: #2568c4 !important;color: #ffffff !important;}.ui-datepicker td.ui-datepicker-current-day .ui-state-default{color: #ffffff !important;}.google-visualization-tooltip-item-list,.google-visualization-tooltip-item-list .google-visualization-tooltip-item:first-child {margin: 1em 0 !important;}.google-visualization-tooltip-item {list-style-type: none !important;margin: 0.65em 0 !important;}.with_frm_style .frm_scale{margin-right:15px;text-align:center;float:left;}.with_frm_style .frm_scale input{display:block;margin:0;}.frm-star-group input {opacity: 0;position: absolute;z-index: -1;}.frm-star-group .star-rating,.frm-star-group input + label {float:left;width:25px;height:25px;font-size:25px;line-height:1;cursor:pointer;display:block;background:transparent;overflow:hidden !important;clear:none;font-style:normal;margin-right:5px;}.frm-star-group input + label:before,.frm-star-group .star-rating:before{font-family:\'s11-fp\';content:\'\\e9d7\';color:#F0AD4E;display: inline-block;vertical-align: top;}.frm-star-group input[type=radio]:checked + label:before,.frm-star-group:not(.frm-star-hovered) input[type=radio]:checked + label:before{color:#F0AD4E;}.frm-star-group:not(.frm-star-hovered) input[type=radio]:checked + label:before,.frm-star-group input + label:hover:before,.frm-star-group:hover input + label:hover:before,.frm-star-group .star-rating-on:before,.frm-star-group .star-rating-hover:before{content:\'\\e9d9\';color:#F0AD4E;}.frm-star-group .frm_half_star:before{content:\'\\e9d8\';}.frm-star-group .star-rating-readonly{cursor:default !important;}.with_frm_style .frm_other_input.frm_other_full{margin-top:10px;}.frm_left_container .frm_other_input{grid-column:2;}.frm_inline_container.frm_other_container .frm_other_input,.frm_left_container.frm_other_container .frm_other_input{margin-left:5px;}.frm_right_container.frm_other_container .frm_other_input{margin-right:5px;}.frm_inline_container.frm_other_container select ~ .frm_other_input,.frm_right_container.frm_other_container select ~ .frm_other_input,.frm_left_container.frm_other_container select ~ .frm_other_input{margin:0;}.with_frm_style input[type=file]::-webkit-file-upload-button{color:#555555;color:var(--text-color);background-color:#ffffff;background-color:var(--bg_color);padding:6px 10px;padding:var(--field-pad);border-radius:4px;border-radius:var(--border-radius);border-color: #BFC3C8;border-color:var(--border-color);border-width:1px;border-width:var(--field-border-width);border-style:solid;border-style:var(--field-border-style);}.frm_pagination_cont ul.frm_pagination{display:inline-block;list-style:none;margin-left:0 !important;}.frm_pagination_cont ul.frm_pagination > li{display:inline;list-style:none;margin:2px;background-image:none;}ul.frm_pagination > li.active a{text-decoration:none;}.frm_pagination_cont ul.frm_pagination > li:first-child{margin-left:0;}.archive-pagination.frm_pagination_cont ul.frm_pagination > li{margin:0;}.frmcal{padding-top:30px;}.frmcal-title{font-size:116%;}.frmcal table.frmcal-calendar{border-collapse:collapse;margin-top:20px;color:#555555;}.frmcal table.frmcal-calendar,.frmcal table.frmcal-calendar tbody tr td{border:1px solid #BFC3C8;}.frmcal table.frmcal-calendar,.frmcal,.frmcal-header{width:100%;}.frmcal-header{text-align:center;}.frmcal-prev{margin-right:10px;}.frmcal-prev,.frmcal-dropdown{float:left;}.frmcal-dropdown{margin-left:5px;}.frmcal-next{float:right;}.frmcal table.frmcal-calendar thead tr th{text-align:center;padding:2px 4px;}.frmcal table.frmcal-calendar tbody tr td{height:110px;width:14.28%;vertical-align:top;padding:0 !important;color:#555555;font-size:12px;}table.frmcal-calendar .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #BFC3C8;-webkit-box-shadow:0 2px 5px #BFC3C8;box-shadow:0 2px 5px #BFC3C8;}table.frmcal-calendar .frmcal-today .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #66afe9;-webkit-box-shadow:0 2px 5px #66afe9;box-shadow:0 2px 5px #66afe9;}.frmcal_day_name,.frmcal_num{display:inline;}.frmcal-content{padding:2px 4px;}.frm_switch_opt {padding:0 8px 0 0;white-space:normal;display:inline;vertical-align: middle;font-size:15px;font-size:var(--toggle-font-size);font-weight:normal;font-weight:var(--check-weight);}.frm_on_label{padding:0 0 0 8px;}.frm_on_label,.frm_off_label{color:#444444;color:var(--check-label-color);}.frm_switch {position: relative;display: inline-block;width: 40px;height: 25px;vertical-align: middle;}.frm_switch_block input {display:none !important;}.frm_slider {position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color:#eaeaea;background-color:var(--toggle-off-color);transition: .4s;border-radius: 30px;}.frm_slider:before {border-radius: 50%;position: absolute;content: \"\";height: 23px;width: 23px;left: 1px;bottom: 1px;background-color: white;transition: .4s;box-shadow:0 2px 6px rgba(41, 58, 82, 0.31);}input:checked + .frm_switch .frm_slider {background-color:#579AF6;background-color:var(--toggle-on-color);}input:focus + .frm_switch .frm_slider {box-shadow: 0 0 1px #3177c7;}input:checked + .frm_switch .frm_slider:before {transform: translateX(15px);}.frm_rtl .frm_switch_opt {padding: 0 8px;}.frm_rtl .frm_slider:before {left: 16px;}.frm_rtl input:checked + .frm_switch .frm_slider:before {transform: none!important;left: 1px;}.with_frm_style .frm_range_unit,.with_frm_style .frm_range_value{display:inline-block;padding-left: 2px;padding-right: 2px;}.with_frm_style .frm_range_value + .frm_range_unit,.with_frm_style .frm_range_container > .frm_range_unit,.with_frm_style .frm_range_value{font-size:24px;font-size:var(--slider-font-size);color:#555555;color:var(--text-color);}.with_frm_style .frm_range_container {padding-top: 5px;}.with_frm_style input[type=range] {-webkit-appearance: none;box-shadow:none !important;border:none !important;cursor: pointer;padding:0 ;background:transparent !important;display: block;width: 100%;margin: 15px 0 8px;font-size:14px;height:auto;}.with_frm_style input[type=range]:active,.with_frm_style input[type=range]:focus {outline: none;box-shadow:none !important;background:transparent !important;padding:0 ;}.with_frm_style .frm_range_max {float: right;}.with_frm_style .frm_range_container input + .frm_range_value {text-align: center;display: block;}.with_frm_style input[type=range]::-webkit-slider-runnable-track {-webkit-appearance: none;border-radius: 4px;border-radius:var(--border-radius);border: none;height: 5px;background-color: #579AF6;background-color:var(--slider-bar-color);}.with_frm_style input[type=range]::-moz-range-track {border-radius: 4px;border-radius:var(--border-radius);border: none;height: 5px;background-color: #579AF6;background-color:var(--slider-bar-color);border-color: transparent;border-width: 39px 0;color: transparent;background-color:var(--toggle-off-color);}.with_frm_style input[type=range]::-moz-range-progress {border-radius: 4px;border-radius:var(--border-radius);border: none;height: 5px;background-color: #579AF6;background-color:var(--slider-bar-color);background-color: #3177c7;}.with_frm_style input[type=range]::-ms-fill-lower {border-radius: 4px;border-radius:var(--border-radius);border: none;height: 5px;background-color: #579AF6;background-color:var(--slider-bar-color);background-color:var(--toggle-off-color);}.with_frm_style input[type=range]::-ms-fill-upper {border-radius: 4px;border-radius:var(--border-radius);border: none;height: 5px;background-color: #579AF6;background-color:var(--slider-bar-color);}.with_frm_style input[type=range]::-webkit-slider-thumb {-webkit-appearance: none;-webkit-border-radius: 20px;height: 24px;width: 24px;border-radius: 24px;border: 1px solid #3177c7;color:#ffffff;background: #fff;cursor: pointer;margin-top: -10px;box-shadow:0 2px 6px rgba(41, 58, 82, 0.31);}.with_frm_style input[type=range]::-moz-range-thumb {height: 24px;width: 24px;border-radius: 24px;border: 1px solid #3177c7;color:#ffffff;background: #fff;cursor: pointer;-moz-border-radius: 20px;}.with_frm_style input[type=range]::-ms-thumb {height: 24px;width: 24px;border-radius: 24px;border: 1px solid #3177c7;color:#ffffff;background: #fff;cursor: pointer;}.with_frm_style input[type=range]::-moz-focus-outer {border: 0;}.with_frm_style .frm_dropzone{border-color: #BFC3C8;border-color: var(--border-color) ;border-radius:4px;border-radius: var(--border-radius) ;color: #555555;color: var(--text-color) ;background-color:#ffffff;background-color:var(--bg-color) ;}.with_frm_style .frm_dropzone .frm_upload_icon:before,.with_frm_style .frm_dropzone .dz-remove{color: #555555;color: var(--text-color) ;}.with_frm_style .frm_compact .frm_dropzone .frm_upload_icon:before {color: #ffffff;color: var(--submit-text-color) ;}.with_frm_style .frm_blank_field .frm_dropzone{border-color:#B94A48;border-color:var(--border-color-error) ;color:#444444;color:var(--text-color-error) ;background-color:#ffffff;background-color:var(--bg-color-error) ;}.with_frm_style .frm_dropzone .dz-preview .dz-progress {background: #eaeaea;background: var(--progress-bg-color) ;}.with_frm_style .frm_dropzone .dz-preview .dz-progress .dz-upload,.with_frm_style .frm_dropzone .dz-preview.dz-complete .dz-progress {background: #579AF6;background: var(--progress-active-bg-color) ;}.frm_image_size_medium {--image-size:250px;}.frm_image_size_large {--image-size:320px;}.frm_image_size_xlarge {--image-size:400px;}.frm_image_options .frm_opt_container {display: inline-flex;flex-flow: wrap;flex-direction:row;margin: 0 -10px;}.frm_image_options .frm_radio input[type=radio],.frm_image_options .frm_checkbox input[type=checkbox]{opacity: 0;position: absolute;z-index: -1;}.frm_image_options .frm_image_option_container {border: 1px solid #BFC3C8;border-color: var(--border-color);border-width: var(--field-border-width);border-radius: 3px;border-radius: var(--border-radius);display: flex;flex-wrap: wrap;box-sizing: border-box;-moz-box-sizing: border-box;position: relative;height: 100%;}.frm_image_options .frm_image_option_container.frm_label_with_image .frm_empty_url,.frm_image_options .frm_image_option_container.frm_label_with_image img {border-bottom-left-radius:0;border-bottom-right-radius:0;}.frm_show_images.frm_image_option_container {display: inline-flex;flex-wrap: nowrap;flex-direction: column;text-align: center;align-items: center;width: 150px;margin-right: 10px;margin-bottom: 10px;}.frm-summary-page-wrapper .frm_image_option_container img{width: 100%;height: 150px;object-fit: cover;}.frm_image_option_container .frm_selected_checkmark{position: absolute;z-index: 99;left: -10px;top: -12px;display: none;}.frm_image_option_container .frm_image_placeholder_icon {position: absolute;}.frm_image_option_container .frm_selected_checkmark svg{fill: #66afe9;fill:var(--border-color-active);width: 24px;height: 24px;}.frm_image_option_container .frm_image_placeholder_icon svg{width: 63px;opacity: .2;}.frm_text_label_for_image {text-align: center;width: 100%;padding: 10px;word-break: keep-all;}.frm_image_options .frm_image_option_container:hover,input[type=\"radio\"]:checked + .frm_image_option_container,input[type=\"checkbox\"]:checked + .frm_image_option_container {border-color: #66afe9;border-color: var(--border-color-active);box-shadow: 0 0 0 1px #66afe9;box-shadow: 0 0 0 1px var(--border-color-active);}input[type=\"radio\"]:disabled + .frm_image_option_container,input[type=\"checkbox\"]:disabled + .frm_image_option_container{opacity: .7;border-color:var(--border-color-disabled);}input[type=\"radio\"]:checked + .frm_image_option_container .frm_selected_checkmark,input[type=\"checkbox\"]:checked + .frm_image_option_container .frm_selected_checkmark {display: block;}.frm_blank_field.frm_image_options .frm_image_option_container {border-color: var(--border-color-error);}.frm_image_options .frm_image_option_container .frm_empty_url,.frm_image_options .frm_image_option_container img {width: 100%;height: 150px;height: var(--image-size);object-fit: cover;border-radius:var(--border-radius);}.frm_image_option_container .frm_empty_url {background:#ecf0f5;display:flex;justify-content: center;align-items: center;}.horizontal_radio .frm_checkbox.frm_image_option,.horizontal_radio .frm_radio.frm_image_option {padding-left: 0;}.frm_checkbox.frm_image_option,.frm_radio.frm_image_option {width:var(--image-size) !important; }.frm_form_field .frm_checkbox.frm_image_option,.frm_form_field .frm_checkbox.frm_image_option + .frm_checkbox,.frm_form_field .frm_radio.frm_image_option,.frm_form_field .frm_radio.frm_image_option + .frm_radio {margin:10px; }.frm_checkbox.frm_image_option label,.frm_radio.frm_image_option label{padding-left: 0;margin-left: 0;min-height: 0;visibility: visible; }@media screen and (max-width: 768px) {.frm-pass-req, .frm-pass-verified {width: 50% !important;white-space: nowrap;}}.frm-pass-req, .frm-pass-verified {float: left;width: 20%;line-height: 20px;font-size: 12px;padding-top: 4px;min-width: 175px;}.frm-pass-req:before, .frm-pass-verified:before {padding-right: 4px;font-size: 12px !important;vertical-align: middle !important;}span.frm-pass-verified::before {content: \'\\e606\';}span.frm-pass-req::before {content: \'\\e608\';}div.frm-password-strength {width: 100%;float: left;}div.frm_repeat_grid:after, div.frm_repeat_inline:after, div.frm_repeat_sec:after {content: \'\';display: table;clear: both;}.with_frm_style .frm-summary-page-wrapper {padding: 50px;margin: 25px 0 50px;border: 1px solid #BFC3C8;border-color: var(--border-color);border-radius: 4px;border-radius: var(--border-radius);}.with_frm_style .frm-summary-page-wrapper .frm-edit-page-btn {float: right;margin: 0;padding: 3px 10px;font-size: 13px;}.frm-summary-page-wrapper .frm-line-table th {width: 40%;}button .frm-icon {display: inline-block;color: inherit;width: 12px;height: 12px;fill: currentColor;}.frm-line-table {width: 100%;border-collapse: collapse;margin-top: 0.5em;font-size: 15px;}.frm-line-table tr {background-color: transparent;border-bottom: 1px solid rgba(191,195,200,0.6);}.frm-line-table td,.frm-line-table th {border: 0;padding: 20px 15px;background-color: transparent;vertical-align: top;color: #3f4b5b;}.frm-line-table th {opacity: .7;font-size: 1.1em;font-weight: 500;}.frm-line-table h3 {font-size: 21px;font-weight: 500;margin: 0;}.frm_form_field .frm_total_formatted {display: inline-block;margin: 5px 0 0;}.frm_form_field.frm_total_big .frm_total_formatted {margin: 0;}.frm_form_field.frm_total_big .frm_total_formatted,.frm_form_field.frm_total_big input[type=text],.frm_form_field.frm_total_big input[type=number],.frm_form_field.frm_total_big input,.frm_form_field.frm_total_big textarea{font-size: 32px;font-weight: bold;line-height: 44px;}.frm_round{border-radius:50%;}.frm_round.frm_color_block{padding:3px;}.frm_square {border-radius:var(--border-radius);object-fit:cover;width:150px;height:150px;}.frmsvg{max-width:100%;fill:currentColor;vertical-align:sub;display:inline-block;}.frm_smaller{font-size:90%;}.frm_small{font-size:14px;font-weight:normal;}.frm_bigger{font-size:110%;}ul.frm_plain_list,ul.frm_plain_list li{list-style:none;list-style-type:none;margin-left:0;margin-right:0;padding-left:0;padding-right:0;}ul.frm_inline_list li{display:inline;padding:2px;}.frm_flex,.frm_full_row{display:flex;flex-direction:row;flex-wrap:wrap;}.frm_full_row > li,.frm_full_row > div{flex:1;text-align:center;}.frm_tiles > li,.frm_tiles > div{border:1px solid #BFC3C8;border-radius:4px;margin-top:20px;padding:25px;box-shadow:0 0 5px 1px rgba(0,0,0,0.075);}.frm_tiles h3{margin-top:5px;}.frm_slidein .frm_form_fields  > fieldset{animation-name: frmSlideInRight;animation-duration: 1s;animation-fill-mode: both;}.frm_slidein.frm_going_back .frm_form_fields  > fieldset {animation-name: frmSlideInLeft;}.frm_slidein.frm_slideout .frm_form_fields  > fieldset {animation-name: frmSlideOutLeft !important;}.frm_slidein.frm_slideout.frm_going_back .frm_form_fields  > fieldset {animation-name: frmSlideOutRight !important;}.frm_slidein .frm-g-recaptcha .grecaptcha-badge{animation-name: fadeIn;animation-duration: 2s;animation-fill-mode: both;}@keyframes frmSlideInLeft {0% {opacity: 0;-webkit-transform: translate3d(-3000px, 0, 0);transform: translate3d(-3000px, 0, 0);}100% {opacity: 1;-webkit-transform: none;transform: none;}}@keyframes frmSlideInRight {0% {opacity: 0;-webkit-transform: translate3d(3000px, 0, 0);transform: translate3d(3000px, 0, 0);}100% {opacity: 1;-webkit-transform: none;transform: none;}}@keyframes frmSlideOutLeft {0% {opacity: 1;-webkit-transform: none;transform: none;}100% {opacity: 0;-webkit-transform: translate3d(-2000px, 0, 0);transform: translate3d(-2000px, 0, 0);}}@keyframes frmSlideOutRight {0% {opacity: 1;-webkit-transform: none;transform: none;}100% {opacity: 0;-webkit-transform: translate3d(2000px, 0, 0);transform: translate3d(2000px, 0, 0);}}.frm_slideup .frm_form_fields  > fieldset {animation-name: frmSlideDown;-webkit-animation-duration: 1s;animation-duration: 1s;-webkit-animation-fill-mode: both;animation-fill-mode: both;}.frm_slideup.frm_going_back .frm_form_fields  > fieldset {animation-name: frmSlideUp;}.frm_slideup.frm_slideout .frm_form_fields  > fieldset {animation-name: frmSlideOutUp !important;}.frm_slideup.frm_slideout.frm_going_back .frm_form_fields  > fieldset {animation-name: frmSlideOutDown !important;}@keyframes frmSlideUp {0% {opacity: 0;-webkit-transform: translate3d(0, -200px, 0);transform: translate3d(0, -200px, 0);}100% {opacity: 1;-webkit-transform: none;transform: none;}}@keyframes frmSlideDown {0% {opacity: 0;-webkit-transform: translate3d(0, 200px, 0);transform: translate3d(0, 200px, 0);}100% {opacity: 1;-webkit-transform: none;transform: none;}}@keyframes frmSlideOutUp {0% {opacity: 1;-webkit-transform: none;transform: none;}100% {opacity: 0;-webkit-transform: translate3d(0, -200px, 0);transform: translate3d(0, -200px, 0);}}@keyframes frmSlideOutDown {0% {opacity: 1;-webkit-transform: none;transform: none;}100% {opacity: 0;-webkit-transform: translate3d(0, 200px, 0);transform: translate3d(0, 200px, 0);}}.with_frm_style .chosen-container{font-size:14px;font-size:var(--field-font-size);position:relative;display:inline-block;zoom:1;vertical-align:middle;width:100% !important;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;}.with_frm_style .chosen-container * {  -webkit-box-sizing: border-box;  box-sizing: border-box;}.with_frm_style .chosen-container .chosen-drop{background:#fff;border:1px solid #aaa;border-top:0;position:absolute;top:100%;z-index:1010;width:100%;clip: rect(0, 0, 0, 0);-webkit-clip-path: inset(100% 100%);clip-path: inset(100% 100%);}.with_frm_style .chosen-container.chosen-with-drop .chosen-drop{clip: auto;-webkit-clip-path: none;clip-path: none;}.with_frm_style .chosen-container a{cursor:pointer;}.with_frm_style .chosen-container .search-choice .group-name,.with_frm_style .chosen-container .chosen-single .group-name {margin-right: 4px;overflow: hidden;white-space: nowrap;text-overflow: ellipsis;font-weight: normal;color: #999999;}.with_frm_style .chosen-container .search-choice .group-name:after,.with_frm_style .chosen-container .chosen-single .group-name:after {content: \":\";padding-left: 2px;vertical-align: top;}.with_frm_style .chosen-container-single .chosen-single{position:relative;display:block;overflow:hidden;padding:0 0 0 8px;height:25px;text-decoration:none;white-space:nowrap;line-height:24px;}.with_frm_style .chosen-container-single .chosen-default {color: #999;}.with_frm_style .chosen-container-single .chosen-single span{margin-right:26px;display:block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;}.with_frm_style .chosen-container-single .chosen-single-with-deselect span{margin-right:38px;}.with_frm_style .chosen-container-single .chosen-single abbr{display:block;position:absolute;right:26px;top:6px;width:12px;height:12px;font-size:1px;background:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite.png\') -42px 1px no-repeat;}.with_frm_style .chosen-container-single .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single.chosen-disabled .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single .chosen-single div{position:absolute;right:0;top:0;display:block;height:100%;width:18px;}.with_frm_style .chosen-container-single .chosen-single div b{background:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite.png\') no-repeat 0 2px;display:block;width:100%;height:100%;}.with_frm_style .chosen-container-single .chosen-search{padding:3px 4px;position:relative;margin:0;white-space:nowrap;z-index:1010;}.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"]{width:100% !important;max-width:100% !important;height:auto;background:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite.png\') no-repeat 100% -20px;font-size:1em;font-family:sans-serif;line-height:normal;border-radius:0;}.with_frm_style .chosen-container-single .chosen-drop{margin-top:-1px;border-radius:0 0 4px 4px;background-clip:padding-box;}.with_frm_style .chosen-container-single.chosen-container-single-nosearch .chosen-search{position:absolute;clip: rect(0, 0, 0, 0);-webkit-clip-path: inset(100% 100%);clip-path: inset(100% 100%);}.with_frm_style .chosen-container .chosen-results{cursor:text;overflow-x:hidden;overflow-y:auto;position:relative;margin:0 4px 4px 0;padding:0 0 0 4px;max-height:240px;-webkit-overflow-scrolling:touch;}.with_frm_style .chosen-container .chosen-results li:before{background:none;}.with_frm_style .chosen-container .chosen-results li{display:none;margin:0;padding:5px 6px;list-style:none;line-height:15px;word-wrap:break-word;-webkit-touch-callout:none;}.with_frm_style .chosen-container .chosen-results li,.with_frm_style .chosen-container .chosen-results li span{color:#555555;color:var(--text-color);}.with_frm_style .chosen-container .chosen-results li.active-result{display:list-item;cursor:pointer;}.with_frm_style .chosen-container .chosen-results li.disabled-result{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container .chosen-results li.highlighted{background-color: #3875d7;background-image: -webkit-gradient(linear, left top, left bottom, color-stop(20%, #3875d7), color-stop(90%, #2a62bc));background-image: linear-gradient(#3875d7 20%, #2a62bc 90%);color: #fff;}.with_frm_style .chosen-container .chosen-results li.no-results{display:list-item;background:#f4f4f4;}.with_frm_style .chosen-container .chosen-results li.group-result{display:list-item;font-weight:bold;cursor:default;}.with_frm_style .chosen-container .chosen-results li.group-option{padding-left:15px;}.with_frm_style .chosen-container .chosen-results li em{font-style:normal;text-decoration:underline;}.with_frm_style .chosen-container-multi .chosen-choices{position:relative;overflow:hidden;margin:0;padding:0 5px;width:100%;height:auto;border: 1px solid #aaa;background-color: #fff;cursor:text;}.with_frm_style .chosen-container-multi .chosen-choices li{float:left;list-style:none;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field{margin:0;padding:0;white-space:nowrap;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field input[type=\"text\"]{margin:1px 0;padding:0 !important;height:25px;outline:0;border:0 !important;background:transparent !important;box-shadow:none;color:#666;font-size:100%;font-family:sans-serif;line-height:normal;border-radius:0;width: 25px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice{position:relative;margin:1px 5px 1px 0;padding:3px 20px 3px 5px;border:1px solid #aaa;max-width:100%;border-radius:3px;background-color:#eee;background-image: -webkit-gradient(linear, left top, left bottom, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), to(#eee));background-image: linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);background-size:100% 19px;background-repeat:repeat-x;background-clip:padding-box;box-shadow:0 0 2px white inset, 0 1px 0 rgba(0, 0, 0, 0.05);color:#333;line-height:13px;cursor:default;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice span {word-wrap: break-word;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close{position:absolute;top:4px;right:3px;display:block;width:12px;height:12px;background:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite.png\') -42px 1px no-repeat;font-size:1px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-disabled{padding-right:5px;border:1px solid #ccc;background-color:#e4e4e4;background-image: -webkit-gradient(linear, left top, left bottom, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), to(#eee));background-image: linear-gradient(#f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);color:#666;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus{background:#d4d4d4;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-results{margin:0;padding:0;}.with_frm_style .chosen-container-multi .chosen-drop .result-selected{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container-single.chosen-container-active .chosen-single{border:1px solid #5897fb;box-shadow:0 0 5px rgba(0, 0, 0, 0.3);}.with_frm_style .chosen-container-single.chosen-container-active.chosen-with-drop .chosen-single{border:1px solid #aaa;border-bottom-right-radius:0;border-bottom-left-radius:0;box-shadow:0 1px 0 #fff inset;}.with_frm_style .chosen-container-single.chosen-container-active.chosen-with-drop .chosen-single div{border-left:none;background:transparent;}.with_frm_style .chosen-container-single.chosen-container-active.chosen-with-drop .chosen-single div b{background-position:-18px 2px;}.with_frm_style .chosen-container-active .chosen-choices {border: 1px solid #5897fb;-webkit-box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);}.with_frm_style .chosen-container-active .chosen-choices li.search-field input[type=\"text\"]{color:#111 !important;}.with_frm_style .chosen-disabled{opacity:0.5 !important;cursor:default;}.with_frm_style .chosen-disabled .chosen-single{cursor:default;}.with_frm_style .chosen-disabled .chosen-choices .search-choice .search-choice-close{cursor:default;}.with_frm_style .chosen-rtl{text-align:right;}.with_frm_style .chosen-rtl .chosen-single{overflow:visible;padding:0 8px 0 0;}.with_frm_style .chosen-rtl .chosen-single span{margin-right:0;margin-left:26px;direction:rtl;}.with_frm_style .chosen-rtl .chosen-single-with-deselect span{margin-left:38px;}.with_frm_style .chosen-rtl .chosen-single div{right:auto;left:3px;}.with_frm_style .chosen-rtl .chosen-single abbr{right:auto;left:26px;}.with_frm_style .chosen-rtl .chosen-choices li{float:right;}.with_frm_style .chosen-rtl .chosen-choices li.search-field input[type=\"text\"]{direction:rtl;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice{margin:1px 5px 1px 0;padding:3px 5px 3px 19px;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice .search-choice-close{right:auto;left:4px;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-results{margin:0 0 4px 4px;padding:0 4px 0 0;}.with_frm_style .chosen-rtl .chosen-results li.group-option{padding-right:15px;padding-left:0;}.with_frm_style .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div{border-right:none;}.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"]{padding:4px 5px 4px 20px;background:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite.png\') no-repeat -30px -20px;direction:rtl;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-single div b{background-position:6px 2px;}.with_frm_style .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b{background-position:-12px 2px;}.with_frm_style .frm_repeat_sec,.with_frm_style .frm_repeat_inline,.with_frm_style .frm_repeat_grid {position: relative;}@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-resolution: 144dpi){.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-single .chosen-single abbr,.with_frm_style .chosen-container-single .chosen-single div b,.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-multi .chosen-choices .search-choice .search-choice-close,.with_frm_style .chosen-container .chosen-results-scroll-down span,.with_frm_style .chosen-container .chosen-results-scroll-up span{background-image:url(\'//template01.ourdemosites.com/wp-content/plugins/formidable-pro/images/chosen-sprite2x.png\') !important;background-size:52px 37px !important;background-repeat:no-repeat !important;}}@-webkit-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-moz-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-webkit-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@-moz-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}.frm_dropzone, .frm_dropzone * {box-sizing: border-box;}.frm_dropzone.frm_single_upload,.frm_dropzone.dz-clickable {min-height: 60px;margin-top:5px;line-height:1.42857143;}.frm_dropzone.dz-clickable * {cursor: default;}.frm_dropzone.frm_single_upload {max-width: 200px;}.frm_dropzone.frm_single_upload.dz-started {max-width: 300px;}.frm_form_field.frm_full .frm_dropzone.dz-clickable.frm_single_upload,.frm_form_field.frm_full_upload .frm_dropzone.dz-clickable.frm_single_upload{max-width:100%;}.frm_form_field.frm_full .frm_dropzone.dz-clickable.frm_single_upload .dz-message,.frm_form_field.frm_full_upload .frm_dropzone.dz-clickable.frm_single_upload .dz-message{margin: .5em 0 1em;}.frm_dropzone .dz-message{border: 2px dashed #dfdfdf;background:#ffffff;padding: 20px;border-radius:5px;cursor: pointer;display:none;font-size:20px;text-align: center;margin: .5em 0 1em;}.frm_dropzone.dz-clickable.frm_single_upload .dz-message{margin: 0 0 .5em 0;}.frm_dropzone.frm_single_upload.dz-started .dz-message{display: none;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone .frm_upload_icon{display:block;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone.dz-clickable .dz-message * {cursor: pointer;}#frm_form_editor_container .frm_dropzone.dz-clickable,#frm_form_editor_container .frm_dropzone.dz-clickable *{cursor: default;}.frm_dropzone.dz-drag-hover .dz-message {opacity: 0.5;}.frm_dropzone .frm_upload_icon:before{font-size:40px;}.frm_dropzone .frm_small_text {font-size:14px;}.frm_dropzone.dz-drag-hover {border-style: solid;}.frm_dropzone .dz-preview {padding: 15px 0;border-bottom: 1px solid #dfdfdf;}.frm_dropzone .dz-preview:last-child {border-bottom: none;}.frm_dropzone .dz-preview:hover {z-index: 1000;}.frm_dropzone .dz-preview.dz-file-preview .dz-details {opacity: 1;}.frm_dropzone .dz-preview.dz-image-preview .dz-details {-webkit-transition: opacity 0.2s linear;-moz-transition: opacity 0.2s linear;-ms-transition: opacity 0.2s linear;-o-transition: opacity 0.2s linear;transition: opacity 0.2s linear;}.frm_dropzone .dz-preview .dz-remove {cursor: pointer;border: none;float: right;}.frm_dropzone .dz-preview:hover .dz-details {opacity: 1;}.frm_dropzone .dz-preview .dz-details {font-size: 14px;margin: 5px 0 10px;}.frm_dropzone .dz-preview .dz-details .dz-size,.frm_dropzone .dz-preview .dz-details .dz-filename {display: inline-block;overflow: hidden;white-space: nowrap;}.frm_dropzone .dz-preview .dz-details .dz-size strong {font-weight: normal;}.frm_dropzone .dz-preview .dz-details .dz-filename {max-width: 65%;text-overflow: ellipsis;}.frm_dropzone .dz-preview .dz-details .dz-filename a{cursor:pointer;}.frm_dropzone .dz-preview .dz-column {float: right;width: 68%;}.frm_dropzone .dz-preview .dz-image {overflow: hidden;width: 30%;height: 60px;display: block;float: left;margin-right: 2%;}.frm_dropzone .dz-preview .dz-image img {display: block;margin:0 auto;max-height: 60px;}.frm_dropzone .dz-preview.dz-success .dz-success-mark {-webkit-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-moz-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-ms-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-o-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);}.frm_dropzone .dz-preview.dz-processing .dz-progress {-webkit-transition: all 0.2s linear;-moz-transition: all 0.2s linear;-ms-transition: all 0.2s linear;-o-transition: all 0.2s linear;transition: all 0.2s linear;}.frm_dropzone .dz-preview .dz-progress {pointer-events: none;position: relative;height: 10px;width: 100%;background: rgba(221, 221, 221, 1);-webkit-transform: scale(1);border-radius: 8px;overflow: hidden;}.frm_dropzone .dz-preview .dz-progress .dz-upload,.frm_dropzone .dz-preview.dz-complete .dz-progress{background: #333;background: linear-gradient(to bottom, #666, #444);}.frm_dropzone .dz-preview .dz-progress .dz-upload {position: absolute;top: 0;left: 0;bottom: 0;width: 0;-webkit-transition: width 300ms ease-in-out;-moz-transition: width 300ms ease-in-out;-ms-transition: width 300ms ease-in-out;-o-transition: width 300ms ease-in-out;transition: width 300ms ease-in-out;}.frm_dropzone .dz-preview.dz-error .dz-error-message {display: block;opacity: 1;pointer-events: auto;}.frm_dropzone .dz-preview .dz-error-message {pointer-events: none;display: none;opacity: 0;-webkit-transition: opacity 0.3s ease;-moz-transition: opacity 0.3s ease;-ms-transition: opacity 0.3s ease;-o-transition: opacity 0.3s ease;transition: opacity 0.3s ease;color: #B94A48;padding: 0.5em;}.frm_dropzone .fallback input[type=file]{display:block;}.frm_compact_text{display:none;}.frm_compact .frm_dropzone.dz-clickable{padding:0;border:none;background-color:transparent;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload{max-width:100%;}.frm_compact .frm_compact_text{display:inline;}.frm_upload_text button,.frm_compact_text button {background: none !important;color: inherit !important;border: none !important;padding: 0 !important;font: inherit !important;cursor: pointer !important;outline: inherit !important;height: auto !important;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload .dz-message,.frm_compact .frm_dropzone.dz-clickable .dz-message{font-size:14px;border:1px solid #dfdfdf;background:#fff;display: inline-block;border-radius: 4px;padding: 6px 11px;box-sizing: border-box;box-shadow: 0 1px 1px #eeeeee;vertical-align: middle;margin: 0 0 1em;}.frm_compact .frm_dropzone.frm_single_upload.dz-started .dz-message,.frm_compact .frm_dropzone.frm_single_upload.dz-started.dz-clickable .dz-message {display: none;}.frm_compact .frm_dropzone .frm_upload_icon:before{font-size:22px;padding-right:7px;vertical-align: middle;}.frm_compact .frm_dropzone .frm_upload_icon{display:inline;}.frm_compact .frm_dropzone .dz-preview{min-height:20px;max-width:200px;margin: 0 5px;padding: 0;display: inline-block;border-bottom: none;}.frm_compact .frm_dropzone .dz-preview.frm_clearfix:after {content:\'\';}.frm_compact .frm_dropzone .frm_upload_text,.frm_compact .frm_dropzone .frm_small_text,.frm_compact .frm_dropzone .dz-preview .dz-image,.frm_compact .frm_dropzone .dz-preview .dz-details .dz-size{display:none;}.frm_compact .frm_dropzone .dz-preview .dz-details {margin: 0;}.frm_compact .frm_dropzone .dz-preview .dz-column {float: none;width: 100%;}.frm_compact .frm_dropzone .dz-preview .dz-details .dz-filename {overflow: hidden;text-overflow: ellipsis;}.frm-show-form .dz-hidden-input{display:none;}.frm_rootline_group{margin: 20px 0 30px;}ul.frm_page_bar{list-style-type: none;margin: 0 !important;padding: 0;width: 100%;float: left;display: table;display: -webkit-flex;display: flex;flex-wrap: wrap;box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;}ul.frm_page_bar li{display: inline-block;-ms-flex: 1;flex: 1;}.frm_forms .frm_page_bar input,.frm_forms .frm_page_bar input:disabled{transition: background-color 0.1s ease;color: #3f4b5b;color: var(--progress-color) ;background-color: #eaeaea;background-color: var(--progress-bg-color) ;font-size: 18px;border-width: 2px;border-width: var(--progress-border-size) ;border-style: solid;border-color: #dbdbdb;border-color: var(--progress-border-color-b) ;}.frm_forms .frm_page_bar input:focus{outline: none;}.frm_forms .frm_progress_line input.frm_page_back{background-color: #579AF6;background-color: var(--progress-active-bg-color) ;}.frm_forms .frm_page_bar .frm_current_page input[type=\"button\"]{background-color: #eaeaea;border-color: #E5E5E5;}.frm_rootline_single{text-align: center;margin: 0;padding: 0;}.frm_current_page .frm_rootline_title{color: #579AF6;color: var(--progress-active-bg-color) ;}.frm_rootline_title,.frm_pages_complete,.frm_percent_complete {font-size:14px;padding:4px;color: #666666;color: var(--description-color) ;}.frm_pages_complete {float: right;margin-right:13px;}.frm_percent_complete {float: left;margin-left:13px;}.frm_forms .frm_progress_line input,.frm_forms .frm_progress_line input:disabled {width: 100%;border: none;border-top: 1px solid #E5E5E5;border-bottom: 1px solid #E5E5E5;box-shadow: inset 0 2px 10px -10px rgba(41, 58, 82, 0.31);margin: 5px 0;padding: 6px 0;border-radius:0;font-size:0;line-height:15px;}.frm_forms .frm_progress_line.frm_show_lines input {border-left: 1px solid #3f4b5b;border-right: 1px solid #3f4b5b;}.frm_progress_line .frm_rootline_single {display: flex;flex-direction: column;justify-content: flex-end;}.frm_forms .frm_progress_line li:first-of-type input {border-top-left-radius: 15px;border-bottom-left-radius: 15px;border-left: 1px solid #579AF6;}.frm_forms .frm_progress_line li:last-of-type input {border-top-right-radius: 15px;border-bottom-right-radius: 15px;border-right: 1px solid #579AF6;}.frm_forms .frm_progress_line li:last-of-type input.frm_page_skip {border-right: 1px solid #E5E5E5;}.frm_forms .frm_progress_line .frm_current_page input[type=\"button\"] {border-left: 1px solid #E5E5E5;}.frm_forms .frm_progress_line.frm_show_lines .frm_current_page input[type=\"button\"] {border-right: 1px solid #3f4b5b;}.frm_forms .frm_progress_line input.frm_page_back {border-color: #579AF6;}.frm_forms .frm_progress_line.frm_show_lines input.frm_page_back{border-left-color: #579AF6;border-right-color: #3f4b5b;}.frm_rtl.frm_forms .frm_progress_line li:first-of-type input {border-top-right-radius: 15px;border-bottom-right-radius: 15px;border-top-left-radius:0px;border-bottom-left-radius:0px;border-right: 1px solid #579AF6;}.frm_rtl.frm_forms .frm_progress_line li:last-of-type input{border-top-left-radius: 15px;border-bottom-left-radius: 15px;border-top-right-radius:0px;border-bottom-right-radius:0px;border-left: 1px solid #579AF6;}.frm_rtl.frm_forms .frm_progress_line li:last-of-type input.frm_page_skip {border-left: 1px solid #E5E5E5;border-right:none;}.frm_rtl.frm_forms .frm_progress_line .frm_current_page input[type=\"button\"] {border-right: 1px solid #E5E5E5;border-left:none;}.frm_rtl.frm_forms .frm_progress_line.frm_show_lines .frm_current_page input[type=\"button\"] {border-left: 1px solid #3f4b5b;border-right:none;}.frm_rootline.frm_show_lines:before {border-top-width: 2px;border-top-style: solid;border-top-color: #E5E5E5;content: \"\";margin: 0 auto;position: absolute;top: 15px;left: 0;right: 0;bottom: 0;width: 100%;z-index: -1;}.frm_rootline.frm_show_lines{position: relative;z-index: 1;}.frm_rootline.frm_show_lines span{display:block;}.frm_forms .frm_rootline input {width: 30px;height: 30px;min-height:auto;border-radius: 30px;padding:0;}.frm_forms .frm_rootline input:focus {border-color: #579AF6;border-color: var(--progress-active-bg-color) ;}.frm_forms .frm_rootline .frm_current_page input[type=\"button\"] {border-color: #4386e2;background-color: #579AF6;color: #ffffff;}.frm_forms .frm_progress_line input,.frm_forms .frm_progress_line input:disabled,.frm_forms .frm_progress_line .frm_current_page input[type=\"button\"],.frm_forms .frm_rootline.frm_no_numbers input,.frm_forms .frm_rootline.frm_no_numbers .frm_current_page input[type=\"button\"] {color: transparent !important;}@media only screen and (max-width: 700px) {.frm_progress span.frm_rootline_title,.frm_rootline.frm_rootline_10 span.frm_rootline_title,.frm_rootline.frm_rootline_9 span.frm_rootline_title,.frm_rootline.frm_rootline_8 span.frm_rootline_title,.frm_rootline.frm_rootline_7 span.frm_rootline_title,.frm_rootline.frm_rootline_6 span.frm_rootline_title,.frm_rootline.frm_rootline_5 span.frm_rootline_title{display:none;}}@media only screen and (max-width: 500px) {.frm_rootline.frm_rootline_4 span.frm_rootline_title,.frm_rootline.frm_rootline_3 span.frm_rootline_title{display:none;}}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth .frm_primary_label{display: block !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(2, 1fr);}.with_frm_style .frm_repeat_inline,.with_frm_style .frm_repeat_grid{margin: 20px 0;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);-moz-box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}", "no");
INSERT INTO `wp_options` VALUES("360", "frm_db_version", "4.09.04-97", "yes");
INSERT INTO `wp_options` VALUES("361", "frm_options", "O:11:\"FrmSettings\":23:{s:11:\"option_name\";s:11:\"frm_options\";s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:6:\"re_msg\";N;s:8:\"re_multi\";N;}", "yes");
INSERT INTO `wp_options` VALUES("364", "widget_frm_show_form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("367", "frmpro-credentials", "a:1:{s:7:\"license\";s:23:\"23H14-8AODS-FMENF-K06JK\";}", "yes");
INSERT INTO `wp_options` VALUES("368", "frmpro-authorized", "1", "yes");
INSERT INTO `wp_options` VALUES("369", "widget_frm_list_items", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("370", "frm_last_cleared", "2020-12-14 15:14:22", "yes");
INSERT INTO `wp_options` VALUES("373", "frmpro_db_version", "4.09.04-82", "yes");
INSERT INTO `wp_options` VALUES("374", "frmpro_options", "O:14:\"FrmProSettings\":29:{s:11:\"option_name\";s:14:\"frmpro_options\";s:8:\"edit_msg\";N;s:12:\"update_value\";N;s:17:\"already_submitted\";N;s:15:\"cal_date_format\";N;s:11:\"date_format\";N;s:10:\"permalinks\";b:0;s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:6:\"re_msg\";N;s:8:\"re_multi\";N;}", "yes");
INSERT INTO `wp_options` VALUES("381", "acf_pro_license", "YToyOntzOjM6ImtleSI7czo3MjoiYjNKa1pYSmZhV1E5TkRneU56RjhkSGx3WlQxa1pYWmxiRzl3WlhKOFpHRjBaVDB5TURFMUxUQXhMVEl4SURFM09qUTBPak0wIjtzOjM6InVybCI7czozNDoiaHR0cDovL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbSI7fQ==", "yes");
INSERT INTO `wp_options` VALUES("436", "ewww_image_optimizer_background_optimization", "1", "yes");
INSERT INTO `wp_options` VALUES("442", "ewww_image_optimizer_disable_pngout", "1", "no");
INSERT INTO `wp_options` VALUES("443", "ewww_image_optimizer_optipng_level", "2", "no");
INSERT INTO `wp_options` VALUES("444", "ewww_image_optimizer_pngout_level", "2", "no");
INSERT INTO `wp_options` VALUES("445", "ewww_image_optimizer_jpegtran_copy", "1", "no");
INSERT INTO `wp_options` VALUES("446", "ewww_image_optimizer_jpg_level", "40", "no");
INSERT INTO `wp_options` VALUES("447", "ewww_image_optimizer_png_level", "50", "no");
INSERT INTO `wp_options` VALUES("448", "ewww_image_optimizer_gif_level", "0", "no");
INSERT INTO `wp_options` VALUES("449", "ewww_image_optimizer_pdf_level", "20", "no");
INSERT INTO `wp_options` VALUES("450", "ewww_image_optimizer_version", "474.0", "yes");
INSERT INTO `wp_options` VALUES("453", "ewww_image_optimizer_lossy_skip_full", "1", "yes");
INSERT INTO `wp_options` VALUES("454", "ewww_image_optimizer_metadata_skip_full", "1", "yes");
INSERT INTO `wp_options` VALUES("455", "ewww_image_optimizer_jpg_background", "", "yes");
INSERT INTO `wp_options` VALUES("456", "ewww_image_optimizer_jpg_quality", "", "yes");
INSERT INTO `wp_options` VALUES("457", "ewww_image_optimizer_bulk_resume", "", "yes");
INSERT INTO `wp_options` VALUES("458", "ewww_image_optimizer_aux_resume", "", "yes");
INSERT INTO `wp_options` VALUES("459", "ewww_image_optimizer_cloud_key", "f29735a1496ec1f7d1c7f03bac556f2c", "yes");
INSERT INTO `wp_options` VALUES("460", "ewww_image_optimizer_auto", "1", "yes");
INSERT INTO `wp_options` VALUES("461", "ewww_image_optimizer_aux_paths", "", "yes");
INSERT INTO `wp_options` VALUES("462", "ewww_image_optimizer_delay", "0", "yes");
INSERT INTO `wp_options` VALUES("463", "ewww_image_optimizer_maxmediawidth", "0", "yes");
INSERT INTO `wp_options` VALUES("464", "ewww_image_optimizer_maxmediaheight", "0", "yes");
INSERT INTO `wp_options` VALUES("465", "ewww_image_optimizer_maxotherwidth", "0", "yes");
INSERT INTO `wp_options` VALUES("466", "ewww_image_optimizer_maxotherheight", "0", "yes");
INSERT INTO `wp_options` VALUES("467", "ewww_image_optimizer_resize_existing", "1", "yes");
INSERT INTO `wp_options` VALUES("468", "ewww_image_optimizer_disable_resizes", "", "yes");
INSERT INTO `wp_options` VALUES("469", "ewww_image_optimizer_disable_resizes_opt", "", "yes");
INSERT INTO `wp_options` VALUES("470", "ewww_image_optimizer_skip_size", "0", "yes");
INSERT INTO `wp_options` VALUES("471", "ewww_image_optimizer_skip_png_size", "0", "yes");
INSERT INTO `wp_options` VALUES("473", "ewww_image_optimizer_parallel_optimization", "1", "yes");
INSERT INTO `wp_options` VALUES("474", "ewww_image_optimizer_include_media_paths", "1", "yes");
INSERT INTO `wp_options` VALUES("475", "ewww_image_optimizer_webp_paths", "", "yes");
INSERT INTO `wp_options` VALUES("476", "ewww_image_optimizer_skip_bundle", "1", "yes");
INSERT INTO `wp_options` VALUES("480", "ewww_image_optimizer_aux_last", "a:2:{i:0;i:1613583534;i:1;N;}", "yes");
INSERT INTO `wp_options` VALUES("483", "WpFc_api_key", "c7b0a0f4ef5b403555635081fefce913", "yes");
INSERT INTO `wp_options` VALUES("556", "project_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("684", "frm_fccf62b26a2c4872c8c81730be14e8ac", "2021-02-15 22:29:41", "no");
INSERT INTO `wp_options` VALUES("707", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("708", "wordpress_api_key", "7841fcd88474", "yes");
INSERT INTO `wp_options` VALUES("709", "akismet_strictness", "0", "yes");
INSERT INTO `wp_options` VALUES("710", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wp_options` VALUES("713", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("716", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("722", "ewww_image_optimizer_aux_folders_completed", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("745", "gadwp_version", "4.9.5", "yes");
INSERT INTO `wp_options` VALUES("747", "widget_gadwp-frontwidget-report", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("757", "ewww_image_optimizer_exclude_paths", "", "yes");
INSERT INTO `wp_options` VALUES("856", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:28:\"william@highervisibility.com\";s:7:\"version\";s:6:\"4.9.16\";s:9:\"timestamp\";i:1604006437;}", "no");
INSERT INTO `wp_options` VALUES("907", "limit_login_retries", "a:1:{s:14:\"209.118.12.114\";i:3;}", "no");
INSERT INTO `wp_options` VALUES("908", "limit_login_retries_valid", "a:1:{s:14:\"209.118.12.114\";i:1485488368;}", "no");
INSERT INTO `wp_options` VALUES("931", "mwp_openssl_parameters", "a:2:{s:4:\"time\";i:1613529931;s:7:\"working\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("932", "mwp_incremental_update_active", "", "yes");
INSERT INTO `wp_options` VALUES("939", "worker_migration_version", "2", "yes");
INSERT INTO `wp_options` VALUES("949", "mmb_stats_filter", "a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}", "yes");
INSERT INTO `wp_options` VALUES("997", "wlcms_o_hide_wp_adminbar", "0", "yes");
INSERT INTO `wp_options` VALUES("998", "wlcms_o_adminbar_custom_logo", "", "yes");
INSERT INTO `wp_options` VALUES("999", "wlcms_o_header_custom_logo", "", "yes");
INSERT INTO `wp_options` VALUES("1000", "wlcms_o_dashboard_override", " ", "yes");
INSERT INTO `wp_options` VALUES("1001", "wlcms_o_footer_custom_logo", "", "yes");
INSERT INTO `wp_options` VALUES("1002", "wlcms_o_developer_url", "", "yes");
INSERT INTO `wp_options` VALUES("1003", "wlcms_o_developer_name", "", "yes");
INSERT INTO `wp_options` VALUES("1004", "wlcms_o_hide_wpversion", "0", "yes");
INSERT INTO `wp_options` VALUES("1005", "wlcms_o_loginbg_white", "0", "yes");
INSERT INTO `wp_options` VALUES("1006", "wlcms_o_login_custom_logo", "", "yes");
INSERT INTO `wp_options` VALUES("1007", "wlcms_o_login_bg_css", "", "yes");
INSERT INTO `wp_options` VALUES("1008", "wlcms_o_admin_page_title", "", "yes");
INSERT INTO `wp_options` VALUES("1009", "wlcms_o_dashboard_remove_right_now", "0", "yes");
INSERT INTO `wp_options` VALUES("1010", "wlcms_o_dashboard_remove_activity_panel", "0", "yes");
INSERT INTO `wp_options` VALUES("1011", "wlcms_o_dashboard_remove_recent_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("1012", "wlcms_o_dashboard_others", "1", "yes");
INSERT INTO `wp_options` VALUES("1013", "wlcms_o_dashboard_admin", "1", "yes");
INSERT INTO `wp_options` VALUES("1014", "wlcms_o_dashboard_border", "1", "yes");
INSERT INTO `wp_options` VALUES("1015", "wlcms_o_show_welcome", "0", "yes");
INSERT INTO `wp_options` VALUES("1016", "wlcms_o_welcome_visible_to", "editor", "yes");
INSERT INTO `wp_options` VALUES("1017", "wlcms_o_welcome_title", "Welcome To Your New Website", "yes");
INSERT INTO `wp_options` VALUES("1018", "wlcms_o_welcome_text", "", "yes");
INSERT INTO `wp_options` VALUES("1019", "wlcms_o_welcome_visible_to1", "0", "yes");
INSERT INTO `wp_options` VALUES("1020", "wlcms_o_welcome_title1", "", "yes");
INSERT INTO `wp_options` VALUES("1021", "wlcms_o_welcome_text1", "", "yes");
INSERT INTO `wp_options` VALUES("1022", "wlcms_o_show_rss_widget", "0", "yes");
INSERT INTO `wp_options` VALUES("1023", "wlcms_o_rss_title", "", "yes");
INSERT INTO `wp_options` VALUES("1024", "wlcms_o_rss_logo", "", "yes");
INSERT INTO `wp_options` VALUES("1025", "wlcms_o_rss_value", "", "yes");
INSERT INTO `wp_options` VALUES("1026", "wlcms_o_rss_num_items", "2", "yes");
INSERT INTO `wp_options` VALUES("1027", "wlcms_o_rss_show_intro", "yes", "yes");
INSERT INTO `wp_options` VALUES("1028", "wlcms_o_rss_intro_html", "", "yes");
INSERT INTO `wp_options` VALUES("1029", "wlcms_o_enable_login_redirect", "1", "yes");
INSERT INTO `wp_options` VALUES("1030", "wlcms_o_dashboard_remove_nag_update", "1", "yes");
INSERT INTO `wp_options` VALUES("1031", "wlcms_o_dashboard_remove_help_box", "0", "yes");
INSERT INTO `wp_options` VALUES("1032", "wlcms_o_dashboard_remove_screen_options", "0", "yes");
INSERT INTO `wp_options` VALUES("1049", "wlcms_o_custom_css", "#wp-admin-bar-autoptimize-delete-cache .ab-item { background-color: transparent !important; } \r\n#wp-admin-bar-autoptimize-delete-cache .ab-item:hover { background-color: transparent !important; color: #FFFFFF !important; }", "yes");
INSERT INTO `wp_options` VALUES("1050", "wlcms_o_welcome_stylesheet", "", "yes");
INSERT INTO `wp_options` VALUES("1059", "wlcms_o_editor_template_access", "0", "yes");
INSERT INTO `wp_options` VALUES("1060", "wlcms_o_subtemplate_hide_5", "true", "yes");
INSERT INTO `wp_options` VALUES("1061", "wlcms_o_subtemplate_hide_6", "true", "yes");
INSERT INTO `wp_options` VALUES("1062", "wlcms_o_subtemplate_hide_10", "true", "yes");
INSERT INTO `wp_options` VALUES("1063", "user_hit_count", "a:53:{s:10:\"2020-12-20\";i:8;s:10:\"2020-12-21\";i:1;s:10:\"2020-12-22\";i:2;s:10:\"2020-12-23\";i:13;s:10:\"2020-12-24\";i:6;s:10:\"2020-12-25\";i:1;s:10:\"2020-12-26\";i:2;s:10:\"2020-12-28\";i:6;s:10:\"2020-12-29\";i:2;s:10:\"2020-12-30\";i:10;s:10:\"2020-12-31\";i:3;s:10:\"2021-01-01\";i:8;s:10:\"2021-01-03\";i:2;s:10:\"2021-01-04\";i:7;s:10:\"2021-01-05\";i:4;s:10:\"2021-01-06\";i:1;s:10:\"2021-01-07\";i:2;s:10:\"2021-01-08\";i:4;s:10:\"2021-01-09\";i:2;s:10:\"2021-01-10\";i:2;s:10:\"2021-01-11\";i:8;s:10:\"2021-01-12\";i:3;s:10:\"2021-01-13\";i:3;s:10:\"2021-01-14\";i:5;s:10:\"2021-01-15\";i:5;s:10:\"2021-01-16\";i:4;s:10:\"2021-01-17\";i:3;s:10:\"2021-01-18\";i:2;s:10:\"2021-01-19\";i:2;s:10:\"2021-01-20\";i:15;s:10:\"2021-01-21\";i:4;s:10:\"2021-01-22\";i:2;s:10:\"2021-01-24\";i:2;s:10:\"2021-01-27\";i:3;s:10:\"2021-01-28\";i:3;s:10:\"2021-01-29\";i:67;s:10:\"2021-01-30\";i:8;s:10:\"2021-01-31\";i:1;s:10:\"2021-02-01\";i:2;s:10:\"2021-02-03\";i:5;s:10:\"2021-02-04\";i:3;s:10:\"2021-02-05\";i:7;s:10:\"2021-02-06\";i:14;s:10:\"2021-02-07\";i:4;s:10:\"2021-02-08\";i:2;s:10:\"2021-02-09\";i:4;s:10:\"2021-02-10\";i:5;s:10:\"2021-02-11\";i:3;s:10:\"2021-02-12\";i:3;s:10:\"2021-02-13\";i:1;s:10:\"2021-02-15\";i:5;s:10:\"2021-02-16\";i:3;s:10:\"2021-02-17\";i:6;}", "yes");
INSERT INTO `wp_options` VALUES("1078", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("1119", "options_feature_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1120", "_options_feature_toggle", "field_58c96244224be", "no");
INSERT INTO `wp_options` VALUES("1121", "options_gallery_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1122", "_options_gallery_toggle", "field_5877b3ec24f4c", "no");
INSERT INTO `wp_options` VALUES("1123", "options_service_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1124", "_options_service_toggle", "field_5877b3ef24f4e", "no");
INSERT INTO `wp_options` VALUES("1125", "options_clients_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1126", "_options_clients_toggle", "field_5877b3ee24f4d", "no");
INSERT INTO `wp_options` VALUES("1127", "options_pricing_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1128", "_options_pricing_toggle", "field_5879440f36f6c", "no");
INSERT INTO `wp_options` VALUES("1129", "options_inquiry_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1130", "_options_inquiry_toggle", "field_58c96243224bc", "no");
INSERT INTO `wp_options` VALUES("1131", "options_action_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1132", "_options_action_toggle", "field_588a648e64fcc", "no");
INSERT INTO `wp_options` VALUES("1133", "options_recent_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1134", "_options_recent_toggle", "field_5877b3cd24f4b", "no");
INSERT INTO `wp_options` VALUES("1135", "options_hours_0_title", "Monday", "no");
INSERT INTO `wp_options` VALUES("1136", "_options_hours_0_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1137", "options_hours_0_timings", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1138", "_options_hours_0_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1139", "options_hours_1_title", "Tuesday", "no");
INSERT INTO `wp_options` VALUES("1140", "_options_hours_1_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1141", "options_hours_1_timings", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1142", "_options_hours_1_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1143", "options_hours_2_title", "Wednesday", "no");
INSERT INTO `wp_options` VALUES("1144", "_options_hours_2_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1145", "options_hours_2_timings", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1146", "_options_hours_2_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1147", "options_hours_3_title", "Thursday", "no");
INSERT INTO `wp_options` VALUES("1148", "_options_hours_3_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1149", "options_hours_3_timings", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1150", "_options_hours_3_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1151", "options_hours_4_title", "Friday", "no");
INSERT INTO `wp_options` VALUES("1152", "_options_hours_4_title", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1153", "options_hours_4_timings", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1154", "_options_hours_4_timings", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1155", "options_hours", "5", "no");
INSERT INTO `wp_options` VALUES("1156", "_options_hours", "field_58343514781ee", "no");
INSERT INTO `wp_options` VALUES("1157", "options_hours_0_day", "Monday", "no");
INSERT INTO `wp_options` VALUES("1158", "_options_hours_0_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1159", "options_hours_0_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1160", "_options_hours_0_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1161", "options_hours_1_day", "Tuesday", "no");
INSERT INTO `wp_options` VALUES("1162", "_options_hours_1_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1163", "options_hours_1_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1164", "_options_hours_1_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1165", "options_hours_2_day", "Wednesday", "no");
INSERT INTO `wp_options` VALUES("1166", "_options_hours_2_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1167", "options_hours_2_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1168", "_options_hours_2_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1169", "options_hours_3_day", "Thursday", "no");
INSERT INTO `wp_options` VALUES("1170", "_options_hours_3_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1171", "options_hours_3_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1172", "_options_hours_3_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1173", "options_hours_4_day", "Friday", "no");
INSERT INTO `wp_options` VALUES("1174", "_options_hours_4_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("1175", "options_hours_4_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("1176", "_options_hours_4_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("1183", "options_color", "#2e5797", "no");
INSERT INTO `wp_options` VALUES("1184", "_options_color", "field_588a843831b1c", "no");
INSERT INTO `wp_options` VALUES("1185", "options_second", "#e54a3a", "no");
INSERT INTO `wp_options` VALUES("1186", "_options_second", "field_588a843b31b1d", "no");
INSERT INTO `wp_options` VALUES("1203", "wpseo", "a:21:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:4:\"12.4\";s:24:\"bf_banner_2019_dismissed\";b:0;s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:0;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:0;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1550163349;s:13:\"myyoast-oauth\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1205", "wpseo_titles", "a:93:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:1;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:1;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:11:\"%%excerpt%%\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:11:\"%%excerpt%%\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:11:\"%%excerpt%%\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:1;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:1;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:17:\"title-frm_display\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:20:\"metadesc-frm_display\";s:11:\"%%excerpt%%\";s:19:\"noindex-frm_display\";b:0;s:20:\"showdate-frm_display\";b:0;s:17:\"title-testimonial\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:20:\"metadesc-testimonial\";s:11:\"%%excerpt%%\";s:19:\"noindex-testimonial\";b:0;s:20:\"showdate-testimonial\";b:0;s:13:\"title-gallery\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:16:\"metadesc-gallery\";s:11:\"%%excerpt%%\";s:15:\"noindex-gallery\";b:0;s:16:\"showdate-gallery\";b:0;s:13:\"title-service\";s:30:\"%%title%% %%sep%% %%sitename%%\";s:16:\"metadesc-service\";s:11:\"%%excerpt%%\";s:15:\"noindex-service\";b:0;s:16:\"showdate-service\";b:0;s:17:\"title-tax-frm_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-tax-frm_tag\";s:0:\"\";s:19:\"noindex-tax-frm_tag\";b:1;s:14:\"title-tax-type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-tax-type\";s:0:\"\";s:16:\"noindex-tax-type\";b:1;s:26:\"post_types-gallery-maintax\";i:0;s:25:\"taxonomy-frm_tag-ptparent\";i:0;s:22:\"taxonomy-type-ptparent\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("1206", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1210", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("1233", "options_actions_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("1234", "_options_actions_toggle", "field_58c96243224bd", "no");
INSERT INTO `wp_options` VALUES("1263", "cptui_new_install", "false", "yes");
INSERT INTO `wp_options` VALUES("1266", "wpseo_onpage", "a:2:{s:6:\"status\";i:-1;s:10:\"last_fetch\";i:1516090242;}", "yes");
INSERT INTO `wp_options` VALUES("1305", "wlcms_o_ver", "1.6.1", "yes");
INSERT INTO `wp_options` VALUES("1314", "theme_mods_template", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"mainnav\";i:2;s:8:\"aboutnav\";i:3;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1497285815;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("2215", "options_branding_type", "Visibility", "no");
INSERT INTO `wp_options` VALUES("2216", "_options_branding_type", "field_58a75c6b2ac4c", "no");
INSERT INTO `wp_options` VALUES("2217", "options_business_type", "Local", "no");
INSERT INTO `wp_options` VALUES("2218", "_options_business_type", "field_58911e4ed87ca", "no");
INSERT INTO `wp_options` VALUES("2219", "options_plan_type", "10 Page", "no");
INSERT INTO `wp_options` VALUES("2220", "_options_plan_type", "field_58a75bea7153e", "no");
INSERT INTO `wp_options` VALUES("2221", "options_tracking_code", "UA-91541349-1", "no");
INSERT INTO `wp_options` VALUES("2222", "_options_tracking_code", "field_58aefa7b743eb", "no");
INSERT INTO `wp_options` VALUES("2223", "options_call_tracking_code", "", "no");
INSERT INTO `wp_options` VALUES("2224", "_options_call_tracking_code", "field_58aefa95743ec", "no");
INSERT INTO `wp_options` VALUES("2231", "options_company_name", "Company Name", "no");
INSERT INTO `wp_options` VALUES("2232", "_options_company_name", "field_58c9687f4d29f", "no");
INSERT INTO `wp_options` VALUES("2233", "options_company_image", "https://template01.ourdemosites.com/image.png", "no");
INSERT INTO `wp_options` VALUES("2234", "_options_company_image", "field_58c968864d2a0", "no");
INSERT INTO `wp_options` VALUES("2235", "options_company_address", "a:3:{s:7:\"address\";s:46:\"490 Main St, Norwich, CT, 06360, United States\";s:3:\"lat\";s:10:\"41.5183104\";s:3:\"lng\";s:11:\"-72.0955841\";}", "no");
INSERT INTO `wp_options` VALUES("2236", "_options_company_address", "field_58c968994d2a1", "no");
INSERT INTO `wp_options` VALUES("2237", "options_prices", "$$", "no");
INSERT INTO `wp_options` VALUES("2238", "_options_prices", "field_58c968a64d2a2", "no");
INSERT INTO `wp_options` VALUES("2267", "ws_menu_editor_pro", "a:25:{s:22:\"hide_advanced_settings\";b:0;s:16:\"show_extra_icons\";b:0;s:11:\"custom_menu\";a:8:{s:4:\"tree\";a:41:{s:9:\"index.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:4:\"Home\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:8:\"Updates \";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:87:\"Updates <span class=\'update-plugins count-0\'><span class=\'update-count\'>0</span></span>\";s:12:\"access_level\";s:11:\"update_core\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"update-core.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"update-core.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"index.php>responsive-lightbox-about\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:40:\"Welcome to Responsive Lightbox & Gallery\";s:10:\"menu_title\";s:40:\"Welcome to Responsive Lightbox & Gallery\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"responsive-lightbox-about\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:40:\"index.php?page=responsive-lightbox-about\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Dashboard\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:43:\"menu-top menu-top-first menu-icon-dashboard\";s:8:\"hookname\";s:14:\"menu-dashboard\";s:8:\"icon_url\";s:19:\"dashicons-dashboard\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:15:\"wpseo_dashboard\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:5:\"Yoast\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";s:38:\"menu-top toplevel_page_wpseo_dashboard\";s:8:\"hookname\";N;s:8:\"icon_url\";s:19:\"dashicons-chart-bar\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">wpseo_dashboard\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:7:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"wpseo_dashboard>wpseo_dashboard\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"General - Yoast SEO\";s:10:\"menu_title\";s:7:\"General\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"wpseo_dashboard\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=wpseo_dashboard\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:7:\"Console\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:36:\"wpseo_dashboard>wpseo_search_console\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:26:\"Search Console - Yoast SEO\";s:10:\"menu_title\";s:14:\"Search Console\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"wpseo_search_console\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:35:\"admin.php?page=wpseo_search_console\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:20:\"wpseo_manage_options\";}i:2;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:10:\"Appearance\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:28:\"wpseo_dashboard>wpseo_titles\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:29:\"Search Appearance - Yoast SEO\";s:10:\"menu_title\";s:17:\"Search Appearance\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"wpseo_titles\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=wpseo_titles\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:20:\"wpseo_manage_options\";}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:28:\"wpseo_dashboard>wpseo_social\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:18:\"Social - Yoast SEO\";s:10:\"menu_title\";s:6:\"Social\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"wpseo_social\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=wpseo_social\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Tools+\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"wpseo_dashboard>wpseo_tools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"Tools - Yoast SEO\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"wpseo_tools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=wpseo_tools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"wpseo_dashboard>wpseo_licenses\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:18:\"role:administrator\";b:0;s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Premium - Yoast SEO\";s:10:\"menu_title\";s:7:\"Premium\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"wpseo_licenses\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=wpseo_licenses\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"wpseo_dashboard>wpseo_courses\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Courses - Yoast SEO\";s:10:\"menu_title\";s:7:\"Courses\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"wpseo_courses\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"wpseo_dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=wpseo_courses\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:18:\"role:administrator\";b:1;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:20:\"Yoast SEO: Dashboard\";s:10:\"menu_title\";s:157:\"SEO <span class=\"update-plugins count-2\"><span class=\"plugin-count\" aria-hidden=\"true\">2</span><span class=\"screen-reader-text\">2 notifications</span></span>\";s:12:\"access_level\";s:20:\"wpseo_manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"wpseo_dashboard\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:38:\"menu-top toplevel_page_wpseo_dashboard\";s:8:\"hookname\";s:29:\"toplevel_page_wpseo_dashboard\";s:8:\"icon_url\";s:1174:\"data:image/svg+xml;base64,PHN2ZyB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgc3R5bGU9ImZpbGw6IzgyODc4YyIgdmlld0JveD0iMCAwIDUxMiA1MTIiIHJvbGU9ImltZyIgYXJpYS1oaWRkZW49InRydWUiIGZvY3VzYWJsZT0iZmFsc2UiPjxnPjxnPjxnPjxnPjxwYXRoIGQ9Ik0yMDMuNiwzOTVjNi44LTE3LjQsNi44LTM2LjYsMC01NGwtNzkuNC0yMDRoNzAuOWw0Ny43LDE0OS40bDc0LjgtMjA3LjZIMTE2LjRjLTQxLjgsMC03NiwzNC4yLTc2LDc2VjM1N2MwLDQxLjgsMzQuMiw3Niw3Niw3NkgxNzNDMTg5LDQyNC4xLDE5Ny42LDQxMC4zLDIwMy42LDM5NXoiLz48L2c+PGc+PHBhdGggZD0iTTQ3MS42LDE1NC44YzAtNDEuOC0zNC4yLTc2LTc2LTc2aC0zTDI4NS43LDM2NWMtOS42LDI2LjctMTkuNCw0OS4zLTMwLjMsNjhoMjE2LjJWMTU0Ljh6Ii8+PC9nPjwvZz48cGF0aCBzdHJva2Utd2lkdGg9IjIuOTc0IiBzdHJva2UtbWl0ZXJsaW1pdD0iMTAiIGQ9Ik0zMzgsMS4zbC05My4zLDI1OS4xbC00Mi4xLTEzMS45aC04OS4xbDgzLjgsMjE1LjJjNiwxNS41LDYsMzIuNSwwLDQ4Yy03LjQsMTktMTksMzcuMy01Myw0MS45bC03LjIsMXY3Nmg4LjNjODEuNywwLDExOC45LTU3LjIsMTQ5LjYtMTQyLjlMNDMxLjYsMS4zSDMzOHogTTI3OS40LDM2MmMtMzIuOSw5Mi02Ny42LDEyOC43LTEyNS43LDEzMS44di00NWMzNy41LTcuNSw1MS4zLTMxLDU5LjEtNTEuMWM3LjUtMTkuMyw3LjUtNDAuNywwLTYwbC03NS0xOTIuN2g1Mi44bDUzLjMsMTY2LjhsMTA1LjktMjk0aDU4LjFMMjc5LjQsMzYyeiIvPjwvZz48L2c+PC9zdmc+\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=wpseo_dashboard\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:15:\"separator_RCx7b\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_RCx7b\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_RCx7b\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_RCx7b\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:9:\"wpo_cache\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"WP-Optimize>wpo_cache\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Cache\";s:10:\"menu_title\";s:5:\"Cache\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"wpo_cache\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"WP-Optimize\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=wpo_cache\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:12:\"wpo_settings\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"WP-Optimize>wpo_settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Settings\";s:10:\"menu_title\";s:8:\"Settings\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"wpo_settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"WP-Optimize\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=wpo_settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:37:\"/wp-admin/post.php?post=5&action=edit\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:4:\"Home\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";s:37:\"/wp-admin/post.php?post=5&action=edit\";s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:20:\"dashicons-admin-home\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:0:\"\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:1;s:3:\"url\";N;s:16:\"embedded_page_id\";i:5;s:21:\"embedded_page_blog_id\";i:1;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:16:{s:10:\"menu_title\";s:11:\"Custom Menu\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:10:\"page_title\";s:0:\"\";s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:12:\"page_heading\";s:0:\"\";s:6:\"colors\";b:0;s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;s:14:\"is_always_open\";b:0;}s:29:\"required_capability_read_only\";s:4:\"read\";}s:8:\"edit.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:21:\"user:highervisibility\";b:1;s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"All Posts\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:21:\"user:highervisibility\";b:1;s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"post-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"post-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:21:\"user:highervisibility\";b:1;s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=category\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=category\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:21:\"user:highervisibility\";b:0;s:18:\"role:administrator\";b:0;s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:4:\"Tags\";s:12:\"access_level\";s:16:\"manage_post_tags\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}}s:12:\"grant_access\";a:2:{s:21:\"user:highervisibility\";b:1;s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Posts\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:37:\"menu-top menu-icon-post open-if-no-js\";s:8:\"hookname\";s:10:\"menu-posts\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:23:\"edit.php?post_type=page\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"All Pages\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"post-new.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"post-new.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Pages\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:23:\"menu-top menu-icon-page\";s:8:\"hookname\";s:10:\"menu-pages\";s:8:\"icon_url\";s:20:\"dashicons-admin-page\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:17:\"edit-comments.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:1:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"All Comments\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:17:\"edit-comments.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:87:\"Comments <span class=\"awaiting-mod count-0\"><span class=\"pending-count\">0</span></span>\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-comments\";s:8:\"hookname\";s:13:\"menu-comments\";s:8:\"icon_url\";s:24:\"dashicons-admin-comments\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_3\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">separator_3\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_3\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"upload.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Library\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"media-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"media-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:8:\"Optimize\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:32:\"tools.php>optimus-bulk-optimizer\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:22:\"Optimus Bulk Optimizer\";s:10:\"menu_title\";s:19:\"Optimize all images\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"optimus-bulk-optimizer\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"tools.php?page=optimus-bulk-optimizer\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:12:\"upload_files\";}i:3;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:8:\"Optimize\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:36:\"upload.php>ewww-image-optimizer-bulk\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:13:\"Bulk Optimize\";s:10:\"menu_title\";s:13:\"Bulk Optimize\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"ewww-image-optimizer-bulk\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:41:\"upload.php?page=ewww-image-optimizer-bulk\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:16:\"activate_plugins\";}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:45:\"upload.php>ewww-image-optimizer-dynamic-debug\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:23:\"Dynamic Image Debugging\";s:10:\"menu_title\";s:23:\"Dynamic Image Debugging\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"ewww-image-optimizer-dynamic-debug\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:50:\"upload.php?page=ewww-image-optimizer-dynamic-debug\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:43:\"upload.php>ewww-image-optimizer-queue-debug\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:21:\"Image Queue Debugging\";s:10:\"menu_title\";s:21:\"Image Queue Debugging\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:32:\"ewww-image-optimizer-queue-debug\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:48:\"upload.php?page=ewww-image-optimizer-queue-debug\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Media\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-media\";s:8:\"hookname\";s:10:\"menu-media\";s:8:\"icon_url\";s:21:\"dashicons-admin-media\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"formidable\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:5:\"Forms\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">formidable\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:7:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"formidable>formidable\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:18:\"Formidable | Forms\";s:10:\"menu_title\";s:5:\"Forms\";s:12:\"access_level\";s:14:\"frm_view_forms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"formidable\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=formidable\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"formidable>formidable-entries\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:20:\"Formidable | Entries\";s:10:\"menu_title\";s:7:\"Entries\";s:12:\"access_level\";s:16:\"frm_view_entries\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"formidable-entries\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"admin.php?page=formidable-entries\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:41:\"formidable>edit.php?post_type=frm_display\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:18:\"Formidable | Views\";s:10:\"menu_title\";s:5:\"Views\";s:12:\"access_level\";s:17:\"frm_edit_displays\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"edit.php?post_type=frm_display\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"edit.php?post_type=frm_display\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:28:\"formidable>formidable-styles\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Formidable | Styles\";s:10:\"menu_title\";s:6:\"Styles\";s:12:\"access_level\";s:19:\"frm_change_settings\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"formidable-styles\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=formidable-styles\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:28:\"formidable>formidable-import\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:26:\"Formidable | Import/Export\";s:10:\"menu_title\";s:13:\"Import/Export\";s:12:\"access_level\";s:14:\"frm_edit_forms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"formidable-import\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=formidable-import\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"formidable>formidable-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:28:\"Formidable | Global Settings\";s:10:\"menu_title\";s:15:\"Global Settings\";s:12:\"access_level\";s:19:\"frm_change_settings\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"formidable-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"admin.php?page=formidable-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:28:\"formidable>formidable-addons\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:20:\"Formidable | Add-Ons\";s:10:\"menu_title\";s:7:\"Add-Ons\";s:12:\"access_level\";s:14:\"frm_view_forms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"formidable-addons\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"formidable\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=formidable-addons\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:10:\"Formidable\";s:10:\"menu_title\";s:10:\"Formidable\";s:12:\"access_level\";s:14:\"frm_view_forms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"formidable\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:33:\"menu-top toplevel_page_formidable\";s:8:\"hookname\";s:24:\"toplevel_page_formidable\";s:8:\"icon_url\";s:706:\"data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA1OTkuNjggNjAxLjM3IiB3aWR0aD0iMTgiIGhlaWdodD0iMTgiPgoJCQk8cGF0aCBmaWxsPSIjYTBhNWFhIiBkPSJNMjg5LjYgMzg0aDE0MHY3NmgtMTQweiIvPgoJCQk8cGF0aCBmaWxsPSIjYTBhNWFhIiBkPSJNNDAwLjIgMTQ3aC0yMDBjLTE3IDAtMzAuNiAxMi4yLTMwLjYgMjkuM1YyMThoMjYwdi03MXpNMzk3LjkgMjY0SDE2OS42djE5Nmg3NVYzNDBIMzk4YTMyLjIgMzIuMiAwIDAgMCAzMC4xLTIxLjQgMjQuMyAyNC4zIDAgMCAwIDEuNy04LjdWMjY0ek0yOTkuOCA2MDEuNEEzMDAuMyAzMDAuMyAwIDAgMSAwIDMwMC43YTI5OS44IDI5OS44IDAgMSAxIDUxMS45IDIxMi42IDI5Ny40IDI5Ny40IDAgMCAxLTIxMiA4OHptMC01NjNBMjYyIDI2MiAwIDAgMCAzOC4zIDMwMC43YTI2MS42IDI2MS42IDAgMSAwIDQ0Ni41LTE4NS41IDI1OS41IDI1OS41IDAgMCAwLTE4NS03Ni44eiIvPgoJCTwvc3ZnPg==\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=formidable\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:28:\"responsive-lightbox-settings\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\">responsive-lightbox-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:57:\"responsive-lightbox-settings>responsive-lightbox-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"General\";s:10:\"menu_title\";s:7:\"General\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"responsive-lightbox-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:43:\"admin.php?page=responsive-lightbox-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:62:\"responsive-lightbox-settings>responsive-lightbox-configuration\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:10:\"Lightboxes\";s:10:\"menu_title\";s:10:\"Lightboxes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"responsive-lightbox-configuration\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:48:\"admin.php?page=responsive-lightbox-configuration\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:56:\"responsive-lightbox-settings>responsive-lightbox-gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Galleries\";s:10:\"menu_title\";s:9:\"Galleries\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"responsive-lightbox-gallery\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:42:\"admin.php?page=responsive-lightbox-gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:56:\"responsive-lightbox-settings>responsive-lightbox-builder\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Builder\";s:10:\"menu_title\";s:7:\"Builder\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"responsive-lightbox-builder\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:42:\"admin.php?page=responsive-lightbox-builder\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:56:\"responsive-lightbox-settings>responsive-lightbox-folders\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Folders\";s:10:\"menu_title\";s:7:\"Folders\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"responsive-lightbox-folders\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:42:\"admin.php?page=responsive-lightbox-folders\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:55:\"responsive-lightbox-settings>responsive-lightbox-addons\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Add-ons\";s:10:\"menu_title\";s:7:\"Add-ons\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"responsive-lightbox-addons\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:28:\"responsive-lightbox-settings\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:41:\"admin.php?page=responsive-lightbox-addons\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"General\";s:10:\"menu_title\";s:8:\"Lightbox\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"responsive-lightbox-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:51:\"menu-top toplevel_page_responsive-lightbox-settings\";s:8:\"hookname\";s:42:\"toplevel_page_responsive-lightbox-settings\";s:8:\"icon_url\";s:22:\"dashicons-format-image\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:43:\"admin.php?page=responsive-lightbox-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:15:\"separator_vjwI7\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_vjwI7\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_vjwI7\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_vjwI7\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:26:\"edit.php?post_type=service\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:18:\"dashicons-plus-alt\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\">edit.php?post_type=service\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:53:\"edit.php?post_type=service>edit.php?post_type=service\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Services\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=service\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=service\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=service\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:57:\"edit.php?post_type=service>post-new.php?post_type=service\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"post-new.php?post_type=service\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=service\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"post-new.php?post_type=service\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:84:\"edit.php?post_type=service>edit-tags.php?taxonomy=service_type&amp;post_type=service\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:57:\"edit-tags.php?taxonomy=service_type&amp;post_type=service\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=service\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:53:\"edit-tags.php?taxonomy=service_type&post_type=service\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Services\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=service\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-service\";s:8:\"hookname\";s:18:\"menu-posts-service\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=service\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:26:\"edit.php?post_type=gallery\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:20:\"dashicons-images-alt\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\">edit.php?post_type=gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:53:\"edit.php?post_type=gallery>edit.php?post_type=gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Galleries\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=gallery\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=gallery\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:57:\"edit.php?post_type=gallery>post-new.php?post_type=gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"post-new.php?post_type=gallery\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=gallery\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"post-new.php?post_type=gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:84:\"edit.php?post_type=gallery>edit-tags.php?taxonomy=gallery_type&amp;post_type=gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:57:\"edit-tags.php?taxonomy=gallery_type&amp;post_type=gallery\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:26:\"edit.php?post_type=gallery\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:53:\"edit-tags.php?taxonomy=gallery_type&post_type=gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Galleries\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=gallery\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-gallery\";s:8:\"hookname\";s:18:\"menu-posts-gallery\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:15:\"separator_Q1b5u\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_Q1b5u\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_Q1b5u\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_Q1b5u\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:23:\"edit.php?post_type=team\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Member\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:17;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:21:\"dashicons-admin-users\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\">edit.php?post_type=team\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Member\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:47:\"edit.php?post_type=team>edit.php?post_type=team\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:4:\"Team\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=team\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=team\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=team\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:51:\"edit.php?post_type=team>post-new.php?post_type=team\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"post-new.php?post_type=team\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=team\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"post-new.php?post_type=team\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:4:\"Team\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=team\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:23:\"menu-top menu-icon-team\";s:8:\"hookname\";s:15:\"menu-posts-team\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=team\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:30:\"edit.php?post_type=testimonial\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:7:\"Reviews\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:18;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:23:\"dashicons-format-status\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\">edit.php?post_type=testimonial\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Member\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:61:\"edit.php?post_type=testimonial>edit.php?post_type=testimonial\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Testimonial\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"edit.php?post_type=testimonial\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:30:\"edit.php?post_type=testimonial\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"edit.php?post_type=testimonial\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:65:\"edit.php?post_type=testimonial>post-new.php?post_type=testimonial\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"post-new.php?post_type=testimonial\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:30:\"edit.php?post_type=testimonial\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"post-new.php?post_type=testimonial\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Testimonial\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"edit.php?post_type=testimonial\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:30:\"menu-top menu-icon-testimonial\";s:8:\"hookname\";s:22:\"menu-posts-testimonial\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"edit.php?post_type=testimonial\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:15:\"separator_hLo3v\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:19;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_hLo3v\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_hLo3v\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_hLo3v\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:34:\"edit.php?post_type=acf-field-group\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:12:\"Custom Field\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:20;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\">edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:5:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:69:\"edit.php?post_type=acf-field-group>edit.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:12:\"Field Groups\";s:10:\"menu_title\";s:12:\"Field Groups\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"edit.php?post_type=acf-field-group\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"edit.php?post_type=acf-field-group\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:73:\"edit.php?post_type=acf-field-group>post-new.php?post_type=acf-field-group\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Add New\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:38:\"post-new.php?post_type=acf-field-group\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"post-new.php?post_type=acf-field-group\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:44:\"edit.php?post_type=acf-field-group>acf-tools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Tools\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"acf-tools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:49:\"edit.php?post_type=acf-field-group&page=acf-tools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:52:\"edit.php?post_type=acf-field-group>acf-settings-info\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Info\";s:10:\"menu_title\";s:4:\"Info\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"acf-settings-info\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:57:\"edit.php?post_type=acf-field-group&page=acf-settings-info\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Update\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:55:\"edit.php?post_type=acf-field-group>acf-settings-updates\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Updates\";s:10:\"menu_title\";s:7:\"Updates\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"acf-settings-updates\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:34:\"edit.php?post_type=acf-field-group\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:60:\"edit.php?post_type=acf-field-group&page=acf-settings-updates\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:13:\"Custom Fields\";s:10:\"menu_title\";s:13:\"Custom Fields\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:34:\"edit.php?post_type=acf-field-group\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:53:\"menu-top toplevel_page_edit?post_type=acf-field-group\";s:8:\"hookname\";s:44:\"toplevel_page_edit?post_type=acf-field-group\";s:8:\"icon_url\";s:31:\"dashicons-welcome-widgets-menus\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"edit.php?post_type=acf-field-group\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:15:\"separator_FZdW5\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:21;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_FZdW5\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_FZdW5\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_FZdW5\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:22:\"theme-general-settings\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:14:\"Theme Settings\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:22;s:6:\"parent\";N;s:9:\"css_class\";s:46:\"menu-top  toplevel_page_theme-general-settings\";s:8:\"hookname\";N;s:8:\"icon_url\";s:20:\"dashicons-align-left\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\">theme-general-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:22:\"Theme General Settings\";s:10:\"menu_title\";s:14:\"Theme Settings\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"theme-general-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:63:\"menu-top menu-icon-generic toplevel_page_theme-general-settings\";s:8:\"hookname\";s:36:\"toplevel_page_theme-general-settings\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=theme-general-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:22:\"theme-control-settings\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:14:\"Theme Controls\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:23;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\">theme-control-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:22:\"Theme Control Settings\";s:10:\"menu_title\";s:14:\"Theme Controls\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"theme-control-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:63:\"menu-top menu-icon-generic toplevel_page_theme-control-settings\";s:8:\"hookname\";s:36:\"toplevel_page_theme-control-settings\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=theme-control-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"edit_posts\";}s:11:\"separator_5\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:24;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">separator_5\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_5\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"plugins.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:7:\"Plugins\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:25;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:9:\"Installed\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\"plugins.php>plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:17:\"Installed Plugins\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:16:\"activate_plugins\";}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"plugins.php>plugin-install.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:15:\"install_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"plugin-install.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:18:\"plugin-install.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"plugins.php>plugin-editor.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Editor\";s:12:\"access_level\";s:12:\"edit_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"plugin-editor.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"plugin-editor.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:87:\"Plugins <span class=\'update-plugins count-0\'><span class=\'plugin-count\'>0</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-plugins\";s:8:\"hookname\";s:12:\"menu-plugins\";s:8:\"icon_url\";s:23:\"dashicons-admin-plugins\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:16:\"activate_plugins\";}s:9:\"Wordfence\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:8:\"Security\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:26;s:6:\"parent\";N;s:9:\"css_class\";s:32:\"menu-top toplevel_page_Wordfence\";s:8:\"hookname\";N;s:8:\"icon_url\";s:20:\"dashicons-shield-alt\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">Wordfence\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:8:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"Wordfence>Wordfence\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Wordfence Dashboard\";s:10:\"menu_title\";s:9:\"Dashboard\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"Wordfence\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=Wordfence\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"Wordfence>WordfenceOptions\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:11:\"All Options\";s:10:\"menu_title\";s:11:\"All Options\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"WordfenceOptions\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=WordfenceOptions\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\"Wordfence>WordfenceScan\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Scan\";s:10:\"menu_title\";s:4:\"Scan\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"WordfenceScan\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=WordfenceScan\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:22:\"Wordfence>WordfenceWAF\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Firewall\";s:10:\"menu_title\";s:8:\"Firewall\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"WordfenceWAF\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=WordfenceWAF\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"Wordfence>WordfenceTools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Tools\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"WordfenceTools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=WordfenceTools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:14:\"Wordfence>WFLS\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:14:\"Login Security\";s:10:\"menu_title\";s:14:\"Login Security\";s:12:\"access_level\";s:23:\"wf2fa_activate_2fa_self\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:4:\"WFLS\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"admin.php?page=WFLS\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"Wordfence>WordfenceSupport\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Help\";s:10:\"menu_title\";s:4:\"Help\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"WordfenceSupport\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=WordfenceSupport\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"Wordfence>WordfenceUpgradeToPremium\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:18:\"Upgrade To Premium\";s:10:\"menu_title\";s:78:\"<strong id=\"wfMenuCallout\" style=\"color: #FCB214;\">Upgrade To Premium</strong>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"WordfenceUpgradeToPremium\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:40:\"admin.php?page=WordfenceUpgradeToPremium\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Wordfence\";s:10:\"menu_title\";s:165:\"Wordfence <span class=\'update-plugins wf-menu-badge wf-notification-count-container\' title=\'1\'><span class=\'update-count wf-notification-count-value\'>1</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"Wordfence\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:32:\"menu-top toplevel_page_Wordfence\";s:8:\"hookname\";s:23:\"toplevel_page_Wordfence\";s:8:\"icon_url\";s:90:\"https://template01.ourdemosites.com/wp-content/plugins/wordfence/images/wordfence-logo.svg\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=Wordfence\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:16:\"activate_plugins\";}s:15:\"separator_5Z8Ta\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:27;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_5Z8Ta\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_5Z8Ta\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_5Z8Ta\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:15:\"separator_i8ahl\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:28;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_i8ahl\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_i8ahl\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_i8ahl\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:19:\"options-general.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:29;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\">options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:17:{i:0;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:11:\"Autoptimize\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"options-general.php>autoptimize\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Autoptimize Options\";s:10:\"menu_title\";s:11:\"Autoptimize\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"autoptimize\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"options-general.php?page=autoptimize\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}i:1;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:11:\"Menu Editor\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"options-general.php>menu_editor\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:15:\"Menu Editor Pro\";s:10:\"menu_title\";s:15:\"Menu Editor Pro\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"menu_editor\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"options-general.php?page=menu_editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"General\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-reading.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Reading\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-reading.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-reading.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>ws-admin-bar-editor\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:24:\"WordPress Toolbar Editor\";s:10:\"menu_title\";s:14:\"Toolbar Editor\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"ws-admin-bar-editor\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:44:\"options-general.php?page=ws-admin-bar-editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:45:\"options-general.php>rlrsssl_really_simple_ssl\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:12:\"SSL settings\";s:10:\"menu_title\";s:93:\"SSL<span class=\'update-plugins rsssl-update-count\'><span class=\'update-count\'>1</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"rlrsssl_really_simple_ssl\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:50:\"options-general.php?page=rlrsssl_really_simple_ssl\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"options-general.php>privacy.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Privacy \";s:12:\"access_level\";s:22:\"manage_privacy_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"privacy.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"privacy.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:9:\"Permalink\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:41:\"options-general.php>options-permalink.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Permalinks\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"options-permalink.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:21:\"options-permalink.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}i:8;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-writing.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Writing\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-writing.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-writing.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:9;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:42:\"options-general.php>options-discussion.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Discussion\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"options-discussion.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:22:\"options-discussion.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:10;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"options-general.php>options-media.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Media\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"options-media.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"options-media.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:11;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:38:\"options-general.php>akismet-key-config\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"Akismet Anti-Spam\";s:10:\"menu_title\";s:17:\"Akismet Anti-Spam\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"akismet-key-config\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:43:\"options-general.php?page=akismet-key-config\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:12;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"options-general.php>mailgun\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Mailgun\";s:10:\"menu_title\";s:7:\"Mailgun\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:7:\"mailgun\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"options-general.php?page=mailgun\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:13;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:33:\"options-general.php>mailgun-lists\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:13:\"Mailgun Lists\";s:10:\"menu_title\";s:13:\"Mailgun Lists\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"mailgun-lists\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"options-general.php?page=mailgun-lists\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:14;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:33:\"options-general.php>cache-enabler\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:13:\"Cache Enabler\";s:10:\"menu_title\";s:13:\"Cache Enabler\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"cache-enabler\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"options-general.php?page=cache-enabler\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:15;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"options-general.php>optimus\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Optimus\";s:10:\"menu_title\";s:7:\"Optimus\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:7:\"optimus\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"options-general.php?page=optimus\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:16;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:10:\"EWWW Cloud\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:77:\"options-general.php>ewww-image-optimizer-cloud/ewww-image-optimizer-cloud.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:20:\"EWWW Image Optimizer\";s:10:\"menu_title\";s:20:\"EWWW Image Optimizer\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:57:\"ewww-image-optimizer-cloud/ewww-image-optimizer-cloud.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:84:\"options-general.php?page=ewww-image-optimizer-cloud%2Fewww-image-optimizer-cloud.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:99:\"Settings<span class=\'update-plugins rsssl-update-count\'><span class=\'update-count\'>1</span></span> \";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-settings\";s:8:\"hookname\";s:13:\"menu-settings\";s:8:\"icon_url\";s:24:\"dashicons-admin-settings\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}s:29:\"video-user-manuals/plugin.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:7:\"Manuals\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:30;s:6:\"parent\";N;s:9:\"css_class\";s:47:\"menu-top toplevel_page_video-user-manualsplugin\";s:8:\"hookname\";N;s:8:\"icon_url\";s:14:\"dashicons-book\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\">video-user-manuals/plugin.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:59:\"video-user-manuals/plugin.php>video-user-manuals/plugin.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:6:\"Videos\";s:10:\"menu_title\";s:6:\"Videos\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"video-user-manuals/plugin.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:29:\"video-user-manuals/plugin.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:46:\"admin.php?page=video-user-manuals%2Fplugin.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:6:\"Manual\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:41:\"video-user-manuals/plugin.php>vum-options\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:14:\"Manual Options\";s:10:\"menu_title\";s:14:\"Manual Options\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"vum-options\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:29:\"video-user-manuals/plugin.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=vum-options\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:6:\"Manual\";s:10:\"menu_title\";s:6:\"Manual\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"video-user-manuals/plugin.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:48:\"menu-top toplevel_page_video-user-manuals/plugin\";s:8:\"hookname\";s:39:\"toplevel_page_video-user-manuals/plugin\";s:8:\"icon_url\";s:3:\"div\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:46:\"admin.php?page=video-user-manuals%2Fplugin.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:4:\"read\";}s:15:\"separator_dTyBf\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:31;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_dTyBf\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_dTyBf\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_dTyBf\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:13:\"nav-menus.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:4:\"Menu\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:32;s:6:\"parent\";N;s:9:\"css_class\";s:8:\"menu-top\";s:8:\"hookname\";N;s:8:\"icon_url\";s:21:\"dashicons-align-right\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"themes.php>nav-menus.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"themes.php>themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Themes\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"themes.php>customize.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Customize\";s:12:\"access_level\";s:9:\"customize\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:90:\"customize.php?return=%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor%26noheader%3D1\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:20:\"hide-if-no-customize\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:90:\"customize.php?return=%2Fwp-admin%2Foptions-general.php%3Fpage%3Dmenu_editor%26noheader%3D1\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"themes.php>nav-menus.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Menus\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"nav-menus.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"nav-menus.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"themes.php>theme-editor.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:6:\"Editor\";s:10:\"menu_title\";s:6:\"Editor\";s:12:\"access_level\";s:11:\"edit_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"theme-editor.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:16:\"theme-editor.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Menus\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"nav-menus.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"nav-menus.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:18:\"edit_theme_options\";}s:9:\"users.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:33;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"users.php>users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"All Users\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:22:\"users.php>user-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Add New\";s:12:\"access_level\";s:12:\"create_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"user-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"user-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:7:\"Profile\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"users.php>profile.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:1;s:21:\"user:highervisibility\";b:1;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Your Profile\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"profile.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"profile.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:4:\"read\";}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:5:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Users\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-users\";s:8:\"hookname\";s:10:\"menu-users\";s:8:\"icon_url\";s:21:\"dashicons-admin-users\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:10:\"list_users\";}s:15:\"separator_W1RCp\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:34;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_W1RCp\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_W1RCp\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_W1RCp\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:9:\"tools.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:35;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:7:{i:0;a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:9:\"WP-Pusher\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"wppusher>wppusher-themes\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:0;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:16:\"WP Pusher Themes\";s:10:\"menu_title\";s:6:\"Themes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"wppusher-themes\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=wppusher-themes\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"tools.php>tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:15:\"Available Tools\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\"tools.php>import.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Import\";s:12:\"access_level\";s:6:\"import\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"import.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"import.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"tools.php>redirection.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:11:\"Redirection\";s:10:\"menu_title\";s:11:\"Redirection\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"redirection.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"tools.php?page=redirection.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\"tools.php>export.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Export\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"export.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"export.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"tools.php>export_personal_data\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:20:\"Export Personal Data\";s:10:\"menu_title\";s:20:\"Export Personal Data\";s:12:\"access_level\";s:27:\"export_others_personal_data\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"export_personal_data\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:35:\"tools.php?page=export_personal_data\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"tools.php>remove_personal_data\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Erase Personal Data\";s:10:\"menu_title\";s:19:\"Erase Personal Data\";s:12:\"access_level\";s:26:\"erase_others_personal_data\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"remove_personal_data\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:35:\"tools.php?page=remove_personal_data\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:0;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-tools\";s:8:\"hookname\";s:10:\"menu-tools\";s:8:\"icon_url\";s:21:\"dashicons-admin-tools\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:15:\"separator_KrT58\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:36;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">separator_KrT58\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"separator_KrT58\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:15:\"separator_KrT58\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:8:\"wppusher\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";s:9:\"WP-Pusher\";s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:37;s:6:\"parent\";N;s:9:\"css_class\";s:31:\"menu-top toplevel_page_wppusher\";s:8:\"hookname\";N;s:8:\"icon_url\";s:16:\"dashicons-upload\";s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:9:\">wppusher\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:5:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:17:\"wppusher>wppusher\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"WP Pusher\";s:10:\"menu_title\";s:9:\"WP Pusher\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"wppusher\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"admin.php?page=wppusher\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"wppusher>wppusher-plugins\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"WP Pusher Plugins\";s:10:\"menu_title\";s:7:\"Plugins\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"wppusher-plugins\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=wppusher-plugins\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"wppusher>https://wppusher.com/support\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Get Help\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"https://wppusher.com/support\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"https://wppusher.com/support\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:32:\"wppusher>wppusher-plugins-create\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:14:\"Install Plugin\";s:10:\"menu_title\";s:14:\"Install Plugin\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"wppusher-plugins-create\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"admin.php?page=wppusher-plugins-create\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"wppusher>wppusher-themes-create\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:3:{s:11:\"role:client\";b:0;s:18:\"role:administrator\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:13:\"Install Theme\";s:10:\"menu_title\";s:13:\"Install Theme\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"wppusher-themes-create\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"wppusher\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=wppusher-themes-create\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:1:{s:11:\"role:client\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:1:{s:21:\"user:highervisibility\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"WP Pusher\";s:10:\"menu_title\";s:9:\"WP Pusher\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"wppusher\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:31:\"menu-top toplevel_page_wppusher\";s:8:\"hookname\";s:22:\"toplevel_page_wppusher\";s:8:\"icon_url\";s:16:\"dashicons-marker\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"admin.php?page=wppusher\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:14:\"manage_options\";}s:11:\"soi_setting\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:38;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">soi_setting\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:2:{s:11:\"role:client\";b:0;s:21:\"user:highervisibility\";b:1;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:6:{s:21:\"user:highervisibility\";b:1;s:11:\"role:editor\";b:1;s:11:\"role:author\";b:1;s:16:\"role:contributor\";b:1;s:15:\"role:subscriber\";b:1;s:18:\"role:administrator\";b:1;}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"soi_settings_page\";s:10:\"menu_title\";s:20:\"SEO Optimized Images\";s:12:\"access_level\";s:13:\"administrator\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"soi_setting\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:52:\"menu-top menu-icon-generic toplevel_page_soi_setting\";s:8:\"hookname\";s:25:\"toplevel_page_soi_setting\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=soi_setting\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:13:\"administrator\";}s:10:\"themes.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:39;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:1:{s:21:\"user:highervisibility\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Appearance\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:29:\"menu-top menu-icon-appearance\";s:8:\"hookname\";s:15:\"menu-appearance\";s:8:\"icon_url\";s:26:\"dashicons-admin-appearance\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:13:\"switch_themes\";}s:10:\"duplicator\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:40;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">duplicator\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"duplicator>duplicator\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Packages\";s:10:\"menu_title\";s:8:\"Packages\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"duplicator\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=duplicator\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"duplicator>duplicator-tools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Tools\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"duplicator-tools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=duplicator-tools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"duplicator>duplicator-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Settings\";s:10:\"menu_title\";s:8:\"Settings\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"duplicator-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"admin.php?page=duplicator-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"duplicator>duplicator-gopro\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:42:\"<span style=\"color:#f18500\">Go Pro!</span>\";s:10:\"menu_title\";s:42:\"<span style=\"color:#f18500\">Go Pro!</span>\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"duplicator-gopro\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"duplicator\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=duplicator-gopro\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"Duplicator Plugin\";s:10:\"menu_title\";s:10:\"Duplicator\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"duplicator\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:33:\"menu-top toplevel_page_duplicator\";s:8:\"hookname\";s:24:\"toplevel_page_duplicator\";s:8:\"icon_url\";s:7146:\"data:image/svg+xml;base64,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\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=duplicator\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:6:\"format\";a:3:{s:4:\"name\";s:22:\"Admin Menu Editor menu\";s:7:\"version\";s:3:\"7.0\";s:13:\"is_normalized\";b:1;}s:13:\"color_presets\";a:0:{}s:20:\"component_visibility\";a:0:{}s:22:\"has_modified_dashicons\";b:1;s:9:\"color_css\";s:0:\"\";s:18:\"color_css_modified\";i:0;s:21:\"prebuilt_virtual_caps\";a:2:{i:2;a:0:{}i:3;a:3:{s:11:\"role:client\";a:7:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:17:\"manage_categories\";b:1;s:10:\"edit_pages\";b:1;s:12:\"upload_files\";b:1;s:14:\"frm_view_forms\";b:1;s:16:\"frm_view_entries\";b:1;}s:21:\"user:highervisibility\";a:23:{s:4:\"read\";b:1;s:11:\"update_core\";b:1;s:20:\"wpseo_manage_options\";b:1;s:10:\"edit_posts\";b:1;s:17:\"manage_categories\";b:1;s:12:\"upload_files\";b:1;s:17:\"frm_edit_displays\";b:1;s:19:\"frm_change_settings\";b:1;s:14:\"frm_edit_forms\";b:1;s:14:\"frm_view_forms\";b:1;s:14:\"manage_options\";b:1;s:16:\"activate_plugins\";b:1;s:22:\"manage_privacy_options\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:10:\"list_users\";b:1;s:12:\"create_users\";b:1;s:6:\"import\";b:1;s:6:\"export\";b:1;s:27:\"export_others_personal_data\";b:1;s:26:\"erase_others_personal_data\";b:1;s:13:\"administrator\";b:1;}s:18:\"role:administrator\";a:11:{s:20:\"wpseo_manage_options\";b:1;s:14:\"frm_edit_forms\";b:1;s:16:\"activate_plugins\";b:1;s:15:\"install_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:14:\"manage_options\";b:1;s:18:\"edit_theme_options\";b:1;s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:6:\"import\";b:1;s:6:\"export\";b:1;}}}}s:19:\"custom_network_menu\";N;s:18:\"first_install_time\";i:1483468863;s:21:\"display_survey_notice\";b:0;s:17:\"plugin_db_version\";i:140;s:24:\"security_logging_enabled\";b:0;s:17:\"menu_config_scope\";s:6:\"global\";s:13:\"plugin_access\";s:14:\"manage_options\";s:15:\"allowed_user_id\";N;s:28:\"plugins_page_allowed_user_id\";N;s:27:\"show_deprecated_hide_button\";b:1;s:37:\"dashboard_hiding_confirmation_enabled\";b:1;s:21:\"submenu_icons_enabled\";s:9:\"if_custom\";s:22:\"force_custom_dashicons\";b:1;s:16:\"ui_colour_scheme\";s:10:\"modern-one\";s:13:\"visible_users\";a:0:{}s:23:\"show_plugin_menu_notice\";b:0;s:20:\"unused_item_position\";s:8:\"relative\";s:23:\"unused_item_permissions\";s:9:\"unchanged\";s:15:\"error_verbosity\";i:2;s:20:\"compress_custom_menu\";b:0;s:16:\"is_active_module\";a:9:{s:14:\"actor-selector\";b:0;s:13:\"visible-users\";b:0;s:9:\"metaboxes\";b:1;s:23:\"dashboard-widget-editor\";b:1;s:17:\"plugin-visibility\";b:1;s:11:\"super-users\";b:1;s:15:\"hide-admin-menu\";b:1;s:14:\"hide-admin-bar\";b:1;s:19:\"highlight-new-menus\";b:0;}s:11:\"super_users\";a:1:{i:0;i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("2278", "options_favicon", "289", "no");
INSERT INTO `wp_options` VALUES("2279", "_options_favicon", "field_58c9747538b83", "no");
INSERT INTO `wp_options` VALUES("2303", "wordfence_version", "7.4.14", "yes");
INSERT INTO `wp_options` VALUES("2305", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("2306", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("2350", "tantan_wordpress_s3", "a:14:{s:6:\"bucket\";s:13:\"templatemedia\";s:10:\"cloudfront\";s:0:\"\";s:10:\"copy-to-s3\";s:1:\"0\";s:6:\"domain\";s:4:\"path\";s:20:\"enable-object-prefix\";s:1:\"0\";s:11:\"force-https\";s:1:\"0\";s:7:\"licence\";s:36:\"c6565342-c7aa-4936-ba68-289c40db17a6\";s:13:\"object-prefix\";s:0:\"\";s:17:\"object-versioning\";s:1:\"0\";s:17:\"post_meta_version\";i:7;s:6:\"region\";s:0:\"\";s:17:\"remove-local-file\";s:1:\"0\";s:13:\"serve-from-s3\";s:1:\"0\";s:21:\"use-yearmonth-folders\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("2371", "autoptimize_version", "2.8.1", "yes");
INSERT INTO `wp_options` VALUES("2389", "autoptimize_html", "on", "yes");
INSERT INTO `wp_options` VALUES("2390", "autoptimize_html_keepcomments", "", "yes");
INSERT INTO `wp_options` VALUES("2391", "autoptimize_js", "on", "yes");
INSERT INTO `wp_options` VALUES("2392", "autoptimize_js_exclude", "", "yes");
INSERT INTO `wp_options` VALUES("2393", "autoptimize_js_trycatch", "", "yes");
INSERT INTO `wp_options` VALUES("2394", "autoptimize_js_justhead", "", "yes");
INSERT INTO `wp_options` VALUES("2395", "autoptimize_js_forcehead", "", "yes");
INSERT INTO `wp_options` VALUES("2396", "autoptimize_js_include_inline", "on", "yes");
INSERT INTO `wp_options` VALUES("2397", "autoptimize_css", "on", "yes");
INSERT INTO `wp_options` VALUES("2398", "autoptimize_css_exclude", "admin-bar.min.css, dashicons.min.css", "yes");
INSERT INTO `wp_options` VALUES("2399", "autoptimize_css_justhead", "", "yes");
INSERT INTO `wp_options` VALUES("2400", "autoptimize_css_datauris", "", "yes");
INSERT INTO `wp_options` VALUES("2401", "autoptimize_css_defer", "on", "yes");
INSERT INTO `wp_options` VALUES("2402", "autoptimize_css_defer_inline", "", "yes");
INSERT INTO `wp_options` VALUES("2403", "autoptimize_css_inline", "", "yes");
INSERT INTO `wp_options` VALUES("2404", "autoptimize_css_include_inline", "on", "yes");
INSERT INTO `wp_options` VALUES("2406", "autoptimize_cdn_url", "", "yes");
INSERT INTO `wp_options` VALUES("2407", "autoptimize_cache_clean", "0", "yes");
INSERT INTO `wp_options` VALUES("2408", "autoptimize_cache_nogzip", "", "yes");
INSERT INTO `wp_options` VALUES("2409", "autoptimize_show_adv", "1", "yes");
INSERT INTO `wp_options` VALUES("2417", "w3tc_state", "{\"common.install\":1489613491,\"common.show_note.plugins_updated\":true,\"common.show_note.plugins_updated.timestamp\":1556722339,\"common.next_support_us_invitation\":1504448723,\"common.support_us_invitations\":3,\"common.show_note.flush_posts_needed\":false,\"common.show_note.flush_posts_needed.timestamp\":1517244461,\"common.next_edge_invitation\":1502461576,\"common.edge_invitations\":2,\"extension.swarmify.hide_note_activate_suggestion\":\"true\",\"wordpress_seo.hide_note_suggest_activation\":\"true\",\"license.status\":\"no_key\",\"license.next_check\":1557152752,\"license.terms\":\"\"}", "no");
INSERT INTO `wp_options` VALUES("2430", "w3tc_nr_application_id", "{\"d41d8cd98f00b204e9800998ecf8427e\":0}", "yes");
INSERT INTO `wp_options` VALUES("2451", "ws_abe_external_updates", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1613564888;s:14:\"checkedVersion\";s:5:\"1.3.4\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:17:\"wp-toolbar-editor\";s:7:\"version\";s:3:\"1.4\";s:12:\"download_url\";s:157:\"https://adminmenueditor.com/?get_product=wp-toolbar-editor&license_token=K778KN2M719JOQ5LKL67L0NG5NPSB16L&license_site_url=http://template01.ourdemosites.com\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:28:\"https://adminmenueditor.com/\";s:6:\"tested\";s:5:\"5.6.1\";s:12:\"requires_php\";N;s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:26:\"wp-toolbar-editor/load.php\";}s:11:\"updateClass\";s:23:\"Puc_v4p10_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}", "no");
INSERT INTO `wp_options` VALUES("2457", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("2458", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("2459", "wordfence_lastSyncAttackData", "1612576210", "no");
INSERT INTO `wp_options` VALUES("2460", "ws_abe_admin_bar_settings", "a:4:{s:17:\"menu_config_scope\";s:6:\"global\";s:5:\"nodes\";a:53:{s:11:\"menu-toggle\";a:7:{s:2:\"id\";s:11:\"menu-toggle\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:73:\"<span class=\"ab-icon\"></span><span class=\"screen-reader-text\">Menu</span>\";s:4:\"href\";s:1:\"#\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:11:\"menu-toggle\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:7:\"wp-logo\";a:7:{s:2:\"id\";s:7:\"wp-logo\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:84:\"<span class=\"ab-icon\"></span><span class=\"screen-reader-text\">About WordPress</span>\";s:4:\"href\";s:54:\"https://template01.ourdemosites.com/wp-admin/about.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:7:\"wp-logo\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:5:\"about\";a:7:{s:2:\"id\";s:5:\"about\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:15:\"About WordPress\";s:4:\"href\";s:54:\"https://template01.ourdemosites.com/wp-admin/about.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:5:\"about\";s:6:\"parent\";s:7:\"wp-logo\";s:5:\"group\";b:0;}s:6:\"parent\";s:7:\"wp-logo\";}s:16:\"wp-logo-external\";a:7:{s:2:\"id\";s:16:\"wp-logo-external\";s:5:\"group\";b:1;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";b:0;s:4:\"href\";b:0;s:5:\"class\";s:16:\"ab-sub-secondary\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:16:\"wp-logo-external\";s:6:\"parent\";s:7:\"wp-logo\";s:5:\"group\";b:1;}s:6:\"parent\";s:7:\"wp-logo\";}s:5:\"wporg\";a:7:{s:2:\"id\";s:5:\"wporg\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:13:\"WordPress.org\";s:4:\"href\";s:22:\"https://wordpress.org/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:5:\"wporg\";s:6:\"parent\";s:16:\"wp-logo-external\";s:5:\"group\";b:0;}s:6:\"parent\";s:16:\"wp-logo-external\";}s:13:\"documentation\";a:7:{s:2:\"id\";s:13:\"documentation\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:13:\"Documentation\";s:4:\"href\";s:28:\"https://codex.wordpress.org/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:13:\"documentation\";s:6:\"parent\";s:16:\"wp-logo-external\";s:5:\"group\";b:0;}s:6:\"parent\";s:16:\"wp-logo-external\";}s:14:\"support-forums\";a:7:{s:2:\"id\";s:14:\"support-forums\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:14:\"Support Forums\";s:4:\"href\";s:30:\"https://wordpress.org/support/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:14:\"support-forums\";s:6:\"parent\";s:16:\"wp-logo-external\";s:5:\"group\";b:0;}s:6:\"parent\";s:16:\"wp-logo-external\";}s:8:\"feedback\";a:7:{s:2:\"id\";s:8:\"feedback\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:8:\"Feedback\";s:4:\"href\";s:57:\"https://wordpress.org/support/forum/requests-and-feedback\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"feedback\";s:6:\"parent\";s:16:\"wp-logo-external\";s:5:\"group\";b:0;}s:6:\"parent\";s:16:\"wp-logo-external\";}s:9:\"site-name\";a:7:{s:2:\"id\";s:9:\"site-name\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:11:\"Template 01\";s:4:\"href\";s:36:\"https://template01.ourdemosites.com/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:9:\"site-name\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:9:\"view-site\";a:7:{s:2:\"id\";s:9:\"view-site\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:10:\"Visit Site\";s:4:\"href\";s:36:\"https://template01.ourdemosites.com/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:9:\"view-site\";s:6:\"parent\";s:9:\"site-name\";s:5:\"group\";b:0;}s:6:\"parent\";s:9:\"site-name\";}s:9:\"dashboard\";a:7:{s:2:\"id\";s:9:\"dashboard\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:9:\"Dashboard\";s:4:\"href\";s:45:\"https://template01.ourdemosites.com/wp-admin/\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:9:\"site-name\";s:2:\"id\";s:9:\"dashboard\";}s:6:\"parent\";s:9:\"site-name\";}s:10:\"appearance\";a:7:{s:2:\"id\";s:10:\"appearance\";s:5:\"group\";b:1;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:13:\"Default Title\";s:4:\"href\";s:0:\"\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:9:\"site-name\";s:2:\"id\";s:10:\"appearance\";s:5:\"group\";b:1;}s:6:\"parent\";s:9:\"site-name\";}s:6:\"themes\";a:7:{s:2:\"id\";s:6:\"themes\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:6:\"Themes\";s:4:\"href\";s:55:\"https://template01.ourdemosites.com/wp-admin/themes.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:6:\"themes\";}s:6:\"parent\";s:10:\"appearance\";}s:9:\"customize\";a:7:{s:2:\"id\";s:9:\"customize\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:9:\"Customize\";s:4:\"href\";s:18:\"[theme customizer]\";s:5:\"class\";s:20:\"hide-if-no-customize\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:9:\"customize\";}s:6:\"parent\";s:10:\"appearance\";}s:7:\"widgets\";a:7:{s:2:\"id\";s:7:\"widgets\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:7:\"Widgets\";s:4:\"href\";s:56:\"https://template01.ourdemosites.com/wp-admin/widgets.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:7:\"widgets\";}s:6:\"parent\";s:10:\"appearance\";}s:5:\"menus\";a:7:{s:2:\"id\";s:5:\"menus\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:5:\"Menus\";s:4:\"href\";s:58:\"https://template01.ourdemosites.com/wp-admin/nav-menus.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:5:\"menus\";}s:6:\"parent\";s:10:\"appearance\";}s:10:\"background\";a:7:{s:2:\"id\";s:10:\"background\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:10:\"Background\";s:4:\"href\";s:78:\"https://template01.ourdemosites.com/wp-admin/themes.php?page=custom-background\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:10:\"background\";}s:6:\"parent\";s:10:\"appearance\";}s:6:\"header\";a:7:{s:2:\"id\";s:6:\"header\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:6:\"Header\";s:4:\"href\";s:74:\"https://template01.ourdemosites.com/wp-admin/themes.php?page=custom-header\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:6:\"parent\";s:10:\"appearance\";s:2:\"id\";s:6:\"header\";}s:6:\"parent\";s:10:\"appearance\";}s:7:\"updates\";a:7:{s:2:\"id\";s:7:\"updates\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:115:\"<span class=\"ab-icon\"></span><span class=\"ab-label\">1</span><span class=\"screen-reader-text\">1 Plugin Update</span>\";s:4:\"href\";s:60:\"https://template01.ourdemosites.com/wp-admin/update-core.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";s:15:\"1 Plugin Update\";s:8:\"tabindex\";N;s:2:\"id\";s:7:\"updates\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:8:\"comments\";a:7:{s:2:\"id\";s:8:\"comments\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:184:\"<span class=\"ab-icon\"></span><span class=\"ab-label awaiting-mod pending-count count-0\" aria-hidden=\"true\">0</span><span class=\"screen-reader-text\">0 comments awaiting moderation</span>\";s:4:\"href\";s:62:\"https://template01.ourdemosites.com/wp-admin/edit-comments.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"comments\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:11:\"new-content\";a:7:{s:2:\"id\";s:11:\"new-content\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:62:\"<span class=\"ab-icon\"></span><span class=\"ab-label\">New</span>\";s:4:\"href\";s:57:\"https://template01.ourdemosites.com/wp-admin/post-new.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:11:\"new-content\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:8:\"new-post\";a:7:{s:2:\"id\";s:8:\"new-post\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:4:\"Post\";s:4:\"href\";s:57:\"https://template01.ourdemosites.com/wp-admin/post-new.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"new-post\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:9:\"new-media\";a:7:{s:2:\"id\";s:9:\"new-media\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:5:\"Media\";s:4:\"href\";s:58:\"https://template01.ourdemosites.com/wp-admin/media-new.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:9:\"new-media\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:8:\"new-page\";a:7:{s:2:\"id\";s:8:\"new-page\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:4:\"Page\";s:4:\"href\";s:72:\"https://template01.ourdemosites.com/wp-admin/post-new.php?post_type=page\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"new-page\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:15:\"new-testimonial\";a:7:{s:2:\"id\";s:15:\"new-testimonial\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:11:\"Testimonial\";s:4:\"href\";s:79:\"https://template01.ourdemosites.com/wp-admin/post-new.php?post_type=testimonial\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:15:\"new-testimonial\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:11:\"new-gallery\";a:7:{s:2:\"id\";s:11:\"new-gallery\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:7:\"Gallery\";s:4:\"href\";s:75:\"https://template01.ourdemosites.com/wp-admin/post-new.php?post_type=gallery\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:11:\"new-gallery\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:11:\"new-service\";a:7:{s:2:\"id\";s:11:\"new-service\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:7:\"Service\";s:4:\"href\";s:75:\"https://template01.ourdemosites.com/wp-admin/post-new.php?post_type=service\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:11:\"new-service\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:8:\"new-user\";a:7:{s:2:\"id\";s:8:\"new-user\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:4:\"User\";s:4:\"href\";s:57:\"https://template01.ourdemosites.com/wp-admin/user-new.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"new-user\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:8:\"new-team\";a:7:{s:2:\"id\";s:8:\"new-team\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:6:\"Member\";s:4:\"href\";s:72:\"https://template01.ourdemosites.com/wp-admin/post-new.php?post_type=team\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:8:\"new-team\";s:6:\"parent\";s:11:\"new-content\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"new-content\";}s:4:\"edit\";a:7:{s:2:\"id\";s:4:\"edit\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:9:{s:5:\"title\";s:9:\"Edit Item\";s:4:\"href\";s:17:\"[post editor URL]\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:4:\"edit\";}s:6:\"parent\";b:0;}s:4:\"view\";a:7:{s:2:\"id\";s:4:\"view\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:9:{s:5:\"title\";s:9:\"View Item\";s:4:\"href\";s:18:\"[post or page URL]\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:4:\"view\";}s:6:\"parent\";b:0;}s:11:\"autoptimize\";a:9:{s:2:\"id\";s:11:\"autoptimize\";s:5:\"group\";b:0;s:5:\"title\";s:42:\"<span class=\"ab-label\">Optimization</span>\";s:4:\"href\";s:1:\"#\";s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:70:\"<span class=\"ab-icon\"></span><span class=\"ab-label\">Autoptimize</span>\";s:4:\"href\";s:81:\"https://template01.ourdemosites.com/wp-admin/options-general.php?page=autoptimize\";s:5:\"class\";s:12:\"bullet-green\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:11:\"autoptimize\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:22:\"autoptimize-cache-info\";a:7:{s:2:\"id\";s:22:\"autoptimize-cache-info\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:480:\"<p>Cache Info</p><div class=\"autoptimize-radial-bar\" percentage=\"2\"><div class=\"autoptimize-circle\"><div class=\"mask full\"><div class=\"fill bg-green\"></div></div><div class=\"mask half\"><div class=\"fill bg-green\"></div></div><div class=\"shadow\"></div></div><div class=\"inset\"><div class=\"percentage\"><div class=\"numbers green\">2%</div></div></div></div><table><tr><td>Size:</td><td class=\"size green\">6.42 MB</td></tr><tr><td>Files:</td><td class=\"files white\">36</td></tr></table>\";s:4:\"href\";b:0;s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:22:\"autoptimize-cache-info\";s:6:\"parent\";s:11:\"autoptimize\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"autoptimize\";}s:24:\"autoptimize-delete-cache\";a:8:{s:2:\"id\";s:24:\"autoptimize-delete-cache\";s:5:\"group\";b:0;s:5:\"title\";s:11:\"Purge Cache\";s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:12:\"Delete Cache\";s:4:\"href\";b:0;s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:24:\"autoptimize-delete-cache\";s:6:\"parent\";s:11:\"autoptimize\";s:5:\"group\";b:0;}s:6:\"parent\";s:11:\"autoptimize\";}s:4:\"w3tc\";a:9:{s:2:\"id\";s:4:\"w3tc\";s:5:\"group\";b:0;s:5:\"title\";s:11:\"Performance\";s:4:\"href\";s:1:\"#\";s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:203:\"<img src=\"https://template01.ourdemosites.com/wp-content/plugins/w3-total-cache/pub/img/w3tc-sprite-admin-bar.png\" style=\"vertical-align:middle; margin-right:5px; width: 29px; height: 29px\" />Performance\";s:4:\"href\";s:74:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:4:\"w3tc\";s:6:\"parent\";b:0;s:5:\"group\";b:0;}s:6:\"parent\";b:0;}s:20:\"w3tc_overlay_upgrade\";a:7:{s:2:\"id\";s:20:\"w3tc_overlay_upgrade\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:70:\"<span style=\"color: red; background: none;\">Upgrade Performance</span>\";s:4:\"href\";s:140:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard&amp;w3tc_message_action=licensing_upgrade&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:20:\"w3tc_overlay_upgrade\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:14:\"w3tc_flush_all\";a:8:{s:2:\"id\";s:14:\"w3tc_flush_all\";s:5:\"group\";b:0;s:5:\"title\";s:11:\"Purge Cache\";s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:16:\"Purge All Caches\";s:4:\"href\";s:117:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard&amp;w3tc_flush_all&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:14:\"w3tc_flush_all\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:10:\"w3tc_flush\";a:7:{s:2:\"id\";s:10:\"w3tc_flush\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:13:\"Purge Modules\";s:4:\"href\";b:0;s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:10:\"w3tc_flush\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:18:\"w3tc_flush_pgcache\";a:7:{s:2:\"id\";s:18:\"w3tc_flush_pgcache\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:15:\"Page Cache: All\";s:4:\"href\";s:121:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard&amp;w3tc_flush_pgcache&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:18:\"w3tc_flush_pgcache\";s:6:\"parent\";s:10:\"w3tc_flush\";s:5:\"group\";b:0;}s:6:\"parent\";s:10:\"w3tc_flush\";}s:18:\"w3tc_flush_dbcache\";a:7:{s:2:\"id\";s:18:\"w3tc_flush_dbcache\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:8:\"Database\";s:4:\"href\";s:121:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard&amp;w3tc_flush_dbcache&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:18:\"w3tc_flush_dbcache\";s:6:\"parent\";s:10:\"w3tc_flush\";s:5:\"group\";b:0;}s:6:\"parent\";s:10:\"w3tc_flush\";}s:22:\"w3tc_flush_objectcache\";a:7:{s:2:\"id\";s:22:\"w3tc_flush_objectcache\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:12:\"Object Cache\";s:4:\"href\";s:125:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_dashboard&amp;w3tc_flush_objectcache&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:22:\"w3tc_flush_objectcache\";s:6:\"parent\";s:10:\"w3tc_flush\";s:5:\"group\";b:0;}s:6:\"parent\";s:10:\"w3tc_flush\";}s:18:\"w3tc_flush_opcache\";a:7:{s:2:\"id\";s:18:\"w3tc_flush_opcache\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:12:\"Opcode Cache\";s:4:\"href\";s:76:\"admin.php?page=w3tc_dashboard&amp;w3tc_opcache_flush&amp;_wpnonce=bf9adee3ec\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:18:\"w3tc_flush_opcache\";s:6:\"parent\";s:10:\"w3tc_flush\";s:5:\"group\";b:0;}s:6:\"parent\";s:10:\"w3tc_flush\";}s:21:\"w3tc_settings_general\";a:7:{s:2:\"id\";s:21:\"w3tc_settings_general\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:16:\"General Settings\";s:4:\"href\";s:96:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_general&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:21:\"w3tc_settings_general\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:24:\"w3tc_settings_extensions\";a:7:{s:2:\"id\";s:24:\"w3tc_settings_extensions\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:17:\"Manage Extensions\";s:4:\"href\";s:99:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_extensions&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:24:\"w3tc_settings_extensions\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:17:\"w3tc_settings_faq\";a:7:{s:2:\"id\";s:17:\"w3tc_settings_faq\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:3:\"FAQ\";s:4:\"href\";s:92:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_faq&amp;_wpnonce=0666cba170\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:17:\"w3tc_settings_faq\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:12:\"w3tc_support\";a:7:{s:2:\"id\";s:12:\"w3tc_support\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:1;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:7:\"Support\";s:4:\"href\";s:72:\"https://template01.ourdemosites.com/wp-admin/admin.php?page=w3tc_support\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:12:\"w3tc_support\";s:6:\"parent\";s:4:\"w3tc\";s:5:\"group\";b:0;}s:6:\"parent\";s:4:\"w3tc\";}s:13:\"top-secondary\";a:7:{s:2:\"id\";s:13:\"top-secondary\";s:5:\"group\";b:1;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";b:0;s:4:\"href\";b:0;s:5:\"class\";s:16:\"ab-top-secondary\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:13:\"top-secondary\";s:6:\"parent\";b:0;s:5:\"group\";b:1;}s:6:\"parent\";b:0;}s:6:\"search\";a:7:{s:2:\"id\";s:6:\"search\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:10:{s:5:\"title\";s:13:\"[Search Form]\";s:4:\"href\";s:0:\"\";s:5:\"class\";s:16:\"admin-bar-search\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";i:-1;s:6:\"parent\";s:13:\"top-secondary\";s:2:\"id\";s:6:\"search\";}s:6:\"parent\";s:13:\"top-secondary\";}s:10:\"my-account\";a:7:{s:2:\"id\";s:10:\"my-account\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:58:\"Howdy, <span class=\"display-name\">Higher Visibility</span>\";s:4:\"href\";s:56:\"https://template01.ourdemosites.com/wp-admin/profile.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:10:\"my-account\";s:6:\"parent\";s:13:\"top-secondary\";s:5:\"group\";b:0;}s:6:\"parent\";s:13:\"top-secondary\";}s:12:\"user-actions\";a:7:{s:2:\"id\";s:12:\"user-actions\";s:5:\"group\";b:1;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";b:0;s:4:\"href\";b:0;s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:12:\"user-actions\";s:6:\"parent\";s:10:\"my-account\";s:5:\"group\";b:1;}s:6:\"parent\";s:10:\"my-account\";}s:9:\"user-info\";a:7:{s:2:\"id\";s:9:\"user-info\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:97:\"<span class=\'display-name\'>Higher Visibility</span><span class=\'username\'>highervisibility</span>\";s:4:\"href\";s:56:\"https://template01.ourdemosites.com/wp-admin/profile.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";i:-1;s:2:\"id\";s:9:\"user-info\";s:6:\"parent\";s:12:\"user-actions\";s:5:\"group\";b:0;}s:6:\"parent\";s:12:\"user-actions\";}s:12:\"edit-profile\";a:7:{s:2:\"id\";s:12:\"edit-profile\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:15:\"Edit My Profile\";s:4:\"href\";s:56:\"https://template01.ourdemosites.com/wp-admin/profile.php\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:12:\"edit-profile\";s:6:\"parent\";s:12:\"user-actions\";s:5:\"group\";b:0;}s:6:\"parent\";s:12:\"user-actions\";}s:6:\"logout\";a:7:{s:2:\"id\";s:6:\"logout\";s:5:\"group\";b:0;s:9:\"is_custom\";b:0;s:9:\"is_hidden\";b:0;s:19:\"is_visible_to_actor\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"title\";s:7:\"Log Out\";s:4:\"href\";s:86:\"https://template01.ourdemosites.com/wp-login.php?action=logout&amp;_wpnonce=0419ff1816\";s:5:\"class\";s:0:\"\";s:4:\"html\";N;s:7:\"onclick\";N;s:6:\"target\";N;s:9:\"titleAttr\";N;s:8:\"tabindex\";N;s:2:\"id\";s:6:\"logout\";s:6:\"parent\";s:12:\"user-actions\";s:5:\"group\";b:0;}s:6:\"parent\";s:12:\"user-actions\";}}s:13:\"plugin_access\";s:11:\"super_admin\";s:15:\"allowed_user_id\";N;}", "no");
INSERT INTO `wp_options` VALUES("2467", "as3cf_tool_errors_uploader", "0", "no");
INSERT INTO `wp_options` VALUES("3425", "options_partner_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("3426", "_options_partner_toggle", "field_58f4fd6095a25", "no");
INSERT INTO `wp_options` VALUES("3472", "soi_options_values", "a:11:{s:13:\"soi_alt_value\";s:6:\"%title\";s:15:\"soi_title_value\";s:0:\"\";s:22:\"soi_override_alt_value\";s:1:\"1\";s:24:\"soi_override_title_value\";s:1:\"1\";s:29:\"soi_override_thumbnail_images\";s:1:\"1\";s:21:\"soi_exclude_post_type\";s:0:\"\";s:20:\"soi_exclude_post_ids\";s:0:\"\";s:20:\"soi_exclude_post_cat\";s:0:\"\";s:21:\"soi_exclude_post_tags\";s:0:\"\";s:20:\"soi_exclude_page_ids\";s:0:\"\";s:29:\"soi_override_yost_primary_cat\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("3516", "as3cf_tool_errors_download_and_remover", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("3558", "critSettings", "{\"inpath\":{\"dummy\":\"dummy\"},\"type\":{\"dummy\":\"dummy\",\"is_front_page\":\"critcss_863b6ff79353fe70d2594690f69399bb.css\"}}", "yes");
INSERT INTO `wp_options` VALUES("3559", "critLicense", "843cf1c7-9a71-475b-96f0-4a31ea82ba29", "yes");
INSERT INTO `wp_options` VALUES("3725", "type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4581", "ai1wm_updater", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4908", "_site_transient_as3cfpro_plugins_to_install_installer", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("4911", "_transient_frm_options", "O:11:\"FrmSettings\":24:{s:11:\"option_name\";s:11:\"frm_options\";s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:9:\"fade_form\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:6:\"re_msg\";N;s:8:\"re_multi\";N;}", "yes");
INSERT INTO `wp_options` VALUES("5045", "wsh_license_manager-admin-menu-editor-pro", "a:4:{s:11:\"license_key\";N;s:10:\"site_token\";s:32:\"K778KN2M719JOQ5LKL67L0NG5NPSB16L\";s:7:\"license\";a:8:{s:12:\"product_slug\";s:21:\"admin-menu-editor-pro\";s:6:\"status\";s:5:\"valid\";s:9:\"issued_on\";s:25:\"2017-01-12T21:45:59+00:00\";s:9:\"max_sites\";N;s:10:\"expires_on\";s:25:\"2022-02-12T16:35:21+00:00\";s:8:\"site_url\";s:34:\"http://template01.ourdemosites.com\";s:6:\"addons\";O:8:\"stdClass\":2:{s:17:\"wp-toolbar-editor\";s:24:\"WordPress Toolbar Editor\";s:19:\"ame-branding-add-on\";s:15:\"Branding Add-on\";}s:11:\"renewal_url\";s:41:\"http://adminmenueditor.com/renew-license/\";}s:13:\"token_history\";a:1:{s:32:\"K778KN2M719JOQ5LKL67L0NG5NPSB16L\";s:34:\"http://template01.ourdemosites.com\";}}", "no");
INSERT INTO `wp_options` VALUES("5046", "ame_pro_external_updates", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1613564889;s:14:\"checkedVersion\";s:4:\"2.13\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"admin-menu-editor-pro\";s:7:\"version\";s:4:\"2.13\";s:12:\"download_url\";s:161:\"https://adminmenueditor.com/?get_product=admin-menu-editor-pro&license_token=K778KN2M719JOQ5LKL67L0NG5NPSB16L&license_site_url=http://template01.ourdemosites.com\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:27:\"http://adminmenueditor.com/\";s:6:\"tested\";s:5:\"5.6.1\";s:12:\"requires_php\";N;s:14:\"upgrade_notice\";N;s:5:\"icons\";a:2:{s:2:\"1x\";s:121:\"https://adminmenueditor.com/wp-content/plugins/ame-paypal-helper/wp-update-server/icons/admin-menu-editor-pro-128x128.png\";s:2:\"2x\";s:121:\"https://adminmenueditor.com/wp-content/plugins/ame-paypal-helper/wp-update-server/icons/admin-menu-editor-pro-256x256.png\";}s:8:\"filename\";s:37:\"admin-menu-editor-pro/menu-editor.php\";}s:11:\"updateClass\";s:23:\"Puc_v4p10_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}", "no");
INSERT INTO `wp_options` VALUES("5261", "theme_mods_framework", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"mainnav\";i:2;s:8:\"aboutnav\";i:3;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1494519393;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"orphaned_widgets_1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("5380", "options_ga_tracking", "", "no");
INSERT INTO `wp_options` VALUES("5381", "_options_ga_tracking", "field_58aefa7b743eb", "no");
INSERT INTO `wp_options` VALUES("5382", "options_ca_tracking", "", "no");
INSERT INTO `wp_options` VALUES("5383", "_options_ca_tracking", "field_58aefa95743ec", "no");
INSERT INTO `wp_options` VALUES("5384", "options_banner_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("5385", "_options_banner_toggle", "field_5914ce933152a", "no");
INSERT INTO `wp_options` VALUES("5386", "options_profiles_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("5387", "_options_profiles_toggle", "field_5914cea23152b", "no");
INSERT INTO `wp_options` VALUES("5388", "options_badges_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("5389", "_options_badges_toggle", "field_58f4fd6095a25", "no");
INSERT INTO `wp_options` VALUES("5417", "options_profile_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("5418", "_options_profile_toggle", "field_5914cea23152b", "no");
INSERT INTO `wp_options` VALUES("5427", "options_company_email", "info@consultant.com", "no");
INSERT INTO `wp_options` VALUES("5428", "_options_company_email", "field_5832c7cd41d5f", "no");
INSERT INTO `wp_options` VALUES("5429", "options_company_phone", "123-456-7890", "no");
INSERT INTO `wp_options` VALUES("5430", "_options_company_phone", "field_5832c7e8768a7", "no");
INSERT INTO `wp_options` VALUES("5431", "options_company_pricing", "$$", "no");
INSERT INTO `wp_options` VALUES("5432", "_options_company_pricing", "field_58c968a64d2a2", "no");
INSERT INTO `wp_options` VALUES("5433", "options_hours_0_company_day", "Monday", "no");
INSERT INTO `wp_options` VALUES("5434", "_options_hours_0_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5435", "options_hours_0_company_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("5436", "_options_hours_0_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5437", "options_hours_1_company_day", "Tuesday", "no");
INSERT INTO `wp_options` VALUES("5438", "_options_hours_1_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5439", "options_hours_1_company_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("5440", "_options_hours_1_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5441", "options_hours_2_company_day", "Wednesday", "no");
INSERT INTO `wp_options` VALUES("5442", "_options_hours_2_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5443", "options_hours_2_company_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("5444", "_options_hours_2_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5445", "options_hours_3_company_day", "Thursday", "no");
INSERT INTO `wp_options` VALUES("5446", "_options_hours_3_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5447", "options_hours_3_company_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("5448", "_options_hours_3_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5449", "options_hours_4_company_day", "Friday", "no");
INSERT INTO `wp_options` VALUES("5450", "_options_hours_4_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5451", "options_hours_4_company_time", "08:00 am - 10:00 pm", "no");
INSERT INTO `wp_options` VALUES("5452", "_options_hours_4_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5453", "options_header_button_text", "Get an Appointment", "no");
INSERT INTO `wp_options` VALUES("5454", "_options_header_button_text", "field_5914dbb21b517", "no");
INSERT INTO `wp_options` VALUES("5455", "options_header_button_link", "a:3:{s:5:\"title\";s:10:\"Learn More\";s:3:\"url\";s:44:\"https://template01.ourdemosites.com/contact/\";s:6:\"target\";s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("5456", "_options_header_button_link", "field_5914dbbe1b518", "no");
INSERT INTO `wp_options` VALUES("5457", "options_footer_text", "Lorem ipsum dolor sit consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna veniam aliqua.", "no");
INSERT INTO `wp_options` VALUES("5458", "_options_footer_text", "field_583433fd781e1", "no");
INSERT INTO `wp_options` VALUES("5459", "options_copyright", "Our Demo Sites. All rights reserved. <a href=\"https://www.highervisibility.com/website-design/?utm_source=client_website&utm_medium=footer_link&source=663504\" target=\"_blank\" rel=\"nofollow\">Website by HigherVisibility</a>", "no");
INSERT INTO `wp_options` VALUES("5460", "_options_copyright", "field_583434b8781e8", "no");
INSERT INTO `wp_options` VALUES("5461", "options_primary", "#2e5797", "no");
INSERT INTO `wp_options` VALUES("5462", "_options_primary", "field_588a843831b1c", "no");
INSERT INTO `wp_options` VALUES("5463", "options_page_banner", "", "no");
INSERT INTO `wp_options` VALUES("5464", "_options_page_banner", "field_5914db451b516", "no");
INSERT INTO `wp_options` VALUES("5486", "options_company_logo", "38", "no");
INSERT INTO `wp_options` VALUES("5487", "_options_company_logo", "field_583433bd781dd", "no");
INSERT INTO `wp_options` VALUES("5491", "options_company_hours_0_company_day", "Monday", "no");
INSERT INTO `wp_options` VALUES("5492", "_options_company_hours_0_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5493", "options_company_hours_0_company_time", "8:00am - 10:00pm", "no");
INSERT INTO `wp_options` VALUES("5494", "_options_company_hours_0_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5495", "options_company_hours_1_company_day", "Tuesday", "no");
INSERT INTO `wp_options` VALUES("5496", "_options_company_hours_1_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5497", "options_company_hours_1_company_time", "8:00am - 10:00pm", "no");
INSERT INTO `wp_options` VALUES("5498", "_options_company_hours_1_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5499", "options_company_hours_2_company_day", "Wednesday", "no");
INSERT INTO `wp_options` VALUES("5500", "_options_company_hours_2_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5501", "options_company_hours_2_company_time", "8:00am - 10:00pm", "no");
INSERT INTO `wp_options` VALUES("5502", "_options_company_hours_2_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5503", "options_company_hours_3_company_day", "Thursday", "no");
INSERT INTO `wp_options` VALUES("5504", "_options_company_hours_3_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5505", "options_company_hours_3_company_time", "8:00am - 10:00pm", "no");
INSERT INTO `wp_options` VALUES("5506", "_options_company_hours_3_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5507", "options_company_hours_4_company_day", "Friday", "no");
INSERT INTO `wp_options` VALUES("5508", "_options_company_hours_4_company_day", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5509", "options_company_hours_4_company_time", "8:00am - 10:00pm", "no");
INSERT INTO `wp_options` VALUES("5510", "_options_company_hours_4_company_time", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("5511", "options_company_hours", "5", "no");
INSERT INTO `wp_options` VALUES("5512", "_options_company_hours", "field_58343514781ee", "no");
INSERT INTO `wp_options` VALUES("5514", "options_company_hours_0_company_days", "Monday", "no");
INSERT INTO `wp_options` VALUES("5515", "_options_company_hours_0_company_days", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5516", "options_company_hours_1_company_days", "Tuesday", "no");
INSERT INTO `wp_options` VALUES("5517", "_options_company_hours_1_company_days", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5518", "options_company_hours_2_company_days", "Wednesday", "no");
INSERT INTO `wp_options` VALUES("5519", "_options_company_hours_2_company_days", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5520", "options_company_hours_3_company_days", "Thursday", "no");
INSERT INTO `wp_options` VALUES("5521", "_options_company_hours_3_company_days", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5522", "options_company_hours_4_company_days", "Friday", "no");
INSERT INTO `wp_options` VALUES("5523", "_options_company_hours_4_company_days", "field_58343523781ef", "no");
INSERT INTO `wp_options` VALUES("5537", "options_accent", "#184b96", "no");
INSERT INTO `wp_options` VALUES("5538", "_options_accent", "field_588a843831b1c", "no");
INSERT INTO `wp_options` VALUES("5567", "options_member_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("5568", "_options_member_toggle", "field_58u4kh9237d95", "no");
INSERT INTO `wp_options` VALUES("5856", "options_custom_css", "body { background: red !important; }", "no");
INSERT INTO `wp_options` VALUES("5857", "_options_custom_css", "field_589753kd768w2", "no");
INSERT INTO `wp_options` VALUES("5861", "options_custom", "\r\n\r\n\r\n\r\n", "no");
INSERT INTO `wp_options` VALUES("5862", "_options_custom", "field_589753kd768w2", "no");
INSERT INTO `wp_options` VALUES("5863", "w3tc_generic_widgetservices", "{\"items\":[{\"name\":\"Premium Support Response (Usually <1h First Response)\",\"parameter_name\":\"field4\",\"parameter_value\":\"Premium Support Response (Usually <1h First Response)\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Performance Audit \\/ Consult (Theme, Plugin, Content, Server)\",\"parameter_name\":\"field4\",\"parameter_value\":\"Performance Audit \\/ Consult (Theme, Plugin, Content, Server)\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Plugin Configuration\",\"parameter_name\":\"field4\",\"parameter_value\":\"Plugin Configuration\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"SSL Performance Setup\",\"parameter_name\":\"field4\",\"parameter_value\":\"SSL Performance Setup\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Full Site Delivery Setup\",\"parameter_name\":\"field4\",\"parameter_value\":\"Full Site Delivery Setup\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Hosting Environment Troubleshooting\",\"parameter_name\":\"field4\",\"parameter_value\":\"Hosting Environment Troubleshooting\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Performance Monitoring\",\"parameter_name\":\"field4\",\"parameter_value\":\"Performance Monitoring\",\"form_hash\":\"m5pom8z0qy59rm\"}],\"expires\":1517849252}", "no");
INSERT INTO `wp_options` VALUES("6105", "gallery_type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6495", "service_type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6671", "ure_tasks_queue", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("7867", "ewww_image_optimizer_tracking_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("8017", "ws_ame_dashboard_widgets", "{\n    \"format\": {\n        \"name\": \"Admin Menu Editor dashboard widgets\",\n        \"version\": \"1.1\"\n    },\n    \"widgets\": [\n        {\n            \"id\": \"dashboard_right_now\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": {\n                \"role:administrator\": false,\n                \"role:client\": false,\n                \"user:highervisibility\": false\n            },\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"At a Glance\",\n                \"location\": \"normal\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/dashboard.php\"\n        },\n        {\n            \"id\": \"dashboard_activity\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Activity\",\n                \"location\": \"normal\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/dashboard.php\"\n        },\n        {\n            \"id\": \"wordfence_activity_report_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": {\n                \"role:administrator\": false,\n                \"role:client\": false,\n                \"user:highervisibility\": false\n            },\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Wordfence activity in the past week\",\n                \"location\": \"normal\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordfence\\/lib\\/wfActivityReport.php\"\n        },\n        {\n            \"id\": \"wpseo-dashboard-overview\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": {\n                \"role:administrator\": false,\n                \"role:client\": false,\n                \"user:highervisibility\": false\n            },\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Yoast SEO Posts Overview\",\n                \"location\": \"normal\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/class-yoast-dashboard-widget.php\"\n        },\n        {\n            \"id\": \"dashboard_quick_press\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": {\n                \"role:administrator\": false,\n                \"role:client\": false,\n                \"user:highervisibility\": false\n            },\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"<span class=\\\"hide-if-no-js\\\">Quick Draft<\\/span> <span class=\\\"hide-if-js\\\">Your Recent Drafts<\\/span>\",\n                \"location\": \"side\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/dashboard.php\"\n        },\n        {\n            \"id\": \"dashboard_primary\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": {\n                \"role:administrator\": false,\n                \"role:client\": false,\n                \"user:highervisibility\": false\n            },\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"WordPress Events and News\",\n                \"location\": \"side\",\n                \"priority\": \"core\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/dashboard.php\"\n        },\n        {\n            \"id\": \"visibility_seo_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Search Engine Optimization\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        },\n        {\n            \"id\": \"visibility_ppc_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Paid Search Management\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        },\n        {\n            \"id\": \"rankology_seo_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": false,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Search Engine Optimization\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": false,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        },\n        {\n            \"id\": \"rankology_ppc_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": false,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Paid Search Management\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": false,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        },\n        {\n            \"id\": \"recent_forms_entry_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Recent Leads\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        },\n        {\n            \"id\": \"request_widget\",\n            \"title\": \"\",\n            \"location\": \"\",\n            \"priority\": \"\",\n            \"isPresent\": true,\n            \"grantAccess\": [],\n            \"widgetType\": \"wrapper\",\n            \"wrappedWidget\": {\n                \"title\": \"Request Form\",\n                \"location\": \"side\",\n                \"priority\": \"high\"\n            },\n            \"wasPresent\": true,\n            \"callbackFileName\": \"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/themes\\/framework\\/inc\\/core-dashboards.php\"\n        }\n    ],\n    \"welcomePanel\": [],\n    \"siteComponentHash\": \"0b654bc5fe269b910f59778dc26a9554\"\n}", "no");
INSERT INTO `wp_options` VALUES("8101", "wppusher_token", "84857c8da6da850b7e9b63386247ac09791bea0d98ae50e64843fedb94d0139e", "yes");
INSERT INTO `wp_options` VALUES("8102", "gl_base_url", "https://gitlab.com", "yes");
INSERT INTO `wp_options` VALUES("8110", "wppusher_license_key", "0ccac168-038f-4d38-ac8d-7bdfee3a9d47", "yes");
INSERT INTO `wp_options` VALUES("8115", "gh_token", "0f74b22d576d20fb1bcdf5dfb82ec368fd795169", "yes");
INSERT INTO `wp_options` VALUES("8303", "wpm_pages_config", "a:24:{s:9:\"dashboard\";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:34;}s:9:\"edit-post\";a:2:{i:0;i:31;i:1;i:30;}s:4:\"post\";a:26:{i:0;i:29;i:1;i:5;i:2;i:6;i:3;i:7;i:4;i:10;i:5;i:11;i:6;i:12;i:7;i:13;i:8;i:14;i:9;i:65;i:10;i:66;i:11;i:96;i:12;i:15;i:13;i:16;i:14;i:17;i:15;i:18;i:16;i:19;i:17;i:20;i:18;i:21;i:19;i:22;i:20;i:23;i:21;i:67;i:22;i:35;i:23;i:43;i:24;i:48;i:25;i:4;}s:9:\"edit-page\";a:2:{i:0;i:25;i:1;i:26;}s:4:\"page\";a:46:{i:0;i:24;i:1;i:5;i:2;i:6;i:3;i:7;i:4;i:10;i:5;i:11;i:6;i:12;i:7;i:13;i:8;i:14;i:9;i:65;i:10;i:66;i:11;i:96;i:12;i:15;i:13;i:16;i:14;i:17;i:15;i:18;i:16;i:19;i:17;i:20;i:18;i:21;i:19;i:22;i:20;i:23;i:21;i:67;i:22;i:43;i:23;i:48;i:24;i:49;i:25;i:97;i:26;i:98;i:27;i:99;i:28;i:100;i:29;i:102;i:30;i:103;i:31;i:104;i:32;i:105;i:33;i:106;i:34;i:107;i:35;i:108;i:36;i:109;i:37;i:110;i:38;i:111;i:39;i:112;i:40;i:113;i:41;i:114;i:42;i:115;i:43;i:116;i:44;i:117;i:45;i:118;}s:13:\"edit-post_tag\";a:1:{i:0;i:33;}s:13:\"edit-category\";a:1:{i:0;i:32;}s:6:\"upload\";a:2:{i:0;i:27;i:1;i:28;}s:13:\"edit-comments\";a:1:{i:0;i:37;}s:7:\"profile\";a:1:{i:0;i:41;}s:9:\"nav-menus\";a:3:{i:0;i:45;i:1;i:46;i:2;i:47;}s:12:\"edit-product\";a:1:{i:0;i:51;}s:7:\"product\";a:9:{i:0;i:43;i:1;i:48;i:2;i:49;i:3;i:56;i:4;i:57;i:5;i:58;i:6;i:59;i:7;i:60;i:8;i:61;}s:16:\"edit-product_cat\";a:1:{i:0;i:52;}s:16:\"edit-product_tag\";a:1:{i:0;i:53;}s:27:\"edit-product_shipping_class\";a:1:{i:0;i:54;}s:31:\"product_page_product_attributes\";a:1:{i:0;i:55;}s:15:\"edit-shop_order\";a:1:{i:0;i:62;}s:16:\"edit-shop_coupon\";a:1:{i:0;i:64;}s:27:\"woocommerce_page_wc-reports\";a:1:{i:0;i:63;}s:27:\"toplevel_page_gf_edit_forms\";a:2:{i:0;i:91;i:1;i:95;}s:22:\"forms_page_gf_new_form\";a:1:{i:0;i:92;}s:22:\"forms_page_gf_settings\";a:1:{i:0;i:41;}s:21:\"forms_page_gf_entries\";a:1:{i:0;i:94;}}", "yes");
INSERT INTO `wp_options` VALUES("8304", "wpm_pages_sections_config", "a:24:{s:9:\"dashboard\";a:2:{i:0;s:9:\"dashboard\";i:1;s:5:\"posts\";}s:9:\"edit-post\";a:1:{i:0;s:5:\"posts\";}s:4:\"post\";a:4:{i:0;s:6:\"editor\";i:1;s:6:\"images\";i:2;s:5:\"posts\";i:3;s:3:\"seo\";}s:9:\"edit-page\";a:1:{i:0;s:5:\"pages\";}s:4:\"page\";a:5:{i:0;s:6:\"editor\";i:1;s:6:\"images\";i:2;s:5:\"pages\";i:3;s:3:\"seo\";i:4;s:12:\"page_builder\";}s:13:\"edit-post_tag\";a:1:{i:0;s:5:\"posts\";}s:13:\"edit-category\";a:1:{i:0;s:5:\"posts\";}s:6:\"upload\";a:1:{i:0;s:5:\"media\";}s:13:\"edit-comments\";a:1:{i:0;s:8:\"comments\";}s:7:\"profile\";a:1:{i:0;s:7:\"profile\";}s:9:\"nav-menus\";a:1:{i:0;s:5:\"menus\";}s:12:\"edit-product\";a:1:{i:0;s:20:\"woocommerce_products\";}s:7:\"product\";a:1:{i:0;s:20:\"woocommerce_products\";}s:16:\"edit-product_cat\";a:1:{i:0;s:20:\"woocommerce_products\";}s:16:\"edit-product_tag\";a:1:{i:0;s:20:\"woocommerce_products\";}s:27:\"edit-product_shipping_class\";a:1:{i:0;s:20:\"woocommerce_products\";}s:31:\"product_page_product_attributes\";a:1:{i:0;s:20:\"woocommerce_products\";}s:15:\"edit-shop_order\";a:1:{i:0;s:11:\"woocommerce\";}s:16:\"edit-shop_coupon\";a:1:{i:0;s:11:\"woocommerce\";}s:27:\"woocommerce_page_wc-reports\";a:1:{i:0;s:11:\"woocommerce\";}s:27:\"toplevel_page_gf_edit_forms\";a:1:{i:0;s:13:\"gravity_forms\";}s:22:\"forms_page_gf_new_form\";a:1:{i:0;s:13:\"gravity_forms\";}s:22:\"forms_page_gf_settings\";a:1:{i:0;s:13:\"gravity_forms\";}s:21:\"forms_page_gf_entries\";a:1:{i:0;s:13:\"gravity_forms\";}}", "yes");
INSERT INTO `wp_options` VALUES("8305", "vum_enable_embed_video", "O:8:\"stdClass\":1:{s:6:\"status\";i:4;}", "yes");
INSERT INTO `wp_options` VALUES("8307", "wpm_external_updater", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1613577503;s:14:\"checkedVersion\";s:5:\"2.5.9\";s:6:\"update\";O:8:\"stdClass\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:18:\"video-user-manuals\";s:7:\"version\";s:6:\"2.5.10\";s:8:\"homepage\";s:28:\"https://videousermanuals.com\";s:12:\"download_url\";s:100:\"https://wordpress.videousermanuals.com/video-user-manuals/dl.php?file=video-user-manuals-v2.5.10.zip\";s:14:\"upgrade_notice\";s:36:\"Various bug fixes and enhancements..\";}}", "yes");
INSERT INTO `wp_options` VALUES("8507", "ws_ame_meta_boxes", "{\"format\":{\"name\":\"Admin Menu Editor meta boxes\",\"version\":\"2.0\"},\"screens\":{\"acf-field-group\":{\"metaBoxes:\":{\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"}},\"postTypeFeatures:\":[]},\"gallery\":{\"metaBoxes:\":{\"gallery_typediv\":{\"id\":\"gallery_typediv\",\"title\":\"Categories\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"},\"acf-group_5988a08c06085\":{\"id\":\"acf-group_5988a08c06085\",\"title\":\"Home Layout\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_582d95848fb08\":{\"id\":\"acf-group_582d95848fb08\",\"title\":\"Home Settings\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_591b27c142fc7\":{\"id\":\"acf-group_591b27c142fc7\",\"title\":\"Services\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_588a5b92db96f\":{\"id\":\"acf-group_588a5b92db96f\",\"title\":\"Testimonial\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_582d835f5628a\":{\"id\":\"acf-group_582d835f5628a\",\"title\":\"Theme Settings\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_5877ac8722496\":{\"id\":\"acf-group_5877ac8722496\",\"title\":\"Theme Controls\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_5877ac8456856\":{\"id\":\"acf-group_5877ac8456856\",\"title\":\"Post Type Control\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_597f58de2faa7\":{\"id\":\"acf-group_597f58de2faa7\",\"title\":\"Gallery - Item\",\"context\":\"acf_after_title\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"}},\"postTypeFeatures:\":[]},\"page\":{\"metaBoxes:\":{\"authordiv\":{\"id\":\"authordiv\",\"title\":\"Author\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"commentsdiv\":{\"id\":\"commentsdiv\",\"title\":\"Comments\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"commentstatusdiv\":{\"id\":\"commentstatusdiv\",\"title\":\"Discussion\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"pageparentdiv\":{\"id\":\"pageparentdiv\",\"title\":\"Page Attributes\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postcustom\":{\"id\":\"postcustom\",\"title\":\"Custom Fields\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"revisionsdiv\":{\"id\":\"revisionsdiv\",\"title\":\"Revisions\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"},\"acf-group_5988a08c06085\":{\"id\":\"acf-group_5988a08c06085\",\"title\":\"Home Layout\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_582d95848fb08\":{\"id\":\"acf-group_582d95848fb08\",\"title\":\"Home Settings\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_591b27c142fc7\":{\"id\":\"acf-group_591b27c142fc7\",\"title\":\"Services\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_588a5b92db96f\":{\"id\":\"acf-group_588a5b92db96f\",\"title\":\"Testimonial\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_582d835f5628a\":{\"id\":\"acf-group_582d835f5628a\",\"title\":\"Theme Settings\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_5877ac8722496\":{\"id\":\"acf-group_5877ac8722496\",\"title\":\"Theme Controls\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_5877ac8456856\":{\"id\":\"acf-group_5877ac8456856\",\"title\":\"Post Type Control\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"},\"acf-group_597f58de2faa7\":{\"id\":\"acf-group_597f58de2faa7\",\"title\":\"Gallery - Item\",\"context\":\"acf_after_title\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"}},\"postTypeFeatures:\":{\"title\":{\"id\":\"title\",\"title\":\"Title\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true},\"editor\":{\"id\":\"editor\",\"title\":\"Content Editor\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true}}},\"post\":{\"metaBoxes:\":{\"authordiv\":{\"id\":\"authordiv\",\"title\":\"Author\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"categorydiv\":{\"id\":\"categorydiv\",\"title\":\"Categories\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"commentsdiv\":{\"id\":\"commentsdiv\",\"title\":\"Comments\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"commentstatusdiv\":{\"id\":\"commentstatusdiv\",\"title\":\"Discussion\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postcustom\":{\"id\":\"postcustom\",\"title\":\"Custom Fields\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postexcerpt\":{\"id\":\"postexcerpt\",\"title\":\"Excerpt\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"revisionsdiv\":{\"id\":\"revisionsdiv\",\"title\":\"Revisions\",\"context\":\"normal\",\"isPresent\":false,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":false,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"tagsdiv-post_tag\":{\"id\":\"tagsdiv-post_tag\",\"title\":\"Tags\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:administrator\":false},\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"trackbacksdiv\":{\"id\":\"trackbacksdiv\",\"title\":\"Send Trackbacks\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"}},\"postTypeFeatures:\":[]},\"service\":{\"metaBoxes:\":{\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"service_typediv\":{\"id\":\"service_typediv\",\"title\":\"Categories\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"},\"acf-group_591b27c142fc7\":{\"id\":\"acf-group_591b27c142fc7\",\"title\":\"Services\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/advanced-custom-fields-pro\\/includes\\/forms\\/form-post.php\"}},\"postTypeFeatures:\":{\"title\":{\"id\":\"title\",\"title\":\"Title\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true},\"editor\":{\"id\":\"editor\",\"title\":\"Content Editor\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true}}},\"team\":{\"metaBoxes:\":{\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"}},\"postTypeFeatures:\":[]},\"testimonial\":{\"metaBoxes:\":{\"postimagediv\":{\"id\":\"postimagediv\",\"title\":\"Featured Image\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Publish\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-admin\\/includes\\/meta-boxes.php\"},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":{\"role:client\":false},\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":\"\\/home\\/ourdemosites\\/public_html\\/template01\\/wp-content\\/plugins\\/wordpress-seo\\/admin\\/metabox\\/class-metabox.php\"}},\"postTypeFeatures:\":[]},\"attachment\":{\"metaBoxes:\":{\"submitdiv\":{\"id\":\"submitdiv\",\"title\":\"Save\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"s3-actions\":{\"id\":\"s3-actions\",\"title\":\"Amazon S3\",\"context\":\"side\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"commentstatusdiv\":{\"id\":\"commentstatusdiv\",\"title\":\"Discussion\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"commentsdiv\":{\"id\":\"commentsdiv\",\"title\":\"Comments\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"slugdiv\":{\"id\":\"slugdiv\",\"title\":\"Slug\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"authordiv\":{\"id\":\"authordiv\",\"title\":\"Author\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":true,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null},\"wpseo_meta\":{\"id\":\"wpseo_meta\",\"title\":\"Yoast SEO\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"ameMetaBoxWrapper\",\"wasPresent\":true,\"callbackFileName\":null}},\"postTypeFeatures:\":{\"title\":{\"id\":\"title\",\"title\":\"Title\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true}}}},\"isInitialRefreshDone\":false}", "no");
INSERT INTO `wp_options` VALUES("8572", "wpm_o_ver", "2.5.9", "yes");
INSERT INTO `wp_options` VALUES("8593", "theme_mods_template01", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"mainnav\";i:2;s:8:\"aboutnav\";i:3;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("10028", "amazon_s3_and_cloudfront_pro_version", "2.1.1", "no");
INSERT INTO `wp_options` VALUES("10192", "_transient_frmpro_options", "O:14:\"FrmProSettings\":31:{s:11:\"option_name\";s:14:\"frmpro_options\";s:8:\"edit_msg\";N;s:12:\"update_value\";N;s:17:\"already_submitted\";N;s:15:\"cal_date_format\";N;s:11:\"date_format\";N;s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:9:\"fade_form\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:7:\"re_type\";N;s:6:\"re_msg\";N;s:8:\"re_multi\";N;s:10:\"permalinks\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("10556", "wp_ewwwio_media_optimize_batch_a", "", "no");
INSERT INTO `wp_options` VALUES("10712", "options_service_type_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("10713", "_options_service_type_toggle", "field_5834b3fg84643", "no");
INSERT INTO `wp_options` VALUES("10714", "options_gallery_type_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("10715", "_options_gallery_type_toggle", "field_5834b3fg98736", "no");
INSERT INTO `wp_options` VALUES("10716", "options_clients_type_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("10717", "_options_clients_type_toggle", "field_5834b3fg89546", "no");
INSERT INTO `wp_options` VALUES("10718", "options_recent_type_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("10719", "_options_recent_type_toggle", "field_5834b3fg26748", "no");
INSERT INTO `wp_options` VALUES("10720", "options_member_type_toggle", "1", "no");
INSERT INTO `wp_options` VALUES("10721", "_options_member_type_toggle", "field_5834b3fg46820", "no");
INSERT INTO `wp_options` VALUES("11561", "wp_ewwwio_media_optimize_batch_b", "", "no");
INSERT INTO `wp_options` VALUES("11645", "slb_version", "2.7.0", "yes");
INSERT INTO `wp_options` VALUES("11646", "slb_options", "a:27:{s:7:\"enabled\";b:1;s:12:\"enabled_home\";b:0;s:12:\"enabled_post\";b:1;s:12:\"enabled_page\";b:1;s:15:\"enabled_archive\";b:1;s:14:\"enabled_widget\";b:0;s:12:\"enabled_menu\";b:0;s:11:\"group_links\";b:1;s:10:\"group_post\";b:1;s:13:\"group_gallery\";b:0;s:12:\"group_widget\";b:0;s:10:\"group_menu\";b:0;s:10:\"ui_autofit\";b:1;s:10:\"ui_animate\";b:1;s:19:\"slideshow_autostart\";b:1;s:18:\"slideshow_duration\";s:1:\"6\";s:10:\"group_loop\";b:1;s:18:\"ui_overlay_opacity\";s:3:\"0.8\";s:16:\"ui_title_default\";b:0;s:11:\"txt_loading\";s:7:\"Loading\";s:9:\"txt_close\";s:5:\"Close\";s:12:\"txt_nav_next\";s:4:\"Next\";s:12:\"txt_nav_prev\";s:8:\"Previous\";s:19:\"txt_slideshow_start\";s:15:\"Start slideshow\";s:18:\"txt_slideshow_stop\";s:14:\"Stop slideshow\";s:16:\"txt_group_status\";s:25:\"Item %current% of %total%\";s:13:\"theme_default\";s:11:\"slb_default\";}", "yes");
INSERT INTO `wp_options` VALUES("12052", "ws_ame_plugin_visibility", "{\"grantAccessByDefault\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"plugins\":{\"admin-menu-editor-pro\\/menu-editor.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"advanced-custom-fields-pro\\/acf.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"akismet\\/akismet.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"amazon-web-services\\/amazon-web-services.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"autoptimize\\/autoptimize.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"ao_critcsscom\\/ao_critcsscom.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"ewww-image-optimizer\\/ewww-image-optimizer.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"formidable\\/formidable.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"worker\\/init.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"seo-optimized-images-business\\/seo-optimized-images.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"simple-lightbox\\/main.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"video-user-manuals\\/plugin.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"w3-total-cache\\/w3-total-cache.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"wordfence\\/wordfence.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"wp-toolbar-editor\\/load.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"amazon-s3-and-cloudfront-pro\\/amazon-s3-and-cloudfront-pro.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"wppusher\\/wppusher.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"},\"wordpress-seo\\/wp-seo.php\":{\"isVisibleByDefault\":true,\"grantAccess\":{\"role:administrator\":true,\"role:client\":false,\"user:highervisibility\":true},\"customName\":\"\",\"customDescription\":\"\"}}}", "no");
INSERT INTO `wp_options` VALUES("12155", "wpm_o_user_id", "m_976b1af2253b9ed475e8bc3fd59ffe1d", "yes");
INSERT INTO `wp_options` VALUES("12156", "wpm_o_form_prefs", "O:8:\"stdClass\":3:{s:5:\"terms\";O:8:\"stdClass\":6:{s:2:\"en\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"1\";s:4:\"lang\";s:1:\"1\";s:11:\"term_manual\";s:6:\"Manual\";s:11:\"term_videos\";s:6:\"Videos\";s:16:\"term_user_manual\";s:11:\"User Manual\";s:19:\"term_manual_options\";s:7:\"Options\";s:30:\"term_wordpress_video_tutorials\";s:25:\"WordPress Video Tutorials\";s:13:\"message_intro\";s:279:\"<p>Hi, welcome to your new website! The following are some quick video tutorials which will help you get started. If you want to read the manual for some more in depth explanations on how your content management system works click <a href=\"admin.php?page=vum-ebook\">here</a>.</p>\";s:9:\"lang_code\";s:2:\"en\";}s:2:\"es\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"3\";s:4:\"lang\";s:1:\"3\";s:11:\"term_manual\";s:7:\"Manual \";s:11:\"term_videos\";s:7:\"Vídeos\";s:16:\"term_user_manual\";s:13:\"Manual de uso\";s:19:\"term_manual_options\";s:8:\"Opciones\";s:30:\"term_wordpress_video_tutorials\";s:30:\"WordPress Tutoriales en Vídeo\";s:13:\"message_intro\";s:342:\"<p>Hola, ¡bienvenido a su nuevo sitio web! A continuación encontrará varios tutoriales en vídeo que le ayudarán a empezar a usarlo. Si usted desea leer el manual completo para profundizar sus conocimientos acerca de cómo funciona su sistema de gestión de contenidos, haga clic <a href=\"wp-admin/admin.php?page=vum-ebook\">aquí</a>.</p>\";s:9:\"lang_code\";s:2:\"es\";}s:2:\"it\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"4\";s:4:\"lang\";s:1:\"5\";s:11:\"term_manual\";s:7:\"Manuale\";s:11:\"term_videos\";s:5:\"Video\";s:16:\"term_user_manual\";s:14:\"Manuale Utente\";s:19:\"term_manual_options\";s:7:\"Opzione\";s:30:\"term_wordpress_video_tutorials\";s:24:\"WordPress Video Tutorial\";s:13:\"message_intro\";s:318:\"<p>Salve, e benvenuti nel nostro nuovo sito! A seguire troverete alcuni brevi video d\'istruzione che vi aiuteranno a cominciare. Se volete leggere il manuale per avere spiegazioni più approfondite sul funzionamento del sistema di gestione del vostro contenuto, cliccate <a href=\"admin.php?page=vum-ebook\">qui</a>.</p>\";s:9:\"lang_code\";s:2:\"it\";}s:2:\"pt\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"5\";s:4:\"lang\";s:1:\"4\";s:11:\"term_manual\";s:6:\"Manual\";s:11:\"term_videos\";s:7:\"Vídeos\";s:16:\"term_user_manual\";s:20:\"Manual de utilizador\";s:19:\"term_manual_options\";s:8:\"Opções\";s:30:\"term_wordpress_video_tutorials\";s:26:\"Vídeo Tutoriais WordPress\";s:13:\"message_intro\";s:291:\"<p>Olá, bem-vindo ao seu novo website! A seguir estão alguns tutoriais em vídeo rápidos que o ajudarão a começar. Se quiser ler o manual para explicações mais detalhadas sobre como o seu sistema de gestão de conteúdo funciona clique <a href=\"admin.php?page=vum-ebook\">aqui</a>.</p>\";s:9:\"lang_code\";s:2:\"pt\";}s:2:\"fr\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"7\";s:4:\"lang\";s:1:\"6\";s:11:\"term_manual\";s:6:\"Manuel\";s:11:\"term_videos\";s:7:\"Vidéos\";s:16:\"term_user_manual\";s:23:\"Manuel de l\'utilisateur\";s:19:\"term_manual_options\";s:25:\"Paramètres d\'utilisation\";s:30:\"term_wordpress_video_tutorials\";s:27:\"WordPress Tutoriels vidéos\";s:13:\"message_intro\";s:275:\"Boujour et bienvenue sur votre nouveau site! Les courts vid&eacute;os suivants vous aideront &agrave; commencer. Si vous voulez lire le manuel pour des explications plus en profondeur sur le fonctionnement de votre syst&egrave;me de gestion de contenu, veuillez cliquer ici.\n\";s:9:\"lang_code\";s:2:\"fr\";}s:2:\"de\";O:8:\"stdClass\":9:{s:2:\"id\";s:1:\"8\";s:4:\"lang\";s:1:\"7\";s:11:\"term_manual\";s:8:\"Handbuch\";s:11:\"term_videos\";s:6:\"Videos\";s:16:\"term_user_manual\";s:16:\"Benutzerhandbuch\";s:19:\"term_manual_options\";s:13:\"Einstellungen\";s:30:\"term_wordpress_video_tutorials\";s:23:\"WordPress Videotutorial\";s:13:\"message_intro\";s:247:\"Hallo, willkommen zu Ihrer neuen Webseite! Hier sind einige kurze Videotutorials, die Ihnen mit den ersten Schritten helfen. Wenn Sie das Handbuch für tiefergehende Erklärungen über das Inhaltsverwaltungssystem lesen möchten, klicken Sie hier.\";s:9:\"lang_code\";s:2:\"de\";}}s:8:\"sections\";a:17:{i:0;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:9:\"Dashboard\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:2:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:1:\"1\";s:7:\"section\";s:1:\"1\";s:11:\"vidFileName\";s:16:\"01-dashboard.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"2\";s:8:\"vidTitle\";s:13:\"The Dashboard\";s:7:\"vidDesc\";s:110:\"The Dashboard - This is a general overview of how your dashboard works, and the important parts to know about.\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:1:\"3\";s:7:\"section\";s:1:\"1\";s:11:\"vidFileName\";s:16:\"02-admin-bar.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"3\";s:8:\"vidTitle\";s:13:\"The Admin Bar\";s:7:\"vidDesc\";s:32:\"This is how to use the admin bar\";s:4:\"lang\";s:1:\"1\";}}}i:1;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:6:\"Editor\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:12:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:1:\"8\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:17:\"08-hyperlinks.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"11\";s:8:\"vidTitle\";s:10:\"Hyperlinks\";s:7:\"vidDesc\";s:56:\"How to add an internal or external link to your website.\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:1:\"9\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:12:\"09-lists.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"12\";s:8:\"vidTitle\";s:5:\"Lists\";s:7:\"vidDesc\";s:103:\"How to make a list on your page or post, and the difference between ordered lists and un-ordered lists.\";s:4:\"lang\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"10\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:13:\"10-oembed.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"13\";s:8:\"vidTitle\";s:11:\"Embed Video\";s:7:\"vidDesc\";s:52:\"How to embed an video directly to your page or post.\";s:4:\"lang\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"11\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:31:\"11-distraction-free-writing.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"14\";s:8:\"vidTitle\";s:24:\"Distraction-Free Writing\";s:7:\"vidDesc\";s:43:\"How us the distraction-free writing feature\";s:4:\"lang\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"15\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:18:\"03-the-toolbar.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"5\";s:8:\"vidTitle\";s:11:\"The Toolbar\";s:7:\"vidDesc\";s:84:\"An overview of the different formatting icons inside the toolbar of a page or post.	\";s:4:\"lang\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"16\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:22:\"04-paste-from-word.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"6\";s:8:\"vidTitle\";s:15:\"Paste From Word\";s:7:\"vidDesc\";s:100:\"How to paste content into your page or post from a word document to without have formatting issues.	\";s:4:\"lang\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"17\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:18:\"05-add-heading.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"7\";s:8:\"vidTitle\";s:14:\"Add A Heading	\";s:7:\"vidDesc\";s:43:\"How to add a heading to your page or post.	\";s:4:\"lang\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"18\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:20:\"06-add-paragraph.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:1:\"8\";s:8:\"vidTitle\";s:15:\"Add A Paragraph\";s:7:\"vidDesc\";s:75:\"How to add a paragraph in your page or post using the kitchensink toolbar.	\";s:4:\"lang\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"19\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:16:\"07-edit-text.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"10\";s:8:\"vidTitle\";s:9:\"Edit Text\";s:7:\"vidDesc\";s:62:\"How to edit or format the text contents of your page or post.	\";s:4:\"lang\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"265\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:16:\"60-revisions.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"65\";s:8:\"vidTitle\";s:9:\"Revisions\";s:7:\"vidDesc\";s:19:\"<p>\n	Revisions</p>\n\";s:4:\"lang\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"271\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:27:\"61-audio-video-playlist.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"66\";s:8:\"vidTitle\";s:21:\"Audio Video Playlists\";s:7:\"vidDesc\";s:21:\"Audio Video Playlists\";s:4:\"lang\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"278\";s:7:\"section\";s:1:\"3\";s:11:\"vidFileName\";s:28:\"89-inline-text-shortcuts.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"96\";s:8:\"vidTitle\";s:14:\"Text Shortcuts\";s:7:\"vidDesc\";s:14:\"text shortcuts\";s:4:\"lang\";s:1:\"1\";}}}i:2;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:6:\"Images\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:10:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"12\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:35:\"12-add-media-from-media-library.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"15\";s:8:\"vidTitle\";s:28:\"Add Media From Media Library\";s:7:\"vidDesc\";s:41:\"How to add an media to your page or post.\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"13\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:24:\"13-add-image-from-pc.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"16\";s:8:\"vidTitle\";s:23:\"Add Image From Computer\";s:7:\"vidDesc\";s:58:\"How to add an image from your computer to a page or post.	\";s:4:\"lang\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"14\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:25:\"14-add-image-from-url.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"17\";s:8:\"vidTitle\";s:18:\"Add Image From URL\";s:7:\"vidDesc\";s:64:\"How to add an image to your page for post from another website.	\";s:4:\"lang\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"20\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:19:\"15-delete-image.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"18\";s:8:\"vidTitle\";s:13:\"Delete Image	\";s:7:\"vidDesc\";s:47:\"How to delete an image from your page or post.	\";s:4:\"lang\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"21\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:17:\"16-edit-image.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"19\";s:8:\"vidTitle\";s:10:\"Edit Image\";s:7:\"vidDesc\";s:100:\"How to edit an image whilst your inside your page or post. This includes alignment, title and more.	\";s:4:\"lang\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"22\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:19:\"17-image-editor.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"20\";s:8:\"vidTitle\";s:12:\"Image Editor\";s:7:\"vidDesc\";s:63:\"How to use the image editor and how to start editing an image.	\";s:4:\"lang\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"23\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:41:\"18-image-editor-rotate-flip-undo-redo.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"21\";s:8:\"vidTitle\";s:22:\"Rotate and Flip Images\";s:7:\"vidDesc\";s:95:\"Overview of the editing icons and other functionality that will be useful in editing an image.	\";s:4:\"lang\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"24\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:34:\"19-image-editor-crop-and-scale.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"22\";s:8:\"vidTitle\";s:22:\"Crop and Scale Images	\";s:7:\"vidDesc\";s:44:\"How to crop an image using the image editor	\";s:4:\"lang\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"25\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:21:\"20-featured-image.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"23\";s:8:\"vidTitle\";s:14:\"Featured Image\";s:7:\"vidDesc\";s:18:\"The Featured Image\";s:4:\"lang\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"272\";s:7:\"section\";s:1:\"4\";s:11:\"vidFileName\";s:22:\"62-image-galleries.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"67\";s:8:\"vidTitle\";s:15:\"Image Galleries\";s:7:\"vidDesc\";s:16:\"Image Galleries\n\";s:4:\"lang\";s:1:\"1\";}}}i:3;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:5:\"Pages\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:3:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"26\";s:7:\"section\";s:1:\"5\";s:11:\"vidFileName\";s:19:\"21-add-new-page.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"24\";s:8:\"vidTitle\";s:13:\"Add New Page	\";s:7:\"vidDesc\";s:45:\"How to add a new page to your Wordpress site.\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"27\";s:7:\"section\";s:1:\"5\";s:11:\"vidFileName\";s:17:\"22-trash-page.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"25\";s:8:\"vidTitle\";s:12:\"Trash A Page\";s:7:\"vidDesc\";s:91:\"How to remove a page. It temporarily removes the post and store them all to the trash bin.	\";s:4:\"lang\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"28\";s:7:\"section\";s:1:\"5\";s:11:\"vidFileName\";s:19:\"23-restore-page.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"26\";s:8:\"vidTitle\";s:14:\"Restore A Page\";s:7:\"vidDesc\";s:69:\"How to restore a post or page after you have placed it in the trash.	\";s:4:\"lang\";s:1:\"1\";}}}i:4;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:5:\"Media\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:2:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"29\";s:7:\"section\";s:1:\"6\";s:11:\"vidFileName\";s:20:\"24-media-library.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"27\";s:8:\"vidTitle\";s:14:\"Media Library	\";s:7:\"vidDesc\";s:73:\"The purpose of a Media Library, how it works and the important features.	\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"30\";s:7:\"section\";s:1:\"6\";s:11:\"vidFileName\";s:16:\"25-add-media.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"28\";s:8:\"vidTitle\";s:10:\"Add Media	\";s:7:\"vidDesc\";s:81:\"How to add or upload a media file from your computer to Wordpress media section.	\";s:4:\"lang\";s:1:\"1\";}}}i:5;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:5:\"Posts\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:7:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"31\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:19:\"26-add-new-post.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"29\";s:8:\"vidTitle\";s:13:\"Add New Post	\";s:7:\"vidDesc\";s:75:\"This will teach you steps on how to add a new post to your wordpress site.	\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"32\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:17:\"27-trash-post.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"30\";s:8:\"vidTitle\";s:13:\"Trash A Post	\";s:7:\"vidDesc\";s:99:\"How to remove a post or page. It temporarily removes the post and store them all to the trash bin.	\";s:4:\"lang\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"33\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:19:\"28-restore-post.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"31\";s:8:\"vidTitle\";s:15:\"Restore A Post	\";s:7:\"vidDesc\";s:69:\"How to restore a post or page after you have placed it in the trash.	\";s:4:\"lang\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"34\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:17:\"29-categories.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"32\";s:8:\"vidTitle\";s:11:\"Categories	\";s:7:\"vidDesc\";s:39:\"Overview of the purpose of categories.	\";s:4:\"lang\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"35\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:11:\"30-tags.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"33\";s:8:\"vidTitle\";s:5:\"Tags	\";s:7:\"vidDesc\";s:74:\"The purpose of tags explained and how to make tags for each page or post.	\";s:4:\"lang\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"36\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:17:\"31-quickpress.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"34\";s:8:\"vidTitle\";s:12:\"Quick Draft	\";s:7:\"vidDesc\";s:32:\"<p>\n	How to use quickpress.</p>\n\";s:4:\"lang\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"37\";s:7:\"section\";s:1:\"7\";s:11:\"vidFileName\";s:14:\"32-excerpt.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"35\";s:8:\"vidTitle\";s:12:\"The Excerpt	\";s:7:\"vidDesc\";s:24:\"How to use the excerpt.	\";s:4:\"lang\";s:1:\"1\";}}}i:6;O:8:\"stdClass\":6:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:8:\"Comments\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:1:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"38\";s:7:\"section\";s:1:\"8\";s:11:\"vidFileName\";s:15:\"33-comments.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"37\";s:8:\"vidTitle\";s:9:\"Comments	\";s:7:\"vidDesc\";s:37:\"Overview of the purpose of comments.	\";s:4:\"lang\";s:1:\"1\";}}}i:7;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:7:\"Profile\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"1\";s:6:\"videos\";a:1:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"42\";s:7:\"section\";s:2:\"10\";s:11:\"vidFileName\";s:22:\"37-change-password.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"41\";s:8:\"vidTitle\";s:21:\"Change Your Password	\";s:7:\"vidDesc\";s:28:\"How to change your password	\";s:4:\"lang\";s:1:\"1\";}}}i:8;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:7:\"Widgets\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:1:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"199\";s:7:\"section\";s:2:\"13\";s:11:\"vidFileName\";s:14:\"41-widgets.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"44\";s:8:\"vidTitle\";s:7:\"Widgets\";s:7:\"vidDesc\";s:28:\"<p>\n	How to add widgets</p>\n\";s:4:\"lang\";s:1:\"1\";}}}i:9;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:5:\"Menus\";s:8:\"category\";s:1:\"1\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:3:{i:0;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"200\";s:7:\"section\";s:2:\"14\";s:11:\"vidFileName\";s:27:\"38-add-a-page-to-a-menu.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"45\";s:8:\"vidTitle\";s:20:\"Add A Page To A Menu\";s:7:\"vidDesc\";s:37:\"<p>\n	How to add a page to a menu</p>\n\";s:4:\"lang\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"201\";s:7:\"section\";s:2:\"14\";s:11:\"vidFileName\";s:24:\"39-moving-menu-items.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"46\";s:8:\"vidTitle\";s:17:\"Moving Menu Items\";s:7:\"vidDesc\";s:32:\"<p>\n	How to move menu items</p>\n\";s:4:\"lang\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"202\";s:7:\"section\";s:2:\"14\";s:11:\"vidFileName\";s:23:\"40-add-custom-links.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"47\";s:8:\"vidTitle\";s:16:\"Add Custom Links\";s:7:\"vidDesc\";s:42:\"<p>\n	How to add custom links to menus</p>\n\";s:4:\"lang\";s:1:\"1\";}}}i:10;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:3:\"SEO\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:4:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:1:\"5\";s:7:\"section\";s:2:\"12\";s:11:\"vidFileName\";s:14:\"42-general.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"43\";s:8:\"vidTitle\";s:7:\"General\";s:7:\"vidDesc\";s:15:\"The general tab\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:1:\"6\";s:7:\"section\";s:2:\"12\";s:11:\"vidFileName\";s:20:\"43-page-analysis.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"48\";s:8:\"vidTitle\";s:13:\"Page Analysis\";s:7:\"vidDesc\";s:17:\"Page analysis tab\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:1:\"7\";s:7:\"section\";s:2:\"12\";s:11:\"vidFileName\";s:13:\"44-social.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"49\";s:8:\"vidTitle\";s:6:\"Social\";s:7:\"vidDesc\";s:11:\"Social tab	\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:1:\"8\";s:7:\"section\";s:2:\"12\";s:11:\"vidFileName\";s:14:\"45-profile.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"50\";s:8:\"vidTitle\";s:7:\"Profile\";s:7:\"vidDesc\";s:11:\"Profile tab\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:11;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:11:\"WooCommerce\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:7:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"22\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:17:\"47-categories.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"52\";s:8:\"vidTitle\";s:10:\"Categories\";s:7:\"vidDesc\";s:10:\"Categories\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"23\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:11:\"48-tags.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"53\";s:8:\"vidTitle\";s:4:\"Tags\";s:7:\"vidDesc\";s:4:\"Tags\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"24\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:23:\"49-shipping-classes.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"54\";s:8:\"vidTitle\";s:16:\"Shipping Classes\";s:7:\"vidDesc\";s:16:\"Shipping Classes\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"25\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:17:\"50-attributes.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"55\";s:8:\"vidTitle\";s:10:\"Attributes\";s:7:\"vidDesc\";s:10:\"Attributes\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"32\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:13:\"57-orders.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"62\";s:8:\"vidTitle\";s:6:\"Orders\";s:7:\"vidDesc\";s:6:\"Orders\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:5;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"33\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:14:\"58-reports.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"63\";s:8:\"vidTitle\";s:7:\"Reports\";s:7:\"vidDesc\";s:7:\"Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:6;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"34\";s:7:\"section\";s:2:\"15\";s:11:\"vidFileName\";s:14:\"59-coupons.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"64\";s:8:\"vidTitle\";s:7:\"Coupons\";s:7:\"vidDesc\";s:7:\"Coupons\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:12;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:20:\"WooCommerce Products\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:7:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"26\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:18:\"51-add-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"56\";s:8:\"vidTitle\";s:13:\"Add a Product\";s:7:\"vidDesc\";s:13:\"Add a Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"27\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:21:\"52-simple-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"57\";s:8:\"vidTitle\";s:14:\"Simple Product\";s:7:\"vidDesc\";s:14:\"Simple Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"28\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:22:\"53-grouped-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"58\";s:8:\"vidTitle\";s:15:\"Grouped Product\";s:7:\"vidDesc\";s:15:\"Grouped Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"29\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:23:\"54-external-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"59\";s:8:\"vidTitle\";s:16:\"External Product\";s:7:\"vidDesc\";s:16:\"External Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"30\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:23:\"55-variable-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"60\";s:8:\"vidTitle\";s:16:\"Variable Product\";s:7:\"vidDesc\";s:16:\"Variable Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:5;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"31\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:27:\"56-downloadable-product.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"61\";s:8:\"vidTitle\";s:20:\"Downloadable Product\";s:7:\"vidDesc\";s:20:\"Downloadable Product\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:6;O:8:\"stdClass\":11:{s:2:\"id\";s:2:\"72\";s:7:\"section\";s:2:\"16\";s:11:\"vidFileName\";s:23:\"46-product-overview.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"51\";s:8:\"vidTitle\";s:16:\"Product Overview\";s:7:\"vidDesc\";s:16:\"Product Overview\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:13;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:22:\"Google Analytics Setup\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:11:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"160\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:38:\"63-importance-of-digital-analytics.mp4\";s:9:\"youtubeID\";s:11:\"JbXNS3NjIfM\";s:8:\"video_id\";s:2:\"69\";s:8:\"vidTitle\";s:31:\"Importance Of Digital Analytics\";s:7:\"vidDesc\";s:31:\"Importance Of Digital Analytics\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"161\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:30:\"64-core-analysis-technique.mp4\";s:9:\"youtubeID\";s:11:\"fi0w57kr_jY\";s:8:\"video_id\";s:2:\"70\";s:8:\"vidTitle\";s:24:\"Core Analysis Techniques\";s:7:\"vidDesc\";s:24:\"Core analysis techniques\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"162\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:45:\"65-conversions-and-conversion-attribution.mp4\";s:9:\"youtubeID\";s:11:\"xLJt5A-NeQI\";s:8:\"video_id\";s:2:\"71\";s:8:\"vidTitle\";s:37:\"Conversions And Marketing Attribution\";s:7:\"vidDesc\";s:37:\"Conversions And Marketing Attribution\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"163\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:34:\"66-creating-a-measurement-plan.mp4\";s:9:\"youtubeID\";s:11:\"EpDA3XaELqs\";s:8:\"video_id\";s:2:\"72\";s:8:\"vidTitle\";s:27:\"Creating A Measurement Plan\";s:7:\"vidDesc\";s:27:\"Creating A Measurement Plan\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"164\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:33:\"67-how-google-analytics-works.mp4\";s:9:\"youtubeID\";s:11:\"eyltEFyZ678\";s:8:\"video_id\";s:2:\"73\";s:8:\"vidTitle\";s:26:\"How Google Analytics works\";s:7:\"vidDesc\";s:26:\"How Google Analytics works\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:5;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"165\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:41:\"68-key-metrics-and-dimensions-defined.mp4\";s:9:\"youtubeID\";s:11:\"TW3gx4t4944\";s:8:\"video_id\";s:2:\"74\";s:8:\"vidTitle\";s:26:\"Key Metrics And Dimensions\";s:7:\"vidDesc\";s:26:\"Key Metrics And Dimensions\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:6;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"166\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:26:\"69-creating-an-account.mp4\";s:9:\"youtubeID\";s:11:\"w9H_P2wAwSE\";s:8:\"video_id\";s:2:\"75\";s:8:\"vidTitle\";s:19:\"Creating An Account\";s:7:\"vidDesc\";s:19:\"Creating An Account\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:7;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"167\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:43:\"70-understanding-your-account-structure.mp4\";s:9:\"youtubeID\";s:11:\"OyixJ7A9phg\";s:8:\"video_id\";s:2:\"76\";s:8:\"vidTitle\";s:31:\"Understanding Account Structure\";s:7:\"vidDesc\";s:31:\"Understanding Account Structure\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:8;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"168\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:31:\"71-setting-up-basic-filters.mp4\";s:9:\"youtubeID\";s:11:\"dzwRzUEc_tA\";s:8:\"video_id\";s:2:\"77\";s:8:\"vidTitle\";s:24:\"Setting Up Basic Filters\";s:7:\"vidDesc\";s:24:\"Setting Up Basic Filters\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:9;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"169\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:37:\"72-setting-up-goals-and-ecommerce.mp4\";s:9:\"youtubeID\";s:11:\"vEpq3nYeZBc\";s:8:\"video_id\";s:2:\"78\";s:8:\"vidTitle\";s:16:\"Setting Up Goals\";s:7:\"vidDesc\";s:16:\"Setting Up Goals\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:10;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"170\";s:7:\"section\";s:2:\"17\";s:11:\"vidFileName\";s:31:\"73-collecting-campaign-data.mp4\";s:9:\"youtubeID\";s:11:\"4gYioQkIqKk\";s:8:\"video_id\";s:2:\"79\";s:8:\"vidTitle\";s:24:\"Collecting Campaign Data\";s:7:\"vidDesc\";s:24:\"Collecting campaign data\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:14;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:24:\"Google Analytics Reports\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:10:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"171\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:25:\"74-reporting-overview.mp4\";s:9:\"youtubeID\";s:11:\"xyh8iG5mRIs\";s:8:\"video_id\";s:2:\"80\";s:8:\"vidTitle\";s:18:\"Reporting Overview\";s:7:\"vidDesc\";s:18:\"Reporting Overview\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"172\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:23:\"75-audience-reports.mp4\";s:9:\"youtubeID\";s:11:\"ORrYEEH_KPc\";s:8:\"video_id\";s:2:\"81\";s:8:\"vidTitle\";s:16:\"Audience Reports\";s:7:\"vidDesc\";s:16:\"Audience reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"173\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:26:\"76-acquisition-reports.mp4\";s:9:\"youtubeID\";s:11:\"ii0T5JUO2BY\";s:8:\"video_id\";s:2:\"82\";s:8:\"vidTitle\";s:19:\"Acquisition Reports\";s:7:\"vidDesc\";s:19:\"Acquisition Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"174\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:22:\"77-adwords-reports.mp4\";s:9:\"youtubeID\";s:11:\"hgycbw6Beuc\";s:8:\"video_id\";s:2:\"83\";s:8:\"vidTitle\";s:15:\"AdWords Reports\";s:7:\"vidDesc\";s:15:\"AdWords Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"175\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:23:\"78-behavior-reports.mp4\";s:9:\"youtubeID\";s:11:\"Dz-zgq6OqTI\";s:8:\"video_id\";s:2:\"84\";s:8:\"vidTitle\";s:16:\"Behavior Reports\";s:7:\"vidDesc\";s:16:\"Behavior reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:5;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"176\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:36:\"79-custom-reports-and-dashboards.mp4\";s:9:\"youtubeID\";s:11:\"I1b4GT-GuEs\";s:8:\"video_id\";s:2:\"85\";s:8:\"vidTitle\";s:29:\"Custom Reports And Dashboards\";s:7:\"vidDesc\";s:29:\"Custom Reports And Dashboards\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:6;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"178\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:23:\"80-goal-flow-report.mp4\";s:9:\"youtubeID\";s:11:\"dN3gkBBffhs\";s:8:\"video_id\";s:2:\"87\";s:8:\"vidTitle\";s:16:\"Goal Flow Report\";s:7:\"vidDesc\";s:16:\"Goal Flow Report\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:7;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"179\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:24:\"81-ecommerce-reports.mp4\";s:9:\"youtubeID\";s:11:\"8Kg-8ZjgLAQ\";s:8:\"video_id\";s:2:\"88\";s:8:\"vidTitle\";s:17:\"Ecommerce Reports\";s:7:\"vidDesc\";s:17:\"Ecommerce Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:8;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"180\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:36:\"82-multi-channel-funnels-reports.mp4\";s:9:\"youtubeID\";s:11:\"E9zfpKsw6f8\";s:8:\"video_id\";s:2:\"89\";s:8:\"vidTitle\";s:29:\"Multi-Channel Funnels Reports\";s:7:\"vidDesc\";s:29:\"Multi-Channel Funnels Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}i:9;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"181\";s:7:\"section\";s:2:\"18\";s:11:\"vidFileName\";s:26:\"83-attribution-reports.mp4\";s:9:\"youtubeID\";s:11:\"eBCw9sC5D40\";s:8:\"video_id\";s:2:\"90\";s:8:\"vidTitle\";s:19:\"Attribution Reports\";s:7:\"vidDesc\";s:19:\"Attribution Reports\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"0\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:15;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:13:\"Gravity Forms\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:5:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"182\";s:7:\"section\";s:2:\"19\";s:11:\"vidFileName\";s:21:\"84-add-a-new-form.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"91\";s:8:\"vidTitle\";s:14:\"Add A New Form\";s:7:\"vidDesc\";s:14:\"Add A New Form\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"183\";s:7:\"section\";s:2:\"19\";s:11:\"vidFileName\";s:18:\"85-form-editor.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"92\";s:8:\"vidTitle\";s:11:\"Form Editor\";s:7:\"vidDesc\";s:11:\"Form Editor\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"184\";s:7:\"section\";s:2:\"19\";s:11:\"vidFileName\";s:20:\"86-form-settings.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"93\";s:8:\"vidTitle\";s:13:\"Form Settings\";s:7:\"vidDesc\";s:13:\"Form Settings\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"185\";s:7:\"section\";s:2:\"19\";s:11:\"vidFileName\";s:19:\"87-form-entries.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"94\";s:8:\"vidTitle\";s:12:\"Form Entries\";s:7:\"vidDesc\";s:12:\"Form Entries\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"186\";s:7:\"section\";s:2:\"19\";s:11:\"vidFileName\";s:19:\"88-form-preview.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"95\";s:8:\"vidTitle\";s:12:\"Form Preview\";s:7:\"vidDesc\";s:12:\"Form Preview\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}}}i:16;O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:12:\"Page Builder\";s:8:\"category\";s:1:\"2\";s:6:\"public\";s:1:\"1\";s:11:\"showDefault\";s:1:\"0\";s:6:\"videos\";a:21:{i:0;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"187\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:33:\"090-starting-the-page-builder.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"97\";s:8:\"vidTitle\";s:25:\"Starting The Page Builder\";s:7:\"vidDesc\";s:25:\"Starting The Page Builder\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:1;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"188\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:30:\"091-page-builder-templates.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"98\";s:8:\"vidTitle\";s:9:\"Templates\";s:7:\"vidDesc\";s:9:\"Templates\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:2;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"189\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:27:\"092-adding-rows-columns.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:2:\"99\";s:8:\"vidTitle\";s:16:\"Rows And Columns\";s:7:\"vidDesc\";s:16:\"Rows And Columns\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:3;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"190\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:26:\"093-the-heading-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"100\";s:8:\"vidTitle\";s:8:\"Headings\";s:7:\"vidDesc\";s:8:\"Headings\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:4;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"191\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:20:\"095-photo-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"102\";s:8:\"vidTitle\";s:6:\"Photos\";s:7:\"vidDesc\";s:6:\"Photos\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:5;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"192\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:24:\"096-separator-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"103\";s:8:\"vidTitle\";s:10:\"Separators\";s:7:\"vidDesc\";s:10:\"Separators\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:6;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"193\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:26:\"097-text-editor-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"104\";s:8:\"vidTitle\";s:11:\"Text Editor\";s:7:\"vidDesc\";s:11:\"Text Editor\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:7;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"194\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:20:\"098-video-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"105\";s:8:\"vidTitle\";s:6:\"Videos\";s:7:\"vidDesc\";s:6:\"Videos\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:8;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"195\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:24:\"099-accordion-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"106\";s:8:\"vidTitle\";s:10:\"Accordions\";s:7:\"vidDesc\";s:10:\"Accordions\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:9;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"196\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:21:\"100-button-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"107\";s:8:\"vidTitle\";s:7:\"Buttons\";s:7:\"vidDesc\";s:7:\"Buttons\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:10;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"197\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:29:\"101-call-to-action-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"108\";s:8:\"vidTitle\";s:15:\"Calls To Action\";s:7:\"vidDesc\";s:15:\"Calls To Action\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:11;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"198\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:22:\"102-callout-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"109\";s:8:\"vidTitle\";s:8:\"Callouts\";s:7:\"vidDesc\";s:8:\"Callouts\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:12;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"199\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:27:\"103-contact-form-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"110\";s:8:\"vidTitle\";s:13:\"Contact Forms\";s:7:\"vidDesc\";s:13:\"Contact Forms\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:13;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"200\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:25:\"104-icon-group-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"111\";s:8:\"vidTitle\";s:11:\"Icon Groups\";s:7:\"vidDesc\";s:11:\"Icon Groups\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:14;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"201\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:19:\"105-icon-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"112\";s:8:\"vidTitle\";s:5:\"Icons\";s:7:\"vidDesc\";s:5:\"Icons\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:15;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"202\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:18:\"106-map-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"113\";s:8:\"vidTitle\";s:4:\"Maps\";s:7:\"vidDesc\";s:4:\"Maps\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:16;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"203\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:29:\"107-social-buttons-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"114\";s:8:\"vidTitle\";s:14:\"Social Buttons\";s:7:\"vidDesc\";s:14:\"Social Buttons\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:17;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"204\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:19:\"108-tabs-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"115\";s:8:\"vidTitle\";s:4:\"Tabs\";s:7:\"vidDesc\";s:4:\"Tabs\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:18;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"205\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:19:\"109-html-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"116\";s:8:\"vidTitle\";s:4:\"HTML\";s:7:\"vidDesc\";s:4:\"HTML\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:19;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"206\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:19:\"110-quick-start.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"117\";s:8:\"vidTitle\";s:11:\"Quick Start\";s:7:\"vidDesc\";s:11:\"Quick Start\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}i:20;O:8:\"stdClass\":11:{s:2:\"id\";s:3:\"207\";s:7:\"section\";s:2:\"20\";s:11:\"vidFileName\";s:27:\"111-testimonials-module.mp4\";s:9:\"youtubeID\";N;s:8:\"video_id\";s:3:\"118\";s:8:\"vidTitle\";s:12:\"Testimonials\";s:7:\"vidDesc\";s:12:\"Testimonials\";s:4:\"lang\";s:1:\"1\";s:9:\"subtitles\";s:1:\"0\";s:13:\"has_lang_vars\";s:1:\"1\";s:12:\"subtitles_id\";s:1:\"0\";}}}}s:5:\"langs\";O:8:\"stdClass\":8:{s:5:\"en-au\";s:18:\"Australian English\";s:5:\"en-gb\";s:15:\"British English\";s:5:\"en-us\";s:16:\"American English\";s:2:\"es\";s:8:\"Español\";s:2:\"pt\";s:11:\" Português\";s:2:\"it\";s:8:\"Italiano\";s:2:\"fr\";s:6:\"French\";s:2:\"de\";s:7:\"Deutsch\";}}", "yes");
INSERT INTO `wp_options` VALUES("12157", "wpm_o_lang", "en-us", "yes");
INSERT INTO `wp_options` VALUES("12158", "wpm_o_user_menu_restrict", "1", "yes");
INSERT INTO `wp_options` VALUES("12159", "wpm_o_hide_manual", "1", "yes");
INSERT INTO `wp_options` VALUES("12160", "wpm_o_move_menu_item", "0", "yes");
INSERT INTO `wp_options` VALUES("12161", "wpm_o_view_access", "1", "yes");
INSERT INTO `wp_options` VALUES("12162", "wpm_o_change_popup_url", "1", "yes");
INSERT INTO `wp_options` VALUES("12163", "wpm_o_custom_menu_name", "Manual", "yes");
INSERT INTO `wp_options` VALUES("12164", "wpm_o_plugin_heading_video", "Video Tutorials", "yes");
INSERT INTO `wp_options` VALUES("12165", "wpm_o_plugin_heading_user", "", "yes");
INSERT INTO `wp_options` VALUES("12166", "wpm_o_intro_text", "", "yes");
INSERT INTO `wp_options` VALUES("12167", "wpm_o_plugin_custom_logo", "", "yes");
INSERT INTO `wp_options` VALUES("12168", "wpm_o_custom_ebook_img", "", "yes");
INSERT INTO `wp_options` VALUES("12169", "wpm_o_branding_img", "", "yes");
INSERT INTO `wp_options` VALUES("12170", "wpm_o_branding_logo", "", "yes");
INSERT INTO `wp_options` VALUES("12171", "wpm_o_custom_vid_placeholder", "", "yes");
INSERT INTO `wp_options` VALUES("12172", "wpm_o_show_dashboard", "0", "yes");
INSERT INTO `wp_options` VALUES("12173", "wpm_o_show_video_2", "0", "yes");
INSERT INTO `wp_options` VALUES("12174", "wpm_o_show_video_3", "0", "yes");
INSERT INTO `wp_options` VALUES("12175", "wpm_o_show_editor", "1", "yes");
INSERT INTO `wp_options` VALUES("12176", "wpm_o_show_video_11", "1", "yes");
INSERT INTO `wp_options` VALUES("12177", "wpm_o_show_video_12", "1", "yes");
INSERT INTO `wp_options` VALUES("12178", "wpm_o_show_video_13", "1", "yes");
INSERT INTO `wp_options` VALUES("12179", "wpm_o_show_video_14", "1", "yes");
INSERT INTO `wp_options` VALUES("12180", "wpm_o_show_video_5", "1", "yes");
INSERT INTO `wp_options` VALUES("12181", "wpm_o_show_video_6", "1", "yes");
INSERT INTO `wp_options` VALUES("12182", "wpm_o_show_video_7", "1", "yes");
INSERT INTO `wp_options` VALUES("12183", "wpm_o_show_video_8", "1", "yes");
INSERT INTO `wp_options` VALUES("12184", "wpm_o_show_video_10", "1", "yes");
INSERT INTO `wp_options` VALUES("12185", "wpm_o_show_video_65", "1", "yes");
INSERT INTO `wp_options` VALUES("12186", "wpm_o_show_video_66", "1", "yes");
INSERT INTO `wp_options` VALUES("12187", "wpm_o_show_video_96", "1", "yes");
INSERT INTO `wp_options` VALUES("12188", "wpm_o_show_images", "1", "yes");
INSERT INTO `wp_options` VALUES("12189", "wpm_o_show_video_15", "1", "yes");
INSERT INTO `wp_options` VALUES("12190", "wpm_o_show_video_16", "1", "yes");
INSERT INTO `wp_options` VALUES("12191", "wpm_o_show_video_17", "1", "yes");
INSERT INTO `wp_options` VALUES("12192", "wpm_o_show_video_18", "1", "yes");
INSERT INTO `wp_options` VALUES("12193", "wpm_o_show_video_19", "0", "yes");
INSERT INTO `wp_options` VALUES("12194", "wpm_o_show_video_20", "0", "yes");
INSERT INTO `wp_options` VALUES("12195", "wpm_o_show_video_21", "0", "yes");
INSERT INTO `wp_options` VALUES("12196", "wpm_o_show_video_22", "0", "yes");
INSERT INTO `wp_options` VALUES("12197", "wpm_o_show_video_23", "1", "yes");
INSERT INTO `wp_options` VALUES("12198", "wpm_o_show_video_67", "1", "yes");
INSERT INTO `wp_options` VALUES("12199", "wpm_o_show_pages", "0", "yes");
INSERT INTO `wp_options` VALUES("12200", "wpm_o_show_video_24", "0", "yes");
INSERT INTO `wp_options` VALUES("12201", "wpm_o_show_video_25", "0", "yes");
INSERT INTO `wp_options` VALUES("12202", "wpm_o_show_video_26", "0", "yes");
INSERT INTO `wp_options` VALUES("12203", "wpm_o_show_media", "0", "yes");
INSERT INTO `wp_options` VALUES("12204", "wpm_o_show_video_27", "0", "yes");
INSERT INTO `wp_options` VALUES("12205", "wpm_o_show_video_28", "0", "yes");
INSERT INTO `wp_options` VALUES("12206", "wpm_o_show_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("12207", "wpm_o_show_video_29", "1", "yes");
INSERT INTO `wp_options` VALUES("12208", "wpm_o_show_video_30", "1", "yes");
INSERT INTO `wp_options` VALUES("12209", "wpm_o_show_video_31", "0", "yes");
INSERT INTO `wp_options` VALUES("12210", "wpm_o_show_video_32", "1", "yes");
INSERT INTO `wp_options` VALUES("12211", "wpm_o_show_video_33", "1", "yes");
INSERT INTO `wp_options` VALUES("12212", "wpm_o_show_video_34", "1", "yes");
INSERT INTO `wp_options` VALUES("12213", "wpm_o_show_video_35", "1", "yes");
INSERT INTO `wp_options` VALUES("12214", "wpm_o_show_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("12215", "wpm_o_show_video_37", "0", "yes");
INSERT INTO `wp_options` VALUES("12216", "wpm_o_show_profile", "1", "yes");
INSERT INTO `wp_options` VALUES("12217", "wpm_o_show_video_41", "1", "yes");
INSERT INTO `wp_options` VALUES("12218", "wpm_o_show_widgets", "0", "yes");
INSERT INTO `wp_options` VALUES("12219", "wpm_o_show_video_44", "1", "yes");
INSERT INTO `wp_options` VALUES("12220", "wpm_o_show_menus", "0", "yes");
INSERT INTO `wp_options` VALUES("12221", "wpm_o_show_video_45", "1", "yes");
INSERT INTO `wp_options` VALUES("12222", "wpm_o_show_video_46", "1", "yes");
INSERT INTO `wp_options` VALUES("12223", "wpm_o_show_video_47", "1", "yes");
INSERT INTO `wp_options` VALUES("12224", "wpm_o_show_seo", "0", "yes");
INSERT INTO `wp_options` VALUES("12225", "wpm_o_show_video_43", "1", "yes");
INSERT INTO `wp_options` VALUES("12226", "wpm_o_show_video_48", "1", "yes");
INSERT INTO `wp_options` VALUES("12227", "wpm_o_show_video_49", "1", "yes");
INSERT INTO `wp_options` VALUES("12228", "wpm_o_show_video_50", "1", "yes");
INSERT INTO `wp_options` VALUES("12229", "wpm_o_show_woocommerce", "0", "yes");
INSERT INTO `wp_options` VALUES("12230", "wpm_o_show_video_52", "1", "yes");
INSERT INTO `wp_options` VALUES("12231", "wpm_o_show_video_53", "1", "yes");
INSERT INTO `wp_options` VALUES("12232", "wpm_o_show_video_54", "1", "yes");
INSERT INTO `wp_options` VALUES("12233", "wpm_o_show_video_55", "1", "yes");
INSERT INTO `wp_options` VALUES("12234", "wpm_o_show_video_62", "1", "yes");
INSERT INTO `wp_options` VALUES("12235", "wpm_o_show_video_63", "1", "yes");
INSERT INTO `wp_options` VALUES("12236", "wpm_o_show_video_64", "1", "yes");
INSERT INTO `wp_options` VALUES("12237", "wpm_o_show_woocommerce_products", "0", "yes");
INSERT INTO `wp_options` VALUES("12238", "wpm_o_show_video_56", "1", "yes");
INSERT INTO `wp_options` VALUES("12239", "wpm_o_show_video_57", "1", "yes");
INSERT INTO `wp_options` VALUES("12240", "wpm_o_show_video_58", "1", "yes");
INSERT INTO `wp_options` VALUES("12241", "wpm_o_show_video_59", "1", "yes");
INSERT INTO `wp_options` VALUES("12242", "wpm_o_show_video_60", "1", "yes");
INSERT INTO `wp_options` VALUES("12243", "wpm_o_show_video_61", "1", "yes");
INSERT INTO `wp_options` VALUES("12244", "wpm_o_show_video_51", "1", "yes");
INSERT INTO `wp_options` VALUES("12245", "wpm_o_show_google_analytics_setup", "0", "yes");
INSERT INTO `wp_options` VALUES("12246", "wpm_o_show_video_69", "1", "yes");
INSERT INTO `wp_options` VALUES("12247", "wpm_o_show_video_70", "1", "yes");
INSERT INTO `wp_options` VALUES("12248", "wpm_o_show_video_71", "1", "yes");
INSERT INTO `wp_options` VALUES("12249", "wpm_o_show_video_72", "1", "yes");
INSERT INTO `wp_options` VALUES("12250", "wpm_o_show_video_73", "1", "yes");
INSERT INTO `wp_options` VALUES("12251", "wpm_o_show_video_74", "1", "yes");
INSERT INTO `wp_options` VALUES("12252", "wpm_o_show_video_75", "1", "yes");
INSERT INTO `wp_options` VALUES("12253", "wpm_o_show_video_76", "1", "yes");
INSERT INTO `wp_options` VALUES("12254", "wpm_o_show_video_77", "1", "yes");
INSERT INTO `wp_options` VALUES("12255", "wpm_o_show_video_78", "1", "yes");
INSERT INTO `wp_options` VALUES("12256", "wpm_o_show_video_79", "1", "yes");
INSERT INTO `wp_options` VALUES("12257", "wpm_o_show_google_analytics_reports", "0", "yes");
INSERT INTO `wp_options` VALUES("12258", "wpm_o_show_video_80", "1", "yes");
INSERT INTO `wp_options` VALUES("12259", "wpm_o_show_video_81", "1", "yes");
INSERT INTO `wp_options` VALUES("12260", "wpm_o_show_video_82", "1", "yes");
INSERT INTO `wp_options` VALUES("12261", "wpm_o_show_video_83", "1", "yes");
INSERT INTO `wp_options` VALUES("12262", "wpm_o_show_video_84", "1", "yes");
INSERT INTO `wp_options` VALUES("12263", "wpm_o_show_video_85", "1", "yes");
INSERT INTO `wp_options` VALUES("12264", "wpm_o_show_video_87", "1", "yes");
INSERT INTO `wp_options` VALUES("12265", "wpm_o_show_video_88", "1", "yes");
INSERT INTO `wp_options` VALUES("12266", "wpm_o_show_video_89", "1", "yes");
INSERT INTO `wp_options` VALUES("12267", "wpm_o_show_video_90", "1", "yes");
INSERT INTO `wp_options` VALUES("12268", "wpm_o_show_gravity_forms", "0", "yes");
INSERT INTO `wp_options` VALUES("12269", "wpm_o_show_video_91", "1", "yes");
INSERT INTO `wp_options` VALUES("12270", "wpm_o_show_video_92", "1", "yes");
INSERT INTO `wp_options` VALUES("12271", "wpm_o_show_video_93", "1", "yes");
INSERT INTO `wp_options` VALUES("12272", "wpm_o_show_video_94", "1", "yes");
INSERT INTO `wp_options` VALUES("12273", "wpm_o_show_video_95", "1", "yes");
INSERT INTO `wp_options` VALUES("12274", "wpm_o_show_page_builder", "0", "yes");
INSERT INTO `wp_options` VALUES("12275", "wpm_o_show_video_97", "1", "yes");
INSERT INTO `wp_options` VALUES("12276", "wpm_o_show_video_98", "1", "yes");
INSERT INTO `wp_options` VALUES("12277", "wpm_o_show_video_99", "1", "yes");
INSERT INTO `wp_options` VALUES("12278", "wpm_o_show_video_100", "1", "yes");
INSERT INTO `wp_options` VALUES("12279", "wpm_o_show_video_102", "1", "yes");
INSERT INTO `wp_options` VALUES("12280", "wpm_o_show_video_103", "1", "yes");
INSERT INTO `wp_options` VALUES("12281", "wpm_o_show_video_104", "1", "yes");
INSERT INTO `wp_options` VALUES("12282", "wpm_o_show_video_105", "1", "yes");
INSERT INTO `wp_options` VALUES("12283", "wpm_o_show_video_106", "1", "yes");
INSERT INTO `wp_options` VALUES("12284", "wpm_o_show_video_107", "1", "yes");
INSERT INTO `wp_options` VALUES("12285", "wpm_o_show_video_108", "1", "yes");
INSERT INTO `wp_options` VALUES("12286", "wpm_o_show_video_109", "1", "yes");
INSERT INTO `wp_options` VALUES("12287", "wpm_o_show_video_110", "1", "yes");
INSERT INTO `wp_options` VALUES("12288", "wpm_o_show_video_111", "1", "yes");
INSERT INTO `wp_options` VALUES("12289", "wpm_o_show_video_112", "1", "yes");
INSERT INTO `wp_options` VALUES("12290", "wpm_o_show_video_113", "1", "yes");
INSERT INTO `wp_options` VALUES("12291", "wpm_o_show_video_114", "1", "yes");
INSERT INTO `wp_options` VALUES("12292", "wpm_o_show_video_115", "1", "yes");
INSERT INTO `wp_options` VALUES("12293", "wpm_o_show_video_116", "1", "yes");
INSERT INTO `wp_options` VALUES("12294", "wpm_o_show_video_117", "1", "yes");
INSERT INTO `wp_options` VALUES("12295", "wpm_o_show_video_118", "1", "yes");
INSERT INTO `wp_options` VALUES("12296", "wpm_o_num_local", "0", "yes");
INSERT INTO `wp_options` VALUES("12297", "wpm_o_vum_sections", "a:4:{i:0;s:6:\"editor\";i:1;s:6:\"images\";i:2;s:5:\"posts\";i:3;s:7:\"profile\";}", "yes");
INSERT INTO `wp_options` VALUES("13765", "options_home_layout", "a:8:{i:0;s:11:\"home_banner\";i:1;s:12:\"home_actions\";i:2;s:12:\"home_feature\";i:3;s:12:\"home_profile\";i:4;s:12:\"home_service\";i:5;s:12:\"home_inquiry\";i:6;s:12:\"home_clients\";i:7;s:11:\"home_badges\";}", "no");
INSERT INTO `wp_options` VALUES("13766", "_options_home_layout", "field_5988a08ecd80c", "no");
INSERT INTO `wp_options` VALUES("13936", "options_company_hours_0_company_time_opens", "8:00am", "no");
INSERT INTO `wp_options` VALUES("13937", "_options_company_hours_0_company_time_opens", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("13938", "options_company_hours_0_company_time_close", "6:00pm", "no");
INSERT INTO `wp_options` VALUES("13939", "_options_company_hours_0_company_time_close", "field_58343528781f1", "no");
INSERT INTO `wp_options` VALUES("13940", "options_company_hours_1_company_time_opens", "8:00am", "no");
INSERT INTO `wp_options` VALUES("13941", "_options_company_hours_1_company_time_opens", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("13942", "options_company_hours_1_company_time_close", "6:00pm", "no");
INSERT INTO `wp_options` VALUES("13943", "_options_company_hours_1_company_time_close", "field_58343528781f1", "no");
INSERT INTO `wp_options` VALUES("13944", "options_company_hours_2_company_time_opens", "8:00am", "no");
INSERT INTO `wp_options` VALUES("13945", "_options_company_hours_2_company_time_opens", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("13946", "options_company_hours_2_company_time_close", "6:00pm", "no");
INSERT INTO `wp_options` VALUES("13947", "_options_company_hours_2_company_time_close", "field_58343528781f1", "no");
INSERT INTO `wp_options` VALUES("13948", "options_company_hours_3_company_time_opens", "8:00am", "no");
INSERT INTO `wp_options` VALUES("13949", "_options_company_hours_3_company_time_opens", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("13950", "options_company_hours_3_company_time_close", "6:00pm", "no");
INSERT INTO `wp_options` VALUES("13951", "_options_company_hours_3_company_time_close", "field_58343528781f1", "no");
INSERT INTO `wp_options` VALUES("13952", "options_company_hours_4_company_time_opens", "8:00am", "no");
INSERT INTO `wp_options` VALUES("13953", "_options_company_hours_4_company_time_opens", "field_58343528781f0", "no");
INSERT INTO `wp_options` VALUES("13954", "options_company_hours_4_company_time_close", "6:00pm", "no");
INSERT INTO `wp_options` VALUES("13955", "_options_company_hours_4_company_time_close", "field_58343528781f1", "no");
INSERT INTO `wp_options` VALUES("14631", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("14814", "options_button_link", "a:3:{s:5:\"title\";s:10:\"Learn More\";s:3:\"url\";s:1:\"#\";s:6:\"target\";s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("14815", "_options_button_link", "field_5914dbbe1b518", "no");
INSERT INTO `wp_options` VALUES("15707", "wpseo_license_server_version", "2", "yes");
INSERT INTO `wp_options` VALUES("17709", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17710", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17711", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17712", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("17713", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18253", "akismet_spam_count", "22", "yes");
INSERT INTO `wp_options` VALUES("18484", "mwp_service_key", "1c4983fd-053b-4588-8936-90a602f160bd", "yes");
INSERT INTO `wp_options` VALUES("18490", "mwp_public_keys", "a:8:{i:0;a:6:{s:2:\"id\";s:19:\"managewp_1611453901\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3hF93JuaulKOMOtC+uys\nCCZaLkfNH5NhZmfqyfITyNxj0AwmPr4j61V0MjnH/0v5i9d/UOka7GhPeJCj3d68\n3T+pbrfY4xEcIu5phvhydOIykYAQcMAKyJ9DdtywrMssTLw43oHicVate1sKr/yt\nXyjrs2w7ukpOAfQvqIeOd9vfDYLsYnVQNImSKI8QE8cbOrcOBZRKlVzxROeSKDEo\npYXDXk0Vv2/NKJZjYbLEtBPZnIq9DQ3mIacnooNErfy43gXI2EUlnqBpEqg1K2Zo\nbGAp/laMyfRw62UCRbG7gIRKamSpfF2U7zeZ6FupKJVtXXiHVpEb1dJO6ZsQbQf9\nLQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:1;a:6:{s:2:\"id\";s:23:\"managewp_dev_1611453902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2sR2tXZBvt6ZU+IdCF0A\nA9dCli75kIuHg1tiS5IdnfY7fRvDspXj4QqzR8gC98p4opf16eSqYrEHVIbc8sUc\nICV+LE4aIrYY11fJS5gh8tnsPoe8YMwYoCNj76wV+SV9GqV/myvUDfbdDWveEG9v\nQO889BqVy5KPB6meAROXx6hsGxErHbnz0iPhjKkaoV3HRqt9jIuz4ayhO6+b0g6f\nRSJmxruL2skHQxnfhg+hlBg7pSr8ogLYfdZtZGVpjPmJSHuQa2jUtyy81VnbU3Se\n/TM15cjoqSySzWhbAq2nR5V5o8LFYkRh3G0mYFc51T0nln9ztz1dTEqipJC+FIWf\ntQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:2;a:6:{s:2:\"id\";s:16:\"mwp20_1611453902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA01Ltn/k7BFSWToKkt/VH\ngrmdWfORNhME0BJf+PPZn1VQm7HBqzO5aBAyHjmx1sF7Dq5AUpkghYoMdAFaBqbU\n/lJK3ObB9pvXcf04/9eIksdc+ojbqjIv1Gg33U05B72hOzKmtgCspGSNYvqUauaS\n/KGtvlTheGQi9GzTVUSDE5M6G6QkfXPkUrT004k4Uo8GqTbNfEGPEqX9//1aw5Vx\neuXLDF/ejKCoRaVvKnLjwHMBBuIfkeIMJwgjZtVKemZTEwk70HEa19sy7UZ4/U1M\njFnH7Fj3MC9pVlPbHiN0qHqP8Kfp1qavGRce6zN/V0llq2M6GgvE7+AlUezLd5to\nmwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:3;a:6:{s:2:\"id\";s:15:\"wpps_1611061501\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2021-02-03 13:05:01\";s:7:\"validTo\";s:19:\"2021-03-07 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6EIRoy8nBccFaql512/1\nOtsSm19jVENNNp5xOej36WHEqtQxNHYiUWtW5aGMDcGkG1WEX6jBk4d3rtWUNmT/\nrsiyPWNjJFIOUWK4zyTgJNg+ujJbF16U2/uQgscngUAuuJ0DaJyZE78SneoIjgsO\nk73k/qSnwrr7kLkrDJSPK3Ad/wnvYzh0Ww0tDHbdOGRBgfFy3qEnFAG/7b1TaL5p\n9k3MpV3iH2q9bt2hfWPcyaeA1MoK9SuhXLKnC94fJxpNfuvUbnFIi3Fu1KVUlY/R\nvkdoCS0WX9ypXOdPYUdhdyn36GnXwul2ba8qiiQeBqhUuKNC6rQTnEeU6ZUl4zU3\n0QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:4;a:6:{s:2:\"id\";s:25:\"cookie_service_1609693501\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2021-01-18 16:27:25\";s:7:\"validTo\";s:19:\"2021-02-19 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2A5j+O6Ij3/58lAqmPIQ\ncQI/M0yztpYTH3LDH9/l0vDFYNKG4sRT0L9zTaEo4AUlZQoxeOkN/hxkt9h3nhPZ\nKfYJaaXyG5L+j4m90tlzHddQdhOjy0bVTn2PlLZ3nitHIssemN/YHHdNMjybZG5/\nONOTnpBJP4uh1kt5CP2K25YDnFXvl5SHMzdLIpSVXr5PsdhfXWMQ/7/f2FMCvHRK\nvmgyEjNjnh3b/speHgIwOeuQd9mr1xsjncVE5+1XsXBRmGdfwz5x90QmUU6AT+Ey\nN70P9qiaUXPjs9M3MxaUS+KicRbq5VEXUL4EPTR6UKaYQOvcbKHRtLJE3hEC8WOO\njQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:5;a:6:{s:2:\"id\";s:25:\"cookie_service_1612285502\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2021-02-17 16:27:25\";s:7:\"validTo\";s:19:\"2021-03-21 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0KqvzL3RH1fv555jY9Fg\n++yfNy2X63c2GqA7CzPcq5YZyHBdDx38RLuJkoY4uai2m3/BKmXd4ki/Ti72IfZF\n+Nj+N1Eb0Q5cha6IsvqGVEZ6wuVFZSr/rglzreQKUtlx3RJDevT95dyv3m8dxdnY\nH1xvclxgsAQ6BrdS/tJvJgoE4vVk+ftAVJ/Q6rAwxMPAUl8cVUWjZ6jB2IQubw2s\nkxapu7VI2PUopP2zfbhCrn+ZshjDdGIWMMCMrOuY/MoPz+RUT9DVJVon430sNbqQ\n/VwzJIbmPEj+axEj1UcHbGMRMf+kFcSUBWM3gsTQ9rud2HqoMOU5mKpbq8JoGTmc\nGwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:6;a:6:{s:2:\"id\";s:15:\"mwp1_1611151502\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2021-02-04 14:05:01\";s:7:\"validTo\";s:19:\"2021-03-08 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6f1ww6iqo1dncWlpJ9OM\n4APLx1a8yFClAZn14+c1muJ4BUW7dyjW57B68jvddO+tUwBn4bWoyW7VgTjZjWni\nVFzeQ6TBnR3QMLTFk1znXjPuWXnGEbicovat0vScIcZ/0wPSBBtmF5oUrUyumn3B\nGvCHhq20qskZcVTz7gUVrIf9irvqsV/PBCfCHCZJvoc9kTWRNoLNZCG2n7JpPcs2\nRi4mb2CmemypiZMo2abQFZIpcYxO+cVXl0u7dWcbeza1964H0RtAL7Lu/HRlM1rT\nqclDpjCKwXsGH1bdVFlSxxSc4Ue1HxR1sxcVgJONf2pxBLLvU2IcNisl/bendiOC\nDQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:7;a:6:{s:2:\"id\";s:20:\"migration_1611410701\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2021-02-07 13:05:02\";s:7:\"validTo\";s:19:\"2021-03-11 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzOLQCOiNlMcCN5nc2PRJ\ng245K7nIruBZiX9Lxn3Wdg4HbqIaof93xGP+MFk42fmVMKdmTDrGBVs+0MtnKTiF\n8xb8iBkShSY/5QnLR+yn4AfPlaaHX3bdHmxJMKzz5rtwgB1JM2CqQkkBte9nfoeL\nvoYirbqB2h59bp6u7pcRNMs0nzNhO2Q/Li0/+rvTbzQKlW0VKbft1TcCmwDIdldg\n0FTweG1muKuVmGAvVaUhtP0NuOx7HRLWQtCUm7q4kolVgdQ3Spv7M5eG4dVFtfGE\nPjCFxchfl9W4AKliTeewzEgJtpwpkYdIJwl05ObCsthU3UYvPdduTwss4QQeppjG\nxQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("18579", "mwp_new_communication_established", "1", "yes");
INSERT INTO `wp_options` VALUES("19167", "wp-optimize-enable-auto-backup", "false", "yes");
INSERT INTO `wp_options` VALUES("19183", "autoptimize_extra_settings", "a:5:{s:34:\"autoptimize_extra_checkbox_field_1\";s:1:\"1\";s:34:\"autoptimize_extra_checkbox_field_0\";s:1:\"1\";s:31:\"autoptimize_extra_radio_field_4\";s:1:\"1\";s:30:\"autoptimize_extra_text_field_2\";s:0:\"\";s:30:\"autoptimize_extra_text_field_3\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("19186", "autoptimize_optimize_logged", "on", "yes");
INSERT INTO `wp_options` VALUES("19187", "autoptimize_optimize_checkout", "", "yes");
INSERT INTO `wp_options` VALUES("19442", "c8e7bcc567376659eb70f8e43ba4a069", "a:2:{s:7:\"timeout\";i:1517670923;s:5:\"value\";s:106590:\"{\"new_version\":\"3.0\",\"stable_version\":\"3.0\",\"name\":\"Formidable Pro\",\"slug\":\"formidable-pro\",\"url\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro\\/?changelog=1\",\"last_updated\":\"2018-02-02 07:35:36\",\"homepage\":\"https:\\/\\/formidableforms.com\\/\",\"package\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxNzczMjExNToyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDpjNDE0YzYxYzkyM2RhYjE5MDkyOGIxODUyNjM2ZjE3ZDpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"download_link\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxNzczMjExNToyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDpjNDE0YzYxYzkyM2RhYjE5MDkyOGIxODUyNjM2ZjE3ZDpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"sections\":{\"description\":\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\",\"changelog\":\"<p><h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<h4>v2.05b1 - September 21, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes.<\\/li>\\n<li>New: Add option to not save IP address with entries.<\\/li>\\n<li>Enhancement: Update minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating directly to it.<\\/li>\\n<li>Fix: Don\'t run the_content filter on View content. Instead, filter the content with functions.<\\/li>\\n<\\/ul>\\n<h4>v2.04.02b1 - September 13, 2017<\\/h4>\\r\\n<p>**Lite Version**<\\/p>\\n<ul>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors in frm-show-entry.<\\/li>\\n<li>Fix: Allow SQL meta_value comparison to integers.<\\/li>\\n<li>Fix: Restore Default Plain option.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads later.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<\\/ul>\\n<p>**Pro Version**<\\/p>\\n<ul>\\n<li>New: Adds new_page param to file upload display shortcode.<\\/li>\\n<li>New: Add frm_before_entries_table hook.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Add RTL time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Work on the \\\"inside\\\" label position.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state.<\\/li>\\n<li>Fix: Delete files if they are 3 hours old or more, regardless of time zone.<\\/li>\\n<li>Fix: Add on to media meta_query rather than replacing it.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Default value for checkbox fields across pages.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Fix credit card fields with drafts.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Make sure repeating field calculations use values from the correct rows.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Improve duplicating sections on form builder.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\",\"installation\":\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\",\"frequently_asked_questions\":\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\n<p>Try the following steps:<\\/p>\\n\\n<ol>\\n<li>Double check to make sure your email address is present and correct in your Email form action on the form \\\"Settings\\\" page. The [admin_email] shortcode uses the email address from your WordPress Settings -&gt; General page.<\\/li>\\n<li>Make sure you are receiving other emails from your site (ie comment notifications, forgot password...). If these emails don\'t work on your site, form emails will not work either.<\\/li>\\n<li>Check your SPAM box<\\/li>\\n<li>Try a different email address in your contact form settings.<\\/li>\\n<li>Install Postman SMPT or another similar plugin and configure the SMTP settings.<\\/li>\\n<li>If none of these steps fix the problem with your form emails, and other site emails are not going out, please contact your web host. You can also <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-not-sending-emails-smtp\\/\\\" title=\\\"read more about WordPress emails not sending\\\">read more about WordPress emails not sending<\\/a> in our blog.<\\/li>\\n<\\/ol>\\n\\n<h4>How do I edit the field names in my forms?<\\/h4>\\n\\n<p>The field and form names and descriptions are all changed with in-place edit. Just click on the text you would like to change, and it will turn into a text field.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/formidable-faqs\\/\\\" title=\\\"Formidable Form FAQs\\\">See more FAQs<\\/a><\\/p>\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-772x250.png\"},\"tested\":\"4.9\",\"tested_up_to\":\"4.9\",\"stable_tag\":\"3.0\",\"contributors\":[\"formidableforms\",\"sswells\",\"srwells\",\"jamiewahlin\"],\"description\":[\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\"],\"changelog\":[\"<p><h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<h4>v2.05b1 - September 21, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes.<\\/li>\\n<li>New: Add option to not save IP address with entries.<\\/li>\\n<li>Enhancement: Update minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating directly to it.<\\/li>\\n<li>Fix: Don\'t run the_content filter on View content. Instead, filter the content with functions.<\\/li>\\n<\\/ul>\\n<h4>v2.04.02b1 - September 13, 2017<\\/h4>\\r\\n<p>**Lite Version**<\\/p>\\n<ul>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors in frm-show-entry.<\\/li>\\n<li>Fix: Allow SQL meta_value comparison to integers.<\\/li>\\n<li>Fix: Restore Default Plain option.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads later.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<\\/ul>\\n<p>**Pro Version**<\\/p>\\n<ul>\\n<li>New: Adds new_page param to file upload display shortcode.<\\/li>\\n<li>New: Add frm_before_entries_table hook.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Add RTL time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Work on the \\\"inside\\\" label position.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state.<\\/li>\\n<li>Fix: Delete files if they are 3 hours old or more, regardless of time zone.<\\/li>\\n<li>Fix: Add on to media meta_query rather than replacing it.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Default value for checkbox fields across pages.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Fix credit card fields with drafts.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Make sure repeating field calculations use values from the correct rows.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Improve duplicating sections on form builder.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\"],\"installation\":[\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\"],\"frequently_asked_questions\":[\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\n<p>Try the following steps:<\\/p>\\n\\n<ol>\\n<li>Double check to make sure your email address is present and correct in your Email form action on the form \\\"Settings\\\" page. The [admin_email] shortcode uses the email address from your WordPress Settings -&gt; General page.<\\/li>\\n<li>Make sure you are receiving other emails from your site (ie comment notifications, forgot password...). If these emails don\'t work on your site, form emails will not work either.<\\/li>\\n<li>Check your SPAM box<\\/li>\\n<li>Try a different email address in your contact form settings.<\\/li>\\n<li>Install Postman SMPT or another similar plugin and configure the SMTP settings.<\\/li>\\n<li>If none of these steps fix the problem with your form emails, and other site emails are not going out, please contact your web host. You can also <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-not-sending-emails-smtp\\/\\\" title=\\\"read more about WordPress emails not sending\\\">read more about WordPress emails not sending<\\/a> in our blog.<\\/li>\\n<\\/ol>\\n\\n<h4>How do I edit the field names in my forms?<\\/h4>\\n\\n<p>The field and form names and descriptions are all changed with in-place edit. Just click on the text you would like to change, and it will turn into a text field.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/formidable-faqs\\/\\\" title=\\\"Formidable Form FAQs\\\">See more FAQs<\\/a><\\/p>\"]}\";}", "yes");
INSERT INTO `wp_options` VALUES("19454", "frm_attempt_copy", "1", "yes");
INSERT INTO `wp_options` VALUES("19574", "59ea8ad6c6d10756471b39051f775377", "a:2:{s:7:\"timeout\";i:1517915878;s:5:\"value\";s:105255:\"{\"new_version\":\"3.0.01\",\"stable_version\":\"3.0.01\",\"name\":\"Formidable Pro\",\"slug\":\"formidable-pro\",\"url\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro\\/?changelog=1\",\"last_updated\":\"2018-02-03 00:32:16\",\"homepage\":\"https:\\/\\/formidableforms.com\\/\",\"package\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxNzk3NzA3MDoyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDoxNjM3OWY2ZTU3ZDUzNjhjODRkOGI3NGMxMTljNzMxMjpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"download_link\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxNzk3NzA3MDoyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDoxNjM3OWY2ZTU3ZDUzNjhjODRkOGI3NGMxMTljNzMxMjpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"sections\":{\"description\":\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\",\"changelog\":\"<p><h4>v3.0.01 - February 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use toggle fields in calculations and conditional logic<\\/li>\\n<li>Fix: Some conditional logic based on empty radio fields wasn\'t functioning<\\/li>\\n<li>Fix: Require time fields at the correct times<\\/li>\\n<li>Fix: Trigger style update when a form is loaded instead of only when an admin page is visited<\\/li>\\n<li>Fix: A few various form styling and layout fixes<\\/li>\\n<li>Fix: Prevent screenreader text for accessibility from showing on sites with older cached css<\\/li>\\n<li>Fix: Prevent conflict with Divi when a form shortcode with a recaptcha is included in page editor<\\/li>\\n<li>Fix: Use \'readfile\' instead of \'include\' for css files for extra safety precautions<\\/li>\\n<li>Fix: Load the field options before frm_new_fields_vars hook for reverse compatibility<\\/li>\\n<\\/ul>\\n<h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4 id=\\\"known-issues\\\">Known Issues<\\/h4>\\n<ul>\\n<li>Divi conflict: Pages that include a form with a recaptcha are not loading. (Fixed for 3.0.1)<\\/li>\\n<li>Styling issues with certain form layouts. We are working on it. In the meantime, go to the Formidable -&gt; Global settings page and check the box to \\\"Load form layout styling for old browsers.\\\" This will load the styling from the previous version of Formidable.<\\/li>\\n<li>Shortcodes showing in some views. Before 3.0, when you had multiple view shortcodes on the page, and one includes filter=1 or filter=limited, all of the views after that would be filtered. Be sure to include filter=limited or filter=1 in any view shortcodes that include a nested shortcode.<\\/li>\\n<li>\\\"If you are human, leave this field blank\\\" showing. This means your styling didn\'t update. Try the following steps:<br \\/>\\n1. Visit a page in your admin area to trigger the update.<br \\/>\\n2. If no change, go to the Formidable -&gt; Styles page and hit update.<br \\/>\\n3. If it still doesn\\u2019t change, clear any CDN or other file caches you may have.<br \\/>\\n4. Clear your browser cache.<\\/li>\\n<\\/ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<h4>v2.05b1 - September 21, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes.<\\/li>\\n<li>New: Add option to not save IP address with entries.<\\/li>\\n<li>Enhancement: Update minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating directly to it.<\\/li>\\n<li>Fix: Don\'t run the_content filter on View content. Instead, filter the content with functions.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\",\"installation\":\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\",\"frequently_asked_questions\":\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\n<p>Try the following steps:<\\/p>\\n\\n<ol>\\n<li>Double check to make sure your email address is present and correct in your Email form action on the form \\\"Settings\\\" page. The [admin_email] shortcode uses the email address from your WordPress Settings -&gt; General page.<\\/li>\\n<li>Make sure you are receiving other emails from your site (ie comment notifications, forgot password...). If these emails don\'t work on your site, form emails will not work either.<\\/li>\\n<li>Check your SPAM box<\\/li>\\n<li>Try a different email address in your contact form settings.<\\/li>\\n<li>Install Postman SMPT or another similar plugin and configure the SMTP settings.<\\/li>\\n<li>If none of these steps fix the problem with your form emails, and other site emails are not going out, please contact your web host. You can also <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-not-sending-emails-smtp\\/\\\" title=\\\"read more about WordPress emails not sending\\\">read more about WordPress emails not sending<\\/a> in our blog.<\\/li>\\n<\\/ol>\\n\\n<h4>How do I edit the field names in my forms?<\\/h4>\\n\\n<p>The field and form names and descriptions are all changed with in-place edit. Just click on the text you would like to change, and it will turn into a text field.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/formidable-faqs\\/\\\" title=\\\"Formidable Form FAQs\\\">See more FAQs<\\/a><\\/p>\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-772x250.png\"},\"tested\":\"4.9\",\"tested_up_to\":\"4.9\",\"stable_tag\":\"3.0.01\",\"contributors\":[\"formidableforms\",\"sswells\",\"srwells\",\"jamiewahlin\"],\"description\":[\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\"],\"changelog\":[\"<p><h4>v3.0.01 - February 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use toggle fields in calculations and conditional logic<\\/li>\\n<li>Fix: Some conditional logic based on empty radio fields wasn\'t functioning<\\/li>\\n<li>Fix: Require time fields at the correct times<\\/li>\\n<li>Fix: Trigger style update when a form is loaded instead of only when an admin page is visited<\\/li>\\n<li>Fix: A few various form styling and layout fixes<\\/li>\\n<li>Fix: Prevent screenreader text for accessibility from showing on sites with older cached css<\\/li>\\n<li>Fix: Prevent conflict with Divi when a form shortcode with a recaptcha is included in page editor<\\/li>\\n<li>Fix: Use \'readfile\' instead of \'include\' for css files for extra safety precautions<\\/li>\\n<li>Fix: Load the field options before frm_new_fields_vars hook for reverse compatibility<\\/li>\\n<\\/ul>\\n<h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4 id=\\\"known-issues\\\">Known Issues<\\/h4>\\n<ul>\\n<li>Divi conflict: Pages that include a form with a recaptcha are not loading. (Fixed for 3.0.1)<\\/li>\\n<li>Styling issues with certain form layouts. We are working on it. In the meantime, go to the Formidable -&gt; Global settings page and check the box to \\\"Load form layout styling for old browsers.\\\" This will load the styling from the previous version of Formidable.<\\/li>\\n<li>Shortcodes showing in some views. Before 3.0, when you had multiple view shortcodes on the page, and one includes filter=1 or filter=limited, all of the views after that would be filtered. Be sure to include filter=limited or filter=1 in any view shortcodes that include a nested shortcode.<\\/li>\\n<li>\\\"If you are human, leave this field blank\\\" showing. This means your styling didn\'t update. Try the following steps:<br \\/>\\n1. Visit a page in your admin area to trigger the update.<br \\/>\\n2. If no change, go to the Formidable -&gt; Styles page and hit update.<br \\/>\\n3. If it still doesn\\u2019t change, clear any CDN or other file caches you may have.<br \\/>\\n4. Clear your browser cache.<\\/li>\\n<\\/ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<h4>v2.05b1 - September 21, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes.<\\/li>\\n<li>New: Add option to not save IP address with entries.<\\/li>\\n<li>Enhancement: Update minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating directly to it.<\\/li>\\n<li>Fix: Don\'t run the_content filter on View content. Instead, filter the content with functions.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\"],\"installation\":[\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\"],\"frequently_asked_questions\":[\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\n<p>Try the following steps:<\\/p>\\n\\n<ol>\\n<li>Double check to make sure your email address is present and correct in your Email form action on the form \\\"Settings\\\" page. The [admin_email] shortcode uses the email address from your WordPress Settings -&gt; General page.<\\/li>\\n<li>Make sure you are receiving other emails from your site (ie comment notifications, forgot password...). If these emails don\'t work on your site, form emails will not work either.<\\/li>\\n<li>Check your SPAM box<\\/li>\\n<li>Try a different email address in your contact form settings.<\\/li>\\n<li>Install Postman SMPT or another similar plugin and configure the SMTP settings.<\\/li>\\n<li>If none of these steps fix the problem with your form emails, and other site emails are not going out, please contact your web host. You can also <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-not-sending-emails-smtp\\/\\\" title=\\\"read more about WordPress emails not sending\\\">read more about WordPress emails not sending<\\/a> in our blog.<\\/li>\\n<\\/ol>\\n\\n<h4>How do I edit the field names in my forms?<\\/h4>\\n\\n<p>The field and form names and descriptions are all changed with in-place edit. Just click on the text you would like to change, and it will turn into a text field.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/formidable-faqs\\/\\\" title=\\\"Formidable Form FAQs\\\">See more FAQs<\\/a><\\/p>\"]}\";}", "yes");
INSERT INTO `wp_options` VALUES("19597", "_site_transient_mwp_sessions", "a:1:{i:1;a:8:{i:0;s:43:\"CTdAEzXAiu3DnDVnuYIK6w1CNpXd6OPKNxC4rA235ym\";i:1;s:43:\"A61KIoMUUG3Rkq4GsD70inB9fyu7J9OpTjH9hT5F6p8\";i:2;s:43:\"hgOYs9tPb09CTbMGeOr1Je4CljSNSjtiu9t8yZHoFcv\";i:3;s:43:\"etP10vLWboBMeyVL9r7An8hBl2f4ZfYLkfZC3rhKdAR\";i:4;s:43:\"OA5QLUVA6pmnaWAwmydJvbRAamc4jk4UVRHmG9tQJR1\";i:5;s:43:\"pP4K53wdSRZD9hfczf0IwERJfGj1CSnH8VZg4E7K7ji\";i:6;s:43:\"VnN0PsJrVV1XYrIiXfKU7c2eewEKUltqNFrF0bnCLZH\";i:7;s:43:\"251tHy7vTHVE7d4Y4Cs3Vi3qvklH5djkazcQiU5nt0t\";}}", "no");
INSERT INTO `wp_options` VALUES("19666", "8644537f0033af61d3b0f5f84fde6a62", "a:2:{s:7:\"timeout\";i:1518126009;s:5:\"value\";s:107733:\"{\"new_version\":\"3.0.02\",\"stable_version\":\"3.0.02\",\"name\":\"Formidable Pro\",\"slug\":\"formidable-pro\",\"url\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro\\/?changelog=1\",\"last_updated\":\"2018-02-06 14:10:48\",\"homepage\":\"https:\\/\\/formidableforms.com\\/\",\"package\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxODE4NzIwMDoyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDpkYzg1NDg3YzJlMmFmY2YwNzA2Y2EzNDY4ZGM3ZjIwMzpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"download_link\":\"https:\\/\\/formidableforms.com\\/edd-sl\\/package_download\\/MTUxODE4NzIwMDoyM0gxNC04QU9EUy1GTUVORi1LMDZKSzo5Mzc5MDpkYzg1NDg3YzJlMmFmY2YwNzA2Y2EzNDY4ZGM3ZjIwMzpodHRwc0AvL3RlbXBsYXRlMDEub3VyZGVtb3NpdGVzLmNvbTow\",\"sections\":{\"description\":\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\",\"changelog\":\"<p><h4>v3.0.02 - February 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Show a generated screenshot of the embedded form in the form builder rather than the first few fields<\\/li>\\n<li>Tweak: Move the forms css inside the plugin rather than saving it in the uploads folder so it will always be reset after updates<\\/li>\\n<li>New: Add frm_fields_container_class hook for changing the new form container class attributes<\\/li>\\n<li>Fix: Auto updates with the nested version going from 3.0 were failing and updating to lite<\\/li>\\n<li>Fix: Some default values were overiding non defaults when the form was displayed. This included user ID fields and other ifelds with separate values.<\\/li>\\n<li>Fix: Recompile the combined javascript file any time the pro version number changes<\\/li>\\n<li>Fix: Embedded forms were being changed when the parent form was saved<\\/li>\\n<li>Fix: Dynamic fields showing the entry key were blank with [25 show=key].<\\/li>\\n<li>Fix: More reliably run calculations in hidden fields inside of a section on multi paged forms<\\/li>\\n<li>Fix: Don\'t apply auto layout classes to inline forms with more than 12 fields<\\/li>\\n<li>Fix: When checking if an inline form needs layout classes added, check for non-numeric classes like frm_half<\\/li>\\n<li>Fix: Prevent the comment box on the entries page from closing immediately<\\/li>\\n<li>Fix: More form styling fixes for css grids. Fixes cover layouts with frm_alignright and smoother responsive layouts.<\\/li>\\n<li>Fix: Combine the old and new form css, and include the old layout CSS by default<\\/li>\\n<li>Fix: Trigger the activation install right when the plugin is installed<\\/li>\\n<li>Fix: Don\'t add label position styling to fields that don\'t include the option to change the label position<\\/li>\\n<li>Fix: Correctly limit the number of fields returned when using the FrmField::get_all_for_form function with a limit set<\\/li>\\n<\\/ul>\\n<h4>v3.0.01 - February 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use toggle fields in calculations and conditional logic<\\/li>\\n<li>Fix: Some conditional logic based on empty radio fields wasn\'t functioning<\\/li>\\n<li>Fix: Require time fields at the correct times<\\/li>\\n<li>Fix: Trigger style update when a form is loaded instead of only when an admin page is visited<\\/li>\\n<li>Fix: A few various form styling and layout fixes<\\/li>\\n<li>Fix: Prevent screenreader text for accessibility from showing on sites with older cached css<\\/li>\\n<li>Fix: Prevent conflict with Divi when a form shortcode with a recaptcha is included in page editor<\\/li>\\n<li>Fix: Use \'readfile\' instead of \'include\' for css files for extra safety precautions<\\/li>\\n<li>Fix: Load the field options before frm_new_fields_vars hook for reverse compatibility<\\/li>\\n<\\/ul>\\n<h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4 id=\\\"known-issues\\\">Known Issues<\\/h4>\\n<ul>\\n<li>Divi conflict: Pages that include a form with a recaptcha are not loading. (Fixed for 3.0.1)<\\/li>\\n<li>Styling issues with certain form layouts. We are working on it. In the meantime, go to the Formidable -&gt; Global settings page and check the box to \\\"Load form layout styling for old browsers.\\\" This will load the styling from the previous version of Formidable.<\\/li>\\n<li>Shortcodes showing in some views. Before 3.0, when you had multiple view shortcodes on the page, and one includes filter=1 or filter=limited, all of the views after that would be filtered. Be sure to include filter=limited or filter=1 in any view shortcodes that include a nested shortcode.<\\/li>\\n<li>\\\"If you are human, leave this field blank\\\" showing. This means your styling didn\'t update. Try the following steps:<br \\/>\\n1. Visit a page in your admin area to trigger the update.<br \\/>\\n2. If no change, go to the Formidable -&gt; Styles page and hit update.<br \\/>\\n3. If it still doesn\\u2019t change, clear any CDN or other file caches you may have.<br \\/>\\n4. Clear your browser cache.<\\/li>\\n<\\/ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\",\"installation\":\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\",\"frequently_asked_questions\":\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\n<p>Try the following steps:<\\/p>\\n\\n<ol>\\n<li>Double check to make sure your email address is present and correct in your Email form action on the form \\\"Settings\\\" page. The [admin_email] shortcode uses the email address from your WordPress Settings -&gt; General page.<\\/li>\\n<li>Make sure you are receiving other emails from your site (ie comment notifications, forgot password...). If these emails don\'t work on your site, form emails will not work either.<\\/li>\\n<li>Check your SPAM box<\\/li>\\n<li>Try a different email address in your contact form settings.<\\/li>\\n<li>Install Postman SMPT or another similar plugin and configure the SMTP settings.<\\/li>\\n<li>If none of these steps fix the problem with your form emails, and other site emails are not going out, please contact your web host. You can also <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-not-sending-emails-smtp\\/\\\" title=\\\"read more about WordPress emails not sending\\\">read more about WordPress emails not sending<\\/a> in our blog.<\\/li>\\n<\\/ol>\\n\\n<h4>How do I edit the field names in my forms?<\\/h4>\\n\\n<p>The field and form names and descriptions are all changed with in-place edit. Just click on the text you would like to change, and it will turn into a text field.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/formidable-faqs\\/\\\" title=\\\"Formidable Form FAQs\\\">See more FAQs<\\/a><\\/p>\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-772x250.png\"},\"tested\":\"4.9\",\"tested_up_to\":\"4.9\",\"stable_tag\":\"3.0.02\",\"contributors\":[\"formidableforms\",\"sswells\",\"srwells\",\"jamiewahlin\"],\"description\":[\"<h4>WordPress Form Builder Plugin<\\/h4>\\n\\n<p>Formidable Forms is a flexible and free WordPress form plugin. Easily create contact forms, polls and surveys, lead generation forms, email forms, and any other forms you imagine. Start with a pre-built contact form template or create totally custom forms. From the smallest sidebar opt-in form to large job and employment application forms, Formidable Forms is built to do it all. Learn more about Formidable Forms at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"FormidableForms.com\\\">FormidableForms.com<\\/a><\\/p>\\n\\n<p>Create a professional WordPress contact form without any code. Get mobile-friendly responsive forms that look great on any screen size. Additionally, changing the form layout is simple with included layout classes. If you need more advanced customizations, you have complete access to change the form HTML and CSS.<\\/p>\\n\\n<p><a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/\\\" title=\\\"View form builder Documentation\\\">View form builder Documentation<\\/a><\\/p>\\n\\n<h4>All the features you need for beautiful WordPress Forms<\\/h4>\\n\\n<p>Create unlimited forms with all the essential field types.<\\/p>\\n\\n<ul>\\n<li>Single line text (for names, phone numbers, addresses, and more)<\\/li>\\n<li>Email<\\/li>\\n<li>Website\\/URL<\\/li>\\n<li>Paragraph text<\\/li>\\n<li>Radio buttons<\\/li>\\n<li>Checkboxes<\\/li>\\n<li>Dropdown select boxes<\\/li>\\n<li>Number<\\/li>\\n<li>Phone number<\\/li>\\n<li>Hidden fields<\\/li>\\n<li>User ID<\\/li>\\n<li>HTML block<\\/li>\\n<li>reCaptcha (Invisible or one-click checkbox)<\\/li>\\n<\\/ul>\\n\\n<h4>Form templates<\\/h4>\\n\\n<p>Create forms in seconds with <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-form-templates\\/\\\">pre-built form templates<\\/a>. Or add your own form templates and export the forms to share. A free contact form template is included when you install Formidable Forms. We also have a growing library of <a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/category\\/form-templates\\/\\\">downloadable form templates<\\/a>.<\\/p>\\n\\n<h4>Customize your WordPress forms<\\/h4>\\n\\n<p>Whether you start from scratch or from a form template, your forms can be customized however you would like.<\\/p>\\n\\n<ul>\\n<li>Send <strong>unlimited form email notifications and autoresponders<\\/strong>.<\\/li>\\n<li>Use <strong>input placeholder text<\\/strong> in form fields that clear when typing starts.<\\/li>\\n<li>Use our ready-made CSS classes (or your own custom CSS classes) to arrange your form fields and create <strong>multi-column forms<\\/strong><\\/li>\\n<li><strong>Modify the form HTML<\\/strong> for your individual needs.<\\/li>\\n<li>Customize the form\\u2019s success message and submit button text.<\\/li>\\n<li>Redirect to another page after submit or show content from a protected page.<\\/li>\\n<\\/ul>\\n\\n<h4>Style your WordPress forms with no code<\\/h4>\\n\\n<p>Use the built-in <a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">visual form style generator<\\/a> to instantly customize the look and feel of your WordPress forms. With just a few clicks, your form can be transformed to match your personal style. A single form styling template will be applied to all the forms on your site. But if you decide you need different styles for different forms, Formidable Forms Pro is waiting.<\\/p>\\n\\n<h4>Publish your WordPress forms with ease<\\/h4>\\n\\n<p>Once your WP form is built and designed just the way you like it, publish with an easy-to-use <strong>shortcode builder<\\/strong> UI. Direct links are also available for <strong>form previews<\\/strong> and <strong>emailing surveys<\\/strong> on a blank page.<\\/p>\\n\\n<p><strong>Honeypot spam protection<\\/strong> is included in every website form, but you can also add Invisible reCAPTCHA, one-click reCAPTCHA, and Akismet for extra Spam control in your contact forms.<\\/p>\\n\\n<h4>Save every form submission<\\/h4>\\n\\n<p>You may already know it, but sending emails with your self-hosted WordPress website isn\'t 100% reliable. But every lead captured in your online contact forms is important. Don\'t lose a single one! This is why Formidable saves every contact form submission in your WordPress database and lists them on your Formidable -&gt; Entries page. Now even if a form email notification fails, you won\\u2019t lose a lead.<\\/p>\\n\\n<p>Do you need <strong>GDPR compliant forms<\\/strong>? No problem. Turn off IP tracking or the setting to save your form submissions, or add a checkbox field to your form to collect consent.<\\/p>\\n\\n<p>Need to import your leads to another service like MailChimp? No problem. <strong>Export form leads to a CSV<\\/strong> then open it in Excel or import anywhere.<\\/p>\\n\\n<p>Plus, don\'t lose leads by accidentally deleting a form. <strong>Send forms to the trash<\\/strong> and recover them if needed.<\\/p>\\n\\n<p>https:\\/\\/www.youtube.com\\/watch?v=d2IPmicn2x8<\\/p>\\n\\n<h4>Pro Form Builder Plugin Features<\\/h4>\\n\\n<p>Formidable Forms Pro is an upgrade that adds even more power to your free forms. Multi-page forms, conditional logic, payment form integrations, data management, front-end post submissions for user-generated content, front-end editing, and boat loads more.<\\/p>\\n\\n<p>Other WordPress form builder plugins only let you collect data. But our Pro forms also add options to display form submissions on the front-end of your site. Input, display, edit and filter data on the front-end without any additional plugins. Formidable Forms is a powerful solution for purchase forms, order forms, member directories, user registration forms, event calendars, and more.<\\/p>\\n\\n<ul>\\n<li><strong>Even more field types<\\/strong>: Page breaks, section headings, repeating field groups (repeaters), multiple file uploads, rich text, datepicker, time, scale, star ratings, slider, toggle, dynamic fields populated from other forms, password, tags, address, and more.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Multi-Step forms with progress bar<\\/a>: Create beautiful paged forms with rootline and progress indicators. Use conditional logic on page breaks for branching forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-multi-step-form\\/\\\">Conditional logic for smart forms<\\/a>: Show or hide fields in your form based on user selections or the role of the user.<\\/li>\\n<li>Email routing: Conditionally send multiple autoresponder emails and notifications based on values in your form.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-calculated-fields-form\\/\\\">Calculated Fields<\\/a>: create basic and complex calculations, and even combine text from multiple fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/wordpress-visual-form-styler\\/\\\">Visual form styler with multiple templates<\\/a>: Create multiple form styling templates and assign them to any of your forms. Need Bootstrap form styling? We\\u2019ve got you covered.<\\/li>\\n<li>Entry management: Flexibly and powerfully display, edit, and delete entries from anywhere on your site, and specify who has permission to do so.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/display-form-data-views\\/\\\" title=\\\"Display form data with Views\\\">Display form data with Views<\\/a>: Format, filter and display the data submitted in your WordPress forms in custom Views.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/create-a-graph-wordpress-forms\\/\\\">Graphs and charts for data visualization<\\/a>: Display statistics from form entries, and graph your data in a variety of eye catching styles with graphs that automatically update as new data is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/user-submitted-posts-wordpress-forms\\/\\\">User submitted front-end posts and pages<\\/a>: Create and edit WordPress posts, pages, and even custom post types from front-end online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/front-end-editing-wordpress\\/\\\">Front-end editing<\\/a>: allow users to edit their form entries and posts from the front-end of your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/save-and-continue-partial-submissions\\/\\\">Saved and continue partial submissions<\\/a>: logged-in users can save form progress and return later.<\\/li>\\n<li>Form permission settings: limit form visibility based on user role.<\\/li>\\n<li>Conditionally redirect after form submission.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/fill-out-forms-automatically\\/\\\">Fill out forms automatically<\\/a> with user meta or values from your posts including custom fields.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/importing-exporting-wordpress-forms\\/\\\">Import and Export form submissions<\\/a> with CSV.<\\/li>\\n<li>Limit the number of form entries per user, IP, or cookie.<\\/li>\\n<li>Import our <a href=\\\"https:\\/\\/formidableforms.com\\/demos\\/\\\">pre-built form\\/view demo templates<\\/a> as a starting point or a final product.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/features\\/white-label-form-builder-wordpress\\/\\\" title=\\\"White labeling\\\">White labeling<\\/a>: Replace the Formidable branding with your own in the admin area. Plus, we never show \\\"powered by\\\" links in your free online forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/support\\/\\\">World Class Support<\\/a>: have questions or need guidance on how to set up your application? We are happy to help. Our purpose with Formidable Forms is to help you <strong>take on bigger projects, earn more clients, and grow your business<\\/strong>.<\\/li>\\n<\\/ul>\\n\\n<h4>Form add-on library<\\/h4>\\n\\n<ul>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\\\" title=\\\"User registration forms\\\">User registration Forms<\\/a>. Register users and create subdomains when using WordPress multisite.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\\\" title=\\\"Form action automation\\\">Form action automation<\\/a>. Schedule email notifications, SMS messages, and API actions.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\\\" title=\\\"Digital Signature Forms\\\">Digital Signature Forms<\\/a>. Add a signature field to your form. The user may write their signature with a trackpad\\/mouse or just type it.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\\\" title=\\\"Formidable Forms API\\\">Formidable Forms API<\\/a>. Send entry results to any other site that has a Rest API. This includes the option of sending entries from one Formidable site to another.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\\\" title=\\\"PayPal Forms\\\">PayPal Forms<\\/a>. Automate your business by collecting instant payments from your clients. Collect information, calculate a total, and send clients on to PayPal.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\\\" title=\\\"Stripe Forms\\\">Stripe Forms<\\/a>. Any Formidable forms on your site can accept credit card payments without users ever leaving your site.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\\\" title=\\\"Authorize.net AIM Forms\\\">Authorize.net AIM Forms<\\/a>. Accept one-time payments directly on your site, using Authorize.net AIM.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\\\" title=\\\"MailChimp Forms\\\">MailChimp Forms<\\/a>. Add leads to a MailChimp mailing list when they submit forms and update their information along with the entry.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\\\" title=\\\"Aweber Forms\\\">Aweber Forms<\\/a>. Subscribe users to an AWeber mailing list when they submit a form. AWeber is a powerful email marketing service.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\\\" title=\\\"Highrise Forms\\\">Highrise Forms<\\/a>. Add your leads to your Highrise CRM account any time a Formidable form is submitted.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\\\" title=\\\"Twilio for SMS Forms\\\">Twilio for SMS Forms<\\/a>. Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when form entries are submitted or updated.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\\\" title=\\\"WPML Forms\\\">WPML Forms<\\/a>. Translate your forms into multiple languages using the Formidable-integrated WPML plugin.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\\\" title=\\\"Polylang Forms\\\">Polylang Forms<\\/a>. Create bilingual or multilingual forms with help from Polylang.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\\\" title=\\\"Bootstrap Form Styles\\\">Bootstrap Form Styles<\\/a>. Instantly add Bootstrap styling to all your Formidable forms.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\\\" title=\\\"Bootstrap Modal Form\\\">Bootstrap Modal Form<\\/a>. Open forms, views, other shortcodes, or sections of content in a Bootstrap modal popup.<\\/li>\\n<li><a href=\\\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\\\" title=\\\"Zapier Forms\\\">Zapier Forms<\\/a>. Connect with hundreds of different applications through Zapier. Insert a new row in a Google docs spreadsheet, post on Twitter, or add a new Dropbox file with your form.<\\/li>\\n<\\/ul>\\n\\n<p>Learn more at <a href=\\\"https:\\/\\/formidableforms.com\\/\\\" title=\\\"Formidable Forms\\\">Formidable Forms<\\/a><\\/p>\\n\\n<p><a href=\\\"https:\\/\\/github.com\\/Strategy11\\/formidable-forms\\\" title=\\\"Contribute on Github\\\">Contribute on Github<\\/a><\\/p>\"],\"changelog\":[\"<p><h4>v3.0.02 - February 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Show a generated screenshot of the embedded form in the form builder rather than the first few fields<\\/li>\\n<li>Tweak: Move the forms css inside the plugin rather than saving it in the uploads folder so it will always be reset after updates<\\/li>\\n<li>New: Add frm_fields_container_class hook for changing the new form container class attributes<\\/li>\\n<li>Fix: Auto updates with the nested version going from 3.0 were failing and updating to lite<\\/li>\\n<li>Fix: Some default values were overiding non defaults when the form was displayed. This included user ID fields and other ifelds with separate values.<\\/li>\\n<li>Fix: Recompile the combined javascript file any time the pro version number changes<\\/li>\\n<li>Fix: Embedded forms were being changed when the parent form was saved<\\/li>\\n<li>Fix: Dynamic fields showing the entry key were blank with [25 show=key].<\\/li>\\n<li>Fix: More reliably run calculations in hidden fields inside of a section on multi paged forms<\\/li>\\n<li>Fix: Don\'t apply auto layout classes to inline forms with more than 12 fields<\\/li>\\n<li>Fix: When checking if an inline form needs layout classes added, check for non-numeric classes like frm_half<\\/li>\\n<li>Fix: Prevent the comment box on the entries page from closing immediately<\\/li>\\n<li>Fix: More form styling fixes for css grids. Fixes cover layouts with frm_alignright and smoother responsive layouts.<\\/li>\\n<li>Fix: Combine the old and new form css, and include the old layout CSS by default<\\/li>\\n<li>Fix: Trigger the activation install right when the plugin is installed<\\/li>\\n<li>Fix: Don\'t add label position styling to fields that don\'t include the option to change the label position<\\/li>\\n<li>Fix: Correctly limit the number of fields returned when using the FrmField::get_all_for_form function with a limit set<\\/li>\\n<\\/ul>\\n<h4>v3.0.01 - February 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use toggle fields in calculations and conditional logic<\\/li>\\n<li>Fix: Some conditional logic based on empty radio fields wasn\'t functioning<\\/li>\\n<li>Fix: Require time fields at the correct times<\\/li>\\n<li>Fix: Trigger style update when a form is loaded instead of only when an admin page is visited<\\/li>\\n<li>Fix: A few various form styling and layout fixes<\\/li>\\n<li>Fix: Prevent screenreader text for accessibility from showing on sites with older cached css<\\/li>\\n<li>Fix: Prevent conflict with Divi when a form shortcode with a recaptcha is included in page editor<\\/li>\\n<li>Fix: Use \'readfile\' instead of \'include\' for css files for extra safety precautions<\\/li>\\n<li>Fix: Load the field options before frm_new_fields_vars hook for reverse compatibility<\\/li>\\n<\\/ul>\\n<h4>v3.0 - February 1, 2018<\\/h4>\\r\\n<ul>\\n<li>Read the highlights in the blog: <a href=\\\"https:\\/\\/formidableforms.com\\/free-form-builder-new-field-types-v3-0\\/\\\">New field types, seamless updates, and a beefed up free form builder in v3.0<\\/a><\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Removed code that has been deprecated since before v2.02. If you are using any custom code or third-party addons, we recommend turning on debug mode in your wp-config.php <strong>before<\\/strong> you update.<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during update or install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite forms, install it automatically. Prevent errors if pro is running alone or is also nested inside of lite.<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Add visibility option to HTML and section fields<\\/li>\\n<li>Move repeater field to its own field button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Star rating fields: Separate from scale fields and remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>New: Added param checking to inline conditionals: [if 25 equals=\'param\' param=\'set-name-here\'] and [if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>Move features into the free form builder: redirect and show page after save, javascript validation, field format options with HTML5 pattern validation, and phone number, number, user ID, hidden field, and HTML fields<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is updated when the plugin is activated or updated.<\\/li>\\n<li>A UI pick-me-up in preparation of things to come in 4.0.<\\/li>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Search for fields by name, id, and key in the customization panel<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Customize the invalid message when a custom format is set on text fields<\\/li>\\n<li>Better a11y\\/WCAG support: hidden labels where required, \\\"for\\\" tag on most labels, and link the field to its description for screenreaders.<\\/li>\\n<li>Move form shortcodes from the sidebar to the form settings page<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\" on the form builder page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default.<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>New: field object class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run form install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>Enhancement: Get the shortcodes for a view more concisely. Check for any numeric shortcode instead of checking the database for the field ids<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Open files in the form upload field in a new tab<\\/li>\\n<li>Tweak: Don\'t show the reports nav if the form has no entries<\\/li>\\n<li>Tweak: Add .do-calculation class on a form to run calculations even if they are not on the current page of the form<\\/li>\\n<li>New hook: Add frm_output_single_style hook to add extra css into the generated stylesheet<\\/li>\\n<li>New hook: Add frm_before_get_form hook for enqueueing form scripts<\\/li>\\n<li>New hook: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New hook: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add $atts with $atts[\'view\'] to all pagination hooks<\\/li>\\n<li>Fix: calculations in hidden fields inside of sections were not calculating<\\/li>\\n<li>Fix: Add validation for the year range in date fields<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without br in dynamic fields<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>Fix: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Fix: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field by an end user when moving between form pages.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: If a field includes regex, keep the slashes when the field is duplicated<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: Searching for a decimal value was dropping the value after the decimal<\\/li>\\n<li>Fix: Searching for a number with post entries and frm-search wasn\'t correctly checking the posts<\\/li>\\n<li>Fix: datepicker settings weren\'t loading correctly in an ajax form with date fields that aren\'t on the first form page<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>Removed: The preview page option in the global settings is no longer used. The form preview page is now generated.<\\/li>\\n<li>Removed: The placeholder fallback javascript for old versions of IE is gone. No need to give everyone extra scripts to load.<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings since it isn\'t used by the plugin. If you had this box checked, you\'ll still see it. Once you uncheck it the option will no longer appear.<\\/li>\\n<li>Removed the option to bulk create templates from forms<\\/li>\\n<li>Removed the list of users on the reports page for quicker report loading<\\/li>\\n<ul>\\n<h4 id=\\\"known-issues\\\">Known Issues<\\/h4>\\n<ul>\\n<li>Divi conflict: Pages that include a form with a recaptcha are not loading. (Fixed for 3.0.1)<\\/li>\\n<li>Styling issues with certain form layouts. We are working on it. In the meantime, go to the Formidable -&gt; Global settings page and check the box to \\\"Load form layout styling for old browsers.\\\" This will load the styling from the previous version of Formidable.<\\/li>\\n<li>Shortcodes showing in some views. Before 3.0, when you had multiple view shortcodes on the page, and one includes filter=1 or filter=limited, all of the views after that would be filtered. Be sure to include filter=limited or filter=1 in any view shortcodes that include a nested shortcode.<\\/li>\\n<li>\\\"If you are human, leave this field blank\\\" showing. This means your styling didn\'t update. Try the following steps:<br \\/>\\n1. Visit a page in your admin area to trigger the update.<br \\/>\\n2. If no change, go to the Formidable -&gt; Styles page and hit update.<br \\/>\\n3. If it still doesn\\u2019t change, clear any CDN or other file caches you may have.<br \\/>\\n4. Clear your browser cache.<\\/li>\\n<\\/ul>\\n<h4>v3.0rc4 - January 29, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Hide the section heading with visibility<\\/li>\\n<li>New: Add frm_before_day_content and frm_after_day_content hooks. These hooks are for adding content on each calendar day that has entries.<\\/li>\\n<li>New: Add frm_enqueue_builder_scripts hook to load extra scripts on the form builder page<\\/li>\\n<li>New: Add frm_show_entry_defaults hook to add extra atts to the frm_show_entry shortcode<\\/li>\\n<li>Tweak: Add font version number so we can make font changes more easily<\\/li>\\n<li>Tweak: Include \'original_default\' in the field array for new entries so we can compare and prevent double processing later<\\/li>\\n<li>Tweak: Improve the form preview page in the theme<\\/li>\\n<li>Tweak: Add a way to run a calculation from a different page of the form. If a form or field has the do-calculation class, always run it even if the total field is on a different page<\\/li>\\n<li>Tweak: Return embedded form values as array in the show entry shortcode. The format is conditionally changed based on child_array=1 in the shortcode to maintain reverse compatibility. The API addon uses this for embedded forms.<\\/li>\\n<li>Fix: issues with calculations in hidden fields inside of sections<\\/li>\\n<li>Fix: frm-search wouldn\'t search posts for a numeric value<\\/li>\\n<li>Fix: Some views were occasionally showing the field shortcodes. Get the shortcodes for a view more concisely by checking for any numeric shortcode instead of checking the database for the field ids.<\\/li>\\n<li>Fix: Allow graphs to work in PHP 5.2 (replaced lcfirst with strtolower)<\\/li>\\n<li>Fix: Default values weren\'t processing correctly in a few cases: hidden fields with a field id like [25] were not getting the value from another page, nested shortcodes like [ frm-stats id=[25]] were not processing the field value, HTML fields were processing shortcodes multiple times. Now if there is a nested shortcode, it isn\'t run until after the nested value is replaced.<\\/li>\\n<li>Fix: Searching for a decimal in a view filter was always switched to a whole number<\\/li>\\n<li>Fix: quotation marks were being escaped in frm_form_attributes and frm_form_div_attributes hooks<\\/li>\\n<li>3.0 fix: more accurately position the submit button for inline forms<\\/li>\\n<li>3.0 fix: fix the layout issues on the form builder page when adding and selecting a field<\\/li>\\n<li>3.0 fix: When a long option was selected in a dropdown field, it pushed the field description lower<\\/li>\\n<li>3.0 fix: The dropdown to create a new template wasn\'t opening<\\/li>\\n<li>3.0 fix: Forms were not redirecting when ajax submit and redirect were enabled<\\/li>\\n<li>3.0 fix: Collapsed section was missing a closing div<\\/li>\\n<li>3.0 fix: Repeating layout styling for second row, or when set to grid.<\\/li>\\n<li>3.0 fix: The repeating section icons were not allowing icons only<\\/li>\\n<li>3.0 fix: A few styling fixes for toggle and slider fields.<\\/li>\\n<li>3.0 fix: Load the star javascript on the form builder page for hovers<\\/li>\\n<li>3.0 fix: Use the correct default HTML for embedded forms to prevent the labels from showing<\\/li>\\n<li>3.0 fix: The button to add a new comment on the view entry page wasn\'t working<\\/li>\\n<li>Update the font icons for star ratings<\\/li>\\n<\\/ul>\\n<h4>v3.0rc3 - January 10, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Added param checking to inline conditionals: [ if 25 equals=\'param\' param=\'set-name-here\'] and [ if get param=\\\"level\\\" equals=\\\"gold\\\"]<\\/li>\\n<li>3.0 fix: Lookup fields weren\'t triggering their watch fields when the form was a published page<\\/li>\\n<li>3.0 fix: Set the value on the slider to the same font size as other inputs<\\/li>\\n<li>3.0 fix: prevent extra vertical space in long forms<\\/li>\\n<li>3.0 fix: Use layout classes like frm_half instead of frm6 to prevent confusion. But frm6 still works.<\\/li>\\n<li>3.0 fix: Prevent the form builder page from moving around when a field is selected<\\/li>\\n<\\/ul>\\n<h4>v3.0rc2 - January 6, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Add more visual layout class selector<\\/li>\\n<li>Fix: Require the credit card field when editing a draft<\\/li>\\n<li>3.0 fix: Format and required errors message settings were not filling by default<\\/li>\\n<li>3.0 fix: Conditional logic wasn\'t working in many cases<\\/li>\\n<li>3.0 fix: Correctly hide fields in multipage form with drafts. The fields were showing on the second page of the form after an auto draft save.<\\/li>\\n<li>3.0 fix: Grids inside collapsible sections were staying full width.<\\/li>\\n<li>Code: Clean up the code for credit card fields<\\/li>\\n<\\/ul>\\n<h4>v3.0rc1 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>New: Use CSS grids for better layouts. If you would like your column layouts to show in Internet Explorer, you\'ll need to turn on the old styling in the Formidable -&gt; Global settings. The grids use a 12-column layout with classes that range from frm1 (1 column of 12) to frm12 (span all 12 columns). (Thanks for the feedback from our feedback group!)<\\/li>\\n<li>New: Automatically adjust fields to fit equally in an inline form<\\/li>\\n<li>New: Move Formidable Pro to its own plugin during install. Wahoo!<\\/li>\\n<li>New: If the Pro version is installed without the lite version, install it automatically and also prevent errors if pro is running alone and inside of lite.<\\/li>\\n<li>Enhancement: If a form creates posts and is set to not save entries, save the created post.<\\/li>\\n<li>Enhancement: Run install on an API route instead of the admin ajax route and make sure there won\'t be multiple instances of the install running at once.<\\/li>\\n<li>Enhancement: Add frm_rtl class to forms with styles set to RTL for easier styling.<\\/li>\\n<li>Enhancement: Use the options instead of transients for checking for updates. Some types of caching store transients indefinitely.<\\/li>\\n<li>New: Add frm_before_get_form hook<\\/li>\\n<li>Tweak: Remove the placeholder fallback javascript for old versions of IE. No need to give everyone extra scripts to load.<\\/li>\\n<li>Tweak: Only show the user login for a user id field when the display name is empty. Don\'t show it as a fallback for other user values.<\\/li>\\n<li>Tweak: Change the appearance of the range slider, and switch from a third-party script to minimal js to show the number.<\\/li>\\n<li>Tweak: Return 403 instead of 401 when a file type isn\'t allowed to be uploaded.<\\/li>\\n<li>Tweak: Open files in the upload field in a new tab<\\/li>\\n<li>Tweak: Remove the list of users on the reports page for quicker report loading.<\\/li>\\n<li>Fix: Install the wp_frm_copies table during the first multisite installation, and prevent it from checking tables before they exist.<\\/li>\\n<li>Fix: Register scripts for loading on shortcode inserted forms too and not only the preview page.<\\/li>\\n<li>Fix: Do not process a shortcode that is inserted into a field.<\\/li>\\n<li>Fix: Conditionals that check user meta were always returning true<\\/li>\\n<li>Fix: Correctly hide and show fields in embedded forms with the frm-show-entry shortcode<\\/li>\\n<li>Fix: Autocomplete for dynamic fields was too small<\\/li>\\n<li>Fix: Correctly check conditional logic when comparing 0 to blank.<\\/li>\\n<li>Fix: Prevent double filtering shortcodes in a nested view<\\/li>\\n<li>Fix: Allow a view to not be filtered on the same page as a filtered view<\\/li>\\n<li>3.0 Fix: Correctly add classes to the admin body and prevent other plugins from overriding it for the new styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.09 - January 3, 2018<\\/h4>\\r\\n<ul>\\n<li>Fix: Read only background and border colors weren\'t showing in the form correctly<\\/li>\\n<li>Fix: A PHP warning was showing with validation messages in the form<\\/li>\\n<li>Fix: Autocomplete dropdowns were looking for a space before the typed value<\\/li>\\n<li>Fix: \\/r was showing in conditional multi-line default values<\\/li>\\n<li>Fix: Add error styling to single option autocomplete dropdowns<\\/li>\\n<li>Fix: Check conditional logic on html fields inside a repeating section<\\/li>\\n<li>Fix: Prevent database errors on the first install in a multisite network<\\/li>\\n<\\/ul>\\n<h4>v2.05.08 - December 13, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: When 100 is higher than the last value in the entry, use 100.<\\/li>\\n<li>Enhancement: Remove type=\\\"text\\/javascript\\\" for new HTML5 validation requirements<\\/li>\\n<li>Fix: Hide extra columns on the Formidable -&gt; Entries page more accurately<\\/li>\\n<li>Fix: Prevent WP confirmation messages from showing when saving a form<\\/li>\\n<li>Fix: Some tooltips were partially covered by the admin menu<\\/li>\\n<li>Fix: The Formidable -&gt; Views page didn\'t look good on small screens<\\/li>\\n<li>Fix: All custom field rows were being removed in post settings when one was removed<\\/li>\\n<li>Fix: Lookup calculations in repeating sections were returning javascript errors<\\/li>\\n<\\/ul>\\n<h4>v3.0b3 - December 7, 2017<\\/h4>\\r\\n<ul>\\n<li>Include v2.05.07 updates<\\/li>\\n<li>All enhancements from 3.0b1 and 3.0b2<\\/li>\\n<li>Fix: Searching dynamic fields were returning extra, incorrect results<\\/li>\\n<li>Fix: When a field immediately follows an embedded form, it was showing up when include_fields included the embedded form<\\/li>\\n<li>More codestyling enhancements and escaping more translated strings<\\/li>\\n<li>3.0 Fix: Correctly load the combined js files<\\/li>\\n<li>3.0 Fix: Default star fields to 5 stars<\\/li>\\n<li>3.0 Fix: Hovering issues for star fields. Stars weren\'t unselecting when mouse was moved away.<\\/li>\\n<li>3.0 Fix: Show a text field for time conditional logic instead of dropdown<\\/li>\\n<li>3.0 Fix: Don\'t default to , (comma) for file separation<\\/li>\\n<li>3.0 Fix: display star stats from a non-star field type<\\/li>\\n<li>3.0 Fix: Prevent two filter\\/order rows from showing when + is clicked<\\/li>\\n<li>3.0 Fix: correctly process default shortcodes in views<\\/li>\\n<li>3.0 Fix: Use the EDD beta option to serve two different downloads. This will allow us to send the nested or non-nested version depending on what is currently installed without requiring a new license.<\\/li>\\n<li>3.0 Fix: More responsive styling<\\/li>\\n<\\/ul>\\n<h4>v2.05.07 - November 29, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add links to edit views and post entry in the top admin bar<\\/li>\\n<li>Security Fix: Fix an SQL injection vulnerability on the Form listing page on the backend. Vulnerability discovered by the static code analysis solution <a href=\\\"https:\\/\\/www.ripstech.com\\/\\\" target=\\\"_blank\\\">RIPS (www.ripstech.com)<\\/a><\\/li>\\n<li>New: Limit the number of field columns in the entry listing page to a max of 11 fields<\\/li>\\n<li>Tweak: Show default val\\/placeholder text icons for any item in an address field and confirmation fields<\\/li>\\n<li>Tweak: Apply the frm_csv_sep hook when importing addresses. This allows for a different separator to be specified for values in an address field<\\/li>\\n<li>Fix: View pagination was being ignored when is wasn\'t overridden from the view shortcode<\\/li>\\n<li>Fix: Prevent errors with hitting server limits for a long regex when processing shortcodes in a view with a long form<\\/li>\\n<li>Fix: Set dependencies on the datepicker locale js. This solves the problem with the scripts getting out of order on some sites.<\\/li>\\n<\\/ul>\\n<h4>v2.05.06 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_load_ajax_field_scripts hook to allow custom field types to load scripts on the first page of the ajax form<\\/li>\\n<li>Tweak: Only check for shortcodes in calculations if it includes a bracket [ to reduce processing time<\\/li>\\n<li>Tweak: Speed up load time for long forms with field calculations by preventing the calculations from running when the total field is not on the current page.<\\/li>\\n<li>Tweak: A few adjustments for the entry shortcode array. Use the child entry id in the returned entry array and include the child form id in the entry array. This fixes issues with API entry updating.<\\/li>\\n<li>Tweak: Move database functions from FrmAppHelper to FrmDb<\\/li>\\n<li>Tweak: Move install\\/update\\/migrate functions from FrmDb to FrmMigrate<\\/li>\\n<li>Tweak: Remove unused check_cache_and_transient function<\\/li>\\n<li>Fix: Better sanitizing before running view query<\\/li>\\n<li>Fix: Save the HTML in the \\\"no entries\\\" message for views<\\/li>\\n<li>Fix: Save all filter settings correctly in the view<\\/li>\\n<li>Fix: Rename ja_JP translation to ja<\\/li>\\n<\\/ul>\\n<h4>v3.0b2 - November 20, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add visibility option to HTML and section fields<\\/li>\\n<li>New: Add entry_position shortcode for incremental content in views. For example, this gives the option to show more or different information for the first entry in the view or insert ads after the third entry.<\\/li>\\n<li>New: Make it easier to show star values. Show the stars by default on the View entry page and show stars in a view with [25 html=1].<\\/li>\\n<li>UI: Add the duplicate entry to actions dropdown<\\/li>\\n<li>Remove the option to bulk create templates from forms<\\/li>\\n<li>Deprecated the accordion javascript checkbox in global settings<\\/li>\\n<li>Move redirect and show page after save options to free version<\\/li>\\n<li>Move javascript validation to free version<\\/li>\\n<li>Fix: Hide \\\"Screen options\\\" and correct entries page styling when menu name is not \\\"Formidable\\\"<\\/li>\\n<li>Fix: Reverse compatibility for loading the input.php file directly<\\/li>\\n<li>Fix: Trigger the frm_default_field_opts hook more often. This fixes an issue with saving the prepend and append options in the Bootstrap addon.<\\/li>\\n<li>Fix an issue with loading datepicker settings in an ajax form with date fields that aren\'t on the first page<\\/li>\\n<li>Fix: More responsive styling for form builder<\\/li>\\n<\\/ul>\\n<h4>v2.05.05 - November 14, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: When form actions were added at the same time with non-alphabetical naming, a new addon was replacing the first one.<\\/li>\\n<li>Fix: Show update notifications more reliably on sites that don\'t save the transient expiration<\\/li>\\n<li>Fix: Allow script and style tags in the content boxes of views<\\/li>\\n<\\/ul>\\n<h4>v3.0b1 - November 13, 2017<\\/h4>\\r\\n<ul>\\n<li>A UI pick-me-up in preparation of things to come in 4.0<\\/li>\\n<li>Add range slider and toggle fields<\\/li>\\n<li>Move phone, number, user ID, hidden, and HTML fields to the free version<\\/li>\\n<li>Separate rating fields from stars<\\/li>\\n<li>Move repeater field to its own button<\\/li>\\n<li>Combine image and URL fields<\\/li>\\n<li>Add readonly option to time fields<\\/li>\\n<li>Remove the jquery rating js and replace with mostly html and css<\\/li>\\n<li>Show frm-stats as stars with straight html\\/css (no more js)<\\/li>\\n<li><strong>Possibly breaking change:<\\/strong> Remove code that has been deprecated since before v2.02<\\/li>\\n<li>Add a new field class to make it easy to make new field types. We don\'t have docs yet, but developers can take a look at the FrmFieldType class. But we\'ve gone to great efforts to make sure fields done the old way will continue to function.<\\/li>\\n<li>Allow the pro and free versions of Formidable to run side-by-side. We are still running is as a single nested plugin right now while we prepare for a mass switch in a future release. v#.0 lays all the groundwork to run and update the two versions separately.<\\/li>\\n<li>Move front-end javascript for pro version into separate file<\\/li>\\n<li>Save a combined js file to use on the front-end with a fallback if the file fails to generate. This file is triggered to update when the plugin is activated or updated.<\\/li>\\n<li>Improved RTL styling in backend<\\/li>\\n<li>Better a11y support with hidden labels where required, and \\\"for\\\" on most labels.<br \\/>\\nLink field to description for screenreaders.<\\/li>\\n<li>Change \\\"field options\\\" to \\\"field settings\\\"<\\/li>\\n<li>Move shortcodes to form settings page<\\/li>\\n<li>Update the Print styling for the entries page<\\/li>\\n<li>Remove the preview page setting, and use the regular preview page instead<\\/li>\\n<li>Remove frm_text_block class and do it by default. Radio buttons and checkboxes with wrapping text should look good by default<\\/li>\\n<li>Remove recaptcha and website fields from default Contact us form template<\\/li>\\n<li>Move format options to free with HTML5 pattern<\\/li>\\n<li>Add new classes for each field type with extendable base class<\\/li>\\n<li>Enable auto update when pro is used as a separate plugin<\\/li>\\n<li>Separate Pro and Lite translations<\\/li>\\n<li>Add validation for the year range in date fields<\\/li>\\n<li>Don\'t show the reports nav if no entries<\\/li>\\n<li>Include line breaks to paragraph fields when viewing entries on backend<\\/li>\\n<li>Hide the \\\"screen options\\\" on the edit\\/new entries pages since it doesn\'t do anything<\\/li>\\n<li>Add a link in the footer to review Formidable<\\/li>\\n<li>Add frm_output_single_style hook for extra css<\\/li>\\n<li>Replace some back-end scripts for showing and hiding settings on click with html data attributes<\\/li>\\n<li>Fix: Don\'t use conditional logic in form actions when the field isn\'t selected<\\/li>\\n<li>Fix: Show address fields without &lt;br&gt; in dynamic fields<\\/li>\\n<\\/ul>\\n<h4>v2.05.04 - November 10, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Allow normal WordPress shortcodes in the field calculations box<\\/li>\\n<li>Updates for WP 4.9 compatibility. This includes preventing double filtering on contact form widgets and using the WordPress Codemirror scripts for the form CSS page.<\\/li>\\n<li>Fix: Strip commas during form validation in non-HTML5 number fields<\\/li>\\n<li>Fix: Correctly order the views dropdown in the shortcode builder<\\/li>\\n<li>Tweak: Remove recaptcha and website fields from sample Contact us form template since most people don\'t need them<\\/li>\\n<li>Fix: Prevent \\\"are you sure\\\" message that has started being triggered by WordPress when saving a WordPress form<\\/li>\\n<li>Fix: Correctly validate form fields with an Inside field label when HTML5 forms are not enabled<\\/li>\\n<li>Fix: Set the background color on loading form submit button. Depending on the hover button covers, the loading spinner may have been the same color as the button<\\/li>\\n<li>Fix: Additional security checks when getting POST or GET values in some places<\\/li>\\n<li>Fix: Return int rather than string from FrmForm::getIdByKey<\\/li>\\n<\\/ul>\\n<h4>v2.05.03 - October 30, 2017<\\/h4>\\r\\n<ul>\\n<li>Enhancement: Clean up BCC and CC email buttons on small screens<\\/li>\\n<li>New: Add frm_xml_field_export_value hook<\\/li>\\n<li>Security enhancement: Use wp_kses instead of wp_kses_post for showing entries<\\/li>\\n<li>Enhancement: Add more HTML options to the wp_kses filters<\\/li>\\n<li>Fix: Correctly show the list of trashed forms after one is permanently deleted<\\/li>\\n<li>Fix: PHP error when editing an entry with a date field set as the post date<\\/li>\\n<li>Fix: Field value formatting when exporting XML<\\/li>\\n<li>Fix: Allow striphtml=1 to work for array values<\\/li>\\n<li>Fix: Prevent confirmation field from moving down on small screens<\\/li>\\n<\\/ul>\\n<h4>v2.05.02 - October 25, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add frm_affiliate_id hook for theme author affiliates<\\/li>\\n<li>Fix: XSS vulnerability on form preview page. Don\'t check POST values before displaying the form<\\/li>\\n<li>Enhancement: Speed up the Formidable &gt; Entries listing page for large forms<\\/li>\\n<li>Enhancement: Add frmCalSeparation jQuery event for changing the comma in text calculations to something else<\\/li>\\n<li>Fix: Prevent more themes from overriding the progress bar styling when the option to override theme styling is checked<\\/li>\\n<li>Fix: More reliably hide and show the buttons for adding taxonomies and custom fields in the create post settings<\\/li>\\n<li>Fix: Several issues with calculations with both fields inside and outside of repeating sections. Fixed issue with conditional radio fields used in repeating calculations.<\\/li>\\n<li>Fix: Prevent endless loops in conditional logic when fields are dependent on each other<\\/li>\\n<li>Fix: Searching number field values with LIKE was causing issues<\\/li>\\n<li>Fix: Use secure cookies on SSL sites<\\/li>\\n<li>Fix: Convert dates in certain formats more realibly before save<\\/li>\\n<li>Fix: Correctly duplicate fields inside a repeating section<\\/li>\\n<li>Fix: Don\'t add slashes to default field values<\\/li>\\n<li>Fix: Replace the arrows in the settings sections that disappeared in WP 4.8<\\/li>\\n<\\/ul>\\n<h4>v2.05.01 - September 29, 2017<\\/h4>\\r\\n<ul>\\n<li>Fix: Let the new label position option override the setting in the styles<\\/li>\\n<li>Fix: Trigger an update for the styling settings so a manual save isn\'t required to get new updates<\\/li>\\n<li>Fix: Prevent an undefined php warning when viewing the form page<\\/li>\\n<li>Fix: Revert the functionality behind filter=1 in views, and instead add a new filter=limited option for compatibility mode<\\/li>\\n<li>Enhancement: Add the drafts=1\\/drafts=both shortcode option into the shortcode builder<\\/li>\\n<\\/ul>\\n<h4>v2.05 - September 26, 2017<\\/h4>\\r\\n<ul>\\n<li>New: Add option to not save IP address with entries for GDPR compliant forms<\\/li>\\n<li>New: Add a new label position option: Inside. This option automatically uses the field labels as placeholders.<\\/li>\\n<li>New: Add Repeat Limit option to Repeatable Sections.<\\/li>\\n<li>New: Add target=\\\"_blank\\\" option to file upload shortcodes with new_tab=1 param.<\\/li>\\n<li>New: Add frm_before_entries_table hook to display extar content on the Formidable -&gt; Entries page.<\\/li>\\n<li>New: Add frm_lookup_is_current_user_filter_needed filter to allow the options in a lookup field to be conditionally limited.<\\/li>\\n<li>Enhancement: Prevent jumping when selecting field to edit on form builder.<\\/li>\\n<li>Enhancement: Trigger frm_after_entry_processed hook after save when the action is set to show a message. This affects deleting entries automatically.<\\/li>\\n<li>Enhancement: Allow text colors like \\\"red\\\" in frm-show-entry.<\\/li>\\n<li>Enhancement: Increase minimum WP version requirement to 4.0.<\\/li>\\n<li>Enhancement: Add array_key option to entry shortcode to set whether an ID or key is used when an array is returned.<\\/li>\\n<li>Enhancement: Allow repeating fields to be excluded from show entry shortcode.<\\/li>\\n<li>Enhancement: Improve field calculations that include fields inside and outside a repeating section<\\/li>\\n<li>Enhancement: Add RTL form support for time fields.<\\/li>\\n<li>Enhancement: Conditionally allow int, rather than string, comparison in Lookup fields.<\\/li>\\n<li>Enhancement: Add frm_main_feedback hook to messages shown after draft and edit.<\\/li>\\n<li>Enhancement: Display zip code on the same line with city and state when an address is displayed.<\\/li>\\n<li>Enhancement: Improve searching Dynamic field values on Entries tab<\\/li>\\n<li>Fix: Restore Default Plain button for filling email content.<\\/li>\\n<li>Fix: Set dependency on reCaptcha script to ensure it loads after the Formidable script when defer fails.<\\/li>\\n<li>Fix: Add frm_entries_list_query hook to filter queries on the Formidable -&gt; Entries page.<\\/li>\\n<li>Fix: Improve field duplication on form builder.<\\/li>\\n<li>Fix: Remove deprecated notification settings on import.<\\/li>\\n<li>Fix: Allow multiple invisible recaptchas to work on the same page.<\\/li>\\n<li>Fix: Make sure licenses tab loads if navigating to it directly.<\\/li>\\n<li>Fix: Improve compatibiliy with page builders and membership plugins. Don\'t run the_content filter on the View content. Instead, filter the content by calling those functions directly.<\\/li>\\n<li>Fix: Delete temporary files after no less than 3 hours, regardless of time zone.<\\/li>\\n<li>Fix: Append the media meta_query rather than replacing it. This resolves a conflict with files in WooCommerce.<\\/li>\\n<li>Fix: Trim logic and actual value in conditional logic comparison.<\\/li>\\n<li>Fix: Improve layout of confirmation field with a left label.<\\/li>\\n<li>Fix: Allow a default value for checkbox fields on any form page.<\\/li>\\n<li>Fix: Prevent Hidden fields from retaining \\\"Clear default value when typing\\\" setting when the field type changes.<\\/li>\\n<li>Fix: Prevent errors when searching Dynamic fields with frm-search bar.<\\/li>\\n<li>Fix: Do not send update emails when a draft is converted to an entry.<\\/li>\\n<li>Fix: Do not show editable entry after submitting a draft.<\\/li>\\n<li>Fix: Ensure the setting to not save credit card values is respected for draft entries too.<\\/li>\\n<li>Fix: Do not show full address if [x show=\\\"line_2\\\"] is empty.<\\/li>\\n<li>Fix: Fix undefined index error for section ID shortcode.<\\/li>\\n<li>Fix: Prevent jQuery from being loaded an extra time with edit in-place.<\\/li>\\n<li>Fix: Correctly validate required field in embedded form on multi-page form.<\\/li>\\n<li>Fix: Error messages were appearing in some server configurations when credit card numbers includes spaces.<\\/li>\\n<\\/ul>\\n<\\/p>\\n\"],\"installation\":[\"<ol>\\n<li>Go to your Plugins -&gt; Add New page in your WordPress admin<\\/li>\\n<li>Search for \'Formidable\'<\\/li>\\n<li>Click the \'Install Now\' button<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu<\\/li>\\n<li>Go to the Formidable Forms menu<\\/li>\\n<li>Click the \'Add New\' button to create a new form<\\/li>\\n<li>Insert your forms on a page, post, or widget using a shortcode [formidable id=x], Alternatively use <code>&lt;?php echo FrmFormsController::show_form(2, $key = \'\', $title=true, $description=true); ?&gt;<\\/code>` in your page template<\\/li>\\n<\\/ol>\"],\"frequently_asked_questions\":[\"<h4>How do I get started with the best WordPress contact form plugin?<\\/h4>\\n\\n<p>The fastest way to build a contact form is to use the contact form template we built for you. After you activate Formidable Forms, insert [formidable id=contact-form] on the WordPress page of your choice. That\'s it!<\\/p>\\n\\n<p>Want to make a new contact form? Go to the Formidable -&gt; Forms page and click \\\"add new\\\". Choose the Contact Us form template and click \\\"Load Template\\\". Now Save your contact form.<\\/p>\\n\\n<p>Next, go to edit the page where you would like to publish your contact form. Click the \\\"Formidable\\\" button to open the shortcode builder. Choose your contact form and insert it into your WordPress page. Save your page, and you\'re done.<\\/p>\\n\\n<p>Get more detail on <a href=\\\"https:\\/\\/formidableforms.com\\/wordpress-contact-form-template-to-unique\\/\\\" title=\\\"using the contact form template\\\">using the contact form template<\\/a> in our blog.<\\/p>\\n\\n<h4>My contact forms are not sending emails. Why not?<\\/h4>\\n\\